<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

$part="";
$order="";
$line="";
$bayID="";
$qty="";
$job=0;
$jobComplete=0;
$parentPart="";
$parentQty=0;
$qtyNeeded=0;
$bayType="";
$isFinishedGood = 0;
$existingBay = 0;
$refreshMessage = "";
$containsColors = 0;
$color = 0;
$x=0;
$maxX=0;
$y=0;
$maxY=0;
//$stagingLocation=2; ## Holland or Jenison, default to Holland
$stageQty=0;
$isWeldment = 0;
$isAssembly = 0;
$useUpOp = 0;
$orderByColor = 0;

if (isset($_POST['part']) && (strlen($_POST['part']) > 0) ) {
	$part=$_POST['part'];
	$part = rtrim($part);
}	
if (isset($_POST['order']) && (strlen($_POST['order']) > 0)) {
	$order=$_POST['order'];
}
if (isset($_POST['line'])) {
	$line=$_POST['line'];
}
if (isset($_POST['job'])) {
	$job=$_POST['job'];
}
if (isset($_POST['color'])) {
	$color=$_POST['color'];
}
if (isset($_POST['job_complete'])) {
	$jobComplete=$_POST['job_complete'];
}
if (isset($_POST['bay'])) {
	$bay=$_POST['bay'];
}	
if (isset($_POST['bayType'])) {
	$bayType=$_POST['bayType'];
}	
if (isset($_POST['quantity'])) {
	$qty=$_POST['quantity'];
}
if (isset($_POST['qty_needed'])) {
	$qtyNeeded=$_POST['qty_needed'];
}
if (isset($_POST['parent_part'])) {
	$parentPart=$_POST['parent_part'];
}
if (isset($_POST['parent_qty'])) {
	$parentQty=$_POST['parent_qty'];
}
if (isset($_POST['refreshMessage'])) {
	$refreshMessage=$_POST['refreshMessage'];
}

if (isset($_POST['use_up_op'])) {
	$useUpOp=$_POST['use_up_op'];  // the operation on billofmaterial that consumes the child part
}
$inserted=0;
$msg="";
$qtyOrder=0;	

## FUNCTIONS
## get how much of a given part is needed for the entire SO, not just a single WO within the SO
## also need to get qty for parts that don't have work orders
function getTotalSOQty($db,$part,$order) {
	$qty = 0;
	// need to get all order lines for the order to match with jobs/wo's 
	$sql="SELECT line_id FROM order_lines WHERE order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$order));
	foreach($rs as $data) {
		$line=$data['line_id'];
		$sql="SELECT SUM(quantity_scheduled) FROM jobs WHERE item_id=? AND line_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("si",$part,$line));
		if ($rs[0][0] > 0) {
			$qty+=$rs[0][0];
		}
	}
	return $qty;
}

print renderPanel("Staging","Staging","blue","span11");

## bdoss 1. When the page first loads, you see this form for entering the part, no user interaction required thus far
if (!(strlen($order) > 0) ) {
	$formDisplay = "display: block";
} else {
	$formDisplay = "visibility: hidden";
}

if ((strlen($refreshMessage)) > 0 && !(strlen($part) > 0)) {
	print "<h3>$refreshMessage</h3>";
}

print "<div id='part_div'>";
print "<form style='$formDisplay' name='partform' id='partform' class='form-horizontal form-bordered' method='POST' action='staging.php'>\n";
print "<div style='display: flex; flex-direction: row'>";
print "<div style='margin-right: 10px'>";
print "<label for='part'>Part</label>";
print "<input type='text'  name='part' id='part'  value='$part'> ";
print "</div>";
print "<div id='order_dropdown' style='margin-right: 10px; display: none'>";
print "<label for='orderOptions'>Which order is this for?</label>";
print "<select name='orderOptions' id='orderOptions'></select> ";
print "</div>";
print "<div id='parent_dropdown' style='margin-right: 10px; display: none'>";
print "<label for='parentOptions'>Which parent is this for?</label>";
print "<select name='parentOptions' id='parentOptions'></select> ";
print "</div>";
print "<div>";
print "<label for='order' style='display: none'>Order</label>";
print "<input type='hidden' name='order' id='order' value='$order'>";
print "<input type='hidden' name='bayType' id='bayType' value='$bayType'>";
print "</div>";
print "<input type='hidden' name='line' id='line' value='$line'>";
print "<input type='hidden' name='bayID' id='bayID' value=''>";  
print "<input type='hidden' name='job' id='job' value='$job'>";
print "<input type='hidden' name='color' id='color' value='$color'>";
print "<input type='hidden' name='job_complete' id='job_complete' value='$jobComplete'>";
print "<input type='hidden' name='qty_needed' id='qty_needed' value='$qtyNeeded'>";
print "<input type='hidden' name='parent_part' id='parent_part' value='$parentPart'>";
print "<input type='hidden' name='parent_qty' id='parent_qty' value='$parentQty'>";
print "<input type='hidden' name='refreshMessage' id='refreshMessage' value='$refreshMessage'>";
print "<input type='hidden' name='use_up_op' id='use_up_op' value='$useUpOp'>";
print "<div style='margin: 5px; height: 21px; width: 30px; margin-left: 10px; margin-top: 20px' class='btn green' onclick='getSO()'>Find</div>";
print "</form>";
print "</div>";


## bdoss 2. to unlock this area, user must enter part, then getSO() will trigger some queries in getSO.php that will return if an order is successfully found
## page is reloaded with new post variables, now we have access to: part, order, bayType
## bdoss it should also determine if parts have already been staged for the so and the bay needed

if ((isset($part) && (strlen($part) > 0)) && (isset($order) && (strlen($order) > 0))) {
	$part=rtrim($part);
	$multipleBays = 0;
	$missingMinutes = 0;
	$productionNotes = "";
	$transferToHolland = 0;
	$transferRequired = 0;
	$transferOffered = 0;

	$sql = "SELECT `name` FROM customers INNER JOIN orders ON orders.customer_id=customers.customer_id WHERE order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$order));
	$customer = $rs[0][0];
	$customer=str_replace(" ","",$customer);

	print "<script>window.open('http://pwncell22/$customer/DXF/$part.dxf?rand-'+Math.random(),'parts');</script>\n";

	print "<h3 id='partToStage' data-bay-type='$bayType'>Part to Stage: <b>$part</b></h3>"; 
	//print "<h3 id='maxStageQty' data-max-qty='$stageQty'>Max Amount Available for Staging: <b>$stageQty</b></h3>";
	print "<h3 id='SOToStage' >SO Number: <b>$order</b></h3>";
	if ($parentPart) {
		print "<h3>Parent Part: <b>$parentPart</b></h3>";
	}
	
	$stagingLocation = $businessUnit;
	## include file for checking production results
	include('getProductionResultsForStaging.php');
	include('getPartsForStaging.php');
	include('stageForTransfer.php');
	foreach ($prs as $pdata) {
		if ($pdata['child_width'] && is_numeric($pdata['child_width'])) {
			$x=$pdata['child_width'];
		} elseif (is_numeric($pdata['width'])) {
			$x=$pdata['width'];
		}
		if ($pdata['child_length'] && is_numeric($pdata['child_length'])) {
			$y=$pdata['child_length'];
		} elseif (is_numeric($pdata['length'])) {
			$y=$pdata['length'];
		}
		if ($x > $y) {
			$s=$x;
			$x=$y;
			$y=$s;
		}
		if ($x > $maxX) {
			$maxX=$x;
		}
		if ($y > $maxY) {
			$maxY=$y;
		}
	}
	## powder coat items don't get staged by WO, need to take away any WO meaning
	if ($bayType == 3) {
		if ($parentPart) {
			$orderByColor = 1;
		}
		$job = 0; // either this was already 0 if it's a finished good going into a powder coat bay, or it's a component that could have multiple work orders staged together
		//if ($color == 0) { // color needs to be fetched from parent
			foreach ($prs as $pdata) {
				if ($pdata['item_id'] == $part || $pdata['child_item'] == $part) {
					$color = $pdata['color'];
				}
			}
		//}
	}
	## determine if the part needs to be transferred from Jenison to Holland
	$stagedForLocation = $businessUnit;
	if ($containsCoat && $businessUnit == 1) {
		$stagedForLocation = 2;
		print "<h3 style='color: red'>Part to be staged will need to be transferred to Holland for powder coat application.</h3>";
	} elseif ($transferRequired) {
		$stagedForLocation = 2;
		print "<h3 style='color: red'>Routing shows that this part or its parent part requires operations done in Holland.  Part will be staged for a transfer to Holland</h3>";
	} elseif ($transferOffered) {
		$stagedForLocation = 2;
		print "<h3 style='color: red'>Production results show that at least one part in this order is located in Holland.  This part will be staged to allow a transfer to Holland</h3>";
	}

	include('getBay.php');
		
	if ($missingMinutes) {
		$productionNotes.= "This part is missing quantity good for the following operation(s): ";
		foreach($missingOperations as $op) {
			$sql = "SELECT operation_name FROM operations WHERE operation_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$op));
			$opName = $rs[0][0];
			$productionNotes.=" $opName ";
		}
		if ($containsDeburr) {
			$productionNotes.="<br>Deburr will not be enforced for now.";
			if (count($missingOperations) == 1) { // parts with only deburr required will be allowed to stage
				$missingMinutes = 0;
				$noRouting = 1;
			}
		}
	}

	if ($brs == "No open bays were found") {
		$bayOptions = $brs;
	} elseif (count($brs) == 1 && $brs[0]['order_id'] == $order) {
			$existingBay = 1;
			foreach ($brs as $bdata) {   
				$bayID=$bdata['bay_id'];
				$bayName=$bdata['bay_name'];
			}
			foreach ($prs as $pdata) {
				$orderItem=$pdata['item_id'];
			}
	
			$defaultBay = $brs[0]['bay_id'];
			$defaultBayName = $brs[0]['bay_name'];
	
			$sql = "SELECT bay_name FROM staging_bay_contents c, staging_bays b WHERE c.bay_id=b.bay_id and item_id='$part' and coalesce(order_id,0) = $order  AND business_unit <> ? ";
			list($otherBU,$berr)=runIQuery($db,$sql,array("i",$stagingLocation));
			$bayOptions="";
			if (count($otherBU)>0) {
				foreach ($otherBU as $budata) {
					$bayOptions.= "<h2 style='font: red'>This Part is in Bay " . $budata['bay_name'] . " at another BUSINESS UNIT</h2>";
				}
			}
				
			$bayOptions.= "<div style='margin-top: 25px; margin-left: 50px;' ><b><p class='recommendation' >We recommend Staging Bay $defaultBayName</p></b></div>";
			$bayOptions.= "&nbsp;&nbsp;<div class='btn blue defaultOptions' style='height: 20px; width: 90px; margin-top: 15px;' onclick='useBay($defaultBay,$order,`$part`,$line, $missingMinutes, `$defaultBayName`,$bayType,$color,$job,$orderByColor,$stagedForLocation)';>Use This Bay</div>";
			// not giving them the option of declaring a bay full
			//$bayOptions.= "&nbsp;&nbsp;<div class='btn red defaultOptions' style='height: 20px; width: 90px; margin-top: 15px;' onclick='fullBay($defaultBay, `$defaultBayName`)'>Full Bay</div>";
			$bayOptions.= "<div class='btn green' style='height: 20px; width: 90px; margin-top: 15px;' onclick='resetForm()'>Change Part</div>";
	} elseif (count($brs) > 0) {
		## there are multiple bays to choose from; new bay needed
		$multipleBays = 1;
		foreach ($brs as $bdata) {   
			$bayID=$bdata['bay_id'];
		}
		foreach ($prs as $pdata) {
			$orderItem=$pdata['item_id'];
		}

		$defaultBay = $brs[0]['bay_id'];
		$defaultBayName = $brs[0]['bay_name'];

		$bayOptions = "<div style='margin-top: 25px; margin-left: 50px;' ><b><p class='recommendation' >We recommend Staging Bay $defaultBayName</p></b></div>";
		$bayOptions.= "&nbsp;&nbsp;<div class='btn blue defaultOptions' style='height: 20px; width: 90px; margin-top: 15px;' onclick='useBay($defaultBay,$order,`$part`,$line,$missingMinutes,`$defaultBayName`,$bayType,$color,$job,$orderByColor,$stagedForLocation)';>Use This Bay</div>";
		// not giving them the option of declaring the bay full
		//$bayOptions.= "&nbsp;&nbsp;<div class='btn red defaultOptions' style='height: 20px; width: 90px; margin-top: 15px;' onclick='fullBay($defaultBay, `$defaultBayName`)'>Full Bay</div>";
		$bayOptions.= "&nbsp;&nbsp;<div class='btn green' style='height: 20px; width: 90px; margin-top: 15px;' onclick='resetForm()'>Change Part</div>";
	}

	if ($existingBay) {
		$bayName = $brs[0]['bay_name'];
		print "<h4>This order is already located in Bay $bayName</h4>";
		## bdoss get the pallet it will go into
		$sql = "SELECT * FROM pallets WHERE assigned_bay=? && cleared_from_bay is NULL && complete is NULL AND order_id=? AND color=? AND wo_parent=? ORDER BY bay_sequence DESC";
		list($rsOpen,$err)=runIQuery($db,$sql,array("iiii",$bayID,$order,$color,$job));
		if ($rsOpen) {
			$palletSeq=$rsOpen[0]['bay_sequence'];
			print "<h4><b>This part will be staged on Pallet $palletSeq</b></h4>";
		} else {
			## get display sequence of new pallet
			$sql = "SELECT bay_sequence FROM pallets WHERE assigned_bay=? AND order_id=? ORDER BY bay_sequence DESC";
			list($rsOther,$err)=runIQuery($db,$sql,array("ii",$bayID,$order));
			$nextPallet=1;
			if ($rsOther) {
				$nextPallet = $rsOther[0][0];
				$nextPallet++;
			}
			print "<h4><b>This part will be staged on a new pallet: Pallet $nextPallet</b></h4>";
		}
		
	}
	if (strlen($productionNotes) > 0) {
		print "<h4 style='color:red'>$productionNotes</h4>";
	}

	print "<div id='staging_div' style='display: flex; flex-direction: row;'>";
	print "<div><label for='quantity'>Quantity</label>";
	print "<input type='number' id='quantity' name='quantity' value='$qty'></div>";
	print $bayOptions;
	print "</div>";

	if ($bayType == 3 || $bayType == 5) {
		print "<h3>Parts for Order $order that go into a Powder Coat Bay</h3>";
	} elseif ($parentPart) {
		print "<h3>Children Parts for Order $order and Parent Part $parentPart</h3>"; 
	} else {
		print "<h3>Parts on this order</h3>";
	}
		
	print "<table class='table table-striped table-hover'>";
	print "<thead><tr><th>Part</th><th>Description</th><th>Width</th><th>Length</th><th>Quantity Needed</th><th>Quantity In Staging</th><th>Bay(s)</th><th>Quantity Shipped</th><th id='color_header'>Color</th></tr></thead><tbody>";
	foreach($prs as $pdata) {
		$background = "";
		$selectedAttributes="";
		$lineID = $pdata['line_id'];  ## lineID is for differentiating the different line ids for each part in the order's order lines for displaying all parts, line is for the part being staged
		$orderItem=$pdata['item_id'];
		$orderQty=$pdata['quantity'];
		$shippedQty=$pdata['shipped_quantity'];
		$width=number_format($pdata['width'],0);
		$length=number_format($pdata['length'],0);
		$color=$pdata['color'];
		$description=$pdata['item_description'];
		//if ($parentPart && $bayType == 3) {
			if ($pdata['child_item'] && strlen($pdata['child_item']) > 0) {
				$orderItem=$pdata['child_item'];
				$width=number_format($pdata['child_width'],0);
				$length=number_format($pdata['child_length'],0);
				$description=$pdata['child_description'];
			}
		//}

		if (!($width > 0)) {
			$width="";
		}
		if (!($length > 0)) {
			$length="";
		}
	
		$colorDescription = "";
		if ($color > 0 ) {
			$sql = "SELECT color_description FROM vendor_colors WHERE vc_id=?";
			list($rs,$err)=runIQuery($db,$sql,array("i",$color));
			if ($rs) {
				$colorDescription = $rs[0][0];
			}
		}

		if (!($bayType==3)) { // components in powder coat bays get the quantity from the jobs table
			$orderQty = $orderQty * $parentQty;  ## $orderQty from $prs is quantity_per, multiply by the qty needed of the parent based on its order line
			if (!$lineID) {
				$lineID = $line;  ## bdoss if the part has no line id because it is a child, it adopts the parent's line id (not the case for powder, because they can have different parents)
			}
		}
		

		$sql = "SELECT COALESCE(SUM(quantity),0) FROM staging_bay_contents WHERE line_id=? AND item_id=? AND (job_id=? or job_id=0)";  ## updating to include wo because pallets need to be used to separate wo's rather than bays
		list($qrs,$err)=runIQuery($db,$sql,array("isi",$lineID,$orderItem,$job));
		$stagingQty = $qrs[0][0];
		$location="";
		## bdoss if a qty exists, find out which bays they're in

		if ($stagingQty > 0) {
			$sql="SELECT DISTINCT bay_name, pallets.pallet_id, bay_sequence, current_location FROM staging_bays, staging_bay_contents 
			LEFT JOIN pallets ON staging_bay_contents.pallet_id = pallets.pallet_id 
			WHERE staging_bay_contents.item_id=? AND staging_bay_contents.line_id=? AND staging_bay_contents.job_id=? AND staging_bay_contents.bay_id=staging_bays.bay_id GROUP BY bay_name ";
			list($irs,$ierr)=runIQuery($db,$sql,array("sii",$orderItem, $lineID, $job));
			$comma="";
			
			foreach ($irs as $idata) {
				$location.= $comma;
				$location.= $idata[0]."-".$idata[2]." ".$idata[3];
				$comma=", ";
			}
		}

		if (strtolower($orderItem) == strtolower($part)) {
			// toggle $noRouting for testing (comments = testing, no comments = production)
			if ($noRouting) { ## bdoss 2/24/23 ADD BACK IN LATER - remove comments when merge settles down
				$stageQty = $orderQty; ## if no job/ routing for the part, assume we can stage the full quantity
			}
			$background = "style='background-color: yellow;font-weight: bold;'";
			$selectedAttributes = "id='selectedPart' data-orderqty='$orderQty' data-shippedqty='$shippedQty' data-stagingqty='$stagingQty' data-maxgood='$stageQty'";
		} 
		
		if ($job == 0) {
			if (!($shippedQty > 0)) {
				$shippedQty = 0;
			}
		} else {
			$shippedQty = "--";
		}
	
		## call function get total qty needed of a given part for the entire order
		$totSOQty = getTotalSOQty($db,$orderItem,$order);

		## can't overwrite the bootstrap for the row styling, but the <td> works
		## DISPLAY PARTS DESTINED FOR BAY HERE
		print "<tr $selectedAttributes><td $background>$orderItem</td><td $background>$description</td><td $background>$width</td><td $background>$length</td><td title='Qty Needed for this Bay (Qty Needed for the Entire SO)' $background>$orderQty";
		$totSOQty >= $orderQty ? print " ($totSOQty)" : print "";  ## if tot qty makes sense, print it, otherwise some qty was missing
		print "</td><td $background>$stagingQty</td><td $background>$location</td><td $background>$shippedQty</td><td class='color_data' $background>$colorDescription</td></tr>";
	}

	print "</tbody></table>";

	if ($multipleBays || $existingBay) {
		## display other bay options below besides the first one which gets recommended

		print "<table><thead><tr><th>Available Bays:</th></tr></thead><tbody>";
		foreach($brs as $bdata) {
			$bayName = $bdata['bay_name'];
			$bayID = $bdata['bay_id'];

			$classDefault = "";

			if ($bayID == $defaultBay) {
				$classDefault = "class='defaultOptions'";
			}

			print "<tr $classDefault><td>$bayName</td><td><div class='btn blue' onclick='useBay($bayID,$order,`$part`,$line,$missingMinutes,`$bayName`,$bayType,$color,$job,$orderByColor,$stagedForLocation)'>Use This Bay</div></td></tr>";
		}
		print "</tbody></table>";
	}
}


print renderClosePanel();


?>
<script>
	let hideColors = 1;
	let colorHeader = document.getElementById('color_header');
	let colorRows = document.querySelectorAll('.color_data');
	colorRows.forEach(function(row) {
		if (row.innerText.length > 0) {
			hideColors = 0;
		}				
	});

	if (hideColors) {
		if (colorHeader) {
			colorHeader.style.display = "none";
			colorRows.forEach(function(row) {
				row.style.display = "none";	
			});
		}
	} 

	function checkQuantity(line,qty) {
		// 1. is number 2. greater than 0 3. no more than order qty 4. check against any already in staging
		if (isNaN(qty) || !(qty > 0)) {
			alert("You must enter a quantity greater than 0.");
		}
	}

	function resetForm() {
		$('#part').val('');
		$('#order').val('');
		$('#parent_part').val('');
		$('#partform').submit();
	}

	function updatePart(updatedPart) {
		$('#part').val(updatedPart);
	}

	function useBay(bayID,order,part,line,missingMinutes,bayName,bayType,color,job,orderByColor,stagedForLocation) {
		let qty = parseInt($('#quantity').val());
		let orderQty = parseInt($('#selectedPart').data('orderqty'));
		let shippedQty = parseInt($('#selectedPart').data('shippedqty'));
		let stagingQty = parseInt($('#selectedPart').data('stagingqty'));
		let maxGoodQty = parseInt($('#selectedPart').data('maxgood'));
		let totalQty = qty + shippedQty + stagingQty;
		let maxStageQty = maxGoodQty - shippedQty - stagingQty;
		if (!(maxStageQty > 0)) {
			maxStageQty = 0;
		}

		if (missingMinutes) {
			alert("This part is missing production results.");
		} else if (isNaN(qty) || !(qty > 0)) {
			alert("You must enter a quantity greater than 0.");
		} else if (shippedQty >= orderQty) {
			alert(shippedQty + " of part " + part + " have already been shipped.");
		} else if (totalQty > orderQty) {
			alert("That quantity is greater than the order quantity. Order Quantity: " + orderQty + " Quantity Already Staged: " + stagingQty + " Quantity Shipped: " + shippedQty);
		} else if (totalQty > maxGoodQty) {
			alert ("Production results show a quantity good of " + maxGoodQty + ". You cannot stage more than " + maxStageQty + ".");
		} else {
			console.log("bayID: " + bayID + " order: " + order + " part: " + part + " qty: " + qty + " line: " + line + " color: " + color + " max good: " + maxGoodQty);
			// TODO updating handleStaging to handle pallet changes
			$.ajax({
				method: "POST",
				url: "staging/handleStaging.php",
				data: {bay:bayID,order:order,part:part,quantity:qty,line:line,color:color, job: job,orderBy:orderByColor,stagedFor:stagedForLocation}
				}).done(function(palletResults) {
					let pallet = "";
					let decodedResults = JSON.parse(palletResults);
					if (decodedResults.success == "true" && decodedResults.pallet) { 
						pallet = decodedResults.pallet;
						console.log(pallet);
					}
					let refreshMessage = `${qty} part(s) allocated to Pallet ${pallet} - Bay ${bayName} for SO ${order}`;
					$('#refreshMessage').val(refreshMessage);
					resetForm();
			})
		}
	}

	function fullBay(bay,bayName) {
		// update staging_bay table to say bay is full
		// hide that bay as an option
		// any quantity entered will go to another bay

		$.ajax({
			method: "POST",
			url: "staging/fullBay.php",
			data: {bay:bay}
			}).done(function(fullBayResults) {
				

				if (fullBayResults) {
					let decodedResults = JSON.parse(fullBayResults);
					if (decodedResults.success == "false" && decodedResults.message) { 
						alert(decodedResults.message);
					}
				} else {
					$('.defaultOptions').hide(); // getSO() makes this and the next line unnecessary, but leaving them here as a precaution
					$('.recommendation').text("Staging Bay " + bayName + " is full.");
					getSO();
				}

			})

	}

	function getSO() {
		let part = "";
		let order = "";
		let parent = "";
		part = $('#part').val();
		part = part.trim();
		order = $('#orderOptions').val();
		console.log("order: " + order);

		if (order) {
			if (order.includes("SO") && order.includes("Parent")) {
				console.log("yes");
				const x = order;
				const y = order;
				const so = 'SO: ';
				const parentPart = ' Parent Part: ';
				let newOrder = x.slice(x.indexOf(so) + so.length);
				newOrder = newOrder.slice(0, newOrder.indexOf(" "));
				parent = y.slice(y.indexOf(parentPart) + parentPart.length);
				order=newOrder;
			} else if (order.includes("SO")) {
				const x = order;
				const so = 'SO: ';
				let newOrder = x.slice(x.indexOf(so) + so.length);
				order=newOrder;
				console.log(" and order: " + order);
			}
		}

		//parent = $('#parentOptions').val();
		$('#refreshMessage').val(""); // reset the refreshmessage

		// add in check that they entered something before sending to getSO.php
		console.log("order: " + order + " part: " + part + " parent: " + parent);
		$.ajax({
			method: "POST",
			url: "staging/getSO.php",
			data: {part:part, order:order, parent:parent}
			}).done(function(soResults) {
				if (soResults) {
					let decodedResults = JSON.parse(soResults);
					//console.log(soResults);
					if (!JSON.parse(soResults)) {
						alert("That part was not found.")
					} else if (decodedResults.success == "true" && decodedResults.results == 1) {
						// I got the match I need, just need to separate between bay types
						if (decodedResults.bayType == 1) {  // includes finished good powdered items
							// not a weldment
							let order = decodedResults.order;
							let bayType = decodedResults.bayType;
							let line = decodedResults.line;
							let job = decodedResults.job;
							let color = decodedResults.color;  
							let qtyNeeded = decodedResults.qty;
							let parentPart = decodedResults.parent;
							
							$('#order').val(order);
							$('#bayType').val(bayType);
							$('#line').val(line);
							$('#job').val(job);
							$('#color').val(color);
							$('#qty_needed').val(qtyNeeded);
							$('#parent_part').val(parentPart);
							$('#partform').submit();

						} else if (decodedResults.bayType == 2 || decodedResults.bayType == 3 || decodedResults.bayType == 4 || decodedResults.bayType == 5) {  // I don't think 5 is used, but just in case
							// is weldment or assembly, job will be parent job
							console.log('weldment or assembly found');
							let order = decodedResults.order;
							let line = decodedResults.line;
							let bayType = decodedResults.bayType;
							let parentPart = decodedResults.parent;
							let parentJob = decodedResults.job;
							let parentQty = decodedResults.parentQuantity;
							let useUpOp = decodedResults.useUpOp;
							let color = decodedResults.color; 

							$('#order').val(order);
							$('#bayType').val(bayType);
							$('#line').val(line);
							$('#job').val(parentJob);
							$('#color').val(color);
							$('#parent_part').val(parentPart);
							$('#parent_qty').val(parentQty);
							$('#use_up_op').val(useUpOp);
							$('#partform').submit();
						} 
					} else if (decodedResults.success == "true" && decodedResults.results == 2) {
						// make them choose an order or job to narrow it down
					
						$('#order_dropdown').css('display', 'block');

						console.log(decodedResults.options);
						let orderOptions = decodedResults.options;
						let selectParent = document.getElementById('orderOptions');

						orderOptions.forEach(function(orderOption) {
							let option = document.createElement("option");
							option.value = orderOption;
							option.text = orderOption;
							console.log(option);
							selectParent.appendChild(option);
						});

					} else if (decodedResults.success == "false") {
						console.log(decodedResults.message);
						alert("Part not found.  Please make sure you have the correct part number and the order status allows for staging.");
					} else {
						console.log("add in error message for catch-all failure");
					}
				} 
		})
	}

	function page_init() {
		$('#part').focus();		
	}

</script>
<?php
include('footer.php');
?>