<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
$part="";
$order="";
$op="Sort";
$employee="";
$reason="";
$qty="";
$ok=-1;
$subops="";
print renderPanel("Sort IRMA","Sort IRMA","primary","span11");
print "<p>Enter Employee Number and scan part, then click Look Up.  Employee Number will be validated.  If more than one Folder matches the part, you will have to select the correct folder as well.   Then select RMA Reason, enter Quantity, and click Post IRMA</p>";
print "<form action='sortIRMA.php' name='findform' method='POST'>";
if (isset($_POST['employee'])) {
	$employee=$_POST['employee'];
	$part=$_POST['part'];
	$sql="select * from employees where card_number=?";
	list($ors,$oerr)=runIQuery($db,$sql,array("s",$employee));
	$ok=0;
	if (count($ors)>0) {
		$ok=1;
	} else {
		print "<h3>Employee Number not found</h3>";
	}
}
print renderTextBox(TRUE,"employee",$employee,"Employee Number");
if (isset($_POST['part'])) {
	$part=$_POST['part'];
}
print renderTextBox(TRUE,"part",$part,"Part");
if (isset($_POST['part'])) {
	if (isset($_POST['order'])) {
		$order=$_POST['order'];
		if (isset($_POST['reason'])) {
			$reason=$_POST['reason'];
			$qty=$_POST['quantity'];
			if (! $reason) {
				print "<h3>No Reason</h3>";
				$ok=0;
				$reason="";
			}
			if (! $qty) {
				print "<h3>No Quantity</h3>";
				$ok=0;
			}
			// get department of reason
			$sql="SELECT reason_department FROM rma_reasons WHERE reason_description=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$reason));
			$newDept=$rs[0][0];
			// bdoss 11/3/22 new code added to update irmas when a negative amount is given, rather than adding negatives as new irma results, per weekly meeting, 
			// this should prevent the error of matching positive and negative irma's having different prices due to the departments not matching
			if ($qty < 0 && $ok) { // bdoss 11/3/22 negative quantity => update existing irma
				$departmentMatch=false;
				$totalIrmaQuantity=0;
				
				// bdoss get the line id and check that there is a positive irma for it
				$sql="select line_id, quantity, folder_number from order_lines INNER JOIN orders ON orders.order_id=order_lines.order_id where order_lines.order_id=? and item_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("is",$order,$part));
				if ($rs) {
					$data=$rs[0];
					$lineID=$data[0];
					$orderQuantity=$data[1];
					$folder=$data[2];
				}
				$sql = "SELECT irma_id, departments.department_id, department_name, quantity FROM irma 
					LEFT OUTER JOIN employees ON employees.card_number=irma.employee_id 
					LEFT OUTER JOIN rma_reasons ON irma.reason=rma_reasons.reason_description
					LEFT OUTER JOIN departments ON departments.department_id=rma_reasons.reason_department 
					WHERE line_id=? AND quantity > 0 ";
				list($irs,$err)=runIQuery($db,$sql,array("i",$lineID));
				if ($irs) {
					foreach ($irs as $data) {
						$irmaID=$data['irma_id'];
						$departmentID=$data['department_id'];
						$departmentName=$data['department_name'];
						$irmaQuantity=$data['quantity'];
						
						if ($newDept == $departmentID) {
							$departmentMatch = true;
							$totalIrmaQuantity += $irmaQuantity;
						}
					}
				
					$sql="SELECT SUM(quantity_good) FROM production_results WHERE job_id=? AND item_name=? AND operation_id=35"; ## operation 35=laser, don't subtract away the negative irma if they cut extra parts
					list($rs,$err)=runIQuery($db,$sql,array("ss",$folder,$part));
					if ($rs[0][0] >= 0) {
						$productionQuantity=$rs[0][0];
					} else {
						$productionQuantity=0;
					}
		
					if ($departmentMatch) {
						if ($orderQuantity >= $productionQuantity) {
							if ($totalIrmaQuantity >= abs($qty)) {
								if ($totalIrmaQuantity == $irmaQuantity) {
									//update the irma 
									$updateNotes = abs($qty) . " subtracted from original quantity";
									$updatedQuantity = $irmaQuantity - abs($qty);
									$sql="UPDATE irma SET quantity=?, update_notes=?, cost=0 WHERE irma_id=?"; ## bdoss set cost to 0 as well
									list($rs,$err)=runIQuery($db,$sql,array("isi",$updatedQuantity,$updateNotes,$irmaID));
	
									print "<h3 style='color:blue'>Existing IRMA updated.  Part $part for job $folder and department $departmentName now has an IRMA quantity of $updatedQuantity.</h3>";
								} else { ## update still happens, but the positive quantity was spread across more than one irma and the negative irma has more parts than a single positive irma
									$i = 0;
									while (abs($qty) > 0 && $i < count($irs)) { ## as long as there is a negative irma quantity...
										$irmaID=$irs[$i]['irma_id'];
										$departmentID=$irs[$i]['department_id'];
										$departmentName=$irs[$i]['department_name'];
										$irmaQuantity=$irs[$i]['quantity'];
	
										if ($departmentID == $newDept) {
											$updatedQuantity = $irmaQuantity - abs($qty);
											if ($updatedQuantity >= 0) { ## bdoss the qty being subtracted is not greater than a positive quantity and can be subtracted from a single result
												$updateNotes = abs($qty) . " subtracted from original quantity";
												$qty = 0;
												$sql="UPDATE irma SET quantity=?, update_notes=?, cost=0 WHERE irma_id=?";  ## bdoss set cost to 0 as well
												list($rs,$err)=runIQuery($db,$sql,array("isi",$updatedQuantity,$updateNotes,$irmaID));
											} else {
												$qty = abs($updatedQuantity);
												$updateNotes = $irmaQuantity . " subtracted from original quantity. " . $qty . " remain(s) to be subtracted.";
												$updatedQuantity = 0;
												$sql="UPDATE irma SET quantity=?, update_notes=?, cost=0 WHERE irma_id=?";
												list($rs,$err)=runIQuery($db,$sql,array("isi",$updatedQuantity,$updateNotes,$irmaID));
											}
										}
										$i++;
									}
									print "<h3 style='color:blue'>Existing IRMA(s) updated.  IRMA quantity for part $part and job $folder and department $departmentName has been adjusted.</h3>";
								}
							} else {
								print "<h3 style='color:red'>You cannot subtract a quantity of $qty when the original IRMA only has a quantity of $totalIrmaQuantity.</h3>";
							}
						} else {
							print "<h3 style='color:red'>More parts were produced than the order called for.  A quantity of $orderQuantity for part $part was ordered, but a quantity of $productionQuantity was produced for Laser.  This negative IRMA cannot be processed.</h3>";
						}
					} else {
						print "<h3 style='color:red'>This IRMA was originally created in department $departmentName and the negative IRMA must be processed in $departmentName as well.</h3>";
					}
				} else {
					print "<h3 style='color:red'>This negative quantity does not match the line id of a positive quantity IRMA.  It cannot be processed.</h3>";
				}

			} elseif ($qty > 0 && $ok) { //positive quantity, insert new irma
				## go ahead and post the results
				$sql="select operation_id from operations where operation_name=?";
				list($rs,$err)=runIQuery($db,$sql,array("s",$op));
				$data=$rs[0];
				$op=$data[0];
				$sql="select line_id from order_lines where order_id=? and item_id=?";
				list($rs,$err)=runIQuery($db,$sql,array("is",$order,$part));
				$data=$rs[0];
				$lineID=$data[0];
				$subops="35";
				$sql="insert into irma (line_id, quantity, employee_id, operation_id, subtract_operations, irma_date, reason) values (?, ?, ?, ?, ?, now(), ?) ";
				list($rs,$err)=runIQuery($db,$sql,array("iiiiss",$lineID,$qty,$employee,$op,$subops,$reason));
				print "<h3>IRMA Notification Created</h3>";
				$part="";
				$order="";
				print "<a href='sortIRMA.php'>Continue</a>";
			}
		}
	}
}
if ($part) {
	if (! $order) {
		$sql="select distinct l.order_id, folder_number from order_lines l, orders o where l.order_id=o.order_id and item_id=? and o.status not in (3,4,5,10,13) ";
		list($rs,$err)=runIQuery($db,$sql,array("s",$part));
		if (count($rs)>1) {
			print renderSelect(TRUE,"order","","Order","N",$rs);			
			print renderButton("Use This Folder","primary",'document.findform.submit();');
		} else {
			if (count($rs)==1) {
				$data=$rs[0];
				$order=$data[0];
				print "<input type='hidden' name='order' id='order' value='$order'>";
				print renderTextBox(TRUE,"quantity",$qty,"Quantity");
				$sql="select reason_description as name, reason_description from rma_reasons where (reason_department in (2) or reason_description='Extra Parts') order by reason_description";
				list($rs,$err)=runIQuery($db,$sql);
				print renderSelect(TRUE,"reason","","Reason","C",$rs,0);
				print renderButton("Post IRMA","success",'document.findform.submit();');
			} else {
				print "<h3>No Open Folder Found for $part</h3>";
				$ok=0;
			}
		}
	} else {
		print "<input type='hidden' name='order' id='order' value='$order'>";
		print renderTextBox(TRUE,"quantity",$qty,"Quantity");
		$sql="select reason_description as name, reason_description from rma_reasons where reason_department=2 order by reason_description";
		list($rs,$err)=runIQuery($db,$sql);
		print renderSelect(TRUE,"reason","","Reason","C",$rs,0);
		print renderButton("Post IRMA","success",'document.findform.submit();');
	}
}
if ($ok < 1) {
	print renderButton("Look Up","warning",'document.findform.submit();');	
}
print "</form>\n";
print renderClosePanel();
include('footer.php');
