<?php
include('dbConnection.php');
include('functions.php');
include('security.php');
$export=0;
if (isset($_GET["export"])) {
    $export = $_GET["export"];
}

if (!$export) {
    include('header.php');
} else {
    header("Content-type: application/octet-stream");
    header("Content-Disposition: attachment; filename=ShowDifferentDates.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
$sql="select o.order_id, folder_number, date_due, item_id, due_date from orders o, order_lines l where o.order_id=l.order_id and o.status in (1,10) and date_due <> due_date and date_due > CURDATE()-7 ";
$sql.=" order by date_due ";
list($rs,$err)=runIQuery($db,$sql);
if ($export) {
    print "Show Different Dates\t\t" . date("m/d/Y h:i") . "\n";
    print "Order\tFolder\tHeader Due\tLine Due\tPart\n";
} else {
    print "<table class='table table-striped'><thead><tr><th>Order</th><th>Folder</th><th>Header Due</th><th>Line Due</th><th>Part</th></tr></thead><tbody>";
}
foreach ($rs as $data) {
    $order=$data['order_id'];
    $folder=$data['folder_number'];
    $hd=formatDateDBToWeb($data['date_due']);
    $ld=formatDateDBToWeb($data['due_date']);
    $part=$data['item_id'];
    if ($export) {
        print "$order\t";
        print "$folder\t";
        print "$hd\t";
        print "$ld\t";
        print "$part\t";
        print "\n";
    } else {
        print "<tr><td><a href='editOrders.php?id=$order' target='_blank'>$order</a></td>";
        print "<td>$folder</td>";
        print "<td>$hd</td>";
        print "<td>$ld</td>";
        print "<td>$part</td>";
        print "</tr>\n";
    }
}
if (!$export) {
    print "</tbody></table>\n";
    include('footer.php');
}