<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Shipping Performance";

$export=0;
if (isset($_POST["export"])) {
    $export=$_POST["export"];
}

if (!$export) {
    include('header.php');
}

$start_date=Date("m/d/Y");
$end_date=$start_date;
if (! isset($_POST['start_date'])) {
    $_POST=$_GET;
}
if (isset($_POST['start_date'])) {
	$start_date=$_POST['start_date'];
}
if (isset($_POST['end_date'])) {
	$end_date=$_POST['end_date'];
}
$employee=0;
if (isset($_POST['employee'])) {
    $employee=$_POST['employee'];
}
$sql="select * from departments where lead_email=?";
list($rs,$err)=runIQuery($db,$sql,array("s",$userEmail));

if (! count($rs)) {
	$canView=0;
	$employee=$userEmployeeID;
	if (! $employee) {
		include('footer.php');
		exit;
	}
} else {
	$canView=1;
}

$sd=formatDateWebToDB($start_date);
$ed=formatDateWebToDB($end_date);

if (!$export) {
print renderPanel("Shipping Performance");
print "<form name='selform' action='shippingPerformance.php' method='POST'>";
print renderDateBox(TRUE,"start_date",$start_date,"Start");
print renderDateBox(TRUE,"end_date",$end_date,"End");
if ($canView) {
    $sql="select employee_id, concat(last_name,', ',first_name) as fullname from employees where inactive=0 and department_id=5 order by last_name, first_name ";
    list($rs,$err)=runIQuery($db,$sql);
    print renderSelect(TRUE,"employee",$employee,"Employee","N",$rs,1);   
}
print renderButton("Find","primary","document.selform.submit();");
print "<div style='clear: both;'></div>";
print "</form>";
}

$useThisUser=0;
if ($employee) {
    $sql="select user_id from site_admins where employee_link=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$employee));
    $data=$rs[0];
    $useThisUser=$data[0];
}
$sql="select employee_link, count(*) as document_count, last_name, first_name from packing_slip p inner join site_admins a on shipped_by=user_id  ";
$sql.=" inner join employees e on employee_link = employee_id ";
$sql.=" where DATE(date_shipped) >= ? and DATE(date_shipped) <= ? ";
if ($useThisUser) {
    $sql.=" and employee_link=$useThisUser ";
}
$sql.=" group by employee_link, last_name, first_name ";
list($rs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
$employeeList=array();
$employeeName=array();
$partList=array();

foreach ($rs as $data) {
    $thisEmployee=$data['employee_link'];
    $name=$data['last_name'] . ", " . $data['first_name'];
    $qty=$data['document_count'];
    if (! in_array($thisEmployee,$employeeList)) {
        $employeeList[]=$thisEmployee;
        $employeeName[$thisEmployee]=$name;
        $partList[$thisEmployee]=0;
    }
    $partList[$thisEmployee]+=$qty;
}
$sql="select employee_link, count(*) as document_count, last_name, first_name from transfers t inner join site_admins s on transferred_by=user_id  ";
$sql.=" inner join employees e on employee_link = employee_id ";
$sql.=" where DATE(transfer_date) >= ? and DATE(transfer_date) <= ? ";
if ($useThisUser) {
    $sql.=" and employee_link=$useThisUser ";
}
$sql.=" group by employee_link, last_name, first_name ";
list($rs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
foreach ($rs as $data) {
    $thisEmployee=$data['employee_link'];
    $name=$data['last_name'] . ", " . $data['first_name'];
    $qty+=$data['document_count'];
    if (! in_array($thisEmployee,$employeeList)) {
        $employeeList[]=$thisEmployee;
        $employeeName[$thisEmployee]=$name;
        $partList[$thisEmployee]=0;
    }
    $partList[$thisEmployee]+=$qty;
}



if (!$export) {
print "<table class='table table-striped'><thead><tr><th>Employee</th><th>Time Clock Minutes</th><th>Shipments</th><th>Shipments/Hour</th><th>Planned Shipments/Hour</th><th>% to Plan</th></tr>\n";
print "</thead><tbody>";
} else {
    print "Employee\tTime Clock Minutes\tShipments\tShipments/Hour\tPlanned Shipments/Hour\t% to Plan\n";
}

foreach ($employeeList as $thisEmployee) {
    $parts=$partList[$thisEmployee];
    $name=$employeeName[$thisEmployee];
    $sql="select  sum(regular_minutes + ot_minutes) as clock_minutes ";
    $sql.=" from clock_punches p left outer join employees e on p.employee_id=e.employee_id ";
    $sql.=" where  in_date >= ? and out_date <= ? ";
    $sql.=" and e.employee_id=$thisEmployee ";
    list($ers,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
    foreach ($ers as $edata) {
        $clock=$edata['clock_minutes'];
        $hours=$clock/60;
        $pph=0;
        if ($hours > 0) {
            $pph=round($parts/$hours,1);
        }
        $pct=round($pph/4*100,1);
        if (!$export) {
        print "<tr><td>$name</td>";
        print "<td>$clock</td>";
        print "<td>$parts</td>";
        print "<td>$pph</td>";
        print "<td>4</td><td>$pct</td>";
        print "</tr>\n";
        } else {
            print "$name\t";
            print "$clock\t";
            print "$parts\t";
            print "$pph\t";
            print "4\t$pct\t";
            print "\n";
        }

    }}
    if (!$export) {
print "</tbody></table>";
print renderClosePanel();
?>
<script>
function page_init() {
	jQuery('.datepicker').datepicker();
}
</script>
<?php
include('footer.php');
    }
