<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=Shipments.xls");
header("Pragma: no-cache");
header("Expires: 0");

if (! $isAdmin) {
	$sql="select * from financials where financial_user=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
	$isAdmin=count($rs);
	if (! $isAdmin) {
		exit;
	}
}
$start_date=$_GET['start_date'];
if (! $start_date) {
	if ($_SESSION['start_date']) {
		$start_date=$_SESSION['start_date'];
	} else {
		$start_date=formatDateDBToWeb(SubtractBusinessDays(Date("Y-m-d"),5));
	}
} else {
	$_SESSION['start_date']=$start_date;
}
$end_date=$_GET['end_date'];
if (! $end_date) {
	if ($_SESSION['end_date']) {
		$end_date=$_SESSION['end_date'];
	} else {
		$end_date=Date("m/d/Y");
	}
} else {
	$_SESSION['end_date']=$end_date;
}
$order_class = 0;
if (isset($_GET['order_class'])) {
	$order_class = $_GET['order_class'];
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
	$_SESSION['customer']=$customer;
} else {
	$customer=$_SESSION['customer'];
}
if (isset($_GET['part'])) {
	$part=$_GET['part'];
	$_SESSION['part']=$part;
} else {
	$part=$_SESSION['part'];
}

$part=trim($part);
$jobstatus=array();
$sql="select * from job_status";
$rs=mysqli_query($db,$sql);
while ($data=mysqli_fetch_array($rs)) {
	$i=$data['status_id'];
	$n=$data['status_name'];
	$jobstatus[$i]=$n;
}

$sql="select packing_slip.packing_slip_id, c.name, packing_slip.attention, tracking_number, date_shipped, invoice_number, part_number, description, ";
$sql.=" sum(packing_slip_lines.quantity) as quantity_shipped, packing_slip_lines.po_number, order_class, class_name, order_lines.price, 
	packing_slip_lines.quantity * order_lines.price as dollar_value, order_lines.order_id  ";
$sql.= " from packing_slip inner join packing_slip_lines on packing_slip_id=packing_list_id ";
$sql.=" inner join order_lines on packing_slip_lines.order_line=order_lines.line_id ";
$sql.=" inner join orders on order_lines.order_id=orders.order_id ";
$sql.=" inner join customers c on packing_slip.customer_id=c.customer_id ";
$sql.=" left outer join  order_classes on orders.order_class=order_classes.class_id ";
$sql.=" where part_number like '%$part%' ";
if ($order_class) {
	$sql .= " and order_class=$selected_class ";
}
if($customer) {
	$sql.=" and packing_slip.customer_id=$customer ";
}
$sql.=" and date_shipped >='" . formatDateWebtoDB($start_date) . "' ";
$sql.=" and date_shipped <='" . formatDateWebtoDB($end_date) . "' ";
$sql.=" group by packing_slip.packing_slip_id, c.name, packing_slip.attention, tracking_number, date_shipped, invoice_number, part_number, description, packing_slip_lines.po_number, order_lines.price ";
$sql.=" order by packing_slip.packing_slip_id desc ";

print "Packing Slip\tBOL\tCustomer\tAttention\tSO Number\tDate Shipped\tTracking Number\tPO Number\tPart\tDescription\tQuantity Shipped";
if ($isAdmin) {
	print "\t";
	print "Dollar Value";
}
print "\n";
$rs=mysqli_query($db,$sql);
$slips="";
$totalExt=0;
$totalQuantity=0;
while ($data=mysqli_fetch_array($rs)) {
	$packer=$data['packing_slip_id'];
	$bol="";
	$sql="select bol_id from bol_skids where packing_slip=$packer LIMIT 1";
	list($brs,$err)=runIQuery($db,$sql);
	if (count($brs)>0) {
		$bdata=$brs[0];
		$bol=$bdata['bol_id'];
	}
	if ($slips) {
		$slips.=",";
	}
	$slips.="$packer";
	$item=$data['part_number'];
	$description=$data['description'];
	$class=$data['class_name'];
	$orderID=$data['order_id'];
	$dt=formatDateDBToWeb($data['date_shipped']);
	$qty=$data['quantity_shipped'];
	$totalQuantity+=$qty;
	$cust=$data['name'];
	$attention=$data['attention'];
	$invoice=$data['invoice_number'];
	$po=$data['po_number'];
	$tracking=$data['tracking_number'];
	$price=$data['price'];
	print "$packer\t$bol\t$cust\t$attention\t$orderID\t$dt\t$tracking\t$po\t$item\t$description\t$qty";
	if ($isAdmin) {
		$ext=$qty*$price;
		$totalExt+=$ext;
		print "\t";
		print number_format($ext,2);
	}
	print "\n";
}
if ($isAdmin) {
	print "\t\t\t\t\t\t\t\tTotals\t";
	print number_format($totalQuantity,0);
	print "\t";
	print number_format($totalExt,2);
	print "\n";
}


$sql="select distinct packing_slip_id, order_id, po_number, customer_id, ship_name, ship_address, tracking_number, date_shipped, invoice_number ";
$sql.=" from packing_slip, packing_slip_lines where packing_slip.packing_slip_id=packing_slip_lines.packing_list_id ";
if ($customer) {
	$sql.=" and customer_id=$customer ";
}
$sql.=" and date_shipped >='" . formatDateWebtoDB($start_date) . "' ";
$sql.=" and DATE(date_shipped) <='" . formatDateWebtoDB($end_date) . "' ";
$sql.=" group by packing_slip_id, order_id, po_number,  customer_id, ship_name, attention, tracking_number, date_shipped, invoice_number ";
$sql.=" order by ship_name, ship_address, packing_slip_id ";
print "Packing Slip\tCustomer\tDate Shipped\tPO Number\tOrder\tShipping Charged\tPD Charge\tTruck\tBOL\n";
$rs=mysqli_query($db,$sql);
if (mysqli_error($db)) {
	print mysqli_error($db);
	print "<BR>$sql<BR>";
}
$holdShip="";
$totalPrice=0;
$truckTotals=array();
while ($data=mysqli_fetch_array($rs)) {
	$packer=$data['packing_slip_id'];
	$sql="select b.bol_id, sa.email from skids s, bol_skids bs, bol b, site_admins sa where packing_slip_id=? and s.skid_id=bs.skid_id and bs.bol_id=b.bol_id and b.assigned_to=sa.user_id LIMIT 1";
	list($brs,$err)=runIQuery($db,$sql,array("i",$packer));
	$truck = NULL;
	$bol = NULL;
	if (count($brs)) {
		$bdata=$brs[0];
		$truck=$bdata['email'];
		$bol=$bdata['bol_id'];
	}
	$shipName=$data['ship_name'];
	$shipAddress=$data['ship_address'];
	$dt=formatDateDBToWeb($data['date_shipped']);
	$cust=$data['customer_id'];
	$invoice=$data['invoice_number'];
	$tracking=$data['tracking_number'];
	$po=$data['po_number'];
	$order=$data['order_id'];
	$sql="select folder_number from orders where order_id=?";
	list($frs,$err)=runIQuery($db,$sql,array("i",$order));
	$folder=$frs[0][0];
	$sql="select hourly_rate,operation_name, sum(minutes) as totminutes from operations o, production_results r where job_id=? and  o.operation_id=r.operation_id   ";
	$sql.=" and operation_name = 'Shipping' ";
	$sql.=" group by hourly_rate, operation_name ";
	list($ors,$err)=runIQuery($db,$sql,array("s",$folder));
	$shipprice=0;
	$ext=0;
	$gotMinutes=0;
	$explanation="";
	foreach ($ors as $odata) {
		$minutes=$odata['totminutes'];
		$rate=$odata['hourly_rate'];
		$ext=$minutes*$rate;
		$shipprice=$ext;
		$gotMinutes=1;
		$explanation="Used time entered";
	}
	if (! $gotMinutes) {
		$testShip=$shipName . $shipAddress;
		if ($testShip != $holdShip) {
			## if no manual shipping, then get mileage from customer
			$sql="select mileage from orders, customer_shiptos where order_id=? and orders.ship_name=customer_shiptos.ship_name and orders.customer_id=customer_shiptos.customer_id ";
			list($ors,$err)=runIQuery($db,$sql,array("s",$order));
			if (count($ors)) {
				$odata=$ors[0];
				$shipprice=$odata['mileage'];
				$explanation="Used Shipto";
			} else {
				$sql="select mileage from orders, customers where order_id=? and orders.customer_id=customers.customer_id";
				list($ors,$err)=runIQuery($db,$sql,array("s",$order));
				if (count($ors)) {
					$odata=$ors[0];
					$shipprice=$odata['mileage'];
					$explanation="Used Customer";
				}
			}
			$holdShipPrice=$shipprice;
			$holdShip=$shipName . $shipAddress;
		} else {
			#$shipprice=-1;
			$shipprice=$holdShipPrice;
			$explanation="Used Above because $testShip eq $holdShip";
		}
	}
	if ($shipprice < 0) {
		$shipprice=5;
	}
	$preferredDeliveryPrice=$shipprice * .75;
	if (strstr(strtoupper($folder),"RMA")) {
		$shipprice=0;
	}
    if (! $shipName) {
        $shipName=$shipAddress;
    }
    print "$packer\t$shipName\t$dt\t$po\t$folder\t$shipprice\t$preferredDeliveryPrice\t$truck\t$bol\n";

}