<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
if (! $isAdmin) {
	$sql="select * from financials where financial_user=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$userID));
	$isAdmin=count($rs);
	if (! $isAdmin) {
		include('footer.php');
	exit;
	}
}
print renderPanel("Shipments","List of all Shipments","blue","span11","truck");
$start_date=$_GET['start_date'];
if (! $start_date) {
	if ($_SESSION['start_date']) {
		$start_date=$_SESSION['start_date'];
	} else {
		$start_date=formatDateDBToWeb(SubtractBusinessDays(Date("Y-m-d"),5));
	}
} else {
	$_SESSION['start_date']=$start_date;
}
$end_date=$_GET['end_date'];
if (! $end_date) {
	if ($_SESSION['end_date']) {
		$end_date=$_SESSION['end_date'];
	} else {
		$end_date=Date("m/d/Y");
	}
} else {
	$_SESSION['end_date']=$end_date;
}
$order_class = 0;
if (isset($_GET['order_class'])) {
	$order_class = $_GET['order_class'];
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
	$_SESSION['customer']=$customer;
} else {
	$customer=$_SESSION['customer'];
}
if (isset($_GET['part'])) {
	$part=$_GET['part'];
	$_SESSION['part']=$part;
} else {
	$part=$_SESSION['part'];
}

$part=trim($part);
$jobstatus=array();
$sql="select * from job_status";
$rs=mysqli_query($db,$sql);
while ($data=mysqli_fetch_array($rs)) {
	$i=$data['status_id'];
	$n=$data['status_name'];
	$jobstatus[$i]=$n;
}
print "<form name='searchform' method='GET' action='shipments.php'>\n";
print renderDateBox(TRUE,"start_date",$start_date,"Start Date");
print renderDateBox(TRUE,"end_date",$end_date,"End Date");
// add inactive customers code -Josh 02/20/2023
$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,TRUE);

print renderTextBox(TRUE,"part",$part,"Part");

$sql = "select class_id, class_name from order_classes";
$rs = mysqli_query($db,$sql);

$selected_class = 0;
while ($data=mysqli_fetch_array($rs)) {
    if ($data['class_id'] == $order_class) {
		$selected_class = $data['class_id'];
	}
}
mysqli_data_seek($rs,0);

print renderSelect(TRUE,"order_class",$selected_class,"Order Class","N",$rs,TRUE);

print "<div class='btn green' style='float: right' onclick='document.searchform.submit();'>Find</div>";
if ($customer) {
	$sql="select * from contacts where contact_type='ASN' and customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customer));
	if (count($rs)>0 ) {
		print "<button type='button' class='btn yellow' style='float: right;' onclick='sendASN();'>ASN</button>";
	}
}
print "</form>\n";
print renderButton("Export","gray","exportReport();");
$sql="select packing_slip.packing_slip_id, c.name, packing_slip.attention, tracking_number, date_shipped, invoice_number, part_number, description, ";
$sql.=" sum(packing_slip_lines.quantity) as quantity_shipped, packing_slip_lines.po_number, order_class, class_name, order_lines.price, 
	packing_slip_lines.quantity * order_lines.price as dollar_value, order_lines.order_id  ";
$sql.= " from packing_slip inner join packing_slip_lines on packing_slip_id=packing_list_id ";
$sql.=" inner join order_lines on packing_slip_lines.order_line=order_lines.line_id ";
$sql.=" inner join orders on order_lines.order_id=orders.order_id ";
$sql.=" inner join customers c on packing_slip.customer_id=c.customer_id ";
$sql.=" left outer join  order_classes on orders.order_class=order_classes.class_id ";
$sql.=" where part_number like '%$part%' ";
if ($order_class) {
	$sql .= " and order_class=$selected_class ";
}
if($customer) {
	$sql.=" and packing_slip.customer_id=$customer ";
}
$sql.=" and date_shipped >='" . formatDateWebtoDB($start_date) . "' ";
$sql.=" and date_shipped <='" . formatDateWebtoDB($end_date) . "' ";
$sql.=" group by packing_slip.packing_slip_id, c.name, packing_slip.attention, tracking_number, date_shipped, invoice_number, part_number, description, packing_slip_lines.po_number, order_lines.price ";
$sql.=" order by packing_slip.packing_slip_id desc ";
$exportsql=$sql;
print "<table class='table-bordered table-condensed flip-content' style='width: 100%;'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "Packing Slip";
print "</th>";
print "<th valign='top'>";
print "BOL";
print "</th>";
print "<th valign='top'>";
print "Customer";
print "</th>";
print "<th valign='top'>";
print "Attention";
print "</th>";

print "<th valign='top'>";
print "SO Number";
print "</th>";

print "<th valign='top'>";
print "Date Shipped";
print "</th>";
print "<th valign='top'>";
print "Tracking Number";
print "</th>";
print "<th valign='top'>";
print "PO Number";
print "</th>";
print "<th valign='top'>";
print "Part";
print "</th>";
print "<th valign='top'>";
print "Description";
print "</th>";
print "<th valign='top'>";
print "Quantity Shipped";
print "</th>";
if ($isAdmin) {
	print "<th valign='top'>";
	print "Dollar Value";
	print "</th>";
}
print "</tr>\n";
print "</thead>\n";
print "<tbody>";
$rs=mysqli_query($db,$sql);
if (mysqli_error($db)) {
	print mysqli_error($db);
	print "<BR>$sql<BR>";
}
$slips="";
$totalExt=0;
$totalQuantity=0;
while ($data=mysqli_fetch_array($rs)) {
	$packer=$data['packing_slip_id'];
	$bol="";
	$sql="select bol_id from bol_skids where packing_slip=$packer LIMIT 1";
	list($brs,$err)=runIQuery($db,$sql);
	if (count($brs)>0) {
		$bdata=$brs[0];
		$bol=$bdata['bol_id'];
	}
	if ($slips) {
		$slips.=",";
	}
	$slips.="$packer";
	$item=$data['part_number'];
	$description=$data['description'];
	$class=$data['class_name'];
	$orderID=$data['order_id'];
	$dt=formatDateDBToWeb($data['date_shipped']);
	$qty=$data['quantity_shipped'];
	$totalQuantity+=$qty;
	$cust=$data['name'];
	$attention=$data['attention'];
	$invoice=$data['invoice_number'];
	$po=$data['po_number'];
	$tracking=$data['tracking_number'];
	$price=$data['price'];
	print "<tr onmouseover=\"this.style.backgroundColor='#d0d0d0';\" onmouseout=\"this.style.backgroundColor='white';\">";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $packer;
	print "</a></td>";
	print "<td valign='top'><a href='editBOL.php?table=bol&key=bol_id&id=$bol' target='_blank'>";
	print $bol;
	print "</a></td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $cust;
	print "</a></td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $attention;
	print "</a></td>";
	print "<td valign='top'>";
	print $orderID;
	print "</td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $dt;
	print "</a></td>";
	print "<td valign='top'><a href='#'>";
	print $tracking;
	print "</a></td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $po;
	print "</a></td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $item;
	print "</a></td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $description;
	print "</a></td>";
	print "<td valign='top'><a href='editSlips.php?from=shipments&table=packing_slip&key=packing_slip_id&id=$packer' target='_blank'>";
	print $qty;
	print "</a></td>";
	if ($isAdmin) {
		$ext=$qty*$price;
		$totalExt+=$ext;
		print "<td valign='top'>";
		print number_format($ext,2);
		print "</td>";
	}
	print "</tr>\n";
}
if ($isAdmin) {
	print "<tr><td colspan='10'>Totals</td><td>";
	print number_format($totalQuantity,0);
	print "</td><td>";
	print number_format($totalExt,2);
	print "</td></tr>\n";
}
print "</tbody></table>";
?>
<script>
function page_init() {
	$('.datepicker').datepicker();
}
function sendASN() {
	url='sendASNEmail.php?slips=<?=$slips?>&rand='+Math.random();
	window.open(url,'asns');
}
function exportReport() {
	document.searchform.action='shipmentsExport.php';
	document.searchform.target='_blank';
	document.searchform.submit();
	document.searchform.action='shipments.php';
	document.searchform.target='_self';
}
</script>
<?php
print renderClosePanel();
include('footer.php');
?>