<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$packingSlip=$_GET['id'];
$pageTitle="Packing Slip $packingSlip";
$sql="select * from packing_slip where packing_slip_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$pdata=$rs[0];
$customer_id=$pdata['customer_id'];
if ($customer_id == 706) {
	## this is Preferred Machine so you need to open that one up
	include('header.php');
	$sql="select distinct po_number from packing_slip_lines where packing_list_id=? ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
	$data=$rs[0];	
	$so=$data[0];
	print "<div><p>Be sure to have Preferred Machine System open, then click the button below to get their packing slip(s) and label(s)</p>";
	print renderButton("Get PM Packing Slip","green","window.open('http://preferredmachineproduction-env.eba-msgmf3n9.us-east-1.elasticbeanstalk.com/viewSlipFromHolland.php?id=$so','_blank');");
}
$shippingID=$pdata['shipping_id'];
$sql="select * from customers where customer_id=?";
list($crs,$err)=runIQuery($db,$sql,array("i",$customer_id));
$cdata=$crs[0];
$sql="select * from company_shiptos where shipto_id=?";
list($srs,$err)=runIQuery($db,$sql,array("i",$shippingID));
if (count($srs)==0) {
	$sql="select * from company_shiptos order by use_on_packer DESC, shipto_id";
	list($srs,$err)=runIQuery($db,$sql);
}
$sdata=$srs[0];
$coname=$sdata['ship_name'];
function printFooter($sdata) {
	$retval="";
	$retval.="<tr><td>&nbsp;</td></tr>\n";
	$retval.="<tr><td>&nbsp;</td></tr>\n";
	$retval.="<tr><td>&nbsp;</td></tr>\n";
	$retval.="</table>";
	$retval.="<table align='right'>";
	$retval.="<tr>";
	$retval.="<td align='right'>RECEIVED BY: __________________ DATE: ________</td></tr>";
	$retval.="</table>";
	return $retval;
}
function printHeader($pdata,$cdata,$date_shipped,$sdata,$packingSlip,$soNumber=0) {
	## sdata is company shipto
	## data is packing slip header info
	## cdata is customer info
	$retval="";
	$coname=$sdata['ship_name'];
	$coaddr=$sdata['ship_address'];
	$cocity=$sdata['ship_city'];
	$costate=$sdata['ship_state'];
	$cozip=$sdata['ship_zip'];
	$cophone=$sdata['ship_phone'];
	$retval.="<table width='800' align='center'>";
	$retval.="<tr><Td valign='top'>";
	$retval.="<img src='images/logo.png' width='100'><BR>";
	$retval.=$coname;
	$retval.="<br>";	
	$retval.=$coaddr;	
	$retval.="<br>";	
	$retval.=$cocity . ", " . $costate . " " . $cozip;
	$retval.="<br>";	
	$retval.=$cophone;
	$retval.="</Td>";
	$retval.="<td colspan='2' valign='top'>";
	$retval.="<h2>Packing Slip $packingSlip</h2>";
	$retval.="</td>";
	$retval.="<td align='center'>";
	$retval.="<div style='font-family: \"Free 3 of 9\"; font-size: 48px;'>*$packingSlip*</div>";
	$retval.="</td>";
	$retval.="<tr><td colspan=3 align='right' valign='top'>";
	$retval.="Date: $date_shipped<BR>";
	$retval.="Page: 1 of 1<BR>";
	$retval.="</td></tr>\n";
	$retval.="<tr><td valign='top' style=' font-size: 14px;'>";
	$retval.="<div style='font-size: 14px;'>Sold To:</div>";
	$retval.=$cdata['name'];
	$retval.="<BR>";
	$retval.=$cdata['address'];
	$retval.="<BR>";
	$retval.=$cdata['city'] . ", " . $cdata['state'] . " " . $cdata['zip'];
	$retval.="<BR>";
	$retval.="</td><td width=200></td>";
	$retval.="<td valign='top' colspan='2' style=' font-size: 14px;'>";
	$retval.="<div style='font-size: 14px;'>Ship To:</div>";
	if ($pdata['ship_name']) {
		$retval.=$pdata['ship_name'];
		$retval.="<BR>";
	} else {
		$retval.=$cdata['name'];		
		$retval.="<BR>";
	}
	if ($pdata['attention']) {
		if (trim($pdata['attention'])!=trim($pdata['ship_name'])) {
			$retval.=trim($pdata['attention']);
			$retval.="<BR>";
		}
	}
	if ($pdata['ship_address']) {
		if (trim($pdata['ship_address'])!=trim($pdata['ship_name'])) {
			$retval.=$pdata['ship_address'];
			$retval.="<BR>";
		}
	} else {
		if (trim($cdata['address'])!=trim($pdata['ship_name'])) {
			$retval.=$cdata['address'];
			$retval.="<BR>";
		}
	}
	if ($pdata['ship_address2']) {
		$retval.=$pdata['ship_address2'];
			$retval.="<BR>";
	}
	$retval.=$pdata['ship_city'];
	$retval.=", ";
	$retval.=$pdata['ship_state'];
	$retval.=" ";
	$retval.=$pdata['ship_zip'];
	$retval.="<BR>";
	if ($pdata['ship_email']) {
		$retval.=$pdata['ship_email'];
		$retval.="<BR>";
	}
	$retval.=$pdata['ship_phone'];
	$retval.="</td></tr>";
	$retval.="<tr><Td>&nbsp;</Td></tr>\n";
	$tracking_number=$pdata['tracking_number'];
	if ($tracking_number) {
		$retval.="<tr><td colspan='3' align='right'>$tracking_number</td></tr>";
	}
	$notes_to_customer=$pdata['notes_to_customer'];
	$retval.="</table>";
	$retval.="<table width='800' cellpadding=3 cellspacing=0 align='center'>";
	$retval.="<tr><td style='border-bottom: 1px solid black;'>Due</td><td style='border-bottom: 1px solid black;' colspan='2'>Part</td><td style='border-bottom: 1px solid black;' align='right'>Quantity&nbsp;</td>";
	$retval.="<td style='border-bottom: 1px solid black;' align='center'>Our Order</td>";
	$retval.="<td style='border-bottom: 1px solid black;' align='center'>PO#</td>";
	$retval.="<td style='border-bottom: 1px solid black;' align='center'>PO Line</td>";
	$retval.="</tr>\n";
	return $retval;
}
?>
<!doctype html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<html lang="en">
<head>
<meta charset="utf-8"/>
<title><?=$pageTitle?></title>	
<link rel="stylesheet" href="css/layout.css" type="text/css" media="screen" />
	<style type="text/css" media="print">
@page {
    size: auto;   /* auto is the initial value */
    margin: 0;  /* this affects the margin in the printer settings */
}
</style>
<?
print "</head>";
print "<body style=' font-size: 14px;'>\n";
$date_shipped=trim(formatDateDBToWeb($pdata['date_shipped']));
if (! $date_shipped) {
	## update shipped date
	$sql="update packing_slip set date_shipped=now() where packing_slip_id=?";
	list($urs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
	$sql="select date_shipped from packing_slip where packing_slip_id=?";
	list($urs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
	$udata=$urs[0];	
	$date_shipped=formatDateDBToWeb($udata['date_shipped']);
}
$sql="update packing_slip set date_printed=now() where packing_slip_id=?";
list($urs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$sql="select date_printed from packing_slip where packing_slip_id=?";
list($urs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$udata=$urs[0];	
$date_printed=formatDateDBToWeb($udata['date_printed']);

$polist=array();
## pull all lines that have not been shipped
$sql="select * from packing_slip_lines where packing_list_id=? and coalesce(shipped,0)=0 order by order_id, order_line";
list($lrs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
foreach ($lrs as $ldata) {
	$order=$ldata['order_id'];
	$line=$ldata['order_line'];
	$lineqty=$ldata['quantity'];
	$part=$ldata['part_number'];
	$po=$ldata['po_id'];
	$polist[$order]=$po;
	$psLine=$ldata['line_id'];
	$sqty=$lineqty;
	$sql="select item_id from items where item_name=?";
	list($irs,$err)=runIQuery($db,$sql,array("s",$part));
	$idata=$irs[0];
	$itemID=$idata[0];
	$sql="select item_locations.* from item_locations, items  where item_name=? and items.item_id=item_locations.item_id and available=1 ";
	list($irs,$err)=runIQuery($db,$sql,array("s",$part));
	foreach ($irs as $idata) {
		if ($sqty > 0) {
			$locationID=$idata['location_id'];
			$qty=$idata['quantity'];
			if ($qty > 0) {
				if ($qty > $sqty) {
					$qty=$sqty;
				}
				$sqty-=$qty;
				$qty=$qty * -1;
				inventoryUpdate($db,$itemID,$qty,$scriptid,"Packing Slip $packingSlip",$userID,$locationID);
			}
		}
	}
	## remaining quantity will take the last item location negative for this.
	if ($sqty > 0) {
			$qty=$sqty*-1;
			if (! $locationID) {
				$locationID="1";  ## main location as default if no locations exist
			}
			inventoryUpdate($db,$itemID,$qty,$scriptid,"Packing Slip $packingSlip (Negative)",$userID,$locationID);
	}
	$sql="update order_lines set shipped_quantity=coalesce(shipped_quantity,0)+? where order_id=? and line_id=?";
	list($urs,$err)=runIQuery($db,$sql,array("dii",$lineqty,$order,$line));
	$sql="update packing_slip_lines set shipped=1 where line_id=?";
	list($urs,$err)=runIQuery($db,$sql,array("i",$psLine));
}

$date_printed=formatDateDBToWeb($data['date_printed']);
$sql="select distinct order_id from packing_slip_lines where packing_list_id=? ";
list($lrs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$soNumber=0;
$soList = array();
if (count($lrs)==1) {
	$ldata=$lrs[0];
	$soNumber=$ldata[0];
	$soList[] = $soNumber;
} 


## see if  can close the order
foreach ($soList as $so) {
	$sql="select * from order_lines where order_id=? and coalesce(shipped_quantity,0) < coalesce(quantity,0) ";
	list($lrs,$err)=runIQuery($db,$sql,array("i",$so));
	if (count($lrs) == 0) {
		## there are no open lines so close the order
		## 4 is shipped
		## 3 is complete
		$sql="update orders set status=3 where order_id=?";
		list($lrs,$err)=runIQuery($db,$sql,array("i",$so));
		$sql="update order_lines set line_status=3 where order_id=?";
		list($lrs,$err)=runIQuery($db,$sql,array("i",$so));
		$po=$polist[$so];
		if ($po) {
			$url="http://preferredmachineproduction-env.eba-msgmf3n9.us-east-1.elasticbeanstalk.com/updateLeftProcessor.php?id=$po&rand=" . Date("ymdhis");
			$resource = curl_init();
			curl_setopt($resource, CURLOPT_URL, $url);
			curl_setopt($resource, CURLOPT_HEADER, 0);
			curl_setopt($resource, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($resource, CURLOPT_BINARYTRANSFER, 1);	
			curl_setopt($resource, CURLOPT_POST, 1);
			curl_setopt($resource, CURLOPT_POSTFIELDS,
		            "user=chris.allen@worldsourcetech.com&password=Chris@443");
			$response = curl_exec($resource);
			curl_close($resource);
		}
	}
}
$soNumber=""; ## always print on the line
$sql="select packing_slip_lines.*, drawing, revision from packing_slip_lines left outer join items on items.item_name=packing_slip_lines.part_number where packing_list_id=?  order by po_number, po_line";
list($rs,$err)=runIQuery($db,$sql,array("i",$packingSlip));
$lc=99;
$printlc=0;
foreach ($rs as $data) {
	$lc++;
	$printlc++;
	if ($lc > 16) {
		if ($lc < 99) {
			print printFooter($sdata);
			print "\n";
			print "<p style='page-break-after: always;'>&nbsp;</p>\n";
		}
		print printHeader($pdata,$cdata,$date_shipped,$sdata,$packingSlip,$soNumber);
		$lc=1;
	}
	$item=$data['part_number'];	
	$desc=$data['description'];
	$qty=$data['quantity'];
	$order=$data['order_id'];
	$line=$data['order_line'];		
	$po=$data['po_number'];
	$po_line=$data['po_line'];	
	$drawing=$data['drawing'];
	$revision=$data['revision'];
	$sql="select po_number, po_line, due_date from orders, order_lines where orders.order_id=? and orders.order_id=order_lines.order_id and order_lines.line_id=?";
	list($drs,$err)=runIQuery($db,$sql,array("ii",$order,$line));
	$ldata=$drs[0];
	$po=$ldata['po_number'];
	$po_line=$ldata['po_line'];	
	$dt=formatDateDBToWeb($ldata['due_date']);
	print "<tr><td valign='top' align='center' style='border-left: 1p solid black; '>$dt</td>";
	print "<td valign='top' colspan='2' style='font-size: 10px; border-left: 1px solid black; '>";
	if (strtolower($item) != 'miscellaneous') {
		print $item;
		print " ";
	}
	print "$desc";
	if ($drawing) {
		print " ";
		print $drawing;
	}
	if ($revision) {
		print " REV " . $revision;
	}
	print "</td>";
	print "<td valign='top' align='right' style='border-left: 1px solid black; '>$qty" . "&nbsp;</td>";
	print "<td valign='top' style='border-left: 1px solid black; border-right: 1px solid black; ' align='center'>";
	if ($order) {
		print $order;
	}
	print "</td>";
	print "<td valign='top' style='border-left: 1px solid black; ' align='center'>$po</td>";
	print "<td valign='top' style='border-left: 1px solid black; border-right: 1px solid black; ' align='center'>";
	if ($po_line) {
		print $po_line;
	}
	print "</td>";
	print "</tr>\n";
}
if ($lc > 0) {
	print printFooter($sdata);
}
?>
<script>
self.print();
</script>
</body>
</html>