<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
## walk through the parts and create raw and painted costs

$processlist=array();
$customerlist=array();
$pricelist=array();
if (isset($_GET['part'])) {
	$processlist[]=$_GET['part'];
} else {
	$step=$_GET['step'];
	## first - upload all of the new costs
	## then - run subassemblies - cat 18
	## then - run subassemblies again
	## then - run painted parts cat 21
	## then run subassesmblies again
	## then - run painted parts again
	## then - run painted parts again
	## then uncomment prefixlist and run the FG
	$sql="select * from items where item_category = 18 and customer_id=693  and 1 > 0 ";
	if ($step==2) {
		$sql="select * from items where item_category = 18 and customer_id=693  ";
	}
	if ($step==3) {
		$sql="select * from items where item_category = 18 and customer_id=693  ";
	}
	if ($step==4) {
		$sql="select * from items where item_category = 21 and customer_id=693  ";
	}
	if ($step==5) {
		$sql="select * from items where item_category = 18 and customer_id=693  ";
	}
	if ($step==6) {
		$sql="select * from items where item_category = 21 and customer_id=693  ";
	}
	if ($step==7) {
		$sql="select * from items where item_category = 21 and customer_id=693  ";
	}
	if ($step==9) {
		$sql="select * from items where item_name like 'A5036E1512%'  ";
	}
	if ($step==8) {
		$prefixList=array("A5031","A5036","A5050","A5055","AY103","B000301","J025001","J031014","J0334","S2040","S5065","W2040","W2047","W5066","K007685","MASY6977","MASY9389");
		foreach ($prefixList as $prefix) {
			$prefix.="%";
			## process in this order
			$sql="select * from items where item_name like ? ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$prefix));
			foreach ($rs as $data) {
				$part=$data['item_name'];
				$processlist[]=$part;
			}
		}
	} else {
		list($rs,$err)=runIQuery($db,$sql);
		foreach ($rs as $data) {
			$part=$data['item_name'];
			$processlist[]=$part;
		}
	}
}
print "<table><tr><td>Part</td><td>Old Price</td><td>New Price</td><td>Difference</td></tr>";
foreach ($processlist as $part) {
	## since they do not fill in the cost field, get the cost from when the component was purchased
	## if it is made, you have to roll up from the job
	$sql="select cost, item_category, old_price, price from items where item_name=?";
	list($brs,$err)=runIQuery($db,$sql,array("s",$part));
	$bdata=$brs[0];
	$paintCost=$bdata['cost'];
	$category=$bdata['item_category'];
	$childPrice=$bdata['old_price'];
	$currentPrice=$bdata['price'];
	$pricelist[$part]=$currentPrice;
	$partCost=0;
	$sql="select * from billofmaterial where parent_item=?";
	list($brs,$err)=runIQuery($db,$sql,array("s",$part));	
	foreach ($brs as $bdata) {
		$qtyper=$bdata['quantity_per'];
		$child=$bdata['child_item'];
		$sql="select price from items where item_name=?";
		list($irs,$err)=runIQuery($db,$sql,array("s",$child));
		$idata=$irs[0];
		$cprice=$idata['price'];
		$childPrice=$cprice;
		$childCost=calculateCost($db,$child);
		$partCost += $childCost * $qtyper;
	}
	$sql="select routing_id, workcenter_name, display_sequence, pph, r.vendor_id, r.operation_id from routing r, workcenters w where r.workcenter_id=w.workcenter_id and parent_part=? and r.vendor_id = 0 order by display_sequence";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$timeCost=0;
	foreach ($rs as $data) {
		$routingID=$data['routing_id'];
		$vendorID=$data['vendor_id'];
		$operationID=$data['operation_id'];
		$sequence=$data['display_sequence'];
		$pph=$data['pph'];
		if ($pph > 0) {
			$sql="select operation_cost from operations where operation_id=?";
			list($ors,$err)=runIQuery($db,$sql,array("i",$operationID));
			$odata=$ors[0];
			$price=$odata['operation_cost'];
			$timeCost += $price / $pph;
		} else {
			## $timePrice += 1;
		}
	}
	$sql="select routing_id, workcenter_name, display_sequence, pph, r.vendor_id, r.operation_id from routing r, workcenters w where r.workcenter_id=w.workcenter_id and parent_part=? and r.vendor_id > 0 order by display_sequence";
	list($rs,$err)=runIQuery($db,$sql,array("s",$part));
	$isOutside=count($rs);
	$newPrice=$partCost;
	$newPrice += $timePrice;
	$newPrice = round($newPrice*100)/100;
	if ($newPrice > 0) {
		$diff=$newPrice - $pricelist[$part];
		print "<tr><td>$part</td><td>" . $pricelist[$part] . "<td>$newPrice</td><td ";
		if ($diff < 0) {
			print " style='color: red;'";
		}
		$sql="update items set price=? where item_name=? ";
		list($rs,$err)=runIQuery($db,$sql,array("ds",$newPrice,$part));
		print ">$diff</td>";
		print "</tr>\n";
	}
}
print "</table>";