<?php 
require_once 'Mail/class.phpmailer.php';

$sql="SELECT order_reminders.*, order_status.status_name, customers.name FROM order_reminders 
	INNER JOIN order_status ON order_reminders.order_status=order_status.status_id 
	INNER JOIN customers ON customers.customer_id=order_reminders.customer
	WHERE sent_on IS NULL AND order_id=? and order_status=?";
list($rs,$err)=runIQuery($db,$sql,array("ii",$id,$status)); 

if ($rs) {
	foreach($rs as $data) { // in case there is more than one automated message for that order and status, prep emails for each
		$customer=$data['name'];
		$reminder=$data['reminder_message'];
		$statusName=$data['status_name'];
		$reminderID=$data['reminder_id'];

		$sql="UPDATE order_reminders SET sent_on=now() WHERE reminder_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$reminderID));

		$sql="SELECT CONCAT(first_name, ' ', last_name) AS full_name, employee_email FROM employees 
			INNER JOIN employee_reminders ON employees.employee_id=employee_reminders.employee_id 
			WHERE employee_reminders.reminder_id=?";
		list($employees, $err)=runIQuery($db,$sql,array("i",$reminderID));
	
				$mail = new PHPMailer();
				$mail->IsSMTP();
				$mail->SMTPDebug  = 0;
				$mail->Debugoutput = 'html';
				$mail->Host = "email-smtp.us-east-1.amazonaws.com";
				$mail->Port       =587;
				$mail->SMTPSecure = 'tls';
				$mail->SMTPAuth   = true;
				$mail->Username = $smtpUser;
				$mail->Password   = $smtpPassword;
				
				$mail->SetFrom($userEmail,"Preferred Machine");	
				foreach($employees as $employee) { // send an email to each person listed as a recipient for the automated reminder
					$employeeName=$employee['full_name'];
					$employeeEmail=$employee['employee_email'];
					$mail->AddAddress($employeeEmail,$employeeName);
					// $mail->AddAddress($userEmail,"Test User"); // for TESTING
				}
				
				$mail->Subject = "Automated Reminder for Order $id and Customer $customer";

				$mail->isHTML(true);  

				$message="Order $id for Customer $customer has been updated to the following status: $statusName<br><br>";
				$message.="Automated message:<br>";
				$message.=$reminder; 
				$mail->Body = $message;	
			
					if(!$mail->Send()) {
						if(!$mail->Send()) {
							if(!$mail->Send()) {
							echo "Mailer Error: " . $mail->ErrorInfo;
							}
						}
					}
	}
}	
return;
?>

