<?php 

require_once 'Mail/class.phpmailer.php';

## Determine if the user is a manager
## manager id's are tied to the site_admins table
$sql="SELECT `user_id` FROM site_admins WHERE LOWER(email)=?";
list($rs,$err)=runIQuery($db,$sql,array('s', strtolower($userEmail)));
if (count($rs)) {
	## if they're a manager, check if they have any pending signatures for an employee reporting to them
	$managerID=$rs[0][0];

	$sql="SELECT activity_date, last_name, first_name, full_name, employee_signed_date, manager_signed_date, point_id, point_log.employee_id, points_remaining FROM point_log 
	INNER JOIN employees ON employees.employee_id=point_log.employee_id
	INNER JOIN site_admins ON site_admins.user_id=point_log.manager_id
	WHERE (employee_signed_date IS NULL OR manager_signed_date IS NULL) 
	AND coalesce(refused_to_sign,0) = 0 AND coalesce(manually_signed,0) = 0 
	AND activity_date < now() - interval 7 day
	AND point_log.manager_id=?
	ORDER BY activity_date ASC";
	list($rs,$err)=runIQuery($db,$sql,array('i',$managerID));
	//list($rs,$err)=runIQuery($db,$sql); //insert manager id in sql for testing and use this 

	if (count($rs)) {
		$pointTable="<table><thead><tr><th>Email Sent On</th><th>Employee</th><th>Employee Signed On</th><th>Manager Signed On</th></tr></thead><tbody>";
		foreach($rs as $data) {
			$activityDate=formatDateDBToWeb($data['activity_date']);
			$employeeName=$data['first_name'] . " " . $data['last_name'];
			$managerName=$data['full_name'];
			$employeeSignDate=formatDateDBToWeb($data['employee_signed_date']);
			$managerSignDate=formatDateDBToWeb($data['manager_signed_date']);

			$pointTable.="<tr><td>$activityDate</td>";
			$pointTable.="<td>$employeeName</td>";
			$employeeSignDate ? $pointTable.="<td>$employeeSignDate</td>" : $pointTable.="<td>Has not signed yet</td>";
			$managerSignDate ? $pointTable.="<td>$managerSignDate</td>" : $pointTable.="<td>Has not signed yet</td>";
			$pointTable.="</tr>";	
		}

		$pointTable.="</tbody></table>";

		$mail = new PHPMailer();
		$mail->IsSMTP();
		$mail->SMTPDebug  = 0;
		$mail->Debugoutput = 'html';
		$mail->Host = "email-smtp.us-east-1.amazonaws.com";
		$mail->Port       =587;
		$mail->SMTPSecure = 'tls';
		$mail->SMTPAuth   = true;
		$mail->Username = $smtpUser;
		$mail->Password   = $smtpPassword;
		
		$mail->SetFrom($userEmail,"Preferred Welding");	
		$mail->AddAddress($userEmail,$managerName);
		$mail->Subject = "Signatures Still Needed For Employee Points";

		$mail->isHTML(true);  

		$message="The following employee points signatures have not been collected yet.\n";
		$message.=$pointTable; 

		$mail->Body = $message;	
	
			if(!$mail->Send()) {
				if(!$mail->Send()) {
					if(!$mail->Send()) {
					echo "Mailer Error: " . $mail->ErrorInfo;
					}
				}
			}
	}
}

?>

