<?php
include('dbConnection.php');
#error_reporting(E_ALL);
#ini_set('display_errors','on');
include('functions.php');
include('security.php');
if ($isEmployee) {
	$exit;
}
include('header.php');
$search=$_GET['quick_search'];
$oursearch=cleanText(str_replace(" ","%",$search));
function buildSQL($db,$table,$oursearch,$userID,$isAdmin) {
	$sql="select * from $table where 1 > 0 ";
	$comma="";
	$sql.=" and (";
	$dsql="select * from field_names where table_name='$table' and key_field=0 ";
	list($rs,$err)=runIQuery($db,$dsql);
	foreach ($rs as $data) {
		$ftype=$data['field_type'];
		if ($ftype!='B' and $ftype!='D' and $ftype!='date') {
			if ($ftype=='N') {
				if (is_numeric($oursearch)) {
					$sql.=$comma;
					$sql.=$data['field_name'] . " = " . $oursearch;
					$comma=" or ";
				}
			} else {
				$sql.=$comma;
				$sql.=$data['field_name'] . " like '%" . $oursearch . "%' ";
				$comma=" or ";
			}
		}
	}
	$sql.=") ";
	$built=true;
	if ($comma=="") {
		$built=false;
	}
	return array($sql,$built);
}
?>
<div class='row-fluid'>
<form name='searchform2' action='search.php' method='GET'>
<input type='text' name='quick_search' value='<?=$oursearch?>'>
<div style="display:flex; flex-direction:row">
	<input type='checkbox' id='batchcheck' name='batchcheck' value=1>
	<label for='batchcheck'>Show batches</label>
</div>
<?php
print renderButton("FIND","blue","document.searchform2.submit()");
?>
</form>
<div class='span11'  >
Results for <?=$search?> ...
</div>
</div>
<?php
if (strtolower($userEmail) != "shop") {
?>
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box blue" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Items</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
if (! trim($oursearch)) {
	print "Enter A Search Term";
	include('footer.php');
	exit;
}

require_once('s3.php');


	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>Item</th>";
	print "<th>Description</th>";
	print "<th>Customer</th>";
	print "<th>Vendor</th>";
	print "<th>Item Category</th>";
	print "<th>PPH</th>";
	print "<th>Cost</th>";
	print "<th>Price</th>";
	print "<th>Width</th>";
	print "<th>Length</th>";
	print "<th>Price/Sq Inch</th>";
	print "<th>Log</th>";
	print "<th>Attachments</th>";
	print "</thead>\n";
	print "<tbody>";

	$sql="select * from items left outer join item_categories on item_category=category_id left outer join vendors v on items.vendor_id=v.vendor_id left outer join customers c on items.customer_id=c.customer_id  where item_name like '%$oursearch%' or item_description like '%$oursearch%' or vendor_part_number like '%$oursearch%' or coalesce(category_name,'') like '%$oursearch%' or drawing like '%$oursearch%'  ";
	$sql.=" order by item_name  ";



	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$name=$data['item_name'];
		$category=$data['category_name'];
		$customer=$data['name'];
		$vendor=$data['vendor_name'];
		$itemID=$data['item_id'];
		$desc=$data['item_description'];
		$cost=$data['cost'];
		$price=$data['price'];
		$width=$data['width'];
		$length=$data['length'];
		if ($price ==0 ) {
			$sql="select price from order_lines where item_id=? order by line_id desc LIMIT 1 ";
			list($ors,$err)=runIQUery($db,$sql,array("s",$name));
			if (count($ors)>0 ) {
				$odata=$ors[0];
				$price=$odata['price'];
			}
		}
		$sql="select min(pph) from routing where parent_part = ? and pph > 0";
		list($prs,$err)=runIQuery($db,$sql,array("s",$name));
		$pph="";
		if (count($prs)) {
			$pph=$prs[0][0];
		}
		print "<tr>";
		print "<td valign='top' onclick=\"editItem('$itemID');\" style='cursor: pointer;'>$name</td>";
		print "<td valign='top'>$desc</td>";
		print "<td valign='top'>$customer</td>";
		print "<td valign='top'>$vendor</td>";
		print "<td align='center' valign='top'>$category</td>";
		print "<td align='center' valign='top'>$pph</td>";
		print "<td align='center' valign='top'>$cost</td>";
		print "<td align='center' valign='top'>$price</td>";
		print "<td align='center' valign='top'>$width</td>";
		print "<td align='center' valign='top'>$length</td>";
		$pi=0;
		if ($width > 0 and $length > 0 ) {
			$pi=$price / ($width * $length * 2);
		}
		print "<td align='center' valign='top'>";
		print number_format($pi,6);
		print "</td>";
		print "<td>";
		print renderButton("LOG","blue","showLog('$name','items');");
		print "</td>";
		print "<td valign='top'>";
		$basePrefix=-1;
		if ($customer == "Dematic Corp.") {
			if (strlen($name)>10) {
				$baseName=substr($name,0,strlen($name)-2);
				$sql="select item_id from items where item_name=?";
				list($brs,$err)=runIQuery($db,$sql,array("s",$baseName));
				if (count($brs)>0) {
					$bdata=$brs[0];
					$basePrefix=$bdata['item_id'];
				}
			}
		}

		$filesShown=array();
		$dh = listFiles($itemID);
		foreach ($dh as $fulldir) {
			$tmp = explode('/', $fulldir); //only get the final file
			$filename = array_pop($tmp);
			if (! in_array($filename,$filesShown)) {
				list($prefix,$rest)=explode("-",$filename);
				$rest=substr($filename,strlen($prefix)+1,999);
				$fid=str_replace("-","",str_replace(".","",$filename));
				$filesShown[]=$filename;
				$flink = rawurlencode($fulldir);
				print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' target='_blank'>View $rest A</a>&nbsp;";
			}
		}
		$dh = listFiles($basePrefix);
		foreach ($dh as $fulldir) {
			$tmp = explode('/', $fulldir); //only get the final file
			$filename = array_pop($tmp);
			if (! in_array($filename,$filesShown)) {
				list($prefix,$rest)=explode("-",$filename);
				$rest=substr($filename,strlen($prefix)+1,999);
				$fid=str_replace("-","",str_replace(".","",$filename));
				$filesShown[]=$filename;
				$flink = rawurlencode($fulldir);
				print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' target='_blank'>View $rest B</a>&nbsp;";
			}
		}
		$dh = listFiles();
		foreach ($dh as $fulldir) {
			$tmp = explode('/', $fulldir); //only get the final file
			$filename = array_pop($tmp);
			if (! in_array($filename,$filesShown)) {
				$noType=explode(".",$filename);
				$fileparts=explode("_",$noType[0]);
				if (substr($fname,0,strlen($fileparts[0])) == substr($name,0,strlen($fileparts[0]))) {
					$fid=str_replace("-","",str_replace(".","",$filename));
					$filesShown[]=$filename;
					$flink = rawurlencode($fulldir);
					print "&nbsp;<a id='$fid' href='showDocument.php?id=$flink' target='_blank'>View $filename C</a>&nbsp;";
				}
			}
		}
		if (shouldIShowWeld($db,$itemID)) {
			$filename="WeldDiscontinuities.pdf";
			$fid=str_replace("-","",str_replace(".","",str_replace("pdf","",$filename)));
			print "&nbsp;<a id='$fid' href='showDocument.php?id=$filename' target='_blank'>View $filename</a>";
		}

		print "</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
?>
</div>
</div>
</div>
</div>
<?php } ?>
<!-- next search -->
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box blue" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Sales Orders</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>SO</th>";
	print "<th>Date Entered</th>";
	print "<th>Customer PO</th>";
	print "<th>PO Line</th>";
	print "<th>Customer</th>";
	print "<th>Part</th>";
	print "<th>Quantity</th>";
	print "<th>Price</th>";
	print "<th>Due Date</th>";
	print "<th>Status</th>";
	print "</thead>\n";
	print "<tbody>";
	$sql="select orders.order_id, date_order, po_number, po_line, customers.name, item_id, item_description, due_date, status_name, quantity, price from order_lines inner join orders on order_lines.order_id=orders.order_id left outer join customers on orders.customer_id=customers.customer_id left outer join order_status on orders.status=status_id ";
	$sql.=" where (( customers.name like '%$oursearch%' or item_id like '%$oursearch%' or item_description like '%$oursearch%' or po_number like '%$oursearch%' ) ";
	if (is_numeric($oursearch)) {
		$sql.=" or orders.order_id=$oursearch ";
	}
	if (formatDateWebtoDB($oursearch)!="0000-00-00") {
		$sql.=" or order_lines.due_date='" . formatDateWebtoDB($oursearch) . "' ";
	}
	$sql.=") ";
	$sql.=" order by po_number, po_line + 0, date_due desc ";
	if ($_GET['debug']) {
		print $sql;
		print "<hr>";
	}
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$order_id=$data['order_id'];
		$name=$data['name'];
		$odt=formatDateDBToWeb($data['date_order']);
		$item=$data['item_id'];
		$po=$data['po_number'];
		$pol=$data['po_line'];
		$price=$data['price'];
		$description=$data['item_description'];
		$status=$data['status_name'];
		$sql="select item_id from items where item_name=?";
		list($irs,$err)=runIQuery($db,$sql,array("s",$item));
		$idata=$irs[0];
		$itemID=$idata[0];
		print "<tr style='cursor: pointer;'>";
		print "<td onclick=\"editOrders('$order_id');\" >" . $data['order_id'] . "</td>";
		print "<td>$odt</td>";
		print "<td onclick=\"editOrders('$order_id');\" >$po</td>";
		print "<td onclick=\"editOrders('$order_id');\" >$pol</td>";
		print "<td onclick=\"editOrders('$order_id');\" >$name</td>";
		print "<td onclick=\"editOrders('$order_id');\" >$item $description</a></td>";
		print "<td onclick=\"editOrders('$order_id');\" >" . $data['quantity'] . "</a></td>";
		print "<td onclick=\"editOrders('$order_id');\">" . number_format($price,2) . "</a></td>";
		print "<td onclick=\"editOrders('$order_id');\" >" . formatDateDBToWeb($data['due_date']) . "</td>";
		print "<td onclick=\"editOrders('$order_id');\" >" . $status . "</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
?>
</div>
</div>
</div>
</div>
<!-- next search -->
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box blue" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Purchase Orders</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
//Table 1/2 adding a column 6/22 Brittany
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>PO</th>";
	print "<th>Vendor</th>";
	print "<th>Part</th>";
	print "<th>Due Date</th>";
	print "<th>Date Emailed</th>";
	print "<th>Qty On PO</th>";
	print "<th>Qty Open</th>";
	print "<th>Price</th>";
	print "<th>Status</th>";
	print "<th>SO</th>";
	print "<th>MT</th>";
	print "<th>WO</th>";
	if (isset($_GET['batchcheck']) && $_GET['batchcheck']==1) {
		print "<th>Batch</th>";
	}
	print "</thead>\n";
	print "<tbody>";
	$sql="select purchase_orders.po_id, vendor_name, po_lines.job_id, po_lines.quantity, item_name, items.item_description, date_expected, po_status.status_name, ";
	$sql.=" po_lines.quantity - coalesce(quantity_received,0) as qtyopen, reference, order_id, po_lines.price from items ";
	$sql.=" inner join po_lines on items.item_id=po_lines.item_id inner join purchase_orders on po_lines.po_id=purchase_orders.po_id  ";
	$sql.=" left outer join vendors on purchase_orders.vendor_id=vendors.vendor_id left outer join po_status on purchase_orders.status=status_id ";
	$sql.=" left outer join jobs on po_lines.job_id=jobs.job_id left outer join order_lines on jobs.line_id=order_lines.line_id ";
	$sql.=" where (( vendor_name like '%$oursearch%' or items.item_name like '%$oursearch%' or items.item_description like '%$oursearch%' or reference='$oursearch' ) ";
	if (is_numeric($oursearch)) {
		$sql.=" or purchase_orders.po_id=$oursearch ";
	}
	if (formatDateWebtoDB($oursearch)!="0000-00-00") {
		$sql.=" or po_lines.date_expected='" . formatDateWebtoDB($oursearch) . "' ";
	}
	if (is_numeric($oursearch)) {
		$sql.=" or purchase_orders.po_id in (select distinct po_id from order_lines, jobs, po_lines where order_id=$oursearch and order_lines.line_id = jobs.line_id and jobs.job_id=po_lines.job_id ) ";
	}
	$sql.=") ";
	$sql.=" order by date_expected desc";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$po_id=$data['po_id'];
		$name=$data['vendor_name'];
		$item=$data['item_name'];
		$so=$data['reference'];
		$description=$data['item_description'];
		$status=$data['status_name'];
		$price=$data['price'];
		$poqty=$data['quantity'];
		$sql="select packing_slip from transfer_lines where po_number=?";
		list($trs,$err)=runIQuery($db,$sql,array("i",$po_id));
		$mt="";
		if (count($trs)>0) {
			$mt=$trs[0][0];
		}
		print "<tr onclick=\"editPO('$po_id');\" style='cursor: pointer;'>";
		print "<td>" . $po_id . "</td>";
		print "<td>$name</td>";
		print "<td>$item $description</td>";
		print "<td>" . formatDateDBToWeb($data['date_expected']) . "</td>";
		$sql="select email_date from email_log where email_type='PO' and document_number=? order by email_date";
		list($ers,$err)=runIQuery($db,$sql,array("i",$po_id));
		$dt="";
		if (count($ers)>0) {
			$dt=formatDateDBToWeb($ers[0][0]);
		}
		print "<td>$dt</td>";
		print "<td>$poqty</td>";
		print "<td>" . $data['qtyopen'] . "</td>";
		print "<td>" . number_format($price,2) . "</td>";
		print "<td>" . $status . "</td>";
		print "<td>";
		$order=$data['order_id'];
		if (! $order) {
			$order=$so;
		}
		print $order;
		print "</td>";
		print "<td>";
		print $mt;
		print "</td>";
		print "<td>";
		if (! $isCustomer)  {
			print "<a href='editJob.php?id=" . $data['job_id'] . "' target='_blank'>";
		}
		print $data['job_id'];
		print "</a>";
		print "</td>";
		//add batch
		if (isset($_GET['batchcheck']) && $_GET['batchcheck']==1) {
			$sql="SELECT purchase_orders.po_id, jobs_batch_orders.batch_id
			FROM purchase_orders
			LEFT OUTER JOIN po_lines ON po_lines.po_id = purchase_orders.po_id
			LEFT OUTER JOIN order_lines ON order_lines.line_id = po_lines.line_id
			LEFT OUTER JOIN jobs ON jobs.line_id = order_lines.line_id
			LEFT OUTER JOIN jobs_batch_orders ON jobs_batch_orders.job_id = jobs.job_id
			WHERE purchase_orders.po_id = ?";
			list($brs,$err)=runIQuery($db,$sql,array('i',$po_id));
			foreach ($brs as $data) {
				is_null($data['batch_id']) ? $batch='No Batch' : $batch=$data['batch_id'];
			}
			print "<td>";
			if ($batch != "No Batch") {
				print "<a href='batchView.php?batch=$batch' target='_blank'>$batch</a>";
			} else {
				print $batch;
			}
			print "</td>";
		}
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
?>
</div>
</div>
</div>
</div>
<!-- next search -->
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box yellow" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Work Orders</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
	//Table 2/2 adding a column 6/22 Brittany
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>WO</th>";
	print "<th>Customer</th>";
	print "<th>Part</th>";
	print "<th>Due Date</th>";
	print "<th>Quantity Scheduled</th>";
	print "<th>Quantity Good</th>";
	print "<th>Sales Order</th>";
	print "<th>Sales Order Status</th>";
	//added batch column 6/22
	print "<th>Batch</th>";
	print "</thead>\n";
	print "<tbody>";
	$sql="select job_id, jobs.item_id, jobs.description, start_date, quantity_scheduled, quantity_good, job_status.status_name, customers.name, jobs.line_id, os.status_name as ostatus ";
	$sql.=" from jobs left  outer join customers on jobs.customer_id=customers.customer_id left outer join job_status on status=job_status.status_id ";
	$sql.=" left outer join order_lines l on jobs.line_id=l.line_id left outer join order_status os on l.line_status=os.status_id ";
	$sql.=" where 1 > 0 ";
	$sql.=" and (( customers.name like '%$oursearch%' or jobs.item_id like '%$oursearch%' or description like '%$oursearch%' ) ";
	if (is_numeric($oursearch)) {
		$sql.=" or job_id=$oursearch ";
		$sql.=" or jobs.line_id in (select line_id from order_lines where order_id=$oursearch) ";
	}
	if (formatDateWebtoDB($oursearch)!="0000-00-00") {
		$sql.=" or start_date='" . formatDateWebtoDB($oursearch) . "' ";
	}
	$sql.=") ";
	if (is_numeric($oursearch)) {
		$sql.=" union all select j.job_id, j.item_id, j.description, j.start_date, quantity_scheduled, quantity_good, job_status.status_name, customers.name, l.line_id,os.status_name as ostatus  ";
		$sql.=" from order_lines l left outer join  jobs_orders jo on l.line_id=order_line  ";
		$sql.=" inner join jobs j on jo.job_id=j.job_id ";
		$sql.=" left outer join order_status os on line_status=status_id ";
		$sql.=" left  outer join customers on j.customer_id=customers.customer_id left outer join job_status on status=job_status.status_id ";
		$sql.=" where l.order_id=$oursearch ";
		$sql.=" order by start_date desc ";
	}
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$job_id=$data['job_id'];
		$name=$data['name'];
		$item=$data['item_id'];
		$description=$data['description'];
		$status=$data['status_name'];
		$qty=$data['quantity_scheduled'];
		$good=$data['quantity_good'];
		$line=$data['line_id'];
		$ostatus=$data['ostatus'];
		$sql="select order_id from order_lines where line_id=?";
		list($lrs,$err)=runIQuery($db,$sql,array("i",$line));
		$ldata=$lrs[0];
		$so=$ldata[0];
		print "<tr onclick=\"editJobs('$job_id');\" style='cursor: pointer;'>";
		print "<td>" . $job_id . "</td>";
		print "<td>$name</td>";
		print "<td>$item $description</td>";
		print "<td>" . formatDateDBToWeb($data['start_date']) . "</td>";
		print "<td align='right'>" . $qty . "</td>";
		print "<td align='right'>" . $good . "</td>";
		print "<td><a href=\"javascript:void(editOrders('$so'))\">$so</a></td>";
		print "<td>$ostatus</td>";
		//add batch
		if (isset($_GET['batchcheck']) && $_GET['batchcheck']==1) {
			$sql="SELECT jobs.job_id, jobs_batch_orders.batch_id
			FROM jobs
			LEFT OUTER JOIN jobs_batch_orders ON jobs_batch_orders.job_id = jobs.job_id
			WHERE jobs.job_id = ?";
			list($brs,$err)=runIQuery($db,$sql,array('i',$job_id));
			foreach ($brs as $data) {
				is_null($data['batch_id']) ? $jbatch='No Batches' : $jbatch=$data['batch_id'];
			}
		} else {
			$jbatch='NA';
		}
		print "<td>$jbatch</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
?>
</div>
</div>
</div>
</div>
<!-- next search -->
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box blue" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Packing Slips</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>Packing Slip</th>";
	print "<th>Customer</th>";
	print "<th>Customer PO</th>";
	print "<th>PO Line</th>";
	print "<th>Ship To</th>";
	print "<th>Our SO</th>";
	print "<th>Part</th>";
	print "<th>Date Shipped</th>";
	print "<th>Quantity Shipped</th>"; ## bdoss 12/16/22 added quantity shipped per Justin request
	print "<th>Invoice</th>";
	print "<th>BOL</th>";
	print "</thead>\n";
	print "<tbody>";
	$sql="select packing_list_id, ship_name, po_number, packing_slip_lines.po_line, customers.name, part_number, description, date_shipped, packing_slip_lines.order_id, invoice_number, shipped_quantity from packing_slip_lines, packing_slip, order_lines, customers  ";
	$sql.=" where packing_slip_id=packing_list_id ";
	$sql.=" and order_lines.line_id = packing_slip_lines.order_line ";  ## bdoss 12/16/22 added in shipped quantity
	$sql.=" and packing_slip.customer_id=customers.customer_id ";
	$sql.=" and (( customers.name like '%$oursearch%' or part_number like '%$oursearch%' or description like '%$oursearch%' ) ";
	if (is_numeric($oursearch)) {
		$sql.=" or packing_list_id=$oursearch ";
		$sql.=" or packing_slip_lines.order_id=$oursearch ";
	}
	$sql.=" or po_number='$oursearch' ";
	$sql.=" or tracking_number like '%$oursearch%' ";
	if (formatDateWebtoDB($oursearch)!="0000-00-00") {
		$sql.=" or date_shipped='" . formatDateWebtoDB($oursearch) . "' ";
	}
	$sql.=") ";
	$sql.=" order by po_number, packing_slip_lines.po_line + 0 ";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$name=$data['name'];
		$item=$data['part_number'];
		$po=$data['po_number'];
		$pol=$data['po_line'];
		$order=$data['order_id'];
		$pl=$data['packing_list_id'];
		$description=$data['description'];
		$shippedQuantity=$data['shipped_quantity'];
		print "<tr onclick=\"editSlips('$pl');\" style='cursor: pointer;'>";
		print "<td valign='top'>" . $data['packing_list_id'] . "</td>";
		print "<td valign='top'>$name</td>";
		print "<td valign='top'>$po</td>";
		print "<td valign='top'>$pol</td>";
		print "<td valign='top'>" . $data['ship_name'] . "</td>";
		print "<td valign='top'>$order</td>";
		print "<td valign='top'>$item $description</td>";
		print "<td valign='top'>" . formatDateDBToWeb($data['date_shipped']) . "</td>";
		print "<td valign='top'>$shippedQuantity</td>";
		$invoice=$data['invoice_number'];
		if ($invoice==0) {
			$invoice="";
		}
		print "<td valign='top'>" . $invoice . "</td>";
		print "<td valign='top'>";
		$sql="select distinct bol_id from bol_skids where packing_slip=?";
		$comma="";
		list($brs,$err)=runIQuery($db,$sql,array("i",$pl));
		foreach ($brs as $bdata) {
			print $comma;
			print "<a href='editBOL.php?id=" . $bdata['bol_id'] . "' target='_blank'>";
			print $bdata['bol_id'];
			print "</a>";
			$comma=", ";
		}
		print "</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
?>
</div>
</div>
</div>
</div>
<!-- next search -->
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box blue" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Material Transfers</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>Packing Slip</th>";
	print "<th>Customer</th>";
	print "<th>Customer PO</th>";
	print "<th>PO Line</th>";
	print "<th>Ship To</th>";
	print "<th>Our SO</th>";
	print "<th>Our PO</th>";
	print "<th>Part</th>";
	print "<th>Quantity</th>";
	print "<th>Date Transferred</th>";
	print "</thead>\n";
	print "<tbody>";
	$sql="select transfers.packing_slip, transfers.ship_name, transfer_date, l.po_number, l.part_number, l.description, transfer_date, l.quantity, ";
	$sql.=" so_number, c.name, pl.line_id as po_line, o.po_number as customer_po  ";
	$sql.=" from transfer_lines l inner join transfers   ";
	$sql.=" on transfers.packing_slip=l.packing_slip ";
	$sql.=" left outer join items i on part_number=item_name ";
	$sql.=" left outer join po_lines pl on l.po_number=pl.po_id and i.item_id=pl.item_id ";
	$sql.=" left outer join orders o on so_number=o.order_id ";
	$sql.=" left outer join customers c on o.customer_id=c.customer_id ";
	$sql.= " where 1 > 0 ";
	$sql.=" and (( transfers.ship_name like '%$oursearch%' or part_number like '%$oursearch%' or l.description like '%$oursearch%' or l.po_number like '%$oursearch%'  ";
	$sql.=" or c.name like '%$oursearch%' or o.po_number like '%$oursearch%' ) ";
	if (is_numeric($oursearch)) {
		$sql.=" or transfers.packing_slip=$oursearch ";
		$sql.=" or so_number = $oursearch ";
	}
	if (formatDateWebtoDB($oursearch)!="0000-00-00") {
		$sql.=" or transfer_date='" . formatDateWebtoDB($oursearch) . "' ";
	}
	$sql.=") ";
	$sql.=" order by transfer_date desc ";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$name=$data['ship_name'];
		$item=$data['part_number'];
		$po=$data['po_number'];
		$so=$data['so_number'];
		$pl=$data['packing_slip'];
		$poline=$data['po_line'];
		$customer=$data['name'];
		$customerPO=$data['customer_po'];
		$description=$data['description'];
		print "<tr onclick=\"editTransfer('$pl');\" style='cursor: pointer;'>";
		print "<td>" . $data['packing_slip'] . "</td>";
		print "<td>$customer</td>";
		print "<td>$customerPO</td>";
		print "<td>$poLine</td>";
		print "<td>" . $data['ship_name'] . "</td>";
		print "<td>$so</td>";
		print "<td>$po</td>";
		print "<td>$item $description</td>";
		print "<td align='center'>" . $data['quantity'] . "</td>";
		print "<td>" . formatDateDBToWeb($data['transfer_date']) . "</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
?>
</div>
</div>
</div>
</div>
<!-- next search -->
<?php
if (strtolower($userEmail) != "shop") {
?>
<div class='row-fluid'>
<div class='span11'  >
<div class="portlet box red" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Customers</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
list($sql,$built)=buildSQL($db,"customers",$oursearch,$userID,$isAdmin);
if ($built) {
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>Name</th>";
	print "<th>Phone</th>";
	print "<th>Email</th>";
	print "</thead>\n";
	print "<tbody>";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$client_id=$data['customer_id'];
		print "<tr onclick=\"editCustomer('$client_id');\" style='cursor: pointer;'>";
		print "<td>" . $data['name'] . "</td>";
		print "<td>" . $data['phone'] . "</td>";
		print "<td>" . $data['email'] . "</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
}
?>
</div>
</div>
</div>
</div>
<!-- next search -->
<div class='row-fluid'>
<div class='span12'  >
<div class="portlet box red" >
	<div class="portlet-title">
		<div class="caption"><i class="icon-user"></i>Vendors</div>
		<div class="tools">
		<a href="javascript:;" class="collapse"></a>
		</div>
	</div>
<div class='portlet-body'>
<?php
list($sql,$built)=buildSQL($db,"vendors",$oursearch,$userID,$isAdmin);
if ($built) {
	print "<table class='table-bordered table-striped table-condensed flip-content' >";
	print "<thead>";
	print "<th>Name</th>";
	print "<th>Phone</th>";
	print "<th>Email</th>";
	print "</thead>\n";
	print "<tbody>";
	list($rs,$err)=runIQuery($db,$sql);
	foreach ($rs as $data) {
		$client_id=$data['vendor_id'];
		print "<tr onclick=\"editVendor('$client_id');\" style='cursor: pointer;'>";
		print "<td>" . $data['vendor_name'] . "</td>";
		print "<td>" . $data['phone'] . "</td>";
		print "<td>" . $data['email'] . "</td>";
		print "</tr>\n";
	}
	print "</tbody>";
	print "</table>\n";
}
?>
</div>
</div>
</div>
</div>
<?php } ?>
<script>
	function editOrders(leadid) {
		url='editOrders.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editPO(leadid) {
		url='editPO.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editJobs(leadid) {
		url='editJob.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editSlips(leadid) {
		url='editSlips.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editTransfer(leadid) {
		url='editTransfer.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editItem(leadid) {
		url='editRecipe.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editCustomer(clientid) {
		url='viewRecord.php?table=customers&key=customer_id&id='+clientid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function editVendor(clientid) {
		url='viewRecord.php?table=vendors&key=vendor_id&id='+clientid+'&rand='+Math.random();
		window.open(url,'editr');
	}
	function showLog(item,tbl) {
		url='showLog.php?table='+tbl+'&search='+item+'&rand='+Math.random();
		window.open(url,'logr');
	}
</script>
<?php
include('footer.php');
?>