<?php
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Schedule";
include('header.php');

$start_date=trim($_GET['start_date']);
if (! $start_date) {
	if ($_SESSION['start_date']) {
		$start_date=$_SESSION['start_date'];
	} else {
		$start_date=Date("m/d/Y");
	}
} else {
	$_SESSION['start_date']=$start_date;
}
$end_date=trim($_GET['end_date']);
if (! $end_date) {
	if ($_SESSION['end_date']) {
		$end_date=$_SESSION['end_date'];
	} else {
		$end_date=Date("m/d/Y");
	}
} else {
	$_SESSION['end_date']=$end_date;

}
if (isset($_GET['part'])) {
	$part=trim($_GET['part']);
	$_SESSION['part']=$part;
} else {
	$part=$_SESSION['part'];
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
	$_SESSION['customer']=$customer;
} else {
	$customer=$_SESSION['customer'];
}

if ($isCustomer) {
	$customer=$isCustomer;
	$_SESSION['customer']=$customer;
}
$searchjob=trim($_GET['searchjob']);
$jobstatus=array();
$sql="select * from job_status";
$rs=mysqli_query($db,$sql);
while ($data=mysqli_fetch_array($rs)) {
	$i=$data['status_id'];
	$n=$data['status_name'];
	$jobstatus[$i]=$n;
}
$searchstatus=$_GET['searchstatus'];
?>
<style>
.future {
	color: black;
	background-color: white;
}
.inprogress {
	color: black;
	background-color: #FFFF00;
}
.onhold {
	color: red;
	background-color: white;
}
.late {
	color: white;
	background-color: #c43f3c;
}
.complete {
	color: black;
	background-color: #9ACD32;
}
.ready {
	color: black;
	font-weight: bold;
	background-color: #FFFF00;
}
.short {
	color: red;
	font-weight: bold;
	background-color: #FFFF00;
}
</style>
<?php
print renderPanel("Job Schedule","Job Schedule", "green", "span11","calendar");
print renderButton("Add New +","green","editJob('0');","newrec");
print renderButton("Export","blue","exportSQL('Schedule');");
print "<div style='clear: both;'></div>\n";
print "<form name='searchform' method='GET' action='schedule.php' class='hidden-print'>\n";
print renderStartItem(TRUE,"searchstatus","Status","span3");
print "<select class='span12' name='searchstatus' id='searchstatus'><option value='' ";
print ">Open Only</option><option value='ALL' ";
if ($searchstatus=='ALL') {
	print " selected ";
}
print ">All</option>";
print "<option value='LATE' ";
if ($searchstatus == "LATE") {
	print " selected ";
}
print ">Late Only</option>";
print "</select>";
print renderEndItem();
print renderDateBox(TRUE,"start_date",$start_date,"Start Date");
print renderDateBox(TRUE,"end_date",$end_date,"End Date");
// add inactive customers code -Josh 02/20/2023
$sql="select customer_id, name from customers where (inactive_customer=0 OR (customer_id=? and inactive_customer=1)) ";
if ($isCustomer) {
	$sql.=" AND customer_id=$isCustomer";
}
$sql.= " order by name";

list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,TRUE,"");
print renderTextBox(TRUE,"part",$part,"Part");
print renderTextBox(TRUE,"searchjob",$searchjob,"Job");
print renderButton("Find","green");
print "</form>\n";
print "<div class='span2 complete' >&nbsp;COMPLETE</div>";
print "<div class='span2 inprogress'>&nbsp;In Progress</div>";
print "<div class='span2 late'>&nbsp;Late</div>";
$sql="select distinct jobs.job_id, jobs.item_id, jobs.description, start_date, quantity_scheduled, quantity_good,  customers.name as customer_name, status_name as status, shift, sequence, duration, l.due_date, o.date_order, o.po_number, projected_completion, actual_completion, packing_list_id, shipped, date_shipped, po_lines.date_expected, po_lines.quantity_received, l.order_id, l.line_id  from jobs left outer join customers on jobs.customer_id=customers.customer_id  left outer join job_status on jobs.status=job_status.status_id left outer join order_lines l on jobs.line_id=l.line_id left outer join orders o on l.order_id=o.order_id left outer join packing_slip_lines s on l.order_id=s.order_id and l.line_id=s.line_id left outer join packing_slip on packing_slip_id=packing_list_id left outer join po_lines on po_lines.job_id=jobs.job_id where 1 > 0 ";
if ($part) {
	$sql.=" and jobs.item_id like '%$part%' ";
}
if ($customer) {
	$sql.=" and jobs.customer_id =$customer ";
}
if ($searchstatus=='') {
	$sql.=" and jobs.status=1";
}
$testStart=formatDateWebToDB($start_date);
$testEnd=formatDateWebToDB($end_date);
$testDate=Date("Y-m-d");
if ($searchstatus != "LATE") {
	if (! $part or $testEnd != Date("Y-m-d") or $testStart != Date("Y-m-d")) {
		$sql.=" and start_date >='" . formatDateWebtoDB($start_date) . "' ";
		$sql.=" and start_date <='" . formatDateWebtoDB($end_date) . "' ";

	}
} else {
	$sql.=" and l.due_date <= now() and jobs.status=1 ";
}
$sql.=" order by start_date, sequence, jobs.item_id";
if ($searchjob!='') {
	$sql="select distinct jobs.job_id, jobs.item_id, jobs.description, start_date, quantity_scheduled, quantity_good,  customers.name as customer_name, status_name as status, shift, sequence, duration, l.due_date, o.date_order, o.status as order_status, o.po_number, projected_completion, actual_completion, packing_list_id, shipped, date_shipped, po_lines.date_expected, po_lines.quantity_received, l.order_id, l.line_id  from jobs left outer join customers on jobs.customer_id=customers.customer_id  left outer join job_status on jobs.status=job_status.status_id left outer join order_lines l on jobs.line_id=l.line_id left outer join orders o on l.order_id=o.order_id left outer join packing_slip_lines s on l.order_id=s.order_id and l.line_id=s.line_id left outer join packing_slip on packing_slip_id=packing_list_id left outer join po_lines	 on po_lines.job_id=jobs.job_id where 1 > 0 and jobs.job_id=$searchjob";

}

print "<table id='showResults' class='table-bordered '>\n";
print "<tr>";
print "<th valign='top'>";
print "Status";
print "</th>";
print "<th valign='top'>";
print "Employee";
print "</th>";
print "<th valign='top'>";
print "OP In Process";
print "</th>";
print "<th valign='top'>";
print "Due Date";
print "</th>";
print "<th valign='top'>";
print "Job";
print "</th>";
print "<th valign='top'>";
print "Date Received";
print "</th>";
print "<th valign='top'>";
print "Qty Scheduled";
print "</th>";
print "<th valign='top'>";
print "Qty Good";
print "</th>";
print "<th valign='top'>";
print "Customer";
print "</th>";
print "<th valign='top'>";
print "SO#";
print "</th>";
print "<th valign='top'>";
print "PO#";
print "</th>";
print "<th valign='top'>";
print "Material Ordered";
print "</th>";
print "<th valign='top'>";
print "Description";
print "</th>";
print "<th valign='top'>";
print "Part";
print "</th>";
print "<th valign='top'>";
print "Hours";
print "</th>";
print "<th valign='top'>";
print "Packing Slip";
print "</th>";
print "<th valign='top'>";
print "Invoiced";
print "</th>";
print "</tr>\n";
print "<tbody>";
$exportsql=$sql;
$rs=mysqli_query($db,$sql);
print mysqli_error($db);
print "<div style='clear: both;'></div>\n";
while ($data=mysqli_fetch_array($rs)) {
	$job=$data['job_id'];
	$item=$data['item_id'];
	$description=$data['description'];
	$orderNumber=$data['order_id'];
	$orderLine=$data['line_id'];
	$dt=formatDateDBToWeb($data['start_date']);
	$qty=$data['quantity_scheduled'];
	$good=$data['quantity_good'];
	$customer=$data['customer_name'];
	$status=$data['status'];
	$ostat = $data['order_status'];
	$po=$data['po_number'];
	if ($ostat > 2) {
		$status="Closed";
		$sql="update jobs set status=2 where job_id=?";
		list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
	}
	$seq=$data['sequence'];
	$line=$data['po_line'];
	$dtr=formatDateDBToWeb($data['date_order']);
	$duration=$data['duration'];
	$lastStep="";
	$currentStep="";
	$sql="select sum(duration_hours) as hours, sum(duration_minutes) as minutes from production_results r where job_id=? ";
	list($prs,$err)=runIQuery($db,$sql,array("i",$job));
	$pdata=$prs[0];
	$hours=$pdata[0];
	$minutes=$pdata[1];
	$duration=($hours * 60) + $minutes;
	$duration = $duration / 60;
	if ($minutes > 60) {
		$mh=floor($minutes / 60);
		$hours += $mh;
		$minutes -= ($mh*60);
		$minutes = round($minutes/60,2);
	}

	## calculate status - put in if status = open after done
	$sql="select max(routing_id) from routing where parent_part=?";
	list($prs,$err)=runIQuery($db,$sql,array("s",$item));
	$pdata=$prs[0];
	$lastStep=$pdata[0];
	$sql="select max(display_sequence) from production_results p, routing r, operations o where p.routing_id = r.routing_id and r.operation_id=o.operation_id and job_id=?";
	list($prs,$err)=runIQuery($db,$sql,array("i",$job));
	$pdata=$prs[0];
	$currentStep=$pdata[0];
	$sql="select operation_name from production_results p, routing r,  operations o where p.routing_id=r.routing_id and  r.operation_id=o.operation_id and job_id=? and display_sequence=?";
	list($prs,$err)=runIQuery($db,$sql,array("ii",$job,$currentStep));
	$pdata=$prs[0];
	$currentOperation=$pdata[0];
	$sql="select coalesce(sum(quantity_good),0) from production_results where routing_id=? and job_id=?";
	list($prs,$err)=runIQuery($db,$sql,array("ii",$lastStep,$job));
	$pdata=$prs[0];
	$tgood=$pdata[0];
	if ($tgood > 0) {
		$good=$tgood;
		$sql="update jobs set quantity_good=? where job_id=?";
		list($jrs,$err)=runIQuery($db,$sql,array("di",$good,$job));
	}
	if ($status == 'Open') {
		## calculate status
		if ($tgood >= $qty) {
			$status='Closed';
			$currentOperation="";
			$sql="update jobs set status=2 where job_id=?";
			list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
		}
	} else {
		$currentOperation="";
	}
	$invoice="";
	$packslip="";
	$sql="select packing_slip_id, invoice_number from packing_slip_lines l, packing_slip h where packing_list_id=packing_slip_id and order_line=?";
	list($prs,$err)=runIQuery($db,$sql,array("i",$orderLine));
	foreach ($prs as $pdata) {
		if ($pdata[1]) {
			$invoice.=$pdata[1] . $comma;
		}
		if ($pdata[0]) {
			$packslip.="<a href='editSlips.php?id=" . $pdata[0] . "' target='_blank'>" . $pdata[0] . "</a>$comma";
			$comma="<BR>";
		}
	}
	if ($status == 'Open') {
		## calculate status
		if ($packslip) {
			$status='Closed';
			$sql="update jobs set status=2 where job_id=?";
			list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
		}
	}
	$style="future";
	if ($data['start_date'] <= Date("Y-m-d")) {
		$style="inprogress";
	}
	if ($status == 'On Hold') {
		$style="onhold";
	}
	if ($status == "Closed") {
		$style="complete";
	}
	$sql="select distinct first_name from production_results r, employees e where job_id=? and r.employee_id=e.card_number";
	list($ers,$err)=runIQuery($db,$sql,array("i",$job));
	if (count($ers) > 0) {
		if ($style=='future') {
			print "???<hr>";
			$style='inprogress';
			$status="Open";
		}
	} else {
		if ($style=='inprogress') {
			$style='late';
		}
	}
	print "<tr class='$style'>";
	print "<td class='$style' valign='top'>";
	if ($status=="Closed" and $good < $qty) {
		if ($good > 0) {
			$style="short";
		} else {
			$sql="update jobs set quantity_good=? where job_id=?";
			list($jrs,$err)=runIQuery($db,$sql,array("di",$good,$job));
		}
	}
	if ($status=="Open" and $good >= $qty) {
		$style="ready";
		$sql="update jobs set status=2 where job_id=?";
	}
	print $status;
	print "</td>";
	print "<td class='$style' valign='top'>";
	$comma="";
	foreach ($ers as $edata) {
		print $comma;
		print $edata['first_name'];
		$comma=", ";
	}
	// get employee here
	print "</td>";
	print "<td class='$style' valign='top'>";
	print $currentOperation;
	print "</td>";
	print "<td  class='$style' valign='top'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print $dt;
	print "</a></td>";
	print "<td  class='$style' align='center' valign='top'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print $job ;
	print "</a></td>";
	print "<td class='$style' valign='top'>$dtr</td>";
	print "<td  class='$style' align='center' valign='top'>$qty</td>";
	print "<td class='$style' align='center' valign='top' align='center'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print $good;
	print "</a></td>";
	print "<td valign='top' class='$style'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print $customer;
	print "</a></td>";
	print "<td class='$style' valign='top'><a class='$style' href='editOrders.php?table=orders&key=order_id&id=$orderNumber' target='_blank'>$orderNumber</a></td>";
	print "<td class='$style' valign='top'><a class='$style' href='editOrders.php?table=orders&key=order_id&id=$orderNumber' target='_blank'>$po</a></td>";
	print "<td></td>\n"; // material ordered
	print "<td valign='top' class='$style'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print $description;
	print "</a></td>";
	print "<td valign='top' class='$style'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print $item;
	print "</a></td>";
	print "<td align='center' valign='top' class='$style'><a class='$style' href='editJob.php?table=jobs&key=job_id&id=$job' target='_blank'>";
	print round($duration,2);
	print "</a></td>";
	print"<td class='$style' valign='top'>$packslip</td>"; // Packing Slip Number
	print"<td class='$style' valign='top'>$invoice</td>"; // Invoice Number
	print "<td align='right' class='hidden-print' class='$style' valign='top'>";
	print "<div style='cursor: pointer; display: inline;' onclick=\"deleteRecord('$key','$table','$keyval');\"><input type='image' src='images/icn_trash.png' title='Cancel' border='0'>";
	print "</div>";
	print "</td>";
	print "</tr>\n";
}
print "</tbody></table>";
?>
<div style='display: none;' id='confirmDialog'>
	Are you sure you want to cancel this job?<br>
	<div class='btn btn-danger' onclick='reallyDelete()'>Confirm Cancel</div>&nbsp;
	<div class='btn' onclick='closeConfirmDialog();'>Do Not Cancel</div>
</div>
<script>
function editJob(id)
{
	url='editJob.php?section=Jobs&action=edit&id='+id;
	document.location.href=url;
}
var delkey=0;
var delkeyfield='';
var deltable='';

function deleteRecord(key,table,id)
{
	delkey=id;
	delkeyfield=key;
	deltable=table;
	html='<table><tr><td colspan=2><h3>Confirm Cancel</h3></td></tr>';
	html=html+'<tr><td colspan=2>Are you sure you want to cancel this job?</td></tr>';
	html=html+'</table>';
	try {
		$('#confirmDialog').dialog({
			modal: true
		});
	}
	catch (err) {
		if (confirm('Are you sure you want to Cancel this job?  Click Cancel to Cancel')) {
			reallyDelete();
		}
	}
}

function reallyDelete() {
	closeConfirmDialog();
	document.getElementById('working').style.display='inline';
	var url = "updateRecord.php"; // the script where you handle the form input.
$.ajax({
	type: "GET",
	url: url,
	data: "key=job_id&table=jobs&status=3&id="+delkey,
	success: function(data)
	{
		hideRow(data);
		document.getElementById('working').style.display='none';
	}
	});
}

function closeConfirmDialog() {
	$('#confirmDialog').dialog('close');
}
function hideRow(returnText)
{
	if (returnText=="<h4 class='alert_success'>Record Deleted</h4>")
	{
		$('#datarow'+delkey).hide();
	}
	else {
		$.gritter.add(returnText);
	}
}
function page_init() {
	$('#showResults').dataTable({"bPaginate" : false});
}

var currentObj;
</script>
</div>
</div>
</div>
</div>
<?php
include('footer.php');
?>