<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Sales Order Progess";
include('header.php');

$order='';

print renderPanel("Sales Order Progress","Sales Order Progress","blue","span11");
print "<form name='findform' action='$scriptid' method=GET>\n";
print renderTextBox(TRUE,"order",$order,"Order");
print renderButton("Find","blue","document.findform.submit()");
print "</form>\n";
$scriptid="salesOrderProgress.php";

if (isset($_GET['order'])) {

    $oplist=array();
    $oplist[]=3123;
    $oplist[]=3122;
    $oplist[]=3086;
    $oplist[]=3092;
    $oplist[]=3099;
    $oplist[]=3091;
    $oplist[]=3113;
    $oplist[]=3106;
    $oplist[]=3100;
    array_reverse($oplist);
    
    //$sum_defects=0;
    $routing_array=array();


    $sum_done=array();
    $sum_needed=array();
    $joblist=array();
    foreach ($oplist as $op) {
        $sum_done[$op]=0;
        $sum_needed[$op]=0;
        $joblist[$op]=array();
        $tot_minutes[$op]=0;
       
    }
    $ship_address=0;
    $due_date=0;

	$order=$_GET['order'];
    $sql= "SELECT orders.ship_name, orders.date_due, order_lines.line_id, order_lines.item_id, order_lines.item_description, status_name, quantity 
    FROM orders 
    INNER JOIN order_lines ON orders.order_id = order_lines.order_id 
    INNER JOIN order_status ON order_status.status_id = order_lines.line_status
    WHERE orders.order_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("s",$order));
    if (count($rs)) {
        print "<div style='clear: both;'></div>";
        print "<p>Click on the Order Number for Job Detail</p>";

        foreach ($rs as $data) {
            $ship=$data['ship_name'];
            $due=formatDateDBToWeb($data['date_due']);
            $line=$data['line_id'];
            $part=$data['item_id'];
            $description=$data['item_description'];
            $status=$data['status_name'];
            $quantity=$data['quantity'];
            $sql="SELECT jobs.job_id, quantity_scheduled, production_results.quantity_good, production_results.duration_minutes, operation_name, routing.operation_id, routing.routing_id, job_defects.quantity, job_defects.date_reported, employees.first_name + ' ' + employees.last_name AS employee_name
            FROM jobs
            INNER JOIN production_results ON jobs.job_id=production_results.job_id 
            INNER JOIN routing ON production_results.routing_id=routing.routing_id
            INNER JOIN operations ON routing.operation_id=operations.operation_id
            LEFT OUTER JOIN employees ON production_results.employee_id=employees.employee_id
            LEFT OUTER JOIN job_defects ON routing.routing_id=job_defects.routing_id
            WHERE jobs.line_id=? and production_results.notes <> 'SORT' 
            ORDER BY operation_name, jobs.job_id";

            list($irs,$err)=runIQuery($db,$sql,array('s',$line));

                foreach ($irs as $op) {

                        $operation=$op['operation_id'];
                        $dsum=intval($op['quantity_good']);
                        $nsum=$op['quantity_scheduled'];
                        $job=$op['job_id'];
                        $defect=$op['quantity'];
                        $minutes=$op['duration_minutes'];
                        $defect_date=formatDateDBToWeb($op['date_reported']);
                        $name=$op['employee_name'];
                        $routing=$op['routing_id'];

                        if (!in_array($routing, $routing_array)) {
                            array_push($routing_array, $routing);
                        }

                        #these operations stand alone
                            #3113	Racking
                            #3106	Outside Process
                            #3100	Assembly                            
                            #3123	Laser
                            #3122	Bend


                        if ($operation==3100 or $operation == 3123 or $operation == 3122 or $operation == 3106 or $operation == 3113 ) {
                            $sum_done[$operation]+= $dsum;
                            $tot_minutes[$operation]+= $minutes;
                            if (!in_array($job, $joblist[$operation])) {
                                array_push($joblist[$operation], $job);
                                $sum_needed[$operation] += $nsum;
                                $sum_defects+=$defect;
                            }
                        }

                        ## combine all 4 as Machining

                        #3086	Drill/Tap
                        ##3092	PASSIVATE
                        #3118	Boring Mill
                        #3085	Saw

                        if ($operation==3086 or $operation == 3092 or $operation == 3118 or $operation == 3085) {
                            $sum_done[3086] += $dsum;
                            $tot_minutes[$operation]+= $minutes;
                            if (!in_array($job, $joblist[3086])) {
                                array_push($joblist[3086], $job);
                                $sum_needed[3086] += $nsum;
                                $sum_defects+=$defect;
                            }
                        }

                        ### combine all 3 welds into one weld
                        #3099	Weld
                        #3081	Tig Weld
                        #3108	Production Weld

                        if ($operation==3108 or $operation == 3099 or $operation == 3081) {
                            $sum_done[3099] += $dsum;
                            $tot_minutes[$operation]+= $minutes;
                            if (!in_array($job, $joblist[3099])) {
                                array_push($joblist[3099], $job);
                                $sum_needed[3099] += $nsum;
                                $sum_defects+=$defect;
                            }
                        }

                        ## combine as Fabrication

                        #3091	Fabrication
                        #3134	Production Fab

                        if ($operation==3091 or $operation == 3134) {
                            $sum_done[3091] += $dsum;
                            $tot_minutes[$operation]+= $minutes;
                            if (!in_array($job, $joblist[3091])) {
                                array_push($joblist[3091], $job);
                                $sum_needed[3091] += $nsum;
                                $sum_defects+=$defect;
                            }
                        }

                }   

                print "<table class='table table-striped'>";
                print "<thead><tr>";
                print "<th>Order</th>";
                print "<th>Part</th>";
                print "<th>Quantity</th>";
                print "<th class='hover'>Description</th>";
                print "<th class='hover'>Ship To</th>";
                print "<th>Due Date</th>";
                print "<th>Order Status</th>";
                print "<th>Defects</th>";

                if ($sum_needed[3123] > 0) {
                    print "<th>Laser</th>";
                }
                if ($sum_needed[3122] > 0) {
                    print "<th>Bend</th>";
                }
                if ($sum_needed[3099] > 0) {
                    print "<th>Weld</th>";
                }
                if ($sum_needed[3091] > 0) {
                    print "<th>Fabrication</th>";
                }
                if ($sum_needed[3086] > 0) {
                    print "<th>Machining</th>";
                }
                if ($sum_needed[3113] > 0) {
                    print "<th>Powder Coating</th>";
                }
                if ($sum_needed[3106] > 0) {
                    print "<th>Outside Process</th>";
                }
                if ($sum_needed[3100] > 0) {
                    print "<th>Assembly</th>";
                }
                print "</tr></thead><tbody>";
        
                print "<tr>";
                print "<td><a href='folderProgress.php?id=$order' target='_blank'>$order</a></td>";
                print "<td onmouseover='showInfo()' onmouseout='hideInfo()'>$part</td>";
                print "<td>$quantity</td>";
                print "<td class='hover'>$description</td>";
                print "<td class='hover'>$ship</td>";
                print "<td>$due</td>";
                print "<td>$status</td>";
                //print "<td>$sum_defects</td>";
                print "<td><table><tr><th>Quantity</th><th>Who</th><th>When</th><th>Reason</th></tr>";
                foreach($routing_array as $route) {
                    $sql = "SELECT job_defects.quantity, job_defects.date_reported, CONCAT(employees.first_name,' ',employees.last_name) AS employee_name, operations.operation_name
                    FROM job_defects 
                    INNER JOIN routing ON routing.routing_id=job_defects.routing_id
                    INNER JOIN operations ON routing.operation_id=operations.operation_id
                    INNER JOIN production_results ON production_results.routing_id=routing.routing_id
                    INNER JOIN employees ON production_results.employee_id=employees.employee_id
                    WHERE job_defects.routing_id=? and production_results.notes <> 'SORT' 
                    LIMIT 1";
                    list($drs,$err)=runIQuery($db,$sql,array('s',$route));
                    foreach($drs as $ddata) {
                        $def_quan=$ddata['quantity'];
                        $def_date=formatDateDBToWeb($ddata['date_reported']);
                        $def_name=$ddata['employee_name'];
                        $def_reason=$ddata['operation_name'];
                    }
                }
                print "<tr><td>$def_quan</td><td>$def_name</td><td>$def_date</td><td>$def_reason</td></tr>";
                
                print "</table></td>";
                reset($oplist);
                foreach ($oplist as $op) {
                    if ($sum_needed[$op]  > 0) {
                        $color = ($sum_done[$op]/$sum_needed[$op]) == 1 ? 'green' : 'red';
                        print "<td title='minutes (quantity)' style='color: $color'>" . $tot_minutes[$op] . " (" .  $sum_done[$op] . ")</td>";
                    }
                }
                print "</tr>";
                print "</tbody></table>"; 
        }
      } else {
        print "<h2>Sales Order Not Found</h2>";
    }
}
   
print renderClosePanel();

?>

<script>

function page_init() {
	$('.hover').hide();
}

function showInfo() {
    $('.hover').show();
}

function hideInfo() {
    $('.hover').hide();
}

</script>

<?php
include('footer.php');
?>
