<?php
$expanded=1;
$locked=0;
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=OrdersDue.xls");
header("Pragma: no-cache");
header("Expires: 0");
include('dbConnection.php');
include('security.php');
include('functions.php');
function getPartValue($db,$part,$qtyper) {
    $partvalue=0;
    $sql="select child_item, item_category, vendor_id, quantity_per, price from billofmaterial b, items i where parent_item=? and child_item=item_name and child_item <> parent_item  ";
    list($rs,$err)=runIQuery($db,$sql,array("s",$part));
    foreach ($rs as $data) {
        $child=$data['child_item'];
        $category=$data['item_category'];
        $vendor=$data['vendor_id'];
        $qp=$data['quantity_per'] * $qtyper;
        $price=$data['price'];
        if ($category == 19 and $vendor) {
            $partvalue+=$price*$qp;
        } else {
            if (in_array($category, array(22,24,26))) {
                $partvalue+=$price*$qp;
            } else {
                $partvalue+=getPartValue($db,$child,$qp);
            }
        }


    }
    return $partvalue;
}

function processItem($opList,$timeList,$rateList) {
    $totalTime=0;
    foreach ($opList as $op) {
        if (isset($timeList[$op])) {
            $totalTime+=$timeList[$op] * $rateList[$op];
        }
    }
    reset($opList);
    $pctList=array();
    if ($totalTime > 0) {
        foreach ($opList as $op) {
            if (isset($timeList[$op])) {
                $pctList[$op]=($timeList[$op]*$rateList[$op])/$totalTime;       
            }
        }    
    }
    return $pctList;
} 


$start_date=$_GET['start_date'];
if (! $start_date) {
    $start_date=Date("m/d/Y");
}
$end_date=$_GET['end_date'];
if (! $end_date) {
    $end_date=Date("m/d/Y");
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
}
$pval=array();
print "Sales By Operation  $start_date  through $end_date";
print "Operation\tSales Order\tPart\tPrice * Qty\tQuantity Shipped\tRate\tMinutes\tPercent\tDollar Value\n";
include('salesHistoryReportSub.php');
$opList=array();
$timeList=array();
$rateList=array();
$holdItem="";
$totalOPList=array();
$fullOPList=array();
$totalMaterial=0;
foreach ($rs as $data) {
    set_time_limit(100);
	$order=$data['order_id'];
	$item=$data['item_id'];
	$qty=$data['quantity'];
	$customer=$data['customer_id'];
    $price=$data['price'];
    $pph=$data['pph'];
    $people=$data['people'];
    if ($people==0) {
        $people=1;
    }
    $hpp=0;
    if ($pph > 0) {
        $hpp=1/$pph*$people;
    }
    $rate=$data['operation_price'];
    $operationName=$data['operation_name'];
    if ($holdItem != $item) {
        if ($holdItem != "") {
            if (! in_array($op,$fullOPList)) {
                $fullOPList[]=$op;
            }
            $pctList=processItem($opList,$timeList,$rateList);
            reset($opList);
            if (! array_key_exists($item,$pval)) {
                $mtl=getPartValue($db,$item,1);
                $pval[$item]=$mtl;
            } else {
                $mtl=$pval[$item];
            }
            $mtlext=$mtl * $qty;
            $ext=$price * $qty;
            $mpct=0;
            if ($ext > 0) {
                $mpct=number_format(($mtlext / $ext)*100,1);
            }
            print "Material\t$order\t$item\t$ext\t$qty\t$mtl\t$mpct\t$mtlext\n";
            $totalMaterial+=$mtlext;
            $opext=$ext - $mtlext;
            foreach($opList as $op) {
                print "$op\t$order\t$item\t$opext\t$qty\t";
                print $rateList[$op];
                print "\t";
                print $timeList[$op];
                print "\t";
                print number_format($pctList[$op]*100,1);
                print "\t";
                $dollars=$opext * $pctList[$op];
                print number_format($dollars,2);
                print "\n";
                if (! isset($totalOPList[$op]))  {
                    $totalOPList[$op]=0;
                } 
                $totalOPList[$op]+=$dollars;
            }
        }
        $holdItem=$item;
        unset($opList);
        unset($timeList);
        unset($rateList);
        $opList=array();
        $timeList=array();               
        $rateList=array();
    }
    $hours=$hpp*$qty;
    $minutes=$hours*60;
    if (strtoupper($operationName)=="CURE" or strtoupper($operationName)=="DRY OFF") {
        if ($minutes > 5) {
            $minutes=5;
        }
    }
    if (! in_array($operationName,$opList)) {
        $opList[]=$operationName;
        $timeList[$operationName]=0;
    }
    if (is_numeric($minutes)) {
        $timeList[$operationName]+=$minutes;
    }
    $rateList[$operationName]=$rate;
}
if ($holdItem != "") {
    $pctList=processItem($opList,$timeList,$rateList);
    reset($opList);
    $ext=$price * $qty;
    $mpct=0;
    if ($ext > 0) {
        $mpct=number_format(($mtlext / $ext)*100,1);
    }
    print "Material\t$order\t$item\t$ext\t$qty\t$mtl\t$mpct\t$mtlext\n";
    $totalMaterial+=$mtlext;
    $opext=$ext - $mtlext;

    foreach($opList as $op) {
        if (! in_array($op,$fullOPList)) {
            $fullOPList[]=$op;
        }
        print "$op\t$order\t$item\t$opext\t$qty\t";
        print $rateList[$op];
        print "\t";
        print $timeList[$op];
        print "\t";
        print number_format($pctList[$op]*100,1);
        print "\t";
        $dollars=$opext * $pctList[$op];
        print number_format($dollars,2);
        print "\n";
        if (! isset($totalOPList[$op]))  {
            $totalOPList[$op]=0;
        } 
        $totalOPList[$op]+=$dollars;
    }
}

print "Material\tTotal\t\t\t\t\t\t";
print number_format($totalMaterial,2);
print "\n";
foreach ($fullOPList as $op) {
    if ($op) {
        print "$op\tTotal\t\t\t\t\t\t";
        print number_format($totalOPList[$op],2);
        print "\n";
    }
}
