<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
function getPartValue($db,$part,$qtyper) {
    $partvalue=0;
    $sql="select child_item, item_category, vendor_id, quantity_per, price from billofmaterial b, items i where parent_item=? and child_item=item_name and child_item <> parent_item  ";
    list($rs,$err)=runIQuery($db,$sql,array("s",$part));
    foreach ($rs as $data) {
        $child=$data['child_item'];
        $category=$data['item_category'];
        $vendor=$data['vendor_id'];
        $qp=$data['quantity_per'] * $qtyper;
        $price=$data['price'];
        if ($category == 19 and $vendor) {
            $partvalue+=$price*$qp;
        } else {
            if (in_array($category, array(22,24,26))) {
                $partvalue+=$price*$qp;
            } else {
                $partvalue+=getPartValue($db,$child,$qp);
            }
        }


    }
    return $partvalue;
}

function processItem($opList,$timeList,$rateList) {
    $totalTime=0;
    foreach ($opList as $op) {
        if (isset($timeList[$op])) {
            $totalTime+=$timeList[$op] * $rateList[$op];
        }
    }
    reset($opList);
    $pctList=array();
    if ($totalTime > 0) {
        foreach ($opList as $op) {
            if (isset($timeList[$op])) {
                $pctList[$op]=($timeList[$op]*$rateList[$op])/$totalTime;
            }
        }
    }
    return $pctList;
}


print renderPanel("Sales By Operation");
$start_date=$_GET['start_date'];
if (! $start_date) {
    $start_date=Date("m/d/Y");
}
$end_date=$_GET['end_date'];
if (! $end_date) {
    $end_date=Date("m/d/Y");
}
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
}
$pval=array();
print "<form name='listform' method='GET' action='salesHistoryReport.php'>\n";
print renderDateBox(TRUE,"start_date",$start_date,"Start");
print renderDateBox(TRUE,"end_date",$end_date,"End");
print renderCheckBox(TRUE,"detail",$detail,"Show Detail");
// add inactive customers code -Josh 02/20/2023
$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print renderButton("Find","green","document.listform.submit();");
print renderButton("Export","blue","exportReport();");
print "</form>\n";
print "<table class='table table-bordered table-striped table-condensed flip-content'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "Operation";
print "</th>";
print "<th valign='top'>";
print "Sales Order";
print "</th>";
print "<th valign='top'>";
print "Part";
print "</th>";
print "<th valign='top'>";
print "Price * Qty";
print "</th>";
print "<th valign='top' align='right'>";
print "Quantity Shipped";
print "</th>";
print "<th valign='top'>";
print "Rate";
print "</th>";
print "<th valign='top'>";
print "Minutes";
print "</th>";
print "<th valign='top'>";
print "Percent";
print "</th>";
print "<th valign='top'>";
print "Dollar Value";
print "</th>";
print "</tr>\n";
print "</thead>";
print "<tbody>";
include('salesHistoryReportSub.php');
$opList=array();
$timeList=array();
$rateList=array();
$holdItem="";
$totalOPList=array();
$fullOPList=array();
$totalMaterial=0;
foreach ($rs as $data) {
    set_time_limit(100);
	$order=$data['order_id'];
	$item=$data['item_id'];
	$qty=$data['quantity'];
	$customer=$data['customer_id'];
    $price=$data['price'];
    $pph=$data['pph'];
    $people=$data['people'];
    if ($people==0) {
        $people=1;
    }
    $hpp=0;
    if ($pph > 0) {
        $hpp=1/$pph*$people;
    }
    $rate=$data['operation_price'];
    $operationName=$data['operation_name'];
    if ($holdItem != $item) {
        if ($holdItem != "") {
            if (! in_array($op,$fullOPList)) {
                $fullOPList[]=$op;
            }
            $pctList=processItem($opList,$timeList,$rateList);
            reset($opList);
            if (! array_key_exists($item,$pval)) {
                $mtl=getPartValue($db,$item,1);
                $pval[$item]=$mtl;
            } else {
                $mtl=$pval[$item];
            }
            $mtlext=$mtl * $qty;
                $ext=$price*$qty;
            $mpct=0;
            if ($ext > 0) {
                $mpct=number_format(($mtlext / $ext)*100,1);
            }
            print "<tr><td>Material</td><td><a href='editOrders.php?id=$order' target='_blank'>$order</a></td><td>$item</td><td>$ext</td><td>$qty</td><td>$mtl</td>";
            print "<td></td><td>$mpct</td><td>$mtlext</td></tr>\n";
            print "<td>";
            $totalMaterial+=$mtlext;
            $opext=$ext - $mtlext;

            foreach($opList as $op) {
                print "<tr><td>$op</td><td><a href='editOrders.php?id=$order' target='_blank'>$order</a></td><td>$item</td><td>$opext</td><td>$qty</td><td>";
                print $rateList[$op];
                print "</td><td>";
                print $timeList[$op];
                print "</td>";
                print "<td>";
                print number_format($pctList[$op]*100,1);
                print "</td>";
                $dollars=$opext * $pctList[$op];
                print "<td>";
                print number_format($dollars,2);
                print "</td></tr>\n";
                if (! isset($totalOPList[$op]))  {
                    $totalOPList[$op]=0;
                }
                $totalOPList[$op]+=$dollars;
            }
        }
        $holdItem=$item;
        unset($opList);
        unset($timeList);
        unset($rateList);
        $opList=array();
        $timeList=array();
        $rateList=array();
    }
    $hours=$hpp*$qty;
    $minutes=$hours*60;
    if (strtoupper($operationName)=="CURE" or strtoupper($operationName)=="DRY OFF") {
        if ($minutes > 5) {
            $minutes=5;
        }
    }
    if (! in_array($operationName,$opList)) {
        $opList[]=$operationName;
        $timeList[$operationName]=0;
    }
    if (is_numeric($minutes)) {
        $timeList[$operationName]+=$minutes;
    }
    $rateList[$operationName]=$rate;
}
if ($holdItem != "") {
    $pctList=processItem($opList,$timeList,$rateList);
    reset($opList);
    $ext=$price * $qty;
    $mpct=0;
    if ($ext > 0) {
        $mpct=number_format(($mtlext / $ext)*100,1);
    }
    print "<tr><td>Material</td><td><a href='editOrders.php?id=$order' target='_blank'>$order</a></td><td>$item</td><td>$ext</td><td>$qty</td><td>$mtl</td>";
    print "<td></td><td>$mpct</td><td>$mtlext</td></tr>\n";
    print "<td>";
    $totalMaterial+=$mtlext;
    $opext=$ext - $mtlext;
    foreach($opList as $op) {
        if (! in_array($op,$fullOPList)) {
            $fullOPList[]=$op;
        }
        print "<tr><td>$op</td><td><a href='editOrders.php?id=$order' target='_blank'>$order</a></td><td>$item</td><td>$opext</td><td>$qty</td><td>";
        print $rateList[$op];
        print "</td><td>";
        print $timeList[$op];
        print "</td>";
        print "<td>";
        print number_format($pctList[$op]*100,1);
        print "</td>";
        $dollars=$opext * $pctList[$op];
        print "<td>";
        print number_format($dollars,2);
        print "</td></tr>\n";
        if (! isset($totalOPList[$op]))  {
            $totalOPList[$op]=0;
        }
        $totalOPList[$op]+=$dollars;
    }
}


print "<tr><td>Material</td><td>Total</td><td colspan='6'></td><td>";
print number_format($totalMaterial,2);
print "</td></tr>\n";

foreach ($fullOPList as $op) {
    if ($op) {
        print "<tr><Td>$op</td><td>Total</td><td colspan='6'></td><td>";
        print number_format($totalOPList[$op],2);
        print "</td></tr>\n";
    }
}
print "</tbody>";
print "</table>";
?>
<script>

	function exportReport() {
		url='salesHistoryReportExport.php?start_date='+document.getElementById('start_date').value+'&end_date='+document.getElementById('end_date').value;
        url=url + '&customer='+document.getElementById('customer').value+'&rand='+Math.random();
		window.open(url,'exporter');
	}
    function page_init() {
        $('.datepicker').datepicker();
    }
</script>
</div>
</div>
<?php
include('footer.php');
?>