<?php
$stopS3=0;
$serverName=$_SERVER['SERVER_NAME'];
if ($serverName == "preferredmachinellc.info") {
	$stopS3=1;
}

if (!$stopS3) {
	require 'vendor/autoload.php';
	require_once 'dbConnection.php';
}

use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;

if (!$stopS3) {
    // weld S3 setup
    $sql="select AES_DECRYPT(key_value,'influx2022') from access_keys where key_type='s3_access'";
    list($rs,$err)=runIQuery($db,$sql);
    $s3Key=$rs[0][0];
    $sql="select AES_DECRYPT(key_value,'influx2022') from access_keys where key_type='s3_secret'";
    list($rs,$err)=runIQuery($db,$sql);
    $s3Secret=$rs[0][0];

    // Set Amazon S3 Credentials
    $s3client = S3Client::factory(
        array(
            'credentials' => array(
                'key' => $s3Key,
                'secret' => $s3Secret
            ),
            'version' => 'latest',
            'region'  => 'us-east-1'
        )
    );


    $bucket="welderp";
    $s3client->createBucket(array('Bucket' => $bucket));

    $s3client->waitUntil('BucketExists', array('Bucket' => $bucket));

    // machine/legacy S3 setup
    $sql="select AES_DECRYPT(key_value,'influx2021') from access_keys where key_type='s3_access_Winter21'";
    list($rs,$err)=runIQuery($db,$sql);
    $legacyS3Key=$rs[0][0];
    $sql="select AES_DECRYPT(key_value,'influx2021') from access_keys where key_type='s3_secret_Winter21'";
    list($rs,$err)=runIQuery($db,$sql);
    $legacyS3Secret=$rs[0][0];

    $legacyS3client = S3Client::factory(
        array(
            'credentials' => array(
                'key' => $legacyS3Key,
                'secret' => $legacyS3Secret
            ),
            'version' => 'latest',
            'region'  => 'us-east-1'
        )
    );

    $legacyBucket="preferrederp";
    $legacyS3client->createBucket(array('Bucket' => $legacyBucket));
    $legacyS3client->waitUntil('BucketExists', array('Bucket' => $legacyBucket));
}


// TODO: update documentation for functions
// functions
// TODO: document this function
function getClient($legacy=0) {
    global $s3client, $bucket, $legacyS3client, $legacyBucket;

    $useClient = $s3client;
    $useBucket = $bucket;
    if ($legacy) {
        $useClient = $legacyS3client;
        $useBucket = $legacyBucket;
    }

    return [$useClient, $useBucket];
}
/**
 * Used for listing all files (will include subfolders due to how S3 works), searching for specific files (by prefix), or listing all files in a subfolder
 *
 * List all files in folder example: listFiles('someFolder/')
 * List all files example: listFiles()
 * Search for specific file example: listFiles('startoffile')
 *
 * @param string $search
 * @return array[string]
 */
function listFiles($search = '', $legacy=0) { //Search can be used for searching specific folders as well
	global $stopS3;
	if ($stopS3) {
		return [];
	}

    list($useClient,$useBucket)=getClient($legacy);

    $objects = $useClient->getIterator("ListObjects", array(
        'Bucket' => $useBucket,
        'Prefix' => $search,
        'Delimiter' => '/' //show only current folder
    ));

    $files = [];
    foreach ($objects as $object) {
        $files[] = $object['Key'];
    }

    return $files;
}

/**
 * Retrieve a file
 *
 * Returns a string containing all the data
 *
 * @param string $file
 * @return string
 */
function getFile($file, $legacy=0) {
	global $stopS3;
	if ($stopS3) {
		return "";
	}

    list($useClient,$useBucket)=getClient($legacy);

    try {
        $result = $useClient->getObject(array(
            'Bucket' => $useBucket,
            'Key'    => $file
        ));

        if (isset($result)) {
            return (string) $result['Body'];
        } else {
            return false;
        }
    } catch (S3Exception $e) {
        return false;
    }
}

/**
 * Rename a file on S3
 *
 * @param string $old
 * @param string $new
 * @return void
 */
function renameFile($old, $new, $legacy=0) {
	global $stopS3;
	if ($stopS3) {
		return true;
	}

    list($useClient,$useBucket)=getClient($legacy);

    $useClient->registerStreamWrapper();
    if (rename("s3://$useBucket/$old", "s3://$useBucket/$new")) {
        return true;
    } else {
        return false;
    }
}

/**
 * Check if a file exists or not
 *
 * @param string $file
 * @return boolean
 */
function fileExists($file, $legacy=0) {
	global $stopS3;
	if ($stopS3) {
		return false;
	}

    list($useClient,$useBucket)=getClient($legacy);

    return $useClient->doesObjectExist($useBucket, $file);
}

/**
 * Check if a folder exists or not, currently unused but may use in the future?
 *
 * @param string $folder
 * @return boolean
 */
function folderExists($folder,$legacy=0) {
	global $stopS3;
	if ($stopS3) {
		return false;
	}

    return count(listFiles($folder,$legacy)) != 0;
}

/**
 * Delete a file
 *
 * @param string $file
 * @return boolean
 */
function deleteFile($file, $legacy=0) {
	global $stopS3;
	if ($stopS3) {
		return false;
	}

    list($useClient,$useBucket)=getClient($legacy);

    try {
        $useClient->deleteObject(array(
            'Bucket' => $useBucket,
            'Key'    => $file
        ));
        return true;
    } catch (S3Exception $e) {
        return false;
    }
}

/**
 * Upload a file or string
 *
 * Source is either a path to a file or data to upload
 * fname is the name of the file
 * body is false if source is a path, if source is data to upload you must make it true
 *
 * @param string $source
 * @param string $fname
 * @param boolean $body
 * @return boolean
 */
function uploadFile($source, $fname, $body = false, $legacy=0) {
	global $stopS3;
	if ($stopS3) {
		return false;
	}

    list($useClient,$useBucket)=getClient($legacy);

    $ext = pathinfo(strtolower($fname), PATHINFO_EXTENSION);
    $type = "application/octet-stream";
    if ($ext == "html") {
        $type = "text/html";
    }
    if ($ext == "png") {
        $type = "image/png";
    }
    if ($ext == "jpg") {
        $type = "image/jpeg";
    }
    if ($ext == "pdf") {
        $type = "application/pdf";
    }
    if ($ext == "dwg") {
        $type = "image/vnd.dwg";
    }
    if ($ext == "docx") {
        $type = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    }
    if ($ext == "stp") {
        $type = "application/step";
    }

    try {
        $opts = [
            'Bucket' => $useBucket,
            'Key'    => $fname,
            'ContentType' => $type,
            'ContentDisposition' => 'inline'
        ];

        if ($body) {
            $opts['Body'] = $source;
        } else {
            $opts['SourceFile'] = $source;
        }

        $useClient->putObject($opts);
        return true;
    } catch (S3Exception $e) {
        return false;
    }
}