<?php
#error_reporting(E_ALL);
#ini_set('display_errors','on');
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
$id=$_GET['id'];

print renderPanel("Review Order $id","Review Order $id","green","col-md-12");
print "<p>Please note that if the PDF link returns a 404 error, it is because the PDF does not exist.</p>";
$sql="select * from orders where order_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
$data=$rs[0];
$po=$data['po_number'];
$customer_id=$data['customer_id'];
$sql="select * from customers where customer_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
$cdata=$rs[0];
$customer_name=$cdata['name'];
$customer=str_replace(" ","",$cdata['name']);
$customer_address=$cdata['address'];
$customer_city=$cdata['city'];
$customer_state=$cdata['state'];
$customer_zip=$cdata['zip'];
$customer_phone=$cdata['phone'];
$customer_email=$cdata['email'];
$ship_name=$data['ship_name'];
$ship_address=$data['ship_address'];
$ship_city=$data['ship_city'];
$ship_state=$data['ship_state'];
$ship_zip=$data['ship_zip'];
$date_order=formatDateDBToWeb($data['date_order']);
$date_due=$data['date_due'];
if (! $date_due) {
	$date_due=Date("Y-m-d");
}
$status=$data['status'];
$po_number=$data['po_number'];
//$folder_number=$data['folder_number'];
$orderType=$data['order_type'];
$salesperson_id=$data['salesperson_id'];
$notes_to_customer=$data['notes_to_customer'];
$notes_to_self=$data['notes_to_self'];
$email=$data['email'];
$phone=$data['phone'];
$surcharge=0;
$sql="select status_id, status_name from order_status where status_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$status));
$data=$rs[0];
$status=$data['status_name'];

print "<table class='table table-striped'><thead><tr><th>Customer</th><th>Ship Name</th><th>Date Due</th><th>PO Number</th><th>Sales Order</th><th>Status</th></tr></thead><tbody>";
print "<tr><td>$customer_name</td><td>$ship_name</td><td>";
print formatDateDBToWeb($date_due);
print "</td><td>$po</td><td><a href='editOrders.php?id=$id' target='_blank'>$id</a></td><td>$status</td></tr>\n";
print "</tbody>";
print "</table>\n";
// print renderStartItem(TRUE,"related_orders","Related Orders");
// $sql="select * from orders where po_number=? and order_id != ? and customer_id = ?";
// list($prs,$perr)=runIQuery($db,$sql,array("ssi",$po,$id,$customer_id));
// foreach($prs as $pdata) {
// 	$order=$pdata['order_id'];
// 	//$folder=$pdata['folder_number'];
// 	//$inqb=$pdata['in_quickbooks'];  // column not in weld's sytem
// 	print "<br><a href='reviewOrder.php?id=$order' target='_blank'>$order</a>";
// 	// if ($inqb) {
// 	// 	 print " - In QB";
// 	// }
// }
// print renderEndItem();
// print renderStartItem(TRUE,"documents","Related Documents"); // not in weld
// $sql="select * from documents where order_id=?";
// list($rs,$err)=runIQuery($db,$sql,array("i",$id));
// foreach ($rs as $data) {
// 	$fname=$data['file_name'];
// 	$docid=$data['document_id'];
// 	print "<a href='showDocument.php?id=$docid' target='_blank'>$fname</a><br>";
// }
// print renderEndItem();

print renderStartItem(TRUE,"notes","Internal Notes");
print nl2br($notes_to_self);
print renderEndItem();

print "<table class='table table-striped'><thead><tr><th>Part</th><th>Rev </th><th>Description</th><th>Quantity </th><th>Material</th><th>PO Line</th><th>Due Date</th><th>Operations</th><th>Reviewed</th></tr></thead><tbody>\n";

$sql = "SELECT * FROM order_lines WHERE order_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));

foreach ($rs as $ldata) {
	$date_due=formatDateDBToWeb($ldata['due_date']);
	if ($id == 143069) {
		print_r($ldata);
	}
	$line_id=$ldata['line_id'];
	$item=$ldata['item_id'];
	$desc=$ldata['item_description'];
	$qty=$ldata['quantity'];
	$rev=$ldata['revision'];
	$poline=$ldata['po_line'];
	$reviewed=$ldata['line_reviewed'];
	$material = "";
	$materialList=array();
	findMaterials($item);
	if (count($materialList)) {
		$material=$materialList[0];
	}
	print "<tr>";
	print "<td valign='top'>";
	$dxflink=renderPartLink($customer,$item,0,1);
	print $dxflink;
	print "</td>";
	print "<td valign='top'>";
	print "$rev</td><td valign='top'>$desc</td>";
	print "<td valign='top'>$qty</td><td  valign='top'>$material</td><td  valign='top'>$poline</td><td valign='top'>$date_due</td><td  valign='top'>";
	$sql = "SELECT operation_name, routing.description FROM operations INNER JOIN routing ON routing.operation_id=operations.operation_id WHERE routing.parent_part=?";
	list($ors,$err)=runIQuery($db,$sql,array("s",$item));
	foreach($ors as $odata) {
		if ($odata['description'] == 'PURCHASE') {
			print "PURCHASE";
		} else {
			print $odata['operation_name'];
		}
		print "<br>";
	}
	print "</td>";
	print "<td valign='top'>";
	print "<input type='checkbox' id='reviewed$line_id' value='$line_id' ";
	if ($reviewed) {
		print " checked ";
	}
	print " onclick='checkBox(this);'>";
	print "</td>";
	print "</tr>\n";
	$itemList=array();
	$qtyList=array();
	$sql="select item_id, description, quantity_scheduled, job_reviewed, job_id from jobs where item_id <> '$item' and line_id=$line_id order by job_id ";
	list($jrs,$err)=runIQuery($db,$sql);
	foreach ($jrs as $jdata) {
		$item=$jdata['item_id'];
		$desc=$jdata['description'];
		$job_id=$jdata['job_id'];
		$qty=$jdata['quantity_scheduled'];
		$reviewed=$jdata['job_reviewed'];
		if (! in_array($item,$itemList)) {
			$itemList[]=$item;
			$qtyList[$item]=$qty;
		}
		$rev="";
		$material = "";
		$materialList=array();
		findMaterials($item);
		if (count($materialList)) {
			$material=$materialList[0];
		}
		print "<tr>";
		print "<td valign='top'>$item</td>"; // separate item from dxf so we alway see the item -Josh 03/17/2023
		print "<td valign='top'>";
		$dxflink=renderPartLink($customer,$item,0,1);
		print $dxflink;
		print "</td>";
		print "<td valign='top'>";
		print "$rev</td><td valign='top'>$desc</td>";
		print "<td valign='top'>$qty</td><td  valign='top'>$material</td><td  valign='top'>$poline</td><td valign='top'>$date_due</td><td  valign='top'>";
		$sql = "SELECT operation_name, routing.description FROM operations INNER JOIN routing ON routing.operation_id=operations.operation_id WHERE routing.parent_part=?";
		list($ors,$err)=runIQuery($db,$sql,array("s",$item));
		foreach($ors as $odata) {
			if ($odata['description'] == 'PURCHASE') {
				print "PURCHASE";
			} else {
				print $odata['operation_name'];
			}
			print "<br>";
		}
		print "</td>";
		print "<td valign='top'>";
		print "<input type='checkbox' id='reviewed$job_id' value='$job_id' ";
		if ($reviewed) {
			print " checked ";
		}
		print " onclick='checkJobBox(this);'>";
		print "</td>";
		print "</tr>\n";
	}

	$components=[];
	// preprocess data so we don't have duplicate components -Josh 03/17/2023
	foreach ($itemList as $item) {
		$sql="select child_item, quantity_per, item_description, item_category from billofmaterial left outer join items on child_item=item_name where parent_item='$item'";
		list($crs,$err)=runIQuery($db,$sql);

		//preprocess data to get total component qty
		foreach ($crs as $cdata) {
			$child=$cdata['child_item'];

			if (in_array($child,$itemList)) {
				continue;
			}

			if (!isset($components[$child])) {
				$cdata["total_qty"] = 0;
				$components[$child] = $cdata;
			}

			$qty=$qtyList[$item] * $cdata['quantity_per'];
			$components[$child]["total_qty"] += $qty;
		}
	}

	// Do we need to do a BOM walk for this TODO? -Josh 03/17/2023
	## TODO List every component for parts in itemList()
	foreach ($components as $cdata) {
		if (! in_array($cdata['child_item'],$itemList)) {
			$child=$cdata['child_item'];
			$itemList[]=$child;
			$qty=$cdata["total_qty"];

			$description="";
			if (!empty($cdata["item_description"])) {
				$description=$cdata["item_description"];
			}

			if ($cdata["item_category"] == 24) {
				$material=$child;
			} else {
				findMaterials($item);
				if (count($materialList)) {
					$material=$materialList[0];
				}
			}

			print "<tr>";
			print "<td valign='top'>$child</td>"; // separate item from dxf so we alway see the item -Josh 03/17/2023
			print "<td valign='top'>";
			$dxflink=renderPartLink($customer,$child,0,1);
			print $dxflink;
			print "</td>";
			print "<td valign='top'>";
			print "$rev</td><td valign='top'>$description</td>";
			print "<td valign='top'>$qty</td><td  valign='top'>$material</td><td  valign='top'>$poline</td><td valign='top'>$date_due</td><td  valign='top'>";
			print "</td>";
			print "<td valign='top'>";
			print "</td>";
			print "</tr>\n";
		}
	}

}
print "</tbody>";
print "</table>\n";
?>
<script>
function checkBox(obj) {
	if (obj.checked) {
		url='updateRecord.php?table=order_lines&key=line_id&id='+obj.value+'&line_reviewed=1';
	} else {
		url='updateRecord.php?table=order_lines&key=line_id&id='+obj.value+'&line_reviewed=0';
	}
	$.ajax(url);
}
function checkJobBox(obj) {
	if (obj.checked) {
		url='updateRecord.php?table=jobs&key=job_id&id='+obj.value+'&job_reviewed=1';
	} else {
		url='updateRecord.php?table=jobs&key=job_id&id='+obj.value+'&job_reviewed=0';
	}
	$.ajax(url);
}
</script>
<?php
include('footer.php');
?>
