<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('functions.php');
include('security.php');
error_reporting(0);
$type="";
if (isset($_GET['type'])) {
	$type=$_GET['type'];
}
header("Content-type: application/pdf");
$datestamp=Date("m/d/Y h:i");
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
include('tcpdf_barcodes_2d.php');
$pdf = new TCPDF("P","pt",array(432,288));
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
$pdf->SetLeftMargin(.1);
$pdf->SetRightMargin(.1);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);




	$packslip=$_GET['pack'];
	$labels=$_GET['labels'];
	if ($type == "PACKSLIP") {
		$sql="select * from packing_slip p, packing_slip_lines l where packing_slip_id=? and packing_slip_id=packing_list_id LIMIT 1";
		list($rs,$err)=runIQuery($db,$sql,array("i",$packslip));
		$data=$rs[0];
		$customerID=$data['customer_id'];
		$customer=$data['ship_name'];
		$po=$data['po_number'];
		$folder=$data['order_id'];
		$address=$data['ship_address'];
		$city=$data['ship_city'];
		$state=$data['ship_state'];
		$zip=$data['ship_zip'];
		$sql="select date_due from orders where order_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$folder));
		$dateDue=formatDateDBToWeb($rs[0][0]);
	}
	if ($type == "TRANSFER") {
		$sql="select * from transfers t, transfer_lines l where  t.packing_slip=? and t.packing_slip=l.packing_slip ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$packslip));
		$data=$rs[0];
		$folder="";
		$po="";
		$polist=array();
		$solist=array();
		foreach ($rs as $data) {
			$testso=$data['so_number'];
			if (! in_array($testso,$solist)) {
				if ($folder) {
					$folder.=", ";
				}
				$folder.=$testso;
				$solist[]=$testso;
			}
			$testpo=$data['po_number'];
			if (! in_array($testpo,$polist)) {
				if ($po) {
					$po.=", ";
				}
				$po.=$testpo;
				$polist[]=$testpo;
			}
		}
		$customer=$data['ship_name'];
		$address=$data['ship_address'];
		$city=$data['ship_city'];
		$state=$data['ship_state'];
		$zip=$data['ship_zip'];
		$part=$data['part_number'];	
		$vendor=$data['vendor_id'];
		$sql="select lead_time from vendors where vendor_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$vendor));
		$lead=$rs[0][0];
		if (! $lead) {
			$lead=7;
		}
		$sql="select date_due from orders where order_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$folder));
		$dateDue=formatDateDBToWeb(SubtractBusinessDays($rs[0][0],$lead));

	}
	$style = array(
		'position' => '',
		'align' => 'C',
		'stretch' => false,
		'fitwidth' => true,
		'cellfitalign' => '',
		'border' => false,
		'hpadding' => 'auto',
		'vpadding' => 'auto',
		'fgcolor' => array(0,0,0),
		'bgcolor' => false, //array(255,255,255),
		'text' => true,
		'font' => 'helvetica',
		'fontsize' => 6,
		'stretchtext' => 4
	);
	$qstyle = array(
		'border' => 1,
		'vpadding' => 'auto',
		'hpadding' => 'auto',
		'fgcolor' => array(0,0,0),
		'bgcolor' => false, //array(255,255,255)
		'module_width' => 1, // width of a single module in points
		'module_height' => 1 // height of a single module in points
	);
	$sql="delete from skids where packing_slip_id=? and skid_type=? ";
	list($rs,$err)=runIQuery($db,$sql,array("is",$packslip,$type));
	$skids="SKIDS";
	$i=0;
	while ($i < $labels) {
		$i++;
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
		$font=20;
		$pdf->SetFont("times","",$font,'',false);
		while ($pdf->GetStringWidth($customer)>200) {
			$font-=.5;
			$pdf->SetFont("times","",$font,'',false);
		}
		while ($pdf->GetStringWidth($address)>200) {
			$font-=.5;
			$pdf->SetFont("times","",$font,'',false);
		}
		$csz="$city, $state $zip";
		while ($pdf->GetStringWidth($csz)>200) {
			$font-=.5;
			$pdf->SetFont("times","",$font,'',false);
		}
		$po=str_replace("\r\n","",$po);
		$po=str_replace("\r","",$po);
		$po=str_replace("\n","",$po);
		while ($pdf->GetStringWidth($po)>150) {
			$font-=.5;
			$pdf->SetFont("times","",$font,'',false);
		}
		$pdf->SetFont("times","B",20,'',false);
		$dt="Due: $dateDue";
		$pdf->SetFont("times","",$font,'',false);
		$pdf->SetXY(20,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,"$customer");
		$pdf->StopTransform();
		$pdf->SetXY(48,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,$address);
		$pdf->StopTransform();
		$pdf->SetXY(66,420);
		$pdf->SetFont("times","",$font,'',false);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,$csz);
		$pdf->StopTransform();
		$pdf->SetFont("times","",$font,'',false);
		$pdf->SetXY(88,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->SetFont("times","",$font,'',false);
		$pdf->Write($font,"PO: " . $po);
		$pdf->StopTransform();
		$pdf->SetXY(110,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,"SO: $folder");
		$pdf->StopTransform();
		$pdf->SetXY(132,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,"$i of $labels");
		$pdf->StopTransform();
		$pdf->SetXY(240,120);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->SetFont("times","",15,'',false);
		if ($type == "TRANSFER") {
			$pdf->Write(12,"PreferredMachinellc.com    Material Transfer");
		} else {
			$pdf->Write(12,"PreferredMachinellc.com");
		}
		$pdf->StopTransform();
		$pdf->SetXY(200,120);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		## W indicates to machine's scanner that this is weld
		$code=$packslip . "-" . $i;
		if ($type == "TRANSFER") {
			## the T in front says transfer and gets scraped off, leaving the W for weld
			$code="T" . $code;
		}
		$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
		# we have 1d barcodes
		$pdf->write2DBarcode($code, 'QRCODE,H', 200, 50, 50, 50, $qstyle, 'N');
		$pdf->StopTransform();
		if ($type == "PACKSLIP") {
			$sql = "select * from system_settings where name=?";
			list($rs,$err) = runIQuery($db, $sql, array(
				"s",
				"qr_code_until"
			));
			if (date("Y-m-d", strtotime("-1 day")) < $rs[0]["setting"]) {
				$pdf->write2DBarcode('https://www.preferredmachinellc.com/survey?c=' . $customerID, 'QRCODE,L', 185, 340, 70, 70, $qstyle, 'N');
				$pdf->SetXY(191,410);
				$pdf->Write(12,"Free Swag Drawing");
	
			}
		}
		$pdf->SetXY(154,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,$dt);
		$pdf->StopTransform();
		$sql="insert into skids (packing_slip_id, skid_number, weight, scanned, skid_type) values (?, ?, 0, '0000-00-00',?)";
		list($rs,$err)=runIQuery($db,$sql,array("iis",$packslip,$i,$type));
	}

$fname=$type . $id . ".pdf";
$pdf->Output($fname, "I");
