<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('functions.php');
include('security.php');
#header("Content-type: application/pdf");
$type=$_GET['type'];
$datestamp=Date("m/d/Y h:i");

function getYPos($lc) {
	return $lc * 13;
}

function printTCHeader($pdf,$start,$end,$employee) {
	$pdf->AddPage();
	$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
	$pdf->Image("images/logo.png",20,10,100,50,'','','',true);
	$pdf->SetFont("times","I",8,'',false);
	$pdf->SetXY(530,10);
    $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
	$pdf->SetFont("times","",12,'',false);
	$pdf->SetXY(180,20);
	$pdf->Write(12,"Week of $start - $end    $employee");
	$pdf->SetXY(20,80);
	$pdf->Write(12,"Employee");		
	$pdf->SetXY(250,80);
	$pdf->Write(12,"Date");		
	$pdf->SetXY(320,80);
	$pdf->Write(12,"Time In");		
	$pdf->SetXY(370,80);
	$pdf->Write(12,"Time Out");		
	$pdf->SetXY(440,80);
	$pdf->Write(12,"Regular");		
	$pdf->SetXY(480,80);
	$pdf->Write(12,"OT");		
	$pdf->SetXY(520,80);
	$pdf->Write(12,"Total");
}

include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
#include('tcpdi.php');
#$pdf = new TCPDF("L","pt",array(306,190));
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);

$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);


$pdf->SetFont("times","",12,'',false);

if ($type == "TIMECLOCK") {
	$start=$_GET['start_date'];
	$end=$_GET['end_date'];
	$sql="select * from clock_punches where in_date>=? and out_date <= ? order by last_name, first_name, punch_id ";
	list($rs,$err)=runIQuery($db,$sql,array("ss",$start,$end));
	$holdEmployee="";
	$holdDate="";
	$regEmployee=0;
	$otEmployee=0;
	$otDay=0;
	$regDay=0;
	$dayRecords=0;
	$lc=10;
	$points=array();
	$totalPoints=0;
	foreach ($rs as $data) {
		$employee=$data['last_name'] . "," . $data['first_name'];
		if ($employee != $holdEmployee) {
			if ($holdEmployee) {
				$totEmployee=$regEmployee+$otEmployee;
				$totDay = $regDay  + $otDay;
				$lc++;
				$ypos=getYPos($lc);
				$pdf->SetXY(440,$ypos);
				$pdf->Write(12,clockFormat($regDay));		
				$pdf->SetXY(480,$ypos);
				$pdf->Write(12,clockFormat($otDay));		
				$pdf->SetXY(520,$ypos);
				$pdf->Write(12,clockFormat($totDay));		
				$lc++;
				$ypos=getYPos($lc);
				$pdf->SetXY(20,$ypos);
				$pdf->Write(12,$holdEmployee);		
				$pdf->SetXY(380,$ypos);
				$pdf->Write(12,"Total");
				$pdf->SetXY(440,$ypos);
				$pdf->Write(12,clockFormat($regEmployee));		
				$pdf->SetXY(480,$ypos);
				$pdf->Write(12,clockFormat($otEmployee));		
				$pdf->SetXY(520,$ypos);
				$pdf->Write(12,clockFormat($totEmployee));						
				// print the points
				foreach($points as $point) {
					$lc++;
					$ypos=getYPos($lc);
					$pdf->SetXY(20,$ypos);
					$pdf->Write(12,$point);
				}
				$lc++;
				$ypos=getYPos($lc);
				$pdf->SetXY(20,$ypos);
				$sql="select sum(points) from clock_punches where out_date <= ? and employee_id=?";
				list($ers,$err)=runIQuery($db,$sql,array("si",$outDate,$employeeID));
				$edata=$ers[0];
				$totalPoints+=$edata[0];
				$pdf->Write(12,"Total Points: $totalPoints");
			}
			$holdEmployee=$employee;
			$holdDate="";
			$regEmployee=0;
			$otEmployee=0;
			$otDay=0;
			$regDay=0;
			$dayRecords=0;
			unset($points);
			$points=array();
			printTCHeader($pdf,formatDateDBToWeb($start),formatDateDBToWeb($end),$employee);
			$lc=8;
			$employeeID=$data['employee_id'];
			$totalPoints=0;
			$sql="select points from employees where employee_id=?";
			list($ers,$err)=runIQuery($db,$sql,array("i",$employeeID));
			$edata=$ers[0];
			$totalPoints=$edata['points'];
		}
		$dt=$data['in_date'];
		$outDate=$data['out_date'];
		if ($dt != $holdDate) {
			if ($holdDate) {
				$lc++;
				$ypos=getYPos($lc);
				$pdf->SetXY(440,$ypos);
				$pdf->Write(12,clockFormat($regDay));		
				$pdf->SetXY(480,$ypos);
				$pdf->Write(12,clockFormat($otDay));		
				$pdf->SetXY(520,$ypos);
				$pdf->Write(12,clockFormat($totDay));		
			}
			$holdDate=$dt;
			$otDay=0;
			$regDay=0;
			$in=$data['in_time'];
		}
		$out=$data['out_time'];
		$reg=$data['regular_minutes']/60;
		$ot=$data['ot_minutes']/60;
		$dayRecords++;
		$thisin=$data['in_time'];
		$last=$data['last_name'];
		$first=$data['first_name'];
		$point=$data['points'];
		$notes=$data['notes'];
		if ($point != 0 or strlen(trim($notes))> 0) {
			list($yr,$mo,$dy)=explode("-",$dt);
			$sdt=$mo . "/" . $dy;
			$points[]="$sdt - Points: $point - Note: $notes";
		}
		$lc++;
		$ypos=getYPos($lc);
		$pdf->SetXY(250,$ypos);
		$pdf->Write(12,formatDateDBToWeb($holdDate));		
		$pdf->SetXY(320,$ypos);
		$pdf->Write(12,$thisin);		
		$pdf->SetXY(370,$ypos);
		$pdf->Write(12,$out);		
		$pdf->SetXY(440,$ypos);
		$pdf->Write(12,clockFormat($reg));		
		$pdf->SetXY(480,$ypos);
		$pdf->Write(12,clockFormat($ot));		
		$tot=$reg+$ot;
		$pdf->SetXY(520,$ypos);
		$pdf->Write(12,clockFormat($tot));		
		$regDay+=$reg;
		$otDay+=$ot;
		$regEmployee+=$reg;
		$otEmployee+=$ot;	
	}
	if ($holdEmployee) {
		$totDay=$regDay + $otDay;
		$lc++;
		$ypos=getYPos($lc);
		$pdf->SetXY(440,$ypos);
		$pdf->Write(12,clockFormat($regDay));		
		$pdf->SetXY(480,$ypos);
		$pdf->Write(12,clockFormat($otDay));		
		$pdf->SetXY(520,$ypos);
		$pdf->Write(12,clockFormat($totDay));		
		$lc++;
		$ypos=getYPos($lc);
		$pdf->SetXY(20,$ypos);
		$pdf->Write(12,$holdEmployee);		
		$pdf->SetXY(380,$ypos);
		$pdf->Write(12,"Total");
		$pdf->SetXY(440,$ypos);
		$pdf->Write(12,clockFormat($regEmployee));		
		$pdf->SetXY(480,$ypos);
		$pdf->Write(12,clockFormat($otEmployee));		
		$pdf->SetXY(520,$ypos);
		$pdf->Write(12,clockFormat($totEmployee));						
		foreach($points as $point) {
			$lc++;
			$ypos=getYPos($lc);
			$pdf->SetXY(20,$ypos);
			$pdf->Write(12,$point);
		}
		$sql="select sum(points) from clock_punches where out_date <= ? and employee_id=?";
		list($ers,$err)=runIQuery($db,$sql,array("si",$outDate,$employeeID));
		$edata=$ers[0];
		$totalPoints+=$edata[0];
		$lc++;
		$ypos=getYPos($lc);
		$pdf->SetXY(20,$ypos);
		$pdf->Write(12,"Total Points: $totalPoints");
	}

}


$fname=$type . $start . ".pdf";
$pdf->Output($fname, "I");
