<?php
#error_reporting(E_ERROR);
#ini_set('display_errors','on');
date_default_timezone_set("America/Detroit");
$receipt=$_GET['id'];
include('dbConnection.php');
## session start is now in dbconnection.php
include('functions.php');
include('security.php');
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
include('tcpdf_barcodes_2d.php');

$qstyle = array(
    'border' => 2,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255)
    'module_width' => 1, // width of a single module in points
    'module_height' => 1 // height of a single module in points
			);

$pdf = new TCPDF("P","pt",array(612,792));
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
$pdf->SetLeftMargin(.1);
$pdf->SetRightMargin(.1);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

$style = array(
	'position' => '',
	'align' => 'C',
	'stretch' => false,
	'fitwidth' => true,
	'cellfitalign' => '',
	'border' => false,
	'hpadding' => 'auto',
	'vpadding' => 'auto',
	'fgcolor' => array(0,0,0),
	'bgcolor' => false, //array(255,255,255),
	'text' => false,
	'font' => 'helvetica',
	'fontsize' => 20,
	'stretchtext' => 4
);

$sql="select vendor_name from receipt_lines l, po_lines pol, purchase_orders p, vendors v where receipt_id=? and l.line_id=pol.line_id and pol.po_id=p.po_id and p.vendor_id=v.vendor_id ";
list($rrs,$err)=runIQuery($db,$sql,array("i",$receipt));
$data=$rrs[0];
$vendor=$data['vendor_name'];
$dateprinted=Date("m/d/y h:i:s");
$base=40;
function printReceiptHeader() {
    global $vendor, $dateprinted, $receipt, $pdf, $base, $page;
    $pdf->AddPage();
    $pdf->Image("logoblank.jpg",0,0,612,792,'','','',true);
    $pdf->SetFont("helvetica","",15,'',false);
    $pdf->SetXY(20,15);
    $pdf->Write(20,"Preferred Machine LLC - RECEIPT #$receipt");
    $pdf->SetXY(20,29);
    $pdf->SetFont("helvetica","",12,'',false);
    $pdf->Write(20,"Vendor: $vendor");
    $pdf->SetXY(450,32);
    $pdf->SetFont("helvetica","",10,'',false);
    $pdf->Write(12,"Printed $dateprinted");
    $page++;
    $pdf->SetXY(540,10);
    $pdf->SetFont("helvetica","I",10,'',false);
    $pdf->Write(12, "$page of " . $pdf->getAliasNbPages());
    $pdf->SetFont("helvetica","",18,'',false);
    $pdf->SetXY(20,55);
    $pdf->Write(20,"PO#");
    $pdf->SetXY(70,55);
    $pdf->Write(20,"SO#");
    $pdf->SetXY(120,55);
    $pdf->Write(20,"BATCH");
    $pdf->SetXY(200,55);
    $pdf->Write(20,"Quantity");
    $pdf->SetXY(285,55);
    $pdf->Write(20,"SO Due");
    $pdf->SetXY(365,55);
    $pdf->Write(20,"Part#");
    $pdf->SetFont("helvetica","",12,'',false);
    $base=60;
}

$sql="select * from receipt_lines where receipt_id=? order by receipt_line ";
list($rrs,$err)=runIQuery($db,$sql,array("i",$receipt));
$page=0;
$lc=99;
foreach ($rrs as $rdata) {
    $lc++;
    if ($lc > 35) {
        printReceiptHeader();
        $lc=1;
    }
	$line=$rdata['line_id'];
    if ($line) {
        $quantity=$rdata['quantity_received'];
        $sql="select po_id, item_name, l.description, l.job_id, order_id, due_date, batch_id from po_lines l left outer join items i on l.item_id=i.item_id ";
        $sql.=" left outer join jobs j on l.job_id=j.job_id left outer join order_lines ol on j.line_id=ol.line_id ";
        $sql.=" left outer join jobs_batch_orders jbo on j.job_id=jbo.job_id ";
        $sql.="  where l.line_id=?";
        list($rs,$err)=runIQuery($db,$sql,array("i",$line));
        $part="";
        $description="";
        $revision="";
        $customer="";
        foreach ($rs as $data) {
            $po=$data['po_id'];
            $part=$data['item_name'];
            $description=$data['description'];
            $batch=$data['batch_id'];
            if ($batch) {
                $batch="B" . $batch;
            }
            $so=$data['order_id'];
            $due=formatDateDBToWeb($data['due_date']);
            $due=substr($due,0,5);
        }

        $base+=18;
        $itemdesc = "$part - $description";
        if (strlen($itemdesc) > 45) {
            $itemdesc = substr($itemdesc,0,45);
        }

        $fontsize=12;
        while ($pdf->GetStringWidth($itemdesc)+370 > $pdf->getPageWidth()) {
            if ($fontsize > 8) {
                $fontsize--;
                $pdf->SetFont("helvetica","",$fontsize,'',false);
            } else {
                $itemdesc = substr($itemdesc,0,strlen($itemdesc)-1);
            }
        }

        $pdf->SetXY(365,$base);
        $pdf->Write(16,$itemdesc);
        $pdf->SetFont("helvetica","",10,'',false);

        $pdf->SetXY(20,$base);
        $pdf->Write(16,$po);
        $pdf->SetXY(70,$base);
        $pdf->Write(16,$so);
        $pdf->SetXY(131,$base);
        $pdf->Write(16,$batch);
        $quantity=str_replace(".00","", $quantity);
        $length=$pdf->GetStringWidth($quantity);
        $x=235-$length;
        $pdf->SetXY($x,$base);
        $pdf->Write(16,$quantity);
        $pdf->SetXY(303,$base);
        $pdf->SetFont("helvetica","",10,'',false);
        $pdf->Write(16,$due);
        $pdf->SetFont("helvetica","",12,'',false);

    }
}


$filename="RECEIPT$receipt.pdf";
$pdf->Output($filename, "I");
?>