<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('functions.php');
include('security.php');
#header("Content-type: application/pdf");
$id="";
if (isset($_GET['id'])) {
	$id=$_GET['id'];
}
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
include('tcpdf_barcodes_2d.php');
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);
$datestamp=Date("m/d/Y h:i");

$sql="select l.line_id, customer_id, date_order, date_due, ship_name, department_name, folder_number, o.order_id, item_id, quantity, reason_description, coalesce(true_reason,reason_id) as reason, notes_to_self, l.price from orders o inner join order_lines l on o.order_id=l.order_id left outer join rma_update u on l.line_id=u.line_id inner join rma_reasons r on coalesce(true_reason,rma_reason)=reason_id inner join   departments d on reason_department =department_id where o.order_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
$headerWritten=0;
$totalRMACost=0;
$reviwed="";
foreach ($rs as $data) {
	if (! $headerWritten) {
		$headerWritten=1;
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,792,792,'','','',true);
		$pdf->Image("images/logohd.png",20,10,100,50,'','','',true);
		$pdf->SetFont("helvetica","B",16,'',false);
		$pdf->SetXY(150,30);
		$pdf->Write(16,"QUALITY INCIDENT REPORT");
		$pdf->SetFont("helvetica","",8,'',false);
		$pdf->SetXY(400,30);
		$pdf->Write(8,"Date Printed: " . Date("m/d/Y h:i"));
		$pdf->SetFont("helvetica","",12,'',false);
		$pdf->SetXY(20,60);
		$dt=formatDateDBToWeb($data['date_order']);
		list($dt,$tm)=explode(" ",$dt);
		$pdf->Write(12,"RMA Date $dt");
		
		$customer=$data['customer_id'];
		$so=$data['order_id'];
		$folder=$data['folder_number'];
		$notes=$data['notes_to_self'];
		$sql="select assigned_employee, root_cause, resolution, employee_reviewed from qir where order_id=?";
		list($qrs,$err)=runIQuery($db,$sql,array("i",$so));
		$employee="";
		$reviewed="";
		$cause="";
		$resolution="";
		$ename="";
		if (count($qrs)>0) {
			$qdata=$qrs[0];
			$employee=$qdata['assigned_employee'];
			$reviewed=formatDateDBToWeb($qdata['employee_reviewed']);
			$cause=$qdata['root_cause'];
			$resolution=$qdata['resolution'];
			$sql="select first_name, last_name from employees where employee_id=?";
			list($ers,$err)=runIQuery($db,$sql,array("i",$employee));
			$edata=$ers[0];
			$ename=$edata['first_name'] . " " . $edata['last_name'];
		}
		$sql="select name from customers where customer_id=?";
		list($crs,$err)=runIQuery($db,$sql,array("i",$customer));
		$cdata=$crs[0];
		$name=$cdata['name'];
		$pdf->SetXY(20,80);
		$pdf->Write(12,"Employee: $ename");
		$pdf->SetXY(20,93);
		$pdf->Write(12,"Customer: $name");
		$pdf->SetXY(20,106);
		$pdf->Write(12,"Folder: $folder");
		$pdf->Line(18,120,594,120);
		$pdf->Line(18,120,18,289);
		$pdf->Line(594,120,594,288);
		$pdf->Line(18,208,594,208);
		$pdf->SetXY(20,120);
		$pdf->Write(12,"Root Cause");
		$html="<table style='width: 572px'><tbody><tr><td>$cause</td></tr></tbody></table>";
		$pdf->SetXY(20,133);
		$pdf->WriteHTML($html, false, false, true, false, '');
		$html2="<table style='width: 572px;'><tbody><tr><td>$resolution</td></tr></tbody></table>";
		$pdf->SetXY(20,210);
		$pdf->Write(12,"Resolution");
		$pdf->SetXY(20,223);
		$pdf->WriteHTML($html2, false, false, true, false, '');
		$html3="<table style='width: 572px;'><tbody><tr><td>$notes</td></tr></tbody></table>";
		$pdf->SetXY(20,289);
		$pdf->Write(12,"Notes");
		$pdf->SetXY(20,303);
		$pdf->WriteHTML($html3, false, false, true, false, '');
		$pdf->Line(18,289,594,289);
		$pdf->Line(18,289,18,398);
		$pdf->Line(18,398,594,398);
		$pdf->Line(594,209,594,398);
		$pdf->SetXY(20,400);
		$pdf->Write(12,"Item");
		$pdf->SetXY(120,400);
		$pdf->Write(12,"Quantity");
		$pdf->SetXY(170,400);
		$pdf->Write(12,"Reason");
		$pdf->SetXY(270,400);
		$pdf->Write(12,"Department");
		$pdf->SetXY(370,400);
		$pdf->Write(12,"Lost Revenue");
		$y=400;
	}
	$y+=13;
	$pdf->SetXY(20,$y);
	$font=12;
	while ($pdf->GetStringWidth($data['item_id']) > 95) 	 {
		$font-=.5;
		$pdf->SetFont("helvetica","",$font,'',false);		
	}
	$pdf->Write(12,$data['item_id']);
	$pdf->SetFont("helvetica","",12,'',false);
	$pdf->SetXY(120,$y);
	$pdf->Write(12,$data['quantity']);
	$pdf->SetXY(170,$y);
	$font=12;
	$pdf->SetFont("helvetica","",$font,'',false);		
	while ($pdf->GetStringWidth($data['reason_description']) > 95) 	 {
		$font-=.5;
		$pdf->SetFont("helvetica","",$font,'',false);		
	}
	$pdf->Write(12,$data['reason_description']);
	$pdf->SetXY(270,$y);
	$font=12;
	$pdf->SetFont("helvetica","",$font,'',false);		
	while ($pdf->GetStringWidth($data['department_name']) > 95) 	 {
		$font-=.5;
		$pdf->SetFont("helvetica","",$font,'',false);		
	}
	$pdf->Write(12,$data['department_name']);
	$pdf->SetXY(370,$y);
	/// TODO - just sum the quantity * price
	$dollars=$data['quantity'] * $data['price'];
	// if reason is wrong material, deduct original line by this quantity
	//$dollars=calculateOrderLineCost($data['line_id'],$data['quantity']);
	$totalRMACost+=$dollars;
	$dollars=number_format($dollars,2);
	$pdf->Write(12,$dollars);
}
$pdf->SetXY(300,60);
$pdf->Write(12,"Lost Revenue $" . number_format($totalRMACost,2));
## todo write out some footer for employee and Manager to sign
$pdf->SetXY(20,750);
$pdf->Write(12,"Employee: __________________________   Date: ___________");
$pdf->SetXY(20,770);
$pdf->Write(12,"Manager: ___________________________   Date: ___________");
if ($reviewed) {
	$pdf->SetXY(300,90);
	$pdf->Write(12,"Reviewed $reviewed");
}
$fname="QIR" . $id . ".pdf";
$pdf->Output($fname, "I");
