<?php

#error_reporting(E_ERROR);
#ini_set('display_errors','on');
date_default_timezone_set("America/Detroit");
$id=$_GET['id'];
header("Content-type: application/pdf");
include('dbConnection.php');
include('functions.php');
include('security.php');
$id=$_GET['id'];
$type=$_GET['type'];

if (! $type) {
	$type="shipping";
}


function printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$email,$folder,$phone,$pdf,$notes) {
	global $db;
	$pdf->AddPage();
	$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
	$pdf->Image("images/logo.png",200,10,100,50,'','','',true);
	$pdf->SetFont("times","I",8,'',false);
	$pdf->SetXY(530,10);
    $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
	$pdf->SetFont("times","",12,'',false);
	$pdf->SetXY(20,10);
	$pdf->Write(12,"For:");
	$pdf->SetXY(20,22);
	$pdf->Write(12,$shipName);
	$pdf->SetXY(20,34);
	$pdf->Write(12,$shipAddress);
	$csz=$shipCity . ", " . $shipState . " " . $shipZip;
	$pdf->SetXY(20,46);
	$pdf->Write(12,$csz);
	$pdf->SetXY(20,58);
	$pdf->Write(12,$phone);
	$o=$order;
	if ($folder) {
		$o=$folder;
	}
	if  ($status == 10) {
		$o="Quote: " . $o;
	} else {
		$o="Sales Order: " . $o;
	}
	$pdf->SetXY(350,10);
	$pdf->Write(12,$o);
	$sql="select * from company_shiptos order by use_on_packer desc, shipto_id";
	list($srs,$err)=runIQuery($db,$sql);
	$sdata=$srs[0];
	$coname=$sdata['ship_name'];
	$coaddr=$sdata['ship_address'];
	$csz=$sdata['ship_city'] . ", " . $sdata['ship_state'] . " " . $sdata['ship_zip'];
	$phone=$sdata['ship_phone'];
	$pdf->SetXY(350,22);
	$pdf->Write(12,$coname);
	$pdf->SetXY(350,34);
	$pdf->Write(12,$coaddr);
	$pdf->SetXY(350,46);
	$pdf->Write(12,$csz);
	$pdf->SetXY(350,58);
	$pdf->Write(12,$phone);
	if ($po) {
		$pdf->SetXY(350,70);
		$pdf->Write(12,"Your PO $po");		
	}
	$base=94;
	list($nc,$notelist)=multiLine($notes, 80);
	foreach (explode("\r\n",$notelist) as $note) {
		$pdf->SetXY(20,$base);
		$pdf->Write(12,$note);
		$base+=12;
	}
	$base+=6;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Part");		
	$pdf->SetXY(300,$base);
	$pdf->Write(12,"Quantity");		
	$pdf->SetXY(350,$base);
	$pdf->Write(12,"Price EA");		
	$pdf->SetXY(400,$base);
	$pdf->Write(12,"Ext Price");		
	$pdf->SetXY(450,$base);
	$pdf->Write(12,"Material");		
	$pdf->SetLineWidth(.5);
	$base-=2;
	$pdf->Line(18,$base,600,$base);
	$pdf->Line(18,$base,18,670);
	$pdf->Line(298,$base,298,670);
	$pdf->Line(348,$base,348,670);
	$pdf->Line(398,$base,398,670);
	$pdf->Line(448,$base,448,670);
	$pdf->Line(600,$base,600,670);
	$pdf->Line(18,670,600,670);
}
function printWOHeader($customer,$folder,$phone,$pdf) {
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
		$pdf->SetFont("times","I",8,'',false);
		$pdf->SetXY(530,10);
        $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
		$pdf->SetFont("times","",16,'',false);
		$pdf->SetXY(20,10);
		$pdf->Write(16,$customer);
		$pdf->SetXY(200,10);
		$pdf->Write(16,$folder);
		$pdf->SetXY(420,10);
		$pdf->Write(16,$phone);

		$pdf->SetFont("times","",6,'',false);
		$pdf->SetXY(460,28);
		$pdf->Write(6,"Printed " . Date("l, m/d/Y h:i a"));
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(20,60);
		$pdf->Write(12,"Folder");		
		$pdf->SetXY(80,60);
		$pdf->Write(12,"Part");		
		$pdf->SetXY(300,60);
		$pdf->Write(12,"SKID");		
		$pdf->SetXY(360,60);
		$pdf->Write(12,"Order Qty");		
		$pdf->SetXY(420,60);
		$pdf->Write(12,"Qty");		
		$pdf->SetXY(460,60);
		$pdf->Write(12,"Initials");		

		
		$style = array(
		    'position' => '',
		    'align' => 'C',
		    'stretch' => false,
		    'fitwidth' => true,
		    'cellfitalign' => '',
		    'border' => false,
		    'hpadding' => 'auto',
		    'vpadding' => 'auto',
		    'fgcolor' => array(0,0,0),
		    'bgcolor' => false, //array(255,255,255),
		    'text' => true,
		    'font' => 'helvetica',
		    'fontsize' => 6,
		    'stretchtext' => 4
		);
		$pdf->SetXY(340,10);
		$pdf->write1DBarcode($folder, 'C39', '', '', '', 36, 0.6, $style, 'N');
		$pdf->SetFont("times","",16,'',false);
}

include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
#include('tcpdi.php');
#$pdf = new TCPDF("L","pt",array(306,190));
if ($type=="TAG") {
	$pdf = new TCPDF("L","pt",array(288,216));	
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	$pdf->SetLeftMargin(.1);
	$pdf->SetRightMargin(.1);
} else {
	$pdf = new TCPDF("P","pt","LETTER");
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->SetLeftMargin(.20);
	$pdf->SetRightMargin(.20);
}
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

if ($type=="TAG") {
	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$customerID=$data['customer_id'];
	$dateDue=formatDateDBToWeb($data['date_due']);
	$po=$data['po_number'];
	$folder=$data['folder_number'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];
	$dateOrder=formatDateDBToWeb($data['date_order']);
	$sql="select name from customers where customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$data=$rs[0];
	$customer=$data['name'];
	$sql="select * from order_lines where order_id=? order by line_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach ($rs as $data) {
		$item=$data['item_id'];
		$description=substr($data['item_description'],0,18);
		$quantity=$data['quantity'];
		$revision=$data['revision'];	
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,288,216,'','','',true);
		$pdf->SetFont("times","",19,'',false);
		$pdf->SetXY(20,2);
		$pdf->Write(19,$customer);
		$pdf->SetXY(20,22);
		$pdf->Write(19,$address);
		$pdf->SetXY(20,42);
		$pdf->Write(19,"$city, $state $zip");
		$pdf->SetXY(20,62);
		$pdf->Write(19,"PO: " . $po);
		$pdf->SetXY(20,82);
		$pdf->Write(19,"Due: $dateDue");
		$pdf->SetXY(150,102);
		$pdf->Write(19,"Folder: $id");
		$pdf->SetXY(20,145);
		$pdf->SetFont("times","B",28,'',false);
		if ($revision) {
			$pdf->Write(28,substr("$item REV $revision",0,19));			
		} else {
			$pdf->Write(28,$item);
		}
		$pdf->SetXY(20,170);
		$pdf->Write(28,"Qty: " . $quantity);
	}
	
}
if ($type=="WO") {
	$lc=99;
	## must be in laser
	$sql="select ship_name, phone, date_due, folder_number, item_id, item_description, quantity, due_date, revision, material from orders, order_lines, order_line_operations where orders.order_id=? and orders.order_id=order_lines.order_id and order_lines.line_id=order_line_operations.line_id and operation_id=35 order by order_lines.line_id ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach ($rs as $data) {
		$part=$data['item_id'];
		$datedue=formatDateDBToWeb($data['due_date']);
		$description=$data['item_description'];
		$quantity=$data['quantity'];
		$revision=$data['revision'];
		$customer=$data['ship_name'];
		$phone=$data['phone'];
		$folder=$data['folder_number'];
		$materialID=$data['material'];		
		if ($lc > 30) {
			printWOHeader($customer,$folder,$phone,$pdf);
			$lc=0;
		}
		$lc++;
		$base=60 + ($lc*20);
		$pdf->SetXY(20,$base);
		if (strstr(strtoupper($folder),"RMA")) {
			$pdf->SetFont("times","",10,'',false);
		}
		$pdf->Write(16,$folder);		
		$pdf->SetFont("times","",16,'',false);
		$pdf->SetXY(80,$base);
		$pdf->Write(16,$part);		
		if ($materialID) {
			$sql="select material_name from materials where material_id=?";
			list($mrs,$err)=runIQuery($db,$sql,array("i",$materialID));
			$mdata=$mrs[0];
			$materialName=$mdata[0];
			if ($materialName) {
				$pdf->SetXY(210,$base+5);
				$pdf->SetFont("times","",6,'',false);
				$pdf->Write(6,$materialName);
				$pdf->SetFont("times","",16,'',false);
			}
		}
		$pdf->SetXY(300,$base);
		$pdf->Write(16,"____");		
		$pdf->SetXY(360,$base);
		$pdf->Write(16,$quantity);		
		$pdf->SetXY(420,$base);
		$pdf->Write(16,"____");		
		$pdf->SetXY(460,$base);
		$pdf->Write(16,"________");		
		$pdf->SetLineWidth(.5);
		$pdf->Line(20,62,550,62);
		$pdf->Line(18,62,18,700);
		$pdf->Line(78,62,78,700);
		$pdf->Line(298,62,298,700);
		$pdf->Line(358,62,358,700);
		$pdf->Line(418,62,418,700);
		$pdf->Line(458,62,458,700);
	}	
}

if ($type=="SO") {
	$lc=99;
	## must not be going into a weldment
	$sql="select o.order_id, ship_name, ship_address, ship_city, ship_state, ship_zip, po_number,email, phone, status, folder_number,  item_id, item_description, quantity, price, due_date, calculated_price, material_name, notes_to_customer from orders o inner join order_lines l on o.order_id=l.order_id left outer join materials on material=material_id where o.order_id = ? and line_id not in (select line_id from order_line_operations where operation_id=62) ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$total=0;
	foreach ($rs as $data) {
		$po=$data['po_number'];
		$order=$data['order_id'];
		$shipName=$data['ship_name'];
		$shipAddress=$data['ship_address'];
		$shipCity=$data['ship_city'];
		$shipState=$data['ship_state'];
		$shipZip=$data['ship_zip'];
		$phone=$data['phone'];
		$email=$data['email'];
		$status=$data['status'];
		$folder=$data['folder_number'];
		$notes=$data['notes_to_customer'];
		$material=$data['material_name'];		
		$quantity=$data['quantity'];
		$price=$data['price'];
		if ($price <= 0) {
			$price=$data['calculated_price'];
		}
		$quantity=$data['quantity'];
		$part=$data['item_id'];		
		$datedue=formatDateDBToWeb($data['due_date']);
		$description=$data['item_description'];
		if ($lc > 25) {
			printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$email,$folder,$phone,$pdf,$notes);
			$lc=0;
		}
		$lc++;
		list($nc,$notearr)=multiLine($notes, 110);
		$base=102 + ($nc*12) + ($lc*20);
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(20,$base);
		$pdf->Write(12,$part);		
		$pdf->SetXY(100,$base);
		$pdf->Write(12,$description);		
		$y = 342 - $pdf->GetStringWidth(number_format($quantity,0));
		$pdf->SetXY($y,$base);
		$pdf->Write(12,number_format($quantity,0));		
		if ($price > 0) {
			$y = 392 - $pdf->GetStringWidth(number_format($price,2));
			$pdf->SetXY(350,$base);
			$pdf->Write(12,number_format($price,2));		
			$ext=$price * $quantity;
			$y=442 - $pdf->GetStringWidth(number_format($ext,2));
			$pdf->SetXY($y,$base);
			$pdf->Write(12,number_format($ext,2));		
			$total += $ext;
		}
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(450,$base);
		if ($material != "Non-Laser") {
			if ($material != "Outsource Weldment") {
				$pdf->Write(12,$material);		
			}
		}
	}	
	$lc++;
	$base=680;
	$pdf->SetFont("times","",8,'',false);
	$pdf->SetXY(20,$base);
	$pdf->Write(8, "Quote is based on customer supplied electronic CAD data. A programming fee will be charged if we have to draw or re-work parts.");
	$base+=8;
	$pdf->SetXY(20,$base);
	$pdf->Write(8, "Preferred Machine, LLC does not assume liability for part design of customer.");
	$base+=8;
	$pdf->SetXY(20,$base);
	$pdf->Write(8, "Preferred Machine, LLC's general tolerances will be used if it is NOT specified on customer print/cad data. Please contact laser@preferredmachinellc.com for current tolerances.");
	$base+=8;
	$pdf->SetXY(20,$base);
	$pdf->Write(8, "Pricing is subject to current material pricing at the time your orders is placed. Quote will include material, unless noted as customer material.");
	$pdf->SetFont("times","",12,'',false);
	$base+=15;
	$pdf->SetXY(350,$base);
	$pdf->Write(12, "Total: ");
	$y=442 - $pdf->GetStringWidth(number_format($total,2));
	$pdf->SetXY($y,$base);
	$pdf->Write(12, number_format($total,2));
}

$fname=$type.$id."pdf";	
$pdf->Output($fname, "I");
