<?php
#error_reporting(E_ALL);
#ini_set('display_errors','1');
date_default_timezone_set("America/Detroit");
header("Content-type: application/pdf");
include('dbConnection.php');
## session start is now in dbconnection.php
include('functions.php');
include('security.php');
$type="DEMATIC";

function multiLine($string,$max) {
	$lines=array();
	$words=explode(" ",$string);
	$widx=0;
	$string="";
	while ($widx < count($words)) {
		$retstring="";
		$tooLong=0;
		while ($widx < count($words) and $tooLong==0 ) {
			if ($retstring) {
				$retstring.=" ";
			}						
			$oldstring=$retstring;
			$retstring.=$words[$widx];
			if (strlen($words[$widx])>$max) {
				$retstring=substr($words[$widx],0,$max);
				$words[$widx]=substr($words[$widx],$max);
				$tooLong=1;
			} else {
				if ( strlen($retstring)>$max) {
					$retstring=$oldstring;
					$tooLong=1;
				} else {
					$widx++;
				}
			}
		}
		if (trim($retstring)) {
			$lines[]=$retstring;
		}
	}	
	return $lines;
}
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
#include('tcpdi.php');

$pack=$_GET['pack'];
$sql="select * from packing_slip, packing_slip_lines where packing_list_id=packing_slip_id and packing_slip_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$pack));
$data=$rs[0];
$customerID=$data['customer_id'];
$packslip=$data['packing_list_id'];
$line=$data['line_id'];
$order=$data['order_id'];
$orderLine=$data['order_line'];
$part=$data['part_number'];
$description=$data['description'];
$description=str_replace(","," ",$description);
$quantity=$data['quantity'];
$attention=$data['attention'];
$ship_name=$data['ship_name'];
$ship_address=$data['ship_address'] . " " . $data['ship_address2'];
$ship_city=$data['ship_city'];
$ship_zip=$data['ship_zip'];
$ship_state=$data['ship_state'];
$tracking_number=$data['tracking_number'];
# get revision from order line
$sql="select po_number, order_lines.* from orders, order_lines where orders.order_id=? and orders.order_id=order_lines.order_id  and line_id=?";
list($rs,$err)=runIQuery($db,$sql,array("ii",$order,$orderLine));

if (count($rs)==0) {
	$sql="select po_number, order_lines.* from orders, order_lines where orders.order_id=? and orders.order_id=order_lines.order_id  and item_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("is",$order,$part));
}
$data=$rs[0];
$revision=$data['revision'];
$poLine=$data['po_line'];
$poNumber=$data['po_number'];
## get skid quantity from item master
$sql="select * from items where item_name=?";
list($rs,$err)=runIQuery($db,$sql,array("s",$part));
$data=$rs[0];
$drawing=$data['drawing'];

//SKID,Part,Qty,PO,Line,packslip,description,skip,weight,SHIPTO,ADDRESS,CITY,STATE,ZIP
//20205,B000301VED98,1,4501762350,0001,17891,MODEL R3000 TALL SUPPORT ASSEMBLY METRIC PAINTED 21.2 X 132 LIGHT GREY,BM,,125,DFW DISTRIBUTION CENTER DDC1-0001,11200 HARMON ROAD ,FORT WORTH,TX,76177
$style = array(
    'position' => '',
    'align' => 'C',
    'stretch' => false,
    'fitwidth' => true,
    'cellfitalign' => '',
    'border' => false,
    'hpadding' => 'auto',
    'vpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255),
    'text' => false,
    'font' => 'helvetica',
    'fontsize' => 8,
    'stretchtext' => 4
);

$pdf = new TCPDF("L","pt",array(432,288));
	
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
$pdf->SetLeftMargin(.10);
$pdf->SetRightMargin(.10);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);



$sql="select * from bol_skids where packing_slip=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$pack));
foreach ($rs as $data) {
    $skid=$data['skid_id'];
    $qty=$data['quantity'];
    $pdf->AddPage();
    $pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
    $pdf->SetFont("times","B",8,'',false);
    $pdf->SetXY(288,20);
    $pdf->Write(10,"FROM:");
    $pdf->SetXY(288,29);
    $pdf->Write(10,"Preferred Machine, LLC");
    $pdf->SetXY(288,38);
    $pdf->Write(10,"4552 136th Avenue");
    $pdf->SetXY(288,47);
    $pdf->Write(10,"Holland, MI 49424");
    $pdf->SetFont("times","",10,'',false);
    $pdf->SetXY(100,10);
    $pdf->Write(10,"PART NUMBER (P)");
    $pdf->SetXY(20,21);
    $pdf->Write(10,$part);
    $pdf->SetXY(20,32);
    $pdf->write1DBarcode("P$part", 'C39', '', '', '', 36, 0.8, $style, 'N');
    $pdf->SetXY(20,80);    
    $pdf->Write(10,"PO NUMBER (K)");
    $pdf->SetXY(20,91);
    $pdf->Write(10,$poNumber);    
    $pdf->SetXY(20,102);    
    $pdf->write1DBarcode("K$poNumber", 'C39', '', '', '', 36, 0.8, $style, 'N');
    $pdf->SetXY(20,150);
    $pdf->Write(10,"QUANTITY (Q)");
    $pdf->SetXY(20,161);
    $pdf->Write(10,$qty);
    $pdf->SetXY(20,173);
    $pdf->write1DBarcode("Q$quantity", 'C39', '', '', '', 36, 0.8, $style, 'N');
    $pdf->SetXY(20,220);
    $pdf->Write(10,"SERIAL (1S)");
    $pdf->SetXY(20,231);
    $pdf->Write(10,$skid);
    $pdf->SetXY(20,243);
    $pdf->write1DBarcode("1S$skid", 'C39', '', '', '', 36, 0.8, $style, 'N');
    $pdf->SetXY(252,84);
    $pdf->Write(10,"PO LINE (4K)");
    $pdf->SetXY(252,95);
    $pdf->Write(10,$poLine);
    $pdf->SetXY(252,106);
    $pdf->write1DBarcode("4K$poLine", 'C39', '', '', '', 36, 0.8, $style, 'N');
    $pdf->SetXY(252,145);
    $pdf->Write(10,"DESCRIPTION");
    $base=156;
    foreach (multiLine($description,20) as $desc) {
        $pdf->SetXY(252,$base);    
        $pdf->Write(7,$desc);
        $base+=8;
    }
    $pdf->SetXY(252,200);
    $pdf->Write(10,"TO:");
    $pdf->SetFont("times","",7,'',false);
    $pdf->SetXY(252,211);
    $pdf->Write(10,$ship_name);
    $pdf->SetXY(252,222);
    $pdf->Write(10,$ship_address);
    $pdf->SetXY(252,233);
    $pdf->Write(10,"$ship_city, $ship_state $ship_zip");
    $pdf->Line(270,0,270,72);
    $pdf->Line(0,72,432,72);
    $pdf->Line(0,144,432,144);
    $pdf->Line(0,216,245,216);
    $pdf->Line(245,72,245,288);


}
			

$pdf->Output($fname, "I");
