<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('functions.php');
include('security.php');
error_reporting(0);
$id="";
if (isset($_GET['id'])) {
	$id=$_GET['id'];
}
$type="";
if (isset($_GET['type'])) {
	$type=$_GET['type'];
}
$pack=0;
if (isset($_GET['pack'])) {
	$pack=$_GET['pack'];
}
$forVendor=0;
if (isset($_GET['for_vendor'])) {
	$forVendor=1;
}
$okToReview=1;
if ($type == "SO") {
	$sql="select line_id,  sum(quantity * xdimension * ydimension * price_per_square_inch) as material_cost, sum(price * quantity) as ext from order_lines l, materials m where order_id=?
	and material=material_id and order_id not in (select order_id from order_reviews)  group by line_id";
	list($lrs,$err)=runIQuery($db,$sql,array("i",$id));
	$mcost=0;
	foreach ($lrs as $ldata) {
		$mcost+=$ldata['material_cost'];
	}
	if ($mcost > 4000) {
		$okToReview=0;
	}
	foreach ($lrs as $ldata) {
		if ($ldata['ext'] > 5000) {
			 $okToReview=0;
		 }
	}
	## cma changed from 8k and 10k to 4k and 5k, and also added individual line price >= 500 or qty >= 100
	$sql="select line_id from order_lines where (price  >= 500 or quantity >= 100)  and order_id=? ";
	list($lrs,$err)=runIQuery($db,$sql,array("i",$id));
	if (count($lrs) > 0) {
			$okToReview=0;
	}
}

header("Content-type: application/pdf");
$datestamp=Date("m/d/Y h:i");

function generateOps($db,$order,$part) {
	$sql="select operation_name from order_lines l, order_line_operations olo, operations o where order_id=? and item_id=? and l.line_id=olo.line_id and olo.operation_id=o.operation_id ";
	$laser=0;
	$deburr=0;
	$machine=0;
	$bend=0;
	$weld=0;
	## bdoss adding class a 9/6/22
	$classA=0;
	list($rs,$err)=runIQuery($db,$sql,array("is",$order,$part));
	foreach ($rs as $data) {
		if (strtolower($data['operation_name']) == 'laser') {
			$laser=1;
		}
		if (strtolower($data['operation_name']) == 'deburr') {
			$deburr=1;
		}
		if (strtolower($data['operation_name']) == 'vibe bowl') {
			$deburr=1;
		}
		if (strtolower($data['operation_name']) == 'hand-deburr') {
			$deburr=1;
		}
		if (strtolower($data['operation_name']) == 'cnc mill') {
			$machine=1;
		}
		if (strtolower($data['operation_name']) == 'roll') {
			$bend=1;
		}
		if (strtolower($data['operation_name']) == 'mid-Level') {
			$machine=1;
		}
		if (strtolower($data['operation_name']) == 'machining') {
			$machine=1;
		}
		if (strtolower($data['operation_name']) == 'bend') {
			$bend=1;
		}
		if (strtolower($data['operation_name']) == 'weld') {
			$weld=1;
		}
		## bdoss adding class a 9/6/22
		if (strtolower($data['operation_name']) == 'class a finish') {
			$classA=1;
		}
	}
	$ops="";
	if ($laser) {
		$ops="Laser Cut";
	}
	if ($deburr) {
		if (strlen($ops)>0) {
			$ops.=", ";
		}
		$ops.="Deburred";
	}
	if ($machine) {
		if (strlen($ops)>0) {
			$ops.=", ";
		}
		$ops.="Machined";
	}
	if ($bend) {
		if (strlen($ops)>0) {
			$ops.=", ";
		}
		$ops.="Bent";
	}
	if ($weld) {
		if (strlen($ops)>0) {
			$ops.=", ";
		}
		$ops.="Welded";
	}
	## bdoss adding class a 9/6/22
	if ($classA) {
		if (strlen($ops)>0) {
			$ops.=", ";
		}
		$ops.="Class A";
	}

	## per Matt H no longer show color as an ops 1/6/21
	#$sql="select color_code from order_lines l, order_line_color lc, vendor_colors vc where order_id=? and item_id=? and l.line_id=lc.order_line and lc.color_id=vc_id ";
	#list($rs,$err)=runIQuery($db,$sql,array("is",$order,$part));
	#if (count($rs)>0) {
	#	$data=$rs[0];
	#	$color=$data['color_code'];
	#	if (strlen($ops)>0) {
	#		$ops.=",";
	#	}
	#	$ops.="PC$color";
	#	}
	return $ops;
}

function generateSOPart($db,$order,$part,$description) {
	$ops=generateOps($db,$order,$part,$description);
	$part=trim($part) . " " . trim($description);
	$part=trim($part);
	if ($ops) {
		$part.=" OPS: " . $ops;
	}
	return $part;
}
function printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$dt,$folder,$phone,$pdf,$notes) {
	global $db, $canReviewHighDollar, $okToReview, $id, $forVendor;
	$pdf->AddPage();
	$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
	$pdf->Image("images/logohd.png",20,10,100,50,'','','',true);

	if (! $canReviewHighDollar and ! $okToReview and $status <> 1 and $status <> 10 ) {
		## make a watermark
		// Get the page width/height
		$myPageWidth = $pdf->getPageWidth();
		$myPageHeight = $pdf->getPageHeight();

		// Find the middle of the page and adjust.
		$myX = ( $myPageWidth / 2 ) - 150;
		$myY = ( $myPageHeight / 2 ) + 25;

		// Set the transparency of the text to really light
		$pdf->SetAlpha(0.40);

		// Rotate 45 degrees and write the watermarking text
		$pdf->StartTransform();

		$pdf->Rotate(45, $myX, $myY);
		$pdf->SetFont("courier", "B", 50);
		$pdf->Text($myX, $myY,"PENDING REVIEW");
		$pdf->StopTransform();

		// Reset the transparency to default
		$pdf->SetAlpha(1);
	} else {
		## check if NOT IN LIST color code
		$sql="select * from order_lines l, order_line_color olc where l.order_id=? and l.line_id=olc.order_line and color_id=149";
		list($colorRS,$err)=runIQuery($db,$sql,array("i",$order));
		if (count($colorRS)>0) {
			$myPageWidth = $pdf->getPageWidth();
			$myPageHeight = $pdf->getPageHeight();

			// Find the middle of the page and adjust.
			$myX = ( $myPageWidth / 2 ) - 150;
			$myY = ( $myPageHeight / 2 ) + 25;

			// Set the transparency of the text to really light
			$pdf->SetAlpha(0.40);

			// Rotate 45 degrees and write the watermarking text
			$pdf->StartTransform();

			$pdf->Rotate(45, $myX, $myY);
			$pdf->SetFont("courier", "B", 20);
			$pdf->Text($myX, $myY,"PENDING COLOR SELECTION");
			$pdf->StopTransform();

			// Reset the transparency to default
			$pdf->SetAlpha(1);
		}
	}
	$pdf->SetFont("helvetica","I",8,'',false);
	$pdf->SetXY(530,10);
    $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
    $pdf->SetXY(350,10);
    $pdf->SetFont("helvetica","B",16,'',false);
	$o=$order;
	$dt=formatDateDBToWeb($dt);
	if ($folder) {
		$o=$folder;
	}
	if  ($status == 10) {
		$o="Quote: " . $o;
	    $pdf->Write(16,"Quote");
	} else {
		$o="Sales Order: " . $o;
		$pdf->Write(16,"Sales Order");
	}
	$pdf->SetFont("helvetica","",12,'',false);
	$pdf->SetXY(15,70);
	$pdf->Write(12,"Bill To");
	$sql="select customers.* from orders, customers where order_id=? and orders.customer_id=customers.customer_id";
	list($srs,$err)=runIQuery($db,$sql,array("i",$order));
	$pdf->SetFont("helvetica","",10,'',false);
	$sdata=$srs[0];
	$coname=$sdata['name'];
	$coaddr=$sdata['address'];
	$coaddr2=$sdata['address2'];
	$csz=$sdata['city'] . ", " . $sdata['state'] . " " . $sdata['zip'];
	$pdf->SetXY(15,83);
	$pdf->Write(12,$coname);
	$pdf->SetXY(15,96);
	$pdf->Write(12,$coaddr);
	$base=109;
	if ($coaddr2) {
		$pdf->SetXY(15,$base);
		$pdf->Write(12,$coaddr2);
		$base+=13;
	}
	$pdf->SetXY(15,$base);
	$pdf->Write(12,$csz);
	$pdf->SetXY(345,70);
	$pdf->SetFont("helvetica","",12,'',false);
	$pdf->Write(12,"Ship To");
	$pdf->SetFont("helvetica","",10,'',false);
	$pdf->SetXY(345,83);
	$pdf->Write(12,$shipName);
	$pdf->SetXY(345,96);
	$pdf->Write(12,$shipAddress);
	$csz=$shipCity . ", " . $shipState . " " . $shipZip;
	$pdf->SetXY(345,109);
	$pdf->Write(12,$csz);
	$pdf->SetXY(345,27);
	$pdf->Write(12,$o);
	$pdf->SetFont("helvetica","",12,'',false);
	if ($po) {
		$pdf->SetXY(350,40);
		$pdf->Write(12,"PO Number: $po");
	}
	$base+=13;
	$pdf->SetXY(350,53);
	$pdf->Write(12,"Due: $dt");
	$base+=13;
	if ($notes != "nolines") {
		$base+=13;
		list($nc,$notelist)=multiLine($notes, 80);
		$sql="select `setting` from `system_settings` where `name` = 'global_so_notes' ";
		list($ssrs,$err)=runIQuery($db,$sql);
		if (count($ssrs)>0) {
			$gnotes=strip_tags($ssrs[0][0]);
			list($gc,$glist)=multiLine($gnotes,80);
			foreach (explode("\r\n",$glist) as $note) {
				$nc++;
				$notelist.="\r\n" . $note;
			}
		}

		$pdf->SetFont("helvetica","B",12,'',false);
		foreach (explode("\r\n",$notelist) as $note) {
			$pdf->SetXY(20,$base);
			$pdf->Write(12,$note);
			$base+=13;
		}
		$pdf->SetFont("helvetica","",12,'',false);
		$base+=13;
	}
	## bdoss 11/30/22 if it's an SO being copied for Preferred Coatings and there are vendor notes for it, copy the notes to the pdf
	if ($forVendor) {
		$sql="SELECT notes_to_vendor FROM orders WHERE folder_number=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
		if ($rs) {
			$notesForVendor="*Notes for this order: ";
			$notesForVendor.=$rs[0][0];
			$pdf->SetXY(20,$base);
			$pdf->Write(12,$notesForVendor);
			$base+=26;
		}
	}
	if ($notes != "nolines") {
		$pdf->SetXY(20,$base);
		$pdf->Write(12,"Part");
		$pdf->SetXY(300,$base);
		$pdf->Write(12,"Quantity");
		$pdf->SetXY(350,$base);
		$pdf->Write(12,"Rate");
		$pdf->SetXY(400,$base);
		$pdf->Write(12,"Amount");
		$pdf->SetXY(475,$base);
		$pdf->Write(12,"Material");
		$pdf->SetLineWidth(1);
		$base+=15;
		$pdf->Line(18,$base,600,$base);
		$pdf->Line(18,$base,18,670);
		$pdf->Line(298,$base,298,670);
		$pdf->Line(348,$base,348,670);
		$pdf->Line(398,$base,398,670);
		$pdf->Line(473,$base,473,670);
		$pdf->Line(600,$base,600,670);
		$pdf->Line(18,670,600,670);
	}

	//Print QR Code -Josh 01-31-2022
	$sql = "select * from system_settings where name=?";
	list($rs,$err) = runIQuery($db, $sql, array(
		"s",
		"qr_code_until"
	));
	if (date("Y-m-d", strtotime("-1 day")) < date("Y-m-d", strtotime($rs[0]["setting"]))) {
		$style = array(
			'border' => 1,
			'vpadding' => 'auto',
			'hpadding' => 'auto',
			'fgcolor' => array(0,0,0),
			'bgcolor' => false, //array(255,255,255)
			'module_width' => 1, // width of a single module in points
			'module_height' => 1 // height of a single module in points
		);

		$pdf->write2DBarcode('http://survey.preferredmachinellc.com/survey.html?c=' . $sdata["customer_id"], 'QRCODE,L', 535, 715, 60, 60, $style, 'N');
		$pdf->SetXY(520, 703);
        $pdf->SetFont("times","",10,'',false);
		$pdf->Write(12,"Free Swag Drawing");
	}

	return $base;
}
function printWOHeader($customer,$folder,$phone,$pdf) {
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
		$pdf->SetFont("times","I",8,'',false);
		$pdf->SetXY(530,10);
        $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
		$pdf->SetFont("times","",16,'',false);
		$pdf->SetXY(20,10);
		$pdf->Write(16,$customer);
		$pdf->SetXY(200,10);
		$pdf->Write(16,$folder);
		$pdf->SetXY(420,10);
		$pdf->Write(16,$phone);

		$pdf->SetFont("times","",6,'',false);
		$pdf->SetXY(460,28);
		$pdf->Write(6,"Printed " . Date("l, m/d/Y h:i a"));
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(20,60);
		$pdf->Write(12,"Folder");
		$pdf->SetXY(80,60);
		$pdf->Write(12,"Part");
		$pdf->SetXY(280,60);
		$pdf->Write(12,"Description");
		$pdf->SetXY(400,60);
		$pdf->Write(12,"Order Qty");
		$pdf->SetXY(460,60);
		$pdf->Write(12,"Qty");
		$pdf->SetXY(500,60);
		$pdf->Write(12,"Initials");


		$style = array(
		    'position' => '',
		    'align' => 'C',
		    'stretch' => false,
		    'fitwidth' => true,
		    'cellfitalign' => '',
		    'border' => false,
		    'hpadding' => 'auto',
		    'vpadding' => 'auto',
		    'fgcolor' => array(0,0,0),
		    'bgcolor' => false, //array(255,255,255),
		    'text' => true,
		    'font' => 'helvetica',
		    'fontsize' => 6,
		    'stretchtext' => 4
		);
		$pdf->SetXY(340,10);
		$pdf->write1DBarcode($folder, 'C39', '', '', '', 36, 0.6, $style, 'N');
		$pdf->SetFont("times","",16,'',false);
		$pdf->SetLineWidth(.5);
		$pdf->Line(20,62,550,62);
		$pdf->Line(18,62,18,700);
		$pdf->Line(78,62,78,700);
		$pdf->Line(278,62,278,700);
		$pdf->Line(398,62,398,700);
		$pdf->Line(458,62,458,700);
		$pdf->Line(498,62,498,700);
}

function printPOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$shipPhone,$po,$reference,$attention,$pdf,$due,$pageNumber) {
	global $db;
	$pdf->AddPage();
	$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
	$pdf->Image("images/logohd.png",200,10,100,50,'','','',true);
	$pdf->SetFont("times","I",8,'',false);
	$pdf->SetXY(530,10);
    $pdf->Write("10",'Page ' . $pageNumber);
	$pdf->SetFont("times","",12,'',false);
	$pdf->SetXY(20,10);
	$pdf->Write(12,"Vendor:");
	$pdf->SetXY(20,22);
	$pdf->Write(12,$shipName);
	$pdf->SetXY(20,34);
	$pdf->Write(12,$shipAddress);
	$csz=$shipCity . ", " . $shipState . " " . $shipZip;
	$pdf->SetXY(20,46);
	$pdf->Write(12,$csz);
	$pdf->SetXY(20,58);
	if (isset($phone)) {
		$pdf->Write(12,$phone);
	}
	$pdf->SetXY(20,70);
	$pdf->Write(12,"Ultimate Destination: $attention");
	$o="Purchase Order: " . $po;
	$pdf->SetXY(350,10);
	$pdf->Write(12,$po);
	$sql="select * from company_shiptos order by use_on_packer desc, shipto_id";
	list($srs,$err)=runIQuery($db,$sql);
	$sdata=$srs[0];
	$coname=$sdata['ship_name'];
	$coaddr=$sdata['ship_address'];
	$csz=$sdata['ship_city'] . ", " . $sdata['ship_state'] . " " . $sdata['ship_zip'];
	$phone=$sdata['ship_phone'];
	$pdf->SetXY(350,22);
	$pdf->Write(12,$coname);
	$pdf->SetXY(350,34);
	$pdf->Write(12,$coaddr);
	$pdf->SetXY(350,46);
	$pdf->Write(12,$csz);
	$pdf->SetXY(350,58);
	$pdf->Write(12,$phone);
	$pdf->SetXY(350,70);
	$pdf->Write(12,"Reference $reference");
	$base=100;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Part");
	$pdf->SetXY(480,$base);
	$pdf->Write(12,"Quantity");
	$pdf->SetXY(530,$base);
	$pdf->Write(12,"Due");
	$pdf->SetLineWidth(.5);
	$base-=2;
	$pdf->Line(18,$base,600,$base);
	$pdf->Line(18,$base,18,670);
	$pdf->Line(478,$base,478,670);
	$pdf->Line(528,$base,528,670);
	$pdf->Line(18,670,600,670);
	$pdf->Line(600,$base,600,670);
}

function printPACKHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$shipPhone,$po,$reference,$attention,$pdf,$isMT=0) {
	global $db;
	$pdf->AddPage();
	$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
	$pdf->Image("images/logohd.png",200,10,100,50,'','','',true);
	$pdf->SetFont("times","I",8,'',false);
	$pdf->SetXY(530,10);
    $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
	$pdf->SetFont("times","",12,'',false);

	$pdf->SetXY(20,10);
	if ($isMT) {
		$pdf->Write(12,"Transfer: $reference");
	} else {
		$pdf->Write(12,"Packing Slip: $reference");
	}
	$sql="select * from company_shiptos order by use_on_packer desc, shipto_id";
	list($srs,$err)=runIQuery($db,$sql);
	$sdata=$srs[0];
	$coname=$sdata['ship_name'];
	$coaddr=$sdata['ship_address'];
	$csz=$sdata['ship_city'] . ", " . $sdata['ship_state'] . " " . $sdata['ship_zip'];
	$phone=$sdata['ship_phone'];
	$pdf->SetXY(20,22);
	$pdf->Write(12,$coname);
	$pdf->SetXY(20,34);
	$pdf->Write(12,$coaddr);
	$pdf->SetXY(20,46);
	$pdf->Write(12,$csz);
	$pdf->SetXY(20,58);
	$pdf->Write(12,$phone);

	$pdf->SetXY(306,10);
	$pdf->Write(12,"Ship To:");
	if (! $isMT) {
		if ($attention != $shipAddress) {
			$pdf->SetXY(306,22);
			$pdf->Write(12,"$attention");
		}
	}
	$pdf->SetXY(306,34);
	$pdf->Write(12,$shipName);
	$pdf->SetXY(306,46);
	$pdf->SetFont("times","",15,'B',false);
	$pdf->Write(16,$shipAddress);
	$pdf->SetFont("times","",12,'',false);
	$pdf->SetXY(306,66);
	$csz=$shipCity . ", " . $shipState . " " . $shipZip;
	$pdf->Write(12,$csz);
	$pdf->SetXY(306,78);
	if (isset($shipPhone)) {
		$pdf->Write(12,$shipPhone);
	}
	#$pdf->SetXY(20,70);
	#$pdf->Write(12,"Due: $due");
	$pdf->SetXY(160,70);
	$pdf->Write(12,"Invoice: $po");
	$base=100;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Line");
	$pdf->SetXY(80,$base);
	$pdf->Write(12,"Part");
	$pdf->SetXY(380,$base);
	$pdf->Write(12,"	Quantity");
	$pdf->SetXY(460,$base);
	$pdf->Write(12,"Your PO#");
	$pdf->SetXY(530,$base);
	if ($isMT) {
		$pdf->SetFont("times","",11,'',false);
		$pdf->Write(12,"Due Customer");
		$pdf->SetFont("times","",12,'',false);
	} else {
		$pdf->Write(12,"PO Line");
	}
	$pdf->SetLineWidth(.5);
	$base-=2;
	$pdf->Line(18,$base,600,$base);
	$pdf->Line(18,$base,18,670);
	$pdf->Line(78,$base,78,670);
	$pdf->Line(378,$base,378,670);
	$pdf->Line(458,$base,458,670);
	$pdf->Line(528,$base,528,670);
	$pdf->Line(18,670,600,670);
	$pdf->Line(600,$base,600,670);
}


include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
include('tcpdf_barcodes_2d.php');
#include('tcpdi.php');
#$pdf = new TCPDF("L","pt",array(306,190));
if ($type=="TAG") {
	$pdf = new TCPDF("L","pt",array(288,216));
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	$pdf->SetLeftMargin(.1);
	$pdf->SetRightMargin(.1);
} else {
	if ($type == "SHIP" or $type=="TRANSFER") {
		$pdf = new TCPDF("P","pt",array(288,432));
		$pdf->SetAutoPageBreak(false, 0);
		$pdf->setCellPaddings(0,0,0,0);
		$pdf->SetLeftMargin(.1);
		$pdf->SetRightMargin(.1);
	} else {
		if ($type == "DEMATIC" or $type=="DEMATICLABEL" or $type == "SEAVER") {
			$pdf = new TCPDF("L","pt",array(288,432));
			$pdf->SetAutoPageBreak(false, 0);
			$pdf->setCellPaddings(0,0,0,0);
			$pdf->SetLeftMargin(.1);
			$pdf->SetRightMargin(.1);
		} else {
			$pdf = new TCPDF("P","pt","LETTER");
			$pdf->SetAutoPageBreak(false, 0);
			$pdf->SetLeftMargin(.20);
			$pdf->SetRightMargin(.20);
		}
	}
}
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);
if (! $canReviewHighDollar and ! $okToReview) {
	$pdf->SetProtection(array('print', 'copy'), '', null, 0, null);
}

if ($type=="TAG") {
	$style = array(
		'position' => '',
		'align' => 'C',
		'stretch' => false,
		'fitwidth' => true,
		'cellfitalign' => '',
		'border' => false,
		'hpadding' => 'auto',
		'vpadding' => 'auto',
		'fgcolor' => array(0,0,0),
		'bgcolor' => false, //array(255,255,255),
		'text' => true,
		'font' => 'helvetica',
		'fontsize' => 10,
		'stretchtext' => 1
	);
	## category 10 is consumables
	$sql="select * from order_lines where order_id=? and line_id not in (select line_id from order_line_operations where operation_id=71) and item_id not in (select item_name from items where item_category=10)  order by line_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach ($rs as $data) {
		$item=strtoupper($data['item_id']);
		$description=substr($data['item_description'],0,18);
		$quantity=$data['quantity'];
		$revision=$data['revision'];
		$order=$data['order_id'];
		$due=$data['due_date'];
		$time=Date("h:m A");
		$now=Date("m/d/y");
		$dt=formatDateDBToWeb($due);
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,288,216,'','','',true);
		$pdf->Image("images/logohd.png",108,2,84,56,'','','',true);
		$pdf->SetLineWidth(.5);
		$pdf->Line(10,70,280,70);
		$pdf->Line(10,102,280,102);
		$pdf->SetFont("times","",14,'',false);
		$pdf->SetXY(10,72);
		$folder=$order;
		$sql="select folder_number from orders where order_id=?";
		list($ors,$err)=runIQuery($db,$sql,array("i",$order));
		if (count($ors)>0) {
			$odata=$ors[0];
			if (trim($odata['folder_number']) != "") {
				$folder=$odata['folder_number'];
			}
		}
		$pdf->Write(14,"WO: $folder");
		$pdf->SetXY(150,72);
		$pdf->Write(14,"Qty: $quantity");
		$pdf->SetXY(170,72);
		$pdf->Write(14,"Due: $dt");
		$pdf->SetXY(10,87);
		$pdf->Write(14,"Part: $item");
		$pdf->SetXY(10,104);
		$pdf->write1DBarcode($item, 'C128', '', '', '', 36, 1, $style, 'N');
		$pdf->SetLineWidth(1);
		$pdf->Rect(10,140,270,68);
		$pdf->SetFont("times","",6,'',false);
		$pdf->SetXY(144,208);
		$pdf->Write(6,"$time    $now");
	}
}

if ($type=="DEMATIC") {
	$style = array(
	    'position' => '',
	    'align' => 'C',
	    'stretch' => false,
	    'fitwidth' => true,
	    'cellfitalign' => '',
	    'border' => false,
	    'hpadding' => 'auto',
	    'vpadding' => 'auto',
	    'fgcolor' => array(0,0,0),
	    'bgcolor' => false, //array(255,255,255),
	    'text' => false,
	    'font' => 'helvetica',
	    'fontsize' => 6,
	    'stretchtext' => 4
	);
	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$customerID=$data['customer_id'];
	$due=$data['due_customer'];
	$folder=$data['folder_number'];
	if (! $due or $due == "0000-00-00") {
		$due=$data['date_due'];
	}
	$lead=getCustomerLeadTime($db,$id);
	if ($lead > 0) {
		$due=SubtractBusinessDays($due,$lead,$db);
	}
	$dateDue=formatDateDBToWeb($due);
	$po=$data['po_number'];
	$folder=$data['folder_number'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];
	$dateOrder=formatDateDBToWeb($data['date_order']);
	$sql="select name from customers where customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$data=$rs[0];
	$customer=$data['name'];
	## cat 10 is consumables
	$sql="select * from order_lines where order_id=? and item_id not in (select item_name from items where item_category=10) order by line_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach ($rs as $data) {
		$item=$data['item_id'];
		$description=$data['item_description'];
		$quantity=$data['quantity'];
		$serial=$data['line_id'];
		$poline=$data['po_line'];
		$revision=$data['revision'];
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(20,10);
		$pdf->Write(12,"PART NUMBER (P)");
		$pdf->SetXY(20,23);
		$pdf->Write(12,$item);
		$pdf->SetXY(20,36);
		$pdf->write1DBarcode("P" . $item, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,72);
		$pdf->Write(12,"PO NUMBER (K)");
		$pdf->SetXY(20,85);
		$pdf->Write(12,$po);
		$pdf->SetXY(20,98);
		$pdf->write1DBarcode("K" . $po, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(220,72);
		$pdf->Write(12,"PO LINE (4K)");
		$pdf->SetXY(265,85);
		$pdf->Write(12,$poline);
		$pdf->SetXY(290,72);
		$pdf->write1DBarcode("4K" . $poline, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,134);
		$pdf->Write(12,"QUANTITY (Q)");
		$pdf->SetXY(20,147);
		$pdf->Write(12,$quantity);
		$pdf->SetXY(20,160);
		$pdf->write1DBarcode("Q" . $quantity, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,196);
		$pdf->Write(12,"SERIAL NUMBER (S)");
		$pdf->SetXY(20,209);
		$pdf->Write(12,$serial);
		$pdf->SetXY(20,222);
		$pdf->write1DBarcode("S" . $serial, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(220,134);
		$pdf->Write(12, "DESCRIPTION");
		$base=147;
		list($nc,$notearr)=multiLine($description, 20);
		$i=0;

		foreach (explode("\r\n",$notearr) as $d) {
			$pdf->SetXY(220,$base);
			$pdf->Write(12,$d);
			$i++;
			$base+=13;
		}
		$pdf->SetFont("times","",10,'',false);
		$pdf->SetXY(220,235);
		$pdf->Write(10,"TO: " . $customer);
		$pdf->SetXY(220,245);
		$pdf->Write(10,$address);
		$pdf->SetXY(220,255);
		$pdf->Write(10,"$city, $state $zip");
		$pdf->SetXY(220,190);
		$pdf->Write(10,"FROM: Preferred Machine, LLC");
		$pdf->SetXY(220,200);
		$pdf->Write(10,"6673 PINE RIDGE COURT SW");
		$pdf->SetXY(220,210);
		$pdf->Write(10,"JENISON, MI 49428-9278");
	}
}

if ($type=="DEMATICLABEL") {
	$style = array(
	    'position' => '',
	    'align' => 'C',
	    'stretch' => false,
	    'fitwidth' => true,
	    'cellfitalign' => '',
	    'border' => false,
	    'hpadding' => 'auto',
	    'vpadding' => 'auto',
	    'fgcolor' => array(0,0,0),
	    'bgcolor' => false, //array(255,255,255),
	    'text' => false,
	    'font' => 'helvetica',
	    'fontsize' => 6,
	    'stretchtext' => 4
	);
	$id=$_GET['packslip'];
	$item=$_GET['part'];
	$po=$_GET['po'];
	$description=$_GET['description'];
	$quantity=$_GET['qty'];
	$serial=$_GET['serial'];
	$poline=$_GET['poline'];

	$sql="select * from packing_slip where packing_slip_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$customer=$data['ship_name'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];
		$revision="";
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(20,10);
		$pdf->Write(12,"PART NUMBER (P)");
		$pdf->SetXY(20,23);
		$pdf->Write(12,$item);
		$pdf->SetXY(20,36);
		$pdf->write1DBarcode("P" . $item, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,72);
		$pdf->Write(12,"PO NUMBER (K)");
		$pdf->SetXY(20,85);
		$pdf->Write(12,$po);
		$pdf->SetXY(20,98);
		$pdf->write1DBarcode("K" . $po, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(220,72);
		$pdf->Write(12,"PO LINE (4K)");
		$pdf->SetXY(265,85);
		$pdf->Write(12,$poline);
		$pdf->SetXY(290,72);
		$pdf->write1DBarcode("4K" . $poline, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,134);
		$pdf->Write(12,"QUANTITY (Q)");
		$pdf->SetXY(20,147);
		$pdf->Write(12,$quantity);
		$pdf->SetXY(20,160);
		$pdf->write1DBarcode("Q" . $quantity, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,196);
		$pdf->Write(12,"SERIAL NUMBER (S)");
		$pdf->SetXY(20,209);
		$pdf->Write(12,$serial);
		$pdf->SetXY(20,222);
		$pdf->write1DBarcode("S" . $serial, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(220,134);
		$pdf->Write(12, "DESCRIPTION");
		$base=147;
		list($nc,$notearr)=multiLine($description, 20);
		$i=0;

		foreach (explode("\r\n",$notearr) as $d) {
			$pdf->SetXY(220,$base);
			$pdf->Write(12,$d);
			$i++;
			$base+=13;
		}
		$pdf->SetFont("times","",10,'',false);
		$pdf->SetXY(220,235);
		$pdf->Write(10,"TO: " . $customer);
		$pdf->SetXY(220,245);
		$pdf->Write(10,$address);
		$pdf->SetXY(220,255);
		$pdf->Write(10,"$city, $state $zip");
		$pdf->SetXY(220,190);
		$pdf->Write(10,"FROM: Preferred Machine, LLC");
		$pdf->SetXY(220,200);
		$pdf->Write(10,"6673 PINE RIDGE COURT SW");
		$pdf->SetXY(220,210);
		$pdf->Write(10,"JENISON, MI 49428-9278");
}

if ($type=="SEAVER") {
	$style = array(
	    'position' => '',
	    'align' => 'C',
	    'stretch' => false,
	    'fitwidth' => true,
	    'cellfitalign' => '',
	    'border' => false,
	    'hpadding' => 'auto',
	    'vpadding' => 'auto',
	    'fgcolor' => array(0,0,0),
	    'bgcolor' => false, //array(255,255,255),
	    'text' => false,
	    'font' => 'helvetica',
	    'fontsize' => 6,
	    'stretchtext' => 4
	);
	$id=$_GET['packslip'];
	$item=$_GET['part'];
	$po=$_GET['po'];
	$description=$_GET['description'];
	$quantity=$_GET['qty'];
	$serial=$_GET['serial'];

	$poline=$_GET['poline'];

	$sql="select * from packing_slip where packing_slip_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$customer=$data['ship_name'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];

	$sql="select order_id, order_line from packing_slip_lines where line_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$serial));
	$data=$rs[0];
	$order=$data['order_id'];
	$orderLine=$data['order_line'];
		$revision="";
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
		$pdf->SetFont("times","B",12,'',false);
		$pdf->SetXY(20,10);
		$pdf->Write(10,"FROM: Preferred Machine, LLC");
		$pdf->SetXY(20,21);
		$pdf->Write(10,"6673 PINE RIDGE COURT SW");
		$pdf->SetXY(20,32);
		$pdf->Write(10,"JENISON, MI 49428-9278");
		$pdf->SetFont("times","",14,'',false);
		$sql="select color_code from order_line_color o, vendor_colors v where o.color_id=v.vc_id and order_line=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$orderLine));
		if (count($rs)>0) {
			$data=$rs[0];
			$color=$data['color_code'];
			$pdf->SetXY(250,10);
			$pdf->Write(14,"COLOR");
			$pdf->SetXY(250,25);
			$pdf->Write(14,$color);
		}
		$pdf->SetXY(20,50);
		$pdf->Write(14,"PART NUMBER");
		$pdf->SetXY(20,65);
		$pdf->Write(14,$item);
		$pdf->SetXY(150,50);
		$pdf->Write(14,"QUANTITY");
		$pdf->SetXY(150,65);
		$pdf->Write(14,$quantity);
		$pdf->SetXY(240,50);
		$pdf->write(14,"DESCRIPTION");
		$pdf->SetFont("times","",10,'',false);
		$pdf->SetXY(240,65);
		$pdf->Write(10,$description);
		$pdf->SetFont("times","",14,'',false);
		$pdf->SetXY(20,100);
		$pdf->Write(14,"PO# $po");
		$pdf->SetXY(20,115);
		$pdf->write1DBarcode($po, 'C39', '', '', '', 36, 1, $style, 'N');
		$pdf->SetXY(20,180);
		$pdf->Write(12,"SO# $order");
		$pdf->SetXY(20,195);
		$pdf->write1DBarcode($order, 'C39', '', '', '', 36, 1, $style, 'N');
}

if ($type=="SHIP") {
	$sql="select * from orders where order_id=?";
	$packslip=$_GET['pack'];
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$customerID=$data['customer_id'];
	$folder=$data['folder_number'];
	$due=$data['due_customer'];
	if (! $due or $due == "0000-00-00") {
		$due=$data['date_due'];
	}
	$dateDue=formatDateDBToWeb($due);
	$po=$data['po_number'];
	$folder=$data['folder_number'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];
	$customer=$data['ship_name'];
	$dateOrder=formatDateDBToWeb($data['date_order']);
	$qty=$_GET['qty'];
	if (! $qty) {
		$qty=1;
	}
		$style = array(
		    'position' => '',
		    'align' => 'C',
		    'stretch' => false,
		    'fitwidth' => true,
		    'cellfitalign' => '',
		    'border' => false,
		    'hpadding' => 'auto',
		    'vpadding' => 'auto',
		    'fgcolor' => array(0,0,0),
		    'bgcolor' => false, //array(255,255,255),
		    'text' => true,
		    'font' => 'helvetica',
		    'fontsize' => 6,
		    'stretchtext' => 4
		);
		$qstyle = array(
			'border' => 1,
			'vpadding' => 'auto',
			'hpadding' => 'auto',
			'fgcolor' => array(0,0,0),
			'bgcolor' => false, //array(255,255,255)
			'module_width' => 1, // width of a single module in points
			'module_height' => 1 // height of a single module in points
		);
	if ($userEmail != "holland pickup") {
		$sql="delete from skids where packing_slip_id=? and skid_type='PACK' ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$packslip));
	}
	$copies=1;
	if (isset($_GET['copies'])) {
		$copies=$_GET['copies'];
	}
	$c=0;
	$vendor=0;
	if (isset($_GET['vendor'])) {
		$vendor=$_GET['vendor'];
	}
	if ($vendor) {
		$c=$copies+1;
	}
	$skids="SKIDS";
	if ($qty == 1) {
		$skids="SKID";
	}
	if ($copies == 1) {
		$skids="BOXES";
		if ($qty == 1) {
			$skids="BOX";
		}
	}
	while ($c < $copies) {
		$c++;
		$i=0;
		while ($i < $qty) {
			$i++;
			$pdf->AddPage();
			$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
			$font=20;
			$pdf->SetFont("times","",$font,'',false);
			while ($pdf->GetStringWidth($customer)>200) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			while ($pdf->GetStringWidth($address)>200) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			$csz="$city, $state $zip";
			while ($pdf->GetStringWidth($csz)>200) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			$po=str_replace("\r\n","",$po);
			$po=str_replace("\r","",$po);
			$po=str_replace("\n","",$po);
			while ($pdf->GetStringWidth($po)>150) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			$pdf->SetFont("times","B",20,'',false);
			$dt="Due: $dateDue";
			$pdf->SetFont("times","",$font,'',false);
			$pdf->SetXY(20,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,"$customer");
			$pdf->StopTransform();
			$pdf->SetXY(48,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,$address);
			$pdf->StopTransform();
			$pdf->SetXY(66,420);
			$pdf->SetFont("times","",$font,'',false);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,$csz);
			$pdf->StopTransform();
			$pdf->SetFont("times","",$font,'',false);
			$pdf->SetXY(88,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->SetFont("times","",$font,'',false);
			$pdf->Write($font,"PO: " . $po);
			$pdf->StopTransform();
			$pdf->SetXY(110,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,"SO: $folder");
			$pdf->StopTransform();
			$pdf->SetXY(132,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,"$i of $qty $skids");
			$pdf->StopTransform();
			$pdf->SetXY(240,120);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->SetFont("times","",15,'',false);
			$pdf->Write(12,"PreferredMachineLLC.com");
			$pdf->StopTransform();
			$pdf->SetXY(200,120);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$code=$packslip . "-" . $i;
			$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
			# we have 1d barcodes
			$pdf->write2DBarcode($code, 'QRCODE,H', 200, 50, 50, 50, $qstyle, 'N');
			$pdf->StopTransform();

			//Print QR Code -Josh 01-31-2022
			$sql = "select * from system_settings where name=?";
			list($rs,$err) = runIQuery($db, $sql, array(
				"s",
				"qr_code_until"
			));
			if (date("Y-m-d", strtotime("-1 day")) < date("Y-m-d", strtotime($rs[0]["setting"]))) {
				$pdf->write2DBarcode('http://survey.preferredmachinellc.com/survey.html?c=' . $customerID, 'QRCODE,L', 185, 340, 70, 70, $qstyle, 'N');
				$pdf->SetXY(191,410);
				$pdf->Write(12,"Free Swag Drawing");

			}


			$pdf->SetXY(154,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,$dt);
			$pdf->StopTransform();

			if ($c == 1) {
				$box=0;
				if ($copies == 1) {
					$box=1;
				}
				if ($userEmail != "holland pickup") {
					$sql="insert into skids (packing_slip_id, skid_number, weight, scanned, skid_type,box) values (?, ?, 0, '0000-00-00','PACK',?)";
					list($rs,$err)=runIQuery($db,$sql,array("iii",$packslip,$i,$box));
				}
			}
		}
	}
	## todo vendor stuff
	if ($vendor > 0) {
		$lead=getCustomerLeadTime($db,$id);
		if ($lead > 0) {
			## $due=SubtractBusinessDays($due,$lead,$db);
		}
		$dateDue=formatDateDBToWeb($due);
		$dt="Due $dateDue";
		$sql="select * from vendors where vendor_id=?";
		list($rs,$err)=runIQuery($db,$sql,array("i",$vendor));
		if (count($rs) > 0) {
			$data=$rs[0];
			$vendorName=$data['vendor_name'];
			$vendorAddress=$data['address'];
			$vendorCity=$data['city'];
			$vendorState=$data['state'];
			$vendorZip=$data['zip'];
			$csz="$vendorCity, $vendorState $vendorZip";
			$c=0;
			while ($c < $copies) {
				$i=0;
				$c++;
				while ($i < $qty) {
					$i++;
					$pdf->AddPage();
					$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
					$font=20;
					$pdf->SetFont("times","",$font,'',false);
					while ($pdf->GetStringWidth($vendorName)>200) {
						$font-=.5;
						$pdf->SetFont("times","",$font,'',false);
					}
					while ($pdf->GetStringWidth($vendorAddresss)>200) {
						$font-=.5;
						$pdf->SetFont("times","",$font,'',false);
					}
					$csz="$city, $state $zip";
					while ($pdf->GetStringWidth($csz)>200) {
						$font-=.5;
						$pdf->SetFont("times","",$font,'',false);
					}
					$pdf->SetFont("times","",$font,'',false);
					$pdf->SetXY(20,420);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->Write($font,$vendorName);
					$pdf->StopTransform();
					$pdf->SetXY(44,420);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->Write($font,$vendorAddress);
					$pdf->StopTransform();
					$pdf->SetXY(66,420);
					$pdf->SetFont("times","",20,'',false);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$csz="$vendorCity, $vendorState $vendorZip";
					$pdf->Write($font,$csz);
					$pdf->StopTransform();
					$pdf->SetFont("times","",$font,'',false);
					$pdf->SetXY(88,420);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->SetFont("times","",20,'',false);
					$pdf->Write(20,"PO: " . $po);
					$pdf->StopTransform();
					$pdf->SetFont("times","",20,'',false);
					$pdf->SetXY(110,420);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->Write(20,"SO: $folder");
					$pdf->StopTransform();
					$pdf->SetXY(132,420);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->Write(20,"$i of $qty $skids");
					$pdf->StopTransform();
					$pdf->SetXY(240,120);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->SetFont("times","",15,'',false);
					$pdf->Write(12,"PreferredMachineLLC.com");
					$pdf->StopTransform();
					$pdf->SetXY(200,120);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$code="T" . $packslip . "-" . $i;
					$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
					$pdf->write2DBarcode($code, 'QRCODE,H', 200, 50, 50, 50, $qstyle, 'N');
					$pdf->StopTransform();
					$pdf->SetXY(154,420);
					$pdf->StartTransform();
					$pdf->Rotate(90);
					$pdf->Write($font,$dt);
					$pdf->StopTransform();

					if ($c == 1) {
						$box=0;
						if ($copies == 1) {
							$box=1;
						}
						if ($userEmail != "holland pickup") {
							$sql="insert into skids (packing_slip_id, skid_number, weight, scanned, skid_type,box) values (?, ?, 0, '0000-00-00','TRANSFER',?)";
							list($rs,$err)=runIQuery($db,$sql,array("iii",$packslip,$i,$box));
						}
					}
				}
			}
		}
	}
}

if ($type=="TRANSFER") {
	$packslip=$_GET['pack'];
	$sql="select * from transfers where packing_slip_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$pack));
	$data=$rs[0];
	$location=$data['location'];
	$dateDue=formatDateDBToWeb($data['transfer_date']);
	$folder=$data['folder_number'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];
	$qty=$_GET['qty'];
	$sql="select po_number from transfer_lines where packing_slip=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$pack));
	$data=$rs[0];
	$po=$data['po_number'];
	if (! $qty) {
		$qty=1;
	}
	$i=0;
		$style = array(
		    'position' => '',
		    'align' => 'C',
		    'stretch' => false,
		    'fitwidth' => true,
		    'cellfitalign' => '',
		    'border' => false,
		    'hpadding' => 'auto',
		    'vpadding' => 'auto',
		    'fgcolor' => array(0,0,0),
		    'bgcolor' => false, //array(255,255,255),
		    'text' => true,
		    'font' => 'helvetica',
		    'fontsize' => 6,
		    'stretchtext' => 4
		);
	if ($userEmail != "holland pickup") {
		$sql="delete from skids where packing_slip_id=? and skid_type='TRANSFER' ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$packslip));
	}
	while ($i < $qty) {
		$i++;
		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
		$font=50;
		$pdf->SetFont("times","B",50,'',false);
		$w = $pdf->GetStringWidth($location);
		while ($w > 250) {
			$font--;
			$pdf->SetFont("times","",$font,'',false);
			$w = $pdf->GetStringWidth($location);
		}
		$w = $pdf->GetStringWidth($address);
		while ($w > 250) {
			$font--;
			$pdf->SetFont("times","",$font,'',false);
			$w = $pdf->GetStringWidth($address);
		}
		$w = $pdf->GetStringWidth("$city, $state $zip");
		while ($w > 250) {
			$font--;
			$pdf->SetFont("times","",$font,'',false);
			$w = $pdf->GetStringWidth("$city, $state $zip");
		}
		$pdf->SetFont("times","",$font,'',false);
		$pdf->SetXY(20,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,$location);
		$pdf->StopTransform();
		$pdf->SetXY(20+$font+4,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,$address);
		$pdf->StopTransform();
		$pdf->SetXY(20+($font*2)+6,420);
		$pdf->SetFont("times","",20,'',false);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$csz="$city, $state $zip";
		$pdf->Write($font,$csz);
		$pdf->StopTransform();
		$pdf->SetFont("times","",$font,'',false);
		$pdf->SetXY(20+($font*3)+8,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->SetFont("times","",20,'',false);
		$pdf->Write($font,"PO: " . $po);
		$pdf->StopTransform();
		$pdf->SetXY(20+($font*4)+10,420);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->Write($font,"SO: $folder");
		$pdf->StopTransform();
		$pdf->SetXY(240,120);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$pdf->SetFont("times","",15,'',false);
		$pdf->Write(12,"PreferredMachineLLC.com");
		$pdf->StopTransform();
		$pdf->SetXY(200,120);
		$pdf->StartTransform();
		$pdf->Rotate(90);
		$code=$packslip . "-" . $i;
		$pdf->write1DBarcode($code, 'C39', '', '', '', 36, 0.6, $style, 'N');
		$pdf->StopTransform();
		$box=0;
		if ($copies == 1) {
			$box=1;
		}
		if ($userEmail != "holland pickup") {
			$sql="insert into skids (packing_slip_id, skid_number, weight, scanned, skid_type,box) values (?, ?, 0, '0000-00-00','TRANSFER',?)";
			list($rs,$err)=runIQuery($db,$sql,array("iii",$packslip,$i,$box));
		}
	}

}

if ($type=="WO") {
	$idlist=$id;
	foreach (explode(",",$idlist) as $id) {
		$lc=99;
		## must be in laser
		$sql="select ship_name, phone, date_due, folder_number, item_id, item_description, quantity, due_date, revision, material from orders, order_lines, order_line_operations where orders.order_id=? and orders.order_id=order_lines.order_id and order_lines.line_id=order_line_operations.line_id and operation_id=35 order by order_lines.line_id ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		foreach ($rs as $data) {

		}
		reset($rs);
		foreach ($rs as $data) {
			$part=$data['item_id'];
			$datedue=formatDateDBToWeb($data['due_date']);
			$description=$data['item_description'];
			$quantity=$data['quantity'];
			$revision=$data['revision'];
			$customer=$data['ship_name'];
			$phone=$data['phone'];
			$folder=$data['folder_number'];
			$materialID=$data['material'];
			if ($lc > 30) {
				printWOHeader($customer,$folder,$phone,$pdf);
				$lc=0;
			}
			$lc++;
			$base=60 + ($lc*20);
			$pdf->SetXY(20,$base);
			if (strstr(strtoupper($folder),"RMA")) {
				$pdf->SetFont("times","",10,'',false);
			}
			$pdf->Write(16,$folder);
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(80,$base);
			$pdf->Write(16,$part);
			if ($materialID) {
				$sql="select material_name from materials where material_id=?";
				list($mrs,$err)=runIQuery($db,$sql,array("i",$materialID));
				$mdata=$mrs[0];
				$materialName=$mdata[0];
				if (strtoupper($materialName) != "NON-LASER") {
					if (strtoupper($materialName) != "OUTSOURCE WELDMENT") {
						if ($materialName) {
							$pdf->SetXY(210,$base+5);
							$pdf->SetFont("times","",6,'',false);
							$pdf->Write(6,$materialName);
							$pdf->SetFont("times","",16,'',false);
						}
					}
				}
			}
			$font=14;
			while ($pdf->GetStringWidth($description) > 120) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			$pdf->SetXY(280,$base);
			$pdf->Write(16,$description);
			$pdf->SetFont("times","",16,'',false);
			$pdf->SetXY(400,$base);
			$pdf->Write(16,$quantity);
			$pdf->SetXY(460,$base);
			$pdf->Write(16,"____");
			$pdf->SetXY(500,$base);
			$pdf->Write(16,"________");

		}
	}
}

if ($type=="SO") {
	$base=700;
	## must not be going into a weldment
	$sql="select o.order_id, o.date_due, o.due_customer, ship_name, ship_address, ship_city, ship_state, ship_zip, po_number, o.email, o.phone, status, folder_number,  ";
	$sql.=" item_id, item_description, quantity, price, due_date, calculated_price, material_name, notes_to_customer, order_vendor, o.order_type, c.separate_expedite ";
	$sql.=" from customers c, orders o inner join order_lines l on o.order_id=l.order_id left outer join materials on material=material_id ";
	$sql.=" where o.customer_id=c.customer_id and o.order_id = ? and line_id not in (select line_id from order_line_operations where operation_id=62) ";
	$sql.=" order by cast(po_line as unsigned), line_id ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$total=0; // not needed

	$baseTotal=0;
	$extTotal=0;
	$nowBase=0;
	$nowExt=0;
	$separateExpedite=0;

	$partFont=12;
	$pdf->SetFont("helvetica","",$partFont,'',false);
	foreach ($rs as $data) {
		$part=$data['item_id'];
		$separateExpedite = $data["separate_expedite"];
		$sql="select item_category from items where item_name=? and item_category=15";
		list($irs,$err)=runIQuery($db,$sql,array("s",$part));
		if (count($irs)==0) {
			$order=$data['order_id'];
			$description=$data['item_description'];
			$showpart=generateSOPart($db,$order,$part,$description);
			while ($pdf->GetStringWidth($showpart) > 275  and $partFont > 6) {
				$partFont-=.5;
				$pdf->SetFont("helvetica","",$partFont,'',false);
			}
			if ($partFont <= 6)  {
				$showpart=trim($part . $description);
				$partFont=12;
				$pdf->SetFont("helvetica","",$partFont,'',false);
				while ($pdf->GetStringWidth($showpart) > 275) {
					$partFont-=.5;
					$pdf->SetFont("helvetica","",$partFont,'',false);
				}
				$ops=generateOps($db,$order,$part);
				while ($pdf->GetStringWidth("OPS: " . $ops)> 275) {
					$partFont-=.5;
					$pdf->SetFont("helvetica","",$partFont,'',false);
				}
			}
		}
	}
	reset($rs);
	foreach ($rs as $data) {
		$po=$data['po_number'];
		$order=$data['order_id'];
		$shipName=$data['ship_name'];
		$shipAddress=$data['ship_address'];
		$shipCity=$data['ship_city'];
		$shipState=$data['ship_state'];
		$shipZip=$data['ship_zip'];
		$phone=$data['phone'];
		$email=$data['email'];
		$status=$data['status'];
		$folder=$data['folder_number'];
		$notes=$data['notes_to_customer'];
		$notes=str_replace("\r"," ",$notes);
		$notes=str_replace("\n"," ",$notes);
		$material=$data['material_name'];
		$quantity=$data['quantity'];
		$price=$data['price'];
		$vendor=$data['order_vendor'];
		$typeName="Standard";
		$orderType=$data['order_type'];
		if ($price <= 0) {
			#$price=$data['calculated_price'];
		}

		$quantity=$data['quantity'];
		$part=$data['item_id'];
		$due=$data['due_customer'];
		if (! $due or $due == "0000-00-00") {
			$due=$data['date_due'];
		}
		$datedue=formatDateDBToWeb($data['due_date']);
		$dateQuote=formatDateDBToWeb($due);
		$sql="select item_category from items where item_name=? and item_category=15";
		list($irs,$err)=runIQuery($db,$sql,array("s",$part));
		if (count($irs)==0) {
			$description=$data['item_description'];
			$sql="select * from order_lines where order_id=? and item_description=? ";
			list($brs,$err)=runIQuery($db,$sql,array("is",$id,$part));
			$ckbase=$base;
			$ckbase+= count($brs)*13;
			if ($ops) {
				$ckbase+=13;
			}
			if ($ckbase > 630) {
				$base=printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$due,$folder,$phone,$pdf,$notes);
			}
			$base+=13;
			list($nc,$notearr)=multiLine($notes, 110);
			$pdf->SetFont("helvetica","",$partFont,'',false);
			$pdf->SetXY(20,$base);
			$showpart=generateSOPart($db,$order,$part,$description);
			$ops="";
			if ($pdf->GetStringWidth($showpart) > 275) {
				$showpart=trim($part . " " . $description);
				$ops=generateOps($db,$order,$part);
			}
			// truncate parts if too long -Josh 02-08-2023
			$fontsize=$partFont;
			while ($pdf->GetStringWidth($showpart) > 266) {
				$fontsize-=0.5;
				$pdf->SetFont("helvetica","",$fontsize,'',false);
				if ($fontsize < 7.5) {
					$showpart = substr($showpart,0,65);
					break;
				}
			}
			$pdf->Write($partFont,$showpart);
			$pdf->SetFont("helvetica","",12,'',false);
			$y = 342 - $pdf->GetStringWidth(number_format($quantity,0));
			$pdf->SetXY($y,$base);
			$pdf->Write(12,number_format($quantity,0));


			$basePrice = $price;
			$nowPrice = 0;
			$baseExt = 0;
			$nowExt = 0;
			$surcharge=0;
			if ($orderType) {
				$sql="select factor, type_name from order_types where type_id=?";
				list($srs,$err)=runIQuery($db,$sql,array("i",$orderType));
				$sdata=$srs[0];
				$typeFactor=$sdata[0];
				$typeExtra = $basePrice*$typeFactor/100;
				$nowPrice = $basePrice+$typeExtra;
				$baseExt=$basePrice*$quantity;
				$nowExt=$nowPrice*$quantity;
				$typeName=$sdata[1];
			}

			$shownPrice = $nowPrice;
			$shownExt = $nowExt;
			if ($separateExpedite) {
				$shownPrice = $basePrice;
				$shownExt = $baseExt;
			}

			if ($shownPrice > 0) {
				$shownPrice=round($shownPrice*100)/100;
				## formatting issues here if price is a large number bdoss, per Justin
				if ($pdf->GetStringWidth(number_format($shownPrice,2)) > 50) {
					$y = 402 - $pdf->GetStringWidth(number_format($shownPrice,2));
					$pdf->SetXY($y,$base);
					$pdf->SetFont("helvetica","",$partFont-2,'',false);
					$pdf->Write(12,number_format($shownPrice,2));
				} else {
					$y = 393 - $pdf->GetStringWidth(number_format($shownPrice,2));
					$pdf->SetXY($y,$base);
					$pdf->Write(12,number_format($shownPrice,2));
				}
				$pdf->SetFont("helvetica","",$partFont,'',false);
				$ext=$shownPrice * $quantity;
				$y=467 - $pdf->GetStringWidth(number_format($ext,2));
				$pdf->SetXY($y,$base);
				$pdf->Write(12,number_format($ext,2));
				$total += $ext;

				$baseTotal += $baseExt;
				$nowTotal += $nowExt;
			}
			$pdf->SetXY(475,$base);
			$font=12;
			while ($pdf->GetStringWidth($material) > 120) {
				$font-=.5;
				$pdf->SetFont("helvetica","",$font,'',false);
			}
			if (strtoupper($material) != "NON-LASER") {
				if (strtoupper($material) != "OUTSOURCE WELDMENT") {
					$pdf->Write(12,$material);
				}
			}
			if ($ops) {
				$base+=13;
				if ($base > 645) {
					$base=printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$due,$folder,$phone,$pdf,$notes);
				}
				$pdf->SetXY(20,$base);
				$pdf->SetFont("helvetica","",$partFont,'',false);
				$pdf->Write(12,"OPS: $ops");
				$pdf->SetFont("helvetica","",12,'',false);
			}
			$sql="select * from order_lines left outer join materials on material=material_id  where order_id=? and item_description=? ";
			list($brs,$err)=runIQuery($db,$sql,array("is",$id,$part));
			foreach ($brs as $bdata) {
				$bompart=$bdata['item_id'];
				$bomqty=$bdata['quantity'];
				$material=$bdata['material_name'];
				$base+=13;
				if ($base > 645) {
					$base=printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$due,$folder,$phone,$pdf,$notes);
				}
				$pdf->SetFont("helvetica","",$partFont,'',false);
				$pdf->SetXY(40,$base);
				$pdf->Write($partFont,$bompart);
				$pdf->SetFont("helvetica","",12,'',false);
				$y = 342 - $pdf->GetStringWidth(number_format($bomqty,0));
				$pdf->SetXY($y,$base);
				$pdf->Write(12,number_format($bomqty,0));
				if (strtoupper($material) != "NON-LASER") {
					if (strtoupper($material) != "OUTSOURCE WELDMENT") {
						$pdf->SetXY(475,$base);
						$font=12;
						while ($pdf->GetStringWidth($material) > 120) {
							$font-=.5;
							$pdf->SetFont("helvetica","",$font,'',false);
						}
						$pdf->Write(12,$material);
					}
				}

			}
			$base += 4;
			//Item lines -Josh 02-16-2022
			$pdf->Line(18,$base+12,600,$base+12, array('width' => 0.1));
            $pdf->SetLineWidth(1);
		}
	}

	$base += 14;
	if ($separateExpedite) {
		if ($nowTotal != $baseTotal) {
			$feeTot = $nowTotal-$baseTotal;
			$feeType="$typeName Fee";
			if ($nowTotal < $baseTotal) {
				$feeType="$typeName";
			}

			$pdf->SetXY(20,$base);
			$pdf->Write(10,$feeType);
			$pdf->SetXY(436, $base);
			if ($pdf->GetStringWidth(number_format($feeTot,2)) > 50) {
				$y = 402 - $pdf->GetStringWidth(number_format($feeTot,2));
				$pdf->SetXY($y,$base);
				$pdf->SetFont("helvetica","",$partFont-2,'',false);
				$pdf->Write(12,number_format($feeTot,2));
			} else {
				$y = 393 - $pdf->GetStringWidth(number_format($feeTot,2));
				$pdf->SetXY($y,$base);
				$pdf->Write(12,number_format($feeTot,2));
			}
			$pdf->SetXY(336, $base);
			$pdf->Write(10,1);
			$y=467 - $pdf->GetStringWidth(number_format($feeTot,2));
			$pdf->SetXY($y,$base);
			$pdf->Write(12,number_format($feeTot,2));
			$base+=15;
			$pdf->Line(18,$base,600,$base, array('width' => 0.1));
		}
	}

	$base += 12;
	if ($base > 580) {
		$base=printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$due,$folder,$phone,$pdf,$notes);
	}
	if (isset($status) && $status == 10) {
		$priceBase = $base;
		$sql = "select * from order_types where factor >= 0 order by factor desc ";
		list($otrs,$err)=runIQuery($db,$sql);
		$pdf->SetXY(40	, $priceBase);
		$pdf->SetFont("helvetica","b",12);
		$pdf->Write(10,"Pricing Options");
		$pdf->Line(38,$priceBase+14,280,$priceBase+14,["width"=>0.1]);
		$pdf->SetFont("helvetica","",12);
		foreach ($otrs as $ot) {
			if ($ot["type_id"] == $orderType) {
				$pdf->SetFont("helvetica","b",12);
			} else {
				$pdf->SetFont("helvetica","",12);
			}
			$pdf->SetXY(40, $priceBase += 15.5);
			$pdf->Write(10,$ot["type_name"] . " ");
			$pdf->SetXY(120, $priceBase);
			if ($ot["type_id"] == $orderType) {
				$pdf->Write(10,"Current Total " . number_format($baseTotal+($baseTotal*$ot["factor"]/100),2));
			} else {
				$pdf->Write(10,"New Total " . number_format($baseTotal+($baseTotal*$ot["factor"]/100),2));
			}
			$pdf->Line(38,$priceBase+14,280,$priceBase+14, array('width' => 0.1));
		}
		$pdf->Line(38,$base,38,$priceBase+14, array('width' => 0.1));
		$pdf->Line(280,$base,280,$priceBase+14, array('width' => 0.1));
		$pdf->Line(38,$base,280,$base, array('width' => 0.1));
	}

	$pdf->SetXY(350,$base);
	$pdf->SetFont("helvetica","B",12,'',false);
	$pdf->Write(12, "Total");
	if ($total <> 0 ) {
		$y=467 - $pdf->GetStringWidth(number_format($nowTotal,2));
		$pdf->SetXY($y,$base);
		$pdf->Write(12, number_format($nowTotal,2));
	} else {
		$y=467 - $pdf->GetStringWidth("T&M");
		$pdf->	SetXY($y,$base);
		$pdf->Write(12, "T&M");
	}
	if ($status != 10) {
		if ($vendor) {
			$sql="select vendor_name from vendors where vendor_id=?";
			list($vrs,$err)=runIQuery($db,$sql,array("i",$vendor));
			$vdata=$vrs[0];
			$vendorName=$vdata['vendor_name'];
			$vendorMessage="Goes to Outside Processor on $datedue";
			$base=685;
			$xpos=288 - ($pdf->GetStringWidth($vendorMessage)/2);
			$pdf->SetXY($xpos,$base);
			$pdf->Write("12",$vendorMessage);
		}
	}
	$pdf->SetFont("helvetica","I",10,'',false);
	$dateQuote = Date("m/d/Y h:i:s");
	$base=700;
	$xpos=288 - ($pdf->GetStringWidth($dateQuote)/2);
	$pdf->SetXY($xpos,$base);
	$pdf->Write(12,"$dateQuote");
	$pdf->SetFont("helvetica","",12,'',false);
	$base=printSOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$order,$po,$status,$due,$folder,$phone,$pdf,"nolines");
	$base+=13;
	if ($status == 10) {
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Due to material type and market volatility, price is subject to change. ");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Pricing good for 7 calendar days contingent on  material  availability.  All amounts are stated in ");
#		$pdf->Write(12, "Quote is valid for 30 calendar days from the date listed on this quotation.  All amounts are stated in ");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "U.S. dollars and must be paid in U.S. dollars.  Quote includes material cost, unless otherwise noted, ");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "and is based on customer supplied electronic CAD data.  Changes requested after a quote has been ");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "submitted may invalidate quoted pricing.  These changes include, but are not limited to, increase or ");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "decrease in part quantity, modifications to prints or CAD data, and deviations of material type or thickness.");
		$base+=13;
		$base+=12;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Unless quoted as such, orders required to be completed within Preferred Machine's expedite window will incur");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "the normal expediting fees in addition to the quoted pricing.  This will be factored automatically on a ");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "per part basis, and will not show as a separate line on an invoice.");
		$base+=13;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Please contact laser@preferredmachinellc.com for current expedite window.");
		$base+=25;
	}
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine does not assume liability for customer part design.  A setup fee will be applied if Preferred");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Machine is required to draw or re-work customer supplied prints or CAD data.  Preferred Machine's general ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "tolerances will be used if tolerances are not specified on customer supplied prints or CAD data.");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Please contact laser@preferredmachinellc.com for current tolerances.");
	$base+=13;
	$base+=12;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine applies an expedite fee to all orders that are required to be completed four business");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "days or less from the date a purchase order is received.  Preferred Machine's cutoff time for receiving");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "purchase orders is 3:00 PM.  All purchase orders received after 3:00 PM will be considered as received");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "on the following business day at 8:00 AM.");
	$base+=13;
	$base+=12;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine stocks a large number of material types and thicknesses.  Any material type or");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "thickness that is not a stocked material is referred to as Custom Material.  When a Custom Material is");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "requested, Preferred Machine will charge for the full amount of material ordered.  Any remaining ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "material drops will be scrapped, unless requested to be included with the order when complete.  Please");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "contact laser@preferredmachinellc.com for a current material stock list.");
	$base+=13;
	$base+=12;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "All orders falling below a $50.00 total are subject to Preferred Machine's minimum order charge, unless ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "otherwise noted.  Shipping costs are not factored into order total, and therefore will not be included when");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "determining if an order falls below the minimum order charge threshold of $50.00.");
	$base+=13;
	$base+=12;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"** PPF (Post Process Finish) is the item code that Preferred Machine applies to orders that require a ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"coating or plating operation that is to be completed by Preferred Machine.  PPF is applied for powder ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"coat, anodize, oxide, and zinc plating.  Any other coating/plating types are not offered by Preferred ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Machine.  Lead times for each coating/plating type vary.  The value in the Rate column for the PPF ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"item code is the total coating/plating cost for that order.  If no value is found in the Rate column ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"for the PPF item code, the coating/plating cost is being treated as “time and material” for pricing purposes.");
	$pdf->SetFont("helvetica","B",12,'',false);
	$base+=13;
	$base+=12;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"SKID RETURN POLICY:");
	$pdf->SetFont("helvetica","",12,'',false);
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"In order to control delivery costs, Preferred Machine asks that you return skids and pallets.  ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Please work with Preferred Delivery Service drivers, or contact Preferred Delivery Service at ");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"preferreddeliveries@gmail.com to arrange for pick up.");
	$base+=13;
	$base+=12;
	$pdf->SetFont("helvetica","B",12,'',false);
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"MARKET VOLATILITY");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->SetFont("helvetica","",12,'',false);
	$pdf->Write(12,"Due to material type and market volatility, price is subject to change.");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Pricing is good for 7 calendar days contingent on material availability.");
}


## This PO is actually a Packing Slip printed as a PO
if ($type=="PO") {
	$copies=2;
	if (isset($_GET['copies'])) {
		$copies=$_GET['copies'];
	}
	$c=0;
	while ($c < $copies) {
		$c++;
	 	$lc=99;
	 	$pageNumber=0;
	 	$colors=array();
		$sql="select vendors.vendor_id, vendor_name, vendors.address, vendors.city, vendors.state, vendors.zip, vendors.phone, vendors.email, date_shipped, packing_slip_lines.order_id, packing_slip_lines.part_number, packing_slip_lines.description, packing_slip_lines.quantity, ship_address as ultimate, packing_slip_lines.po_number, packing_slip_lines.order_line from packing_slip inner join packing_slip_lines on packing_slip_id = packing_list_id left outer join vendors on packing_slip.vendor_id=vendors.vendor_id left outer join order_lines on order_line=order_lines.line_id where packing_slip_id=? order by packing_slip_lines.line_id ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$updated=0;
		foreach ($rs as $data) {
			$order=$data['order_id'];
			$vendorID=$data['vendor_id'];
			if (! $updated) {
				if ($vendorID) {
					if ($vendorID == 20) {
						## MFT mark as at processor as well
						updateOrderStatus($db,$order,11);
					} else {
						// might be 11 some day
						// used to be 4 now lets try 11
						updateOrderStatus($db,$order,11);
					}
				}
				$updated=1;
			}
			$shipName=$data['vendor_name'];
			$shipAddress=$data['address'];
			$attention=$shipAddress;
			$shipCity=$data['city'];
			$shipState=$data['state'];
			$shipZip=$data['zip'];
			$phone=$data['phone'];
			$email=$data['email'];
			$quantity=$data['quantity'];
			$part=$data['part_number'];
			$po=$data['po_number'];
			$description=strtoupper($data['description']);
			if (! in_array($description,$colors)) {
				$colors[]=$description;
			}
			$line=$data['order_line'];
			$color="";
			if ($line) {
				$sql="select color_code from order_line_color c, vendor_colors v where c.order_line=? and c.color_id=v.vc_id";
				list($crs,$err)=runIQuery($db,$sql,array("i",$line));
				if (count($crs)) {
					$cdata=$crs[0];
					$color=$cdata['color_code'];
					if (! in_array($color,$colors)) {
						$colors[]=$color;
					}
				}
			}
			$attention=$data['ultimate'];
			list($due,$time)=explode(" ",formatDateDBToWeb($data['date_shipped']));
			if ($lc > 25) {
				if ($lc < 99) {
					if ($tracking) {
						$pdf->SetXY(306,692);
						$pdf->SetFont("times","B",9,'',false);
						$pdf->Write(9,"TRACKING# $tracking");
						$pdf->SetFont("times","",12,'',false);
					}
					$pdf->SetXY(20,702);
					$pdf->Write(12,"Phone: 616.272.6334  Email: shipping@preferredmachinellc.com Accounts Payable: ap@preferredmachinellc.com");
				}
				$pageNumber++;
				printPOHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$phone,$order,$id,$attention,$pdf,$due,$pageNumber);
				$lc=0;
			}
			$lc++;
			$base=102  + ($lc*20);
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(20,$base);
			$pdf->Write(12,$part . " " . $description . " " . $color);
			$y = 522 - $pdf->GetStringWidth(number_format($quantity,0));
			$pdf->SetXY($y,$base);
			$pdf->Write(12,number_format($quantity,0));
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(530,$base);
			$pdf->Write(12,$due);
		}
		$pdf->SetXY(20,680);
		$sql="select due_customer from orders where order_id=?";
		list($drs,$err)=runIQuery($db,$sql,array("i",$order));
		$ddata=$drs[0];
		$due=$ddata[0];
		$dueCustomer=formatDateDBToWeb($due);
		$pdf->Write(12,"Ultimate Destination: $attention $dueCustomer");
		if ($tracking) {
			$pdf->SetXY(306,692);
			$pdf->SetFont("times","B",9,'',false);
			$pdf->Write(9,"TRACKING# $tracking");
			$pdf->SetFont("times","",12,'',false);
		}
		$pdf->SetXY(20,702);
		$pdf->Write(12,"Phone: 616.272.6334  Email: shipping@preferredmachinellc.com Accounts Payable: ap@preferredmachinellc.com");			$pdf->SetXY(20,760);
		$pdf->SetFont("times","",6,'',false);
		$pdf->Write(6,"Printed: $datestamp");
		$pdf->SetFont("times","",12,'',false);
	}
	$pdf->AddPage();
	$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
	$pdf->Image("images/logohd.png",250,10,100,50,'','','',true);
	$pdf->SetFont("times","",50,'',false);
	$w = $pdf->GetStringWidth($shipName);
	$w=$w/2;
	$x = 302 - $w;
	$pdf->SetXY($x,80);
	$pdf->Write(50,$shipName);
	$text="PO# $order";
	$w = $pdf->GetStringWidth($text);
	$w=$w/2;
	$x = 302 - $w;
	$pdf->SetXY($x,130);
	$pdf->Write(50,$text);
	$pdf->SetFont("times","",80,'',false);
	$w = $pdf->GetStringWidth($dueCustomer);
	$w=$w/2;
	$x = 302 - $w;
	$pdf->SetXY($x,180);
	$pdf->Write(80,$dueCustomer);
	$base=260;
	$pdf->SetFont("times","",50,'',false);
	foreach ($colors as $color) {
		$pdf->SetFont("times","",50,'',false);
		$font=50;
		$text=trim($color);
		$w = $pdf->GetStringWidth($text);
		while ($w >500) {
			$font--;
			$pdf->SetFont("times","",$font,'',false);
			$w = $pdf->GetStringWidth($text);
		}
		$w=$w/2;
		$x = 302 - $w;
		$pdf->SetXY($x,$base);
		$pdf->Write(50,$text);
		$base+=50;
	}

}

if ($type=="MT") {
	$copies=1;
	$c=0;
	$isMT=1;
	while ($c < $copies) {
		$c++;
	 	$lc=99;
	 	$lineNumber=0;
	 	$pageNumber=0;
	 	$colors=array();
		$sql="select packing_slip.*,  vendor_name,  packing_slip_lines.order_id, part_number, description, packing_slip_lines.quantity,  orders.po_number, order_lines.po_line, order_lines.line_id, due_date, due_customer, vendors.vendor_id, folder_number, order_lines.material from packing_slip inner join packing_slip_lines on packing_slip_id = packing_list_id  left outer join vendors on packing_slip.vendor_id=vendors.vendor_id  left outer join order_lines on order_lines.line_id=order_line left outer join orders on order_lines.order_id=orders.order_id where packing_slip_id=? order by cast(order_lines.po_line as unsigned), packing_slip_lines.line_id ";
		$packSlip=$_GET['pack'];
		list($rs,$err)=runIQuery($db,$sql,array("i",$packSlip));
		$updated=0;
		$numPages=ceil(count($rs)/25);
		$partFont=12;
		foreach ($rs as $data) {
			$part=strtoupper($data['part_number']);
			$material=$data['material'];
			$sql="select material_name from materials where material_id=?";
			list($mrs,$err)=runIQuery($db,$sql,array("i",$material));
			$materialName="";
			if (count($mrs)>0) {
				$materialName=$mrs[0][0];
			}
			if (strtoupper($materialName) == "NON-LASER") {
				$materialName="";
			}
			if (strtoupper($material) == "OUTSOURCE WELDMENT") {
				$materialName="";
			}
			$description=trim(strtoupper($data['description']));
			$sql="select color_code from order_line_color o, vendor_colors v where order_line=? and o.color_id=v.vc_id";
			list($crs,$err)=runIQuery($db,$sql,array("i",$line));
			$color="";
			if (count($crs)>0) {
				$cdata=$crs[0];
				$color=$cdata['color_code'];
			}
			$test=$part." ".$description." ".$color." ".$materialName;
			$font=12;
			$pdf->SetFont("times","",$font,'',false);
			while ($pdf->GetStringWidth($test) > 300) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			if ($font < $partFont) {
				$partFont=$font;
			}
		}
		reset($rs);
		$ultimate="";
		foreach ($rs as $data) {
			$order=$data['order_id'];
			$line=$data['line_id'];
			$sql="select color_code from order_line_color o, vendor_colors v where order_line=? and o.color_id=v.vc_id";
			list($crs,$err)=runIQuery($db,$sql,array("i",$line));
			$color="";
			if (count($crs)>0) {
				$cdata=$crs[0];
				$color=$cdata['color_code'];
				if (! in_array($color,$colors)) {
					$colors[]=$color;
				}
			}
			$folder=$data['folder_number'];
			if (! $folder) {
				$folder=$order;
			}
			$vendorID=$data['vendor_id'];
			if (! $updated) {
				if ($vendorID) {
					if ($vendorID == 20) {
						## MFT, mark as shipped
						//updateOrderStatus($db,$order,4);
						updateOrderStatus($db,$order,11);
					} else {
						//updateOrderStatus($db,$order,4);
						updateOrderStatus($db,$order,11);
					}
				}
				$updated=1;
			}
			$poLine=$data['po_line'];
			if ($poLine == 0) {
				$poLine="";
			}
			$customer=$data['customer_id'];
			$vendorName=$data['vendor_name'];
			$attention=$data['ship_address'];
			$phone=$data['ship_phone'];
			$email=$data['ship_email'];
			$sql="select * from transfers where packing_slip_id=?";
			list($trs,$err)=runIQuery($db,$sql,array("i",$packSlip));
			$tdata=$trs[0];
			$signedBy=$tdata['signed_by'];
			$vendor=$data['vendor_id'];
			$sql="select * from vendors where vendor_id=?";
			list($vrs,$err)=runIQuery($db,$sql,array("i",$vendor));
			if (count($vrs) > 0) {
				$vdata=$vrs[0];
				$phone="";
				$email="";
				$shipName=$vdata['vendor_name'];
				$shipAddress=$vdata['address'];
				$shipCity=$vdata['city'];
				$shipState=$vdata['state'];
				$shipZip=$vdata['zip'];
			}
			$quantity=$data['quantity'];
			$part=strtoupper($data['part_number']);
			$po=$data['po_number'];
			$due=$data['due_customer'];
			if (! $due or $due == "0000-00-00") {
				$due=$data['due_date'];
			}
			$material=$data['material'];
			$sql="select material_name from materials where material_id=?";
			list($mrs,$err)=runIQuery($db,$sql,array("i",$material));
			$materialName="";
			if (count($mrs)>0) {
				$mdata=$mrs[0];
				$materialName=$mdata[0];
			}
			if (strtoupper($materialName) == "NON-LASER") {
				$materialName="";
			}
			if (strtoupper($material) == "OUTSOURCE WELDMENT") {
				$materialName="";
			}
			$lead=getCustomerLeadTime($db,$id);
			if ($lead > 0) {
				$due=SubtractBusinessDays($due,$lead,$db);
			}
			$dueDate=formatDateDBToWeb($due);
			$dueCustomer=formatDateDBToWeb($due);
			$description=trim(strtoupper($data['description']));
			if (! in_array($description,$colors)) {
				$colors[]=$description;
			}
			#list($due,$time)=explode(" ",formatDateDBToWeb($data['date_shipped']));
			if ($lc > 25) {
				if ($lc < 99) {
					if ($tracking) {
						$pdf->SetXY(306,692);
						$pdf->SetFont("times","B",9,'',false);
						$pdf->Write(9,"TRACKING# $tracking");
						$pdf->SetFont("times","",12,'',false);
					}
					$pdf->SetXY(20,702);
					$pdf->Write(12,"Phone: 616.272.6334  Email: shipping@preferredmachinellc.com Accounts Payable: ap@preferredmachinellc.com");
				}
				$pageNumber++;
				printPACKHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$phone,$folder,$packSlip,$attention,$pdf,$isMT);
				$lc=0;
			}
			$lc++;
			$base=102  + ($lc*20);
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(20,$base);
			if ($quantity > 0) {
				$lineNumber++;
				$pdf->Write(12,$lineNumber);
			}
			$pdf->SetXY(80,$base);
			$pdf->SetFont("times","",$partFont,'',false);
			$pdf->Write(12,$part . " " . $description. " " . $color. " " . $materialName);
			$pdf->SetFont("times","",12,'',false);
			$y = 422 - $pdf->GetStringWidth(number_format($quantity,0));
			$pdf->SetXY($y,$base);
			if ($quantity > 0) {
				$pdf->Write(12,number_format($quantity,0));
			}
			$font=12;
			$pdf->SetFont("times","",$font,'',false);
			while ($pdf->GetStringWidth($po) > 50) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			$pdf->SetXY(460,$base);
			$pdf->Write(12,$po);
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(530,$base);
			$pdf->Write(12,$dueLessShipping);
		}
 		$pdf->SetXY(20,680);
		$sql="select due_customer from orders where order_id=?";
		list($drs,$err)=runIQuery($db,$sql,array("i",$order));
		$ddata=$drs[0];
		$due=$ddata[0];
		$lead=getCustomerLeadTime($db,$id);
		if ($lead > 0) {
			$due=SubtractBusinessDays($due,$lead,$db);
		}
		$dueCustomer=formatDateDBToWeb($due);
		$pdf->Write(12,"Ultimate Destination: $attention $dueCustomer");
		if ($tracking) {
			$pdf->SetXY(306,692);
			$pdf->SetFont("times","B",9,'',false);
			$pdf->Write(9,"TRACKING# $tracking");
			$pdf->SetFont("times","",12,'',false);
		}
		$pdf->SetXY(20,702);
		$pdf->Write(12,"Phone: 616.272.6334  Email: shipping@preferredmachinellc.com Accounts Payable: ap@preferredmachinellc.com");
		$pdf->SetXY(20,713);
		$pdf->SetFont("times","",8,'',false);
		$pdf->Write(8,"By signing this packing slip, you are agreeing that the listed parts and quantities are accurate and acceptable.");
		$pdf->SetXY(20,721);
		$pdf->Write(8,"You will have 30 calendar days from the date below to claim any discrepancies.");
		$pdf->SetXY(180,730);
		$pdf->SetFont("times","",12,'',false);
		if ($signedBy) {
			try { //Added try/catch in the event that the credentials are incorrect -Josh 01/30/2022
				include('s3.php');
				$dateSigned=formatDateDBToWeb($tdata['date_signed']);
				$s3client->registerStreamWrapper();
				$file="signature-PACK$packSlip.png";
				if ($isMT) {
					$file="signature-MT$packSlip.png";
				}
				if (file_exists("s3://$bucket/$file")) {
					$img = file_get_contents("s3://$bucket/$file");
					$pdf->Image("@".$img,410,721,100,40,'','','',true);
				}
				$pdf->Write(12,"Received By: $signedBy  Date: $dateSigned");
			} catch (Exception $err) {
				$pdf->Write(12,"Received By: _____________________________  Date: _____________");
			}
		} else {
			$pdf->Write(12,"Received By: _____________________________  Date: _____________");
		}
		if (isset($_GET['internal'])) {
			$pdf->SetXY(20,742);
			$inotes=$data['notes_to_self'];
			$pdf->Write(12,$inotes);
		}
		$pdf->SetXY(20,760);
		$pdf->SetFont("times","",6,'',false);
		$pdf->Write(6,"Printed: $datestamp");
		$pdf->SetFont("times","",12,'',false);
	}
}



if ($type=="PACK" or $type == "XFER") {
	$copies=2;
	if (isset($_GET['copies'])) {
		$copies=$_GET['copies'];
	}
	$c=0;
	$isMT=0;
	$copies=1;
	$packSlip=$_GET['pack'];
	$sql="select vendor_id from packing_slip where packing_slip_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$packSlip));
	$vendorID=0;
	if (count($rs)>0) {
		$data=$rs[0];
		$vendorID=$data['vendor_id'];
		if ($vendorID) {
			## only need one copy now just printing transfer
			## $copies=2;
		}
	}
	while ($c < $copies) {
		$c++;
	 	$lc=99;
	 	$lineNumber=0;
	 	$pageNumber=0;
	 	$colors=array();
		$sql="select packing_slip.*,  vendor_name,  packing_slip_lines.order_id, part_number, description, packing_slip_lines.quantity,  orders.po_number, orders.folder_number, order_lines.po_line, order_lines.line_id, due_date, due_customer, vendors.vendor_id, folder_number, order_lines.material from packing_slip inner join packing_slip_lines on packing_slip_id = packing_list_id  left outer join vendors on packing_slip.vendor_id=vendors.vendor_id  left outer join order_lines on order_lines.line_id=order_line left outer join orders on order_lines.order_id=orders.order_id where packing_slip_id=? ";
		$sql.=" and part_number not in (select item_name from items where item_category = 16) ";
		$sql.=" order by cast(order_lines.po_line as unsigned), packing_slip_lines.line_id ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$packSlip));
		$updated=0;
		$numPages=ceil(count($rs)/25);
		$partFont=12;
		foreach ($rs as $data) {
			$part=strtoupper($data['part_number']);
			$line=$data['line_id'];
			$material=$data['material'];
			$folder=$data['folder_number'];
			$sql="select material_name from materials where material_id=?";
			list($mrs,$err)=runIQuery($db,$sql,array("i",$material));
			$materialName="";
			if (count($mrs)>0) {
				$materialName=$mrs[0][0];
			}
			if (strtoupper($materialName) == "NON-LASER") {
				$materialName="";
			}
			if (strtoupper($material) == "OUTSOURCE WELDMENT") {
				$materialName="";
			}
			$description=trim(strtoupper($data['description']));
			$sql="select color_code from order_line_color o, vendor_colors v where order_line=? and o.color_id=v.vc_id";
			list($crs,$err)=runIQuery($db,$sql,array("i",$line));
			$color="";
			if (count($crs)>0) {
				$cdata=$crs[0];
				$color=$cdata['color_code'];
			}
			if (strstr(strtoupper($description),strtoupper($color))) {
				$test=$part." ".$description." ".$materialName;
			} else {
				$test=$part." ".$description." ".$color." ".$materialName;
			}
			$font=12;
			$pdf->SetFont("times","",$font,'',false);
			while ($pdf->GetStringWidth($test) > 300) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			if ($font < $partFont) {
				$partFont=$font;
			}
		}
		reset($rs);

		foreach ($rs as $data) {
			$order=$data['order_id'];
			$line=$data['line_id'];
			$tracking=trim($data['tracking_number']);
			$sql="select color_code from order_line_color o, vendor_colors v where order_line=? and o.color_id=v.vc_id";
			list($crs,$err)=runIQuery($db,$sql,array("i",$line));
			$color="";
			if (count($crs)>0) {
				$cdata=$crs[0];
				$color=$cdata['color_code'];
				if (! in_array($color,$colors)) {
					$colors[]=$color;
				}
			}
			$folder=$data['folder_number'];
			if (! $folder) {
				$folder=$order;
			}
			if ($type == "XFER") {
				updateOrderStatus($db,$order,11);
			} else {
				updateOrderStatus($db,$order,4);
			}
			$shipName=$data['ship_name'];
			$poLine=$data['po_line'];
			if ($poLine == 0) {
				$poLine="";
			}
			$material=$data['material'];
			$sql="select material_name from materials where material_id=?";
			list($mrs,$err)=runIQuery($db,$sql,array("i",$material));
			$materialName="";
			if (count($mrs)>0) {
				$materialName=$mrs[0][0];
			}
			if (strtoupper($materialName) == "NON-LASER") {
				$materialName="";
			}
			if (strtoupper($material) == "OURSOURCE WELDMENT") {
				$materialName="";
			}
			$customer=$data['customer_id'];
			$vendorName=$data['vendor_name'];
			$shipAddress=$data['ship_address'];
			$attention=$shipAddress;
			$shipCity=$data['ship_city'];
			$shipState=$data['ship_state'];
			$shipZip=$data['ship_zip'];
			$phone=$data['ship_phone'];
			$email=$data['ship_email'];
			$signedBy=$data['signed_by'];
			## 7/13/22  Add in check for QA Checklist required Brittany, see below for QA Checklist updates, looking for checkbox rather than specific customer
			$sql="SELECT qa_checklist FROM customers WHERE customer_id=?";
			list($qrs,$err)=runIQuery($db,$sql,array("i",$customer));
			foreach ($qrs as $qdata) {
				$qaRequired=$qdata['qa_checklist'];
			}

			if ($vendorID > 0 ) {
				## need to check to see if need to create transfer record
				$sql="select * from transfers where packing_slip_id=?";
				list($trs,$err)=runIQuery($db,$sql,array("i",$packSlip));
				$sql="select vendor_name, address, city, state, zip from vendors where vendor_id=?";
				list($vrs,$err)=runIQuery($db,$sql,array("i",$vendorID));
				$vdata=$vrs[0];
				$vendorName=$vdata['vendor_name'];
				$vendorAddress=$vdata['address'];
				$vendorCity=$vdata['city'];
				$vendorState=$vdata['state'];
				$vendorZip=$vdata['zip'];
				if (count($trs) == 0 ) {
					## need to create the transfer
					## get vendor shipping
					$sql="insert into transfers (vendor_id, packing_slip_id, ship_name, ship_address, ship_city, ship_state, ship_zip, customer_id, date_created, transferred_by) ";
					$sql.=" values (?, ?, ?, ?, ?, ?, ?, ?, now(), ?) ";
					list($trs,$err)=runIQuery($db,$sql,array("iisssssii",$vendorID,$packSlip,$vendorName,$vendorAddress,$vendorCity,$vendorState,$vendorZip,$customer,$userID));
				}
				if ($type == "XFER") {
					$isMT=1;
					$shipName=$vendorName;
					$shipAddress=$vendorAddress;
					$shipCity=$vendorCity;
					$shipState=$vendorState;
					$shipZip=$vendorZip;
					$sql="select * from transfers where packing_slip_id=?";
					list($trs,$err)=runIQuery($db,$sql,array("i",$packSlip));
					$tdata=$trs[0];
					$signedBy=$tdata['signed_by'];
				}
			}
			$quantity=$data['quantity'];
			$part=strtoupper($data['part_number']);
			$po=$data['po_number'];
			$due=$data['due_customer'];
			if (! $due or $due == "0000-00-00") {
				$due=$data['due_date'];
			}
			$dueDate=formatDateDBToWeb($due);
			$dueCustomer=formatDateDBToWeb($due);
			$description=trim(strtoupper($data['description']));
			if (! in_array($description,$colors)) {
				$colors[]=$description;
			}

			//Print QR Code -Josh 02-17-2022
            $sql = "select * from system_settings where name=?";
            list($rs,$err) = runIQuery($db, $sql, array(
                "s",
                "qr_code_until"
            ));

			#list($due,$time)=explode(" ",formatDateDBToWeb($data['date_shipped']));
			if ($lc > 26) {
				if ($lc < 99) {
					if ($tracking) {
						$pdf->SetXY(306,682);
						$pdf->SetFont("times","B",9,'',false);
						$pdf->Write(9,"TRACKING# $tracking");
						$pdf->SetFont("times","",12,'',false);
					}
					$pdf->SetXY(20,690);
					$pdf->Write(12,"Phone: 616.272.6334  Email: shipping@preferredmachinellc.com Accounts Payable: ap@preferredmachinellc.com");
				}
				$pageNumber++;

				//Print QR Code -Josh 01-31-2022
				$sql = "select * from system_settings where name=?";
				list($rs,$err) = runIQuery($db, $sql, array(
					"s",
					"qr_code_until"
				));
                if (date("Y-m-d", strtotime("-1 day")) < date("Y-m-d", strtotime($rs[0]["setting"])) && $type != "XFER") {
                    $style = array(
                        'border' => 1,
                        'vpadding' => 'auto',
                        'hpadding' => 'auto',
                        'fgcolor' => array(0,0,0),
                        'bgcolor' => false, //array(255,255,255)
                        'module_width' => 1, // width of a single module in points
                        'module_height' => 1 // height of a single module in points
                    );

                    $pdf->write2DBarcode('http://survey.preferredmachinellc.com/survey.html?c=' . $customer, 'QRCODE,L', 540, 720, 60, 60, $style, 'N');
                    $pdf->SetXY(520, 703);
                    $pdf->SetFont("times","",10,'',false);
                    $pdf->Write(12,"Free Swag Drawing");
                }

				printPACKHeader($shipName,$shipAddress,$shipCity,$shipState,$shipZip,$phone,$folder,$packSlip,$attention,$pdf,$isMT);
				$lc=0;
			}

			$lc++;
			$base=102  + ($lc*20);
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(20,$base);
			if ($quantity > 0) {
				$lineNumber++;
				$pdf->Write(12,$lineNumber);
			}
			$pdf->SetXY(80,$base);
			if ($isMT) {
				if (strstr(strtoupper($description),strtoupper($color))) {
					$pinfo=$part . " " . $description . " " . $materialName;
				} else {
					$pinfo=$part . " " . $description . " " . $color . " " . $materialName;
				}
			} else {
				if (strstr(strtoupper($description),strtoupper($color))) {
					$pinfo=$part . " " . $description;
				} else {
					$pinfo=$part . " " . $description . " " . $color;
				}
			}
			$pdf->SetFont("times","",$partFont,'',false);
			$pdf->Write($partFont,$pinfo);
			$pdf->SetFont("times","",12,'',false);
			$y = 422 - $pdf->GetStringWidth(number_format($quantity,0));
			$pdf->SetXY($y,$base);
			if ($quantity > 0) {
				$pdf->Write(12,number_format($quantity,0));
			}
			$font=12;
			$pdf->SetFont("times","",$font,'',false);
			while ($pdf->GetStringWidth($po) > 50) {
				$font-=.5;
				$pdf->SetFont("times","",$font,'',false);
			}
			$pdf->SetXY(460,$base);
			$pdf->Write(12,$po);
			$pdf->SetFont("times","",12,'',false);
			$pdf->SetXY(530,$base);
			$dueLessShipping=formatDateDBToWeb(SubtractBusinessDays($due,getCustomerLeadTime($db,$order),$db));
			if ($isMT) {
				$pdf->Write(12,$dueLessShipping);
			} else {
				if ($customer == 715) {
					$checkpart=str_replace("-","%",$part);
					$sql="select po_line from edi_orders eo, edi_order_lines eol where po_number=? and eo.order_id=eol.order_id and item_id like ? ";
					list($ers,$err)=runIQuery($db,$sql,array("ss",$po, $checkpart));
					$foundedi=0;
					foreach ($ers as $edata) {
						$poLine=$edata['po_line'];
						$foundedi=1;
					}
					if (! $foundedi) {
						if ($poLine > 9) {
							$poLine=$poLine/10;
							$poLine=substr("000" .$poLine,-4);
						}
					}
				}
				$font=12;
				$pdf->SetFont("times","",$font,'',false);
				while ($pdf->GetStringWidth($poLine) > 50) {
					$font-=.5;
					$pdf->SetFont("times","",$font,'',false);
				}
				$pdf->Write(12,$poLine);
				$pdf->SetFont("times","",12,'',false);
			}

			//Item lines -Josh 02-16-2022
			$pdf->Line(18,$base+15,600,$base+15, array('width' => 0.1));
            $pdf->SetLineWidth(1);
		}
		if ($type == "XFER") {
			## this is if it is a material transfer
	 		$pdf->SetXY(20,670);
			$sql="select due_customer from orders where order_id=?";
			list($drs,$err)=runIQuery($db,$sql,array("i",$order));
			$ddata=$drs[0];
			$due=$ddata['due_customer'];
			$lead=getCustomerLeadTime($db,$order);
			if ($lead)  {
				$due=SubtractBusinessDays($due,$lead,$db);
			}
			$dueCustomer=formatDateDBToWeb($due);

			##Brittany updates 7/28/22 using checkbox from vendors table to determine if customer info can be seen by vendor
			$packSlip=0;
			$canSeeCustomerInfo=0;
			if (isset($_GET['pack'])) {
			$packSlip=$_GET['pack'];
			}
			$vsql="select vendor_id from packing_slip where packing_slip_id=?";
			list($vrs,$err)=runIQuery($db,$vsql,array("i",$packSlip));
			$vendorID=0;
			if (count($vrs)>0) {
				$data=$vrs[0];
				$vendorID=$data['vendor_id'];
			}
			$cssql="SELECT can_see_customer_name FROM vendors WHERE vendor_id=?";
			list($csrs,$err)=runIQuery($db,$cssql,array("i",$vendorID));
			if ($csrs[0][0]==1) {
				$canSeeCustomerInfo=1;
			}
			if ($canSeeCustomerInfo) {
				$pdf->Write(12,"Ultimate Destination: $attention $dueCustomer");
			}

		} else {
	 		$pdf->SetXY(20,670);
			$pdf->SetFont("times","B",12,'',false);
			$notes=$data['notes_to_customer'];
			$notes=str_replace("\r"," ",$notes);
			$notes=str_replace("\n"," ",$notes);
			$pdf->Write(12,$notes);
			$pdf->SetFont("times","",12,'',false);
		}
		if ($tracking) {
			$pdf->SetXY(306,680);
			$pdf->SetFont("times","B",9,'',false);
			$pdf->Write(9,"TRACKING# $tracking");
			$pdf->SetFont("times","",12,'',false);
		}

		//Print QR Code -Josh 01-31-2022
		$sql = "select * from system_settings where name=?";
		list($rs,$err) = runIQuery($db, $sql, array(
			"s",
			"qr_code_until"
		));
		if (date("Y-m-d", strtotime("-1 day")) < date("Y-m-d", strtotime($rs[0]["setting"])) && $type != "XFER") {
            $style = array(
                'border' => 1,
                'vpadding' => 'auto',
                'hpadding' => 'auto',
                'fgcolor' => array(0,0,0),
                'bgcolor' => false, //array(255,255,255)
                'module_width' => 1, // width of a single module in points
                'module_height' => 1 // height of a single module in points
            );

            $pdf->write2DBarcode('http://survey.preferredmachinellc.com/survey.html?c=' . $customer, 'QRCODE,L', 540, 720, 60, 60, $style, 'N');
            $pdf->SetXY(520, 703);
            $pdf->SetFont("times","",10,'',false);
            $pdf->Write(12,"Free Swag Drawing");
        }

		$pdf->SetXY(20,690);
		$pdf->Write(12,"Phone: 616.272.6334  Email: shipping@preferredmachinellc.com Accounts Payable: ap@preferredmachinellc.com");
		$pdf->SetXY(20,700);
		$pdf->SetFont("times","",8,'',false);
		$pdf->Write(8,"By signing this packing slip, you are agreeing that the listed parts and quantities are accurate and acceptable.");
		$pdf->SetXY(20,710);
		$pdf->Write(8,"You will have 30 calendar days from the date below to claim any discrepancies.");
		$pdf->SetXY(180,725);
		$pdf->SetFont("times","",12,'',false);
		if ($signedBy) {
			try { //Added try/catch in the event that the credentials are incorrect -Josh 01/30/2022
				include('s3.php');
				$dateSigned=formatDateDBToWeb($data['date_signed']);
				if ($isMT) {
					$dateSigned=formatDateDBToWeb($tdata['date_signed']);
				}
				$s3client->registerStreamWrapper();
				$file="signature-PACK$packSlip.png";
				if ($isMT) {
					$file="signature-MT$packSlip.png";
				}
				if (file_exists("s3://$bucket/$file")) {
					$img = file_get_contents("s3://$bucket/$file");
					$pdf->Image("@".$img,410,721,100,40,'','','',true);
				}
				$pdf->Write(12,"Received By: $signedBy  Date: $dateSigned");
			} catch (Exception $err) {
				$pdf->Write(12,"Received By: _____________________________  Date: _____________");
			}
		} else {
			$pdf->Write(12,"Received By: _____________________________  Date: _____________");
		}
		if (isset($_GET['internal'])) {
			$pdf->SetXY(20,742);
			$inotes=$data['notes_to_self'];
			$pdf->Write(12,$inotes);
		}
		$pdf->SetXY(20,760);
		$pdf->SetFont("times","",6,'',false);
		$pdf->Write(6,"Printed: $datestamp");
		$pdf->SetXY(20,768);
		$pdf->SetFont("times","",8,'',false);
		$pdf->Write(8,"In order to control delivery costs, Preferred Machine asks that you return skids and pallets.  Please work with Preferred Delivery Service drivers,");
		$pdf->SetXY(20,777);
		$pdf->SetFont("times","",8,'',false);
		$pdf->Write(8,"or contact Preferred Delivery Service at corey@preferreddeliveries.com to arrange for pick up.");

		##changing Vendor Quality Assurance Checklist to look for qa_checklist boolean rather than customer id Brittany 7/14/22
		if ($type == "PACK" and $qaRequired) {
			## print the AMS Vendor Quality Assurance Checklist
			$sql="select  o.po_number, o.order_id, folder_number from packing_slip_lines l, orders o where packing_list_id=? and l.order_id=o.order_id LIMIT 1";
			list($rs,$err)=runIQuery($db,$sql,array("i",$packSlip));
			$data=$rs[0];
			$po=$data['po_number'];
			$so=$data['order_id'];
			$folder=$data['folder_number'];
			$sql="select salesperson_id, DATE(date_order) from orders where order_id=?  ";
			list($rs,$err)=runIQuery($db,$sql,array("i",$so));
			$data=$rs[0];
			$salesPerson=$data['salesperson_id'];
			$salesDate=formatDateDBToWeb($data[1]);
			$sql="select employee_id, DATE(result_date) from production_results pr where operation_id=35 and pr.job_id=?  order by result_date DESC";
			list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
			$laser=$rs[0]['employee_id'];
			if ($laser ==0) {
				$laser=99;
			}
			$laserDate=formatDateDBToWeb($rs[0][1]);
			$sql="select employee_id, DATE(result_date) from production_results pr where operation_id=41 and pr.job_id=?  order by result_date DESC";
			list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
			if (count($rs)>0) {
				$bend=$rs[0]['employee_id'];
				$bendDate=formatDateDBToWeb($rs[0][1]);
			} else {
				$bend="NA";
				$bendDate="";
			}
			$sql="select employee_id, DATE(result_date) from production_results pr where operation_id in (2,62) and pr.job_id=?  order by result_date DESC";
			list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
			if (count($rs)>0) {
				$weld=$rs[0]['employee_id'];
				$weldDate=formatDateDBToWeb($rs[0][1]);
			} else {
				$weld=$bend;
				$weldDate=$bendDate;
				if ($weld == "NA") {
					$weld=$laser;
					$weldDate=$laserDate;
				}
			}
			$sql="select user_id, DATE(date_loaded) from staging_bay_history  where folder_number=? and action='CLEAR' order by date_loaded DESC ";
			list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
			if (count($rs)>0) {
				$staging=$rs[0][0];
				$stagingDate=formatDateDBToWeb($rs[0][1]);
			} else {
				$sql="select shipped_by, DATE(p.date_shipped) from orders o, packing_slip_lines l, packing_slip p where o.folder_number=? and o.order_id=l.order_id and packing_list_id=packing_slip_id order by p.date_shipped desc";
				list($rs,$err)=runIQuery($db,$sql,array("s",$folder));
				$staging=$rs[0][0];
				$stagingDate=formatDateDBToWeb($rs[0][1]);
				$staging="Shipping"; ## shipping
			}
			$pdf->AddPage();
			$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
			$pdf->Image("images/logohd.png",200,10,100,50,'','','',true);
			$pdf->SetFont("times","I",8,'',false);
			$pdf->SetXY(530,10);
			$pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());
			$pdf->SetFont("times","",24,'',false);
			$x = 306 - ($pdf->GetStringWidth("Vendor Quality Assurance Checklist")/2);
			$pdf->SetXY($x,70);
			$pdf->Write(24,"Vendor Quality Assurance Checklist");
			$pdf->SetFont("times","",14,'',false);
			$pdf->SetXY(20,125);
			$pdf->Write(16,"Purchase Order # $po");
			$dt=Date("m/d/Y");
			$pdf->SetXY(306,125);
			$pdf->Write(16,"Date: $dt");
			$pdf->SetXY(20,150);
			$pdf->Write(16,"1. Are all part quantities correct according to order request/BOM?");
			$pdf->SetXY(35,166);
			$pdf->Write(16,"YES - Checked by: $salesPerson on $salesDate");
			$pdf->SetXY(20,206);
			$pdf->Write(16,"2. Does the material match for each part according to the print/BOM?");
			$pdf->SetXY(35,222);
			$pdf->Write(16,"YES - Checked by: $laser on $laserDate");
			$pdf->SetXY(20,262);
			$pdf->Write(16,"3. Do shown/opposite quantities and bend/form directions match specifications on the prints?");
			$pdf->SetXY(35,278);
			if ($bend == "NA") {
				$pdf->Write(16,"Operation Bend was not specified on this Purchase Order");
			} else {
				$pdf->Write(16,"YES - Checked by: $bend on $bendDate");
			}
			$pdf->SetXY(20,318);
			$pdf->Write(16,"4. Are all dimensions and specifications correct according to the prints?");
			$pdf->SetXY(35,334);
			$pdf->Write(16,"YES - Checked by $weld on $weldDate");
			$pdf->SetXY(20,374);
			$pdf->Write(16,"5. Do all parts match prints and purchase order?");
			$pdf->SetXY(35,390);
			$pdf->Write(16,"YES - Checked by: $staging on $stagingDate");
		}
	}

}
$fname=$type . $id . ".pdf";
$pdf->Output($fname, "I");
