<?php
session_start();
#error_reporting(E_ALL);
#ini_set('display_errors','1');
date_default_timezone_set("America/Detroit");
$id=$_GET['id'];
include('dbConnection.php');
include('functions.php');
include('security.php');
$id=$_GET['id'];
$type=$_GET['type'];


function multiLine($string,$max) {
	$lines=array();
	$words=explode(" ",$string);
	$widx=0;
	$string="";
	while ($widx < count($words)) {
		$retstring="";
		$tooLong=0;
		while ($widx < count($words) and $tooLong==0 ) {
			if ($retstring) {
				$retstring.=" ";
			}						
			$oldstring=$retstring;
			$retstring.=$words[$widx];
			if (strlen($words[$widx])>$max) {
				$retstring=substr($words[$widx],0,$max);
				$words[$widx]=substr($words[$widx],$max);
				$tooLong=1;
			} else {
				if ( strlen($retstring)>$max) {
					$retstring=$oldstring;
					$tooLong=1;
				} else {
					$widx++;
				}
			}
		}
		if (trim($retstring)) {
			$lines[]=$retstring;
		}
	}	
	$string=implode("\r\n",$lines);
	$numberLines=count($lines);
	return array($numberLines,$string);
}


?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->
<!--[if !IE]><!--> <html lang="en" > <!--<![endif]-->
<head>
	<meta charset="utf-8">
	<title>Render PDF</title>
</head>
<body>
<?php
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
#include('tcpdi.php');


$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);
#$pdf->setFontSubsetting(false);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

function printWOHeader($db,$id,$pdf,$routing) {
	$sql="select jobs.*, drawing, revision, length, width from jobs, items where job_id=? and jobs.item_id=items.item_name";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$part=$data['item_id'];
	$line=$data['line_id'];
	$sequence=$data['sequence'];
	$datedue=formatDateDBToWeb($data['start_date']);
	$endDate=$datedue;
	$description=$data['description'];
	list($nbrLines,$text)=multiLine($description,80);
	$quantity=$data['quantity_scheduled'];
	$drawing=$data['drawing'];
	$revision=$data['revision'];
	$length=$data['length'];
	$width=$data['width'];
	$customer_id=$data['customer_id'];
	$sql="select name from customers where customer_id=?";
	list($crs,$err)=runIQuery($db,$sql,array("i",$customer_id));
	$cdata=$crs[0];
	$customer=$cdata[0];
	$sql="select order_id from order_lines where line_id=?";
	list($crs,$err)=runIQuery($db,$sql,array("i",$line));
	$cdata=$crs[0];
	$orderNumber=$cdata[0];
	
	$opid=$routing['operation_id'];
	$routingID=$routing['routing_id'];
	$sql="select schedule_date from schedule, schedule_items where (routing_id=? or (coalesce(routing_id,0) =0 and operation_id=?)) and schedule.schedule_id=schedule_items.schedule_id and job_id=?";
	list($drs,$err)=runIQuery($db,$sql,array("iii",$routingID,$opid,$id));
	$datedue=formatDateDBToWeb($data['start_date']);
	if (count($drs)>0) {
		$ddata=$drs[0];
		if (formatDateDBToWeb($ddata['schedule_date'])) {
			$datedue=formatDateDBToWeb($ddata['schedule_date']);
		}
	}	
	$routingID=$routing['routing_id'];
	$opid=$routing['operation_id'];		
	$sql="select po_number, ship_state from jobs, order_lines, orders where job_id=? and jobs.line_id=order_lines.line_id and order_lines.order_id = orders.order_id ";
	list($prs,$err)=runIQuery($db,$sql,array("i",$id));
	$polist="";
	$comma="";
	$shipState="";
	$style = array(
		'position' => '',
		'align' => 'C',
		'stretch' => false,
		'fitwidth' => true,
		'cellfitalign' => '',
		'border' => false,
		'hpadding' => 'auto',
		'vpadding' => 'auto',
		'fgcolor' => array(0,0,0),
		'bgcolor' => false, //array(255,255,255),
		'text' => true,
		'font' => 'helvetica',
		'fontsize' => 6,
		'stretchtext' => 4
	);

	foreach ($prs as $data) {			
		$polist.=$comma;
		$polist.= $data['po_number'];
		$shipState=$data['ship_state'];
		$comma=", ";
	}
		$mname=$routing['machine_name'];
		$mname=$routing['machine_name'];
		$opname=$routing['operation_name'];
		$wname=$routing['workcenter_name'];
		$pph=$routing['pph'];
		$units=$routing['units'];

		$pdf->AddPage();
		$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
		$pdf->Image("images/logoblack.png",1,1,150, 60,'','','',true);
		$pdf->SetFont("times","",8,'',false);
		$pdf->SetXY(300,10);
		$pdf->Write(8,"Printed " . Date("l, m/d/Y h:i:s"));
		// rectangle		
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(20,50);
		$pdf->Write(12,"PW#");		
		$pdf->SetXY(80,50);
		$pdf->Write(12,"SO#");
		$pdf->SetXY(140,50);
		$pdf->Write(12,"PO#");
		$pdf->SetXY(230,50);
		$pdf->Write(12,"QTY");
		$pdf->SetXY(290,50);
		$pdf->Write(12,"WC");
		$pdf->SetXY(370,50);
		$pdf->Write(12,"STS");
		$pdf->SetXY(20,65);
		$pdf->Write(12,$id);		
		$pdf->SetXY(80,65);
        $pdf->Write(12,$orderNumber);
		$pdf->SetXY(140,65);
		$pdf->Write(12,$polist);
		$pdf->SetXY(230,65);
		$pdf->Write(12,$quantity);
		$pdf->SetFont("times","",11,'',false);
		$pdf->SetXY(290,65);
		$pdf->Write(12,$wname);
		$pdf->SetFont("times","",12,'',false);
		$pdf->SetXY(370,65);
		$pdf->Write(12,$shipState);
		$pdf->SetXY(20,80);
        $pdf->Write(12,"SO: ");
		$pdf->SetXY(40,80);
        $pdf->write1DBarcode("S".$orderNumber, 'C39', '', '', '', 42, 0.8, $style, 'N');
		$pdf->SetXY(20,120);
		$pdf->Write(12,"PART: " . $part);
		$pdf->SetXY(300,120);
		$pdf->Write(12,"DUE: " . $endDate);
		$pdf->SetXY(20,135);
		$text=str_replace("\r"," ",$text);
		$text=str_replace("\n"," ",$text);
		$font=12;
		while ($pdf->GetStringWidth($text)>370 and $font > 4) {
			$font-=.5;
			$pdf->SetFont("times","",$font,'',false);
		}
		$pdf->Write(12,$text);				
		// sideways end date
		$pdf->SetFont("times","",10,'',false);
		$pdf->StartTransform();
		$pdf->Rotate(90,580,120);
		$pdf->Text(420,110,$endDate);
		$pdf->StopTransform();

		$pdf->SetFont("times","",16,'',false);

		// operation dependent information		
		
		$operationSequence=$routing['display_sequence'];
		
		$pdf->SetXY(160,12);
		$pdf->write1DBarcode($id."-".$operationSequence, 'C39', '', '', '', 42, 0.8, $style, 'N');
		$pdf->SetFont("times","",16,'',false);

		$pdf->SetFont("times","B",16,'',false);
}


if ($type=='WO') {	
	$idlist=$id;
	$laser=0;
	if (isset($_GET['laser'])) {
		$laser=$_GET['laser'];
	}
	$pageSize=array();
	$pdf = new TCPDF("L","pt",array(432,288));	
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);
	#$pdf->setFontSubsetting(false);
	$pdf->SetLeftMargin(.10);
	$pdf->SetRightMargin(.10);
	$pdf->SetTextColor(0,0,0,100); ## 100% black
	$pdf->SetDrawColor(0,0,0,100);
	$pdf->SetLineWidth(1);
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	$ids=array();
	$ids=explode(",",$idlist);
	if (isset($_GET['copies'])) {
		$copies=$_GET['copies'];
	} else {
		$copies=1;
	}
	$c=1;
	while ($c <= $copies) {
		$c++;
		foreach ($ids as $id) {
			$sql="select jobs.*, drawing, revision, length, width from jobs, items where job_id=? and jobs.item_id=items.item_name";
			list($rs,$err)=runIQuery($db,$sql,array("i",$id));
			print "<hr>";
			print renderQuery($sql,array("i",$id));
			$data=$rs[0];
			$part=$data['item_id'];
			$sequence=$data['sequence'];
			$datedue=formatDateDBToWeb($data['start_date']);
			$description=$data['description'];
			$description=str_replace("\r","",$description);
			$description=str_replace("\n","",$description);
			$description=str_replace("<br>"," ",$description);
			$description=str_replace("<BR>"," ",$description);
			$description=str_replace("<br />"," ",$description);
			$description=str_replace("<BR />"," ",$description);
			$description=strip_tags($description);
			$quantity=$data['quantity_scheduled'];
			$drawing=$data['drawing'];
			$revision=$data['revision'];
			$length=$data['length'];
			$width=$data['width'];
			$customer_id=$data['customer_id'];
			$sql="select name from customers where customer_id=?";
			list($crs,$err)=runIQuery($db,$sql,array("i",$customer_id));
			$cdata=$crs[0];
			$customer=$cdata[0];
			$sql="select operations.operation_id, operation_name, machine_name, workcenter_name, pph, units, routing.routing_id, routing.display_sequence, notes from jobs left outer join routing on routing.parent_part=jobs.item_id left outer join operations on routing.operation_id=operations.operation_id left outer join machines on routing.machine_id=machines.machine_id left outer join workcenters on routing.workcenter_id=workcenters.workcenter_id left outer join routing_text on routing.routing_id=routing_text.routing_id where  jobs.job_id=? ";
			if ($laser) {
				## only not laser
				$sql="select operations.operation_id, operation_name, machine_name, workcenter_name, pph, units, routing.routing_id, routing.display_sequence, notes from jobs left outer join routing on routing.parent_part=concat(jobs.item_id,'-LASER') left outer join operations on routing.operation_id=operations.operation_id left outer join machines on routing.machine_id=machines.machine_id left outer join workcenters on routing.workcenter_id=workcenters.workcenter_id left outer join routing_text on routing.routing_id=routing_text.routing_id where  jobs.job_id=? ";
				$rsql="select count(*) from jobs left outer join routing on routing.parent_part=concat(jobs.item_id,'-LASER') where jobs.job_id=?";
				list($rrs,$err)=runIQuery($db,$rsql,array("i",$id));
				$routingcount=$rrs[0][0];
				if ($routingcount > 1) {
					$sql.=" and routing.operation_id != 3123 ";
				}
			}
			$sql.=" order by routing.display_sequence ";
			list($ors,$err)=runIQuery($db,$sql,array("i",$id));
			$numPages=count($ors);
			$needHeader = 1;
			$base=10;
			foreach ($ors as $routing) {
				// header job info		
				$routingID=$routing['routing_id'];
				$opid=$routing['operation_id'];
				$operationSequence=$routing['display_sequence'];
				$notes=$routing['notes'];
				$notes=str_replace("&nbsp;"," ",$notes);
				$notes=str_replace("<br>"," ",$notes);
				$notes=str_replace("<br />"," ",$notes);
				$notes=str_replace("<BR>"," ",$notes);
				$notes=str_replace("<BR />"," ",$notes);
				$notes=strip_tags($notes);
				$notes=trim($notes);
				print "notes is $notes<br>";
				printWOHeader($db,$id,$pdf,$routing);
				$start=148;
				$sql="select * from billofmaterial where parent_item=? and routing_id=? ";
				if ($operationSequence==10) {
					$sql="select * from billofmaterial where parent_item=? and (routing_id=? or routing_id=0)  ";
				}
				$sql.=" order by child_item ";
				if ($laser) {
					list($liners,$err)=runIQuery($db,$sql,array("si","$part-LASER",$routingID));
				} else {
					list($liners,$err)=runIQuery($db,$sql,array("si",$part,$routingID));
				}
				$pdf->SetFont("times","N",8,'',false);
				if (count($liners)>0 ) {
					#$pdf->Line(10,$start+15,420,$start+15);
					$pdf->SetXY(22,$start);
					$pdf->Write(16,"Qty Per");
					$pdf->SetXY(64,$start);
					$pdf->Write(16,"Qty");
					$pdf->SetXY(92,$start);
					$pdf->Write(16,"Component");
					$pdf->SetXY(192,$start);
					$pdf->Write(16,"Description");
				}
				$pdf->SetLineWidth(.5);
				$newbase=$start;
				foreach ($liners as $linedata) {			
					$newbase+=12;
					$childItem=$linedata['child_item'];
					$qtyper=$linedata['quantity_per'];
					$childInfo=getItemData($db,$childItem);
					$cdesc=$childInfo['item_description'];
					$tq=$quantity * $qtyper;
					$dwg=$childInfo['drawing'];
					$length=$childInfo['length'];
					if ($length == '0.0000') {
						$length="";
					}
					$pdf->SetXY(22,$newbase);
					$pdf->Write(12,$qtyper);
					$pdf->SetXY(64,$newbase);
					$pdf->Write(12,$tq);
					$pdf->SetXY(92,$newbase);
					$pdf->Write(12,$childItem);
					$pdf->SetXY(192,$newbase);
					$pdf->Write(12,$cdesc);
					$pdf->Line(10,$newbase,420,$newbase);
				}
				$pdf->SetLineWidth(.5);
				$pdf->Line(62,$start,62,$newbase);
				$pdf->Line(90,$start,90,$newbase);
				$pdf->Line(190,$start,190,$newbase);
				$newbase+=12;
				$pdf->SetXY(22,$newbase);
				$pdf->Write(12,$notes);
			}
		}
	}
}

if ($type=='TOTE') {	
	$pageSize=array();
	$pdf = new TCPDF("L","pt",array(432,288));	
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);
	#$pdf->setFontSubsetting(false);
	$pdf->SetLeftMargin(.10);
	$pdf->SetRightMargin(.10);
	$pdf->SetTextColor(0,0,0,100); ## 100% black
	$pdf->SetDrawColor(0,0,0,100);
	$pdf->SetLineWidth(1);
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	$fname="files/" . $id;
	$labelText="";
	if (file_exists($fname)) {
		$labelText=file_get_contents($fname);
		unlink($fname);	
	}
	$id="LABEL";
	$due=formatDateDBToWeb(AddBusinessDays(Date("Y-m-d"),5));
	foreach (explode("\n",$labelText) as $record) {
		if (trim($record) <> "") {
			$fields=explode(",",$record);
			if ($fields[0] != "poNumber") {
				$po=$fields[0];
				$so=$fields[1];
				$color=$fields[2];
				$part=$fields[3];
				$qty=$fields[4];
				$description=$fields[5];
				$pdf->AddPage();
				$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
				$pdf->Image("images/logoblack.png",1,1,150, 60,'','','',true);
				$pdf->SetFont("times","",8,'',false);
				$pdf->SetXY(300,10);
				$pdf->Write(8,"Printed " . Date("l, m/d/Y h:i:s"));
				$pdf->SetFont("times","",12,'',false);
				$pdf->SetXY(20,80);
				$pdf->Write(12,"PO# $po");		
				$pdf->SetXY(20,100);
				$pdf->Write(12,"SO# $so");
				$pdf->SetXY(20,120);
				$pdf->Write(12,"COLOR: $color");
				$pdf->SetXY(20,140);
				$pdf->Write(12,"PART# $part");
				$pdf->SetXY(20,160);
				$pdf->Write(12,$description);
				$pdf->SetXY(20,180);
				$pdf->Write(12,"QUANTITY: $qty");			
				$pdf->SetFont("times","B",38,'',false);
				$pdf->SetXY(20,200);
				$pdf->Write(20,"DUE DATE: $due");
			}
		}
	}
}


if ($type == "SHIP") {
	$pdf = new TCPDF("P","pt",array(288,432));
	$pdf->SetAutoPageBreak(false, 0);
	$pdf->setCellPaddings(0,0,0,0);
	$pdf->SetLeftMargin(.1);
	$pdf->SetRightMargin(.1);
	$sql="select po_number, customer_id, ship_name, ship_address, ship_city, ship_state, ship_zip,   l.* from orders o, order_lines l where line_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];
	$customerID=$data['customer_id'];
	$due=$data['due_date'];
	$dateDue=formatDateDBToWeb($due);
	$po=$data['po_number'];
	$folder=$data['order_id'];
	$shipName=$data['ship_name'];
	$address=$data['ship_address'];
	$city=$data['ship_city'];
	$state=$data['ship_state'];
	$zip=$data['ship_zip'];
	$packslip=$data['order_id'];
	$customer=$shipName;
	$qty=$_GET['qty'];
	if (! $qty) {
		$qty=1;
	}
	$style = array(
	'position' => '',
	'align' => 'C',
	'stretch' => false,
	'fitwidth' => true,
	'cellfitalign' => '',
	'border' => false,
	'hpadding' => 'auto',
	'vpadding' => 'auto',
	'fgcolor' => array(0,0,0),
	'bgcolor' => false, //array(255,255,255),
	'text' => true,
	'font' => 'helvetica',
	'fontsize' => 6,
	'stretchtext' => 4
	);
	$sql="delete from skids where packing_slip_id=? and skid_type='PACK' ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$packslip));
	$copies=1;
	if (isset($_GET['copies'])) {
		$copies=$_GET['copies'];
	}
	$c=0;
	while ($c < $copies) {
		$c++;
		$i=0;
		while ($i < $qty) {
			$i++;
			$pdf->AddPage();
			$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
			$font=20;
			$pdf->SetFont("times","B",20,'',false);
			$dt="Due: " . $dateDue;
			$pdf->SetFont("times","",$font,'',false);
			$pdf->SetXY(20,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,$customer);
			$pdf->StopTransform();
			$pdf->SetXY(20+$font+4,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,$address);
			$pdf->StopTransform();
			$pdf->SetXY(20+($font*2)+6,420);
			$pdf->SetFont("times","",20,'',false);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$csz="$city, $state $zip";
			$pdf->Write($font,$csz);
			$pdf->StopTransform();
			$pdf->SetFont("times","",$font,'',false);
			$pdf->SetXY(20+($font*3)+8,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->SetFont("times","",20,'',false);
			$pdf->Write($font,"PO: " . $po);
			$pdf->StopTransform();
			$pdf->SetXY(20+($font*4)+10,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write($font,"SO: $id");
			$pdf->StopTransform();
			$pdf->SetXY(20+($font*5)+12,420);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->Write(20,$dt);
			$pdf->StopTransform();
			$pdf->SetXY(240,120);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$pdf->SetFont("times","",15,'',false);
			$pdf->Write(12,"PreferredMachinellc.com");
			$pdf->StopTransform();
			$pdf->SetXY(100,220);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$code=$po . "-" . $i;
			$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
			$pdf->StopTransform();
			$pdf->SetXY(200,120);
			$pdf->StartTransform();
			$pdf->Rotate(90);
			$code=$packslip . "-" . $i;
			$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
			$pdf->StopTransform();
			if ($c == 1) {
				$sql="insert into skids (packing_slip_id, skid_number, weight, scanned, skid_type) values (?, ?, 0, '0000-00-00','PACK')";
				list($rs,$err)=runIQuery($db,$sql,array("ii",$packslip,$i));
			}
		}
	}
}

	if ($type == "RACK") {
		$pdf = new TCPDF("P","pt",array(288,432));
		$pdf->SetAutoPageBreak(false, 0);
		$pdf->setCellPaddings(0,0,0,0);
		$pdf->SetLeftMargin(.1);
		$pdf->SetRightMargin(.1);
		$sql="select po_number, customer_id, ship_name, ship_address, ship_city, ship_state, ship_zip,   l.order_id, due_date, l.item_id, c.quantity from rack_contents c, order_lines l, orders o where content_id=? and c.order_line=l.line_id and l.order_id=o.order_id ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$data=$rs[0];
		$customerID=$data['customer_id'];
		$due=$data['due_date'];
		$dateDue=formatDateDBToWeb($due);
		$po=$data['po_number'];
		$folder=$data['order_id'];
		$shipName=$data['ship_name'];
		$address=$data['ship_address'];
		$city=$data['ship_city'];
		$state=$data['ship_state'];
		$zip=$data['ship_zip'];
		$packslip=$data['order_id'];
		$item=$data['item_id'];
		$customer=$shipName;
		$qty=$_GET['qty'];
		$copies=$_GET['copies'];
		if (! $qty) {
			$qty=1;
		}
		$contentQuantity=$data['quantity'];
		$style = array(
		'position' => '',
		'align' => 'C',
		'stretch' => false,
		'fitwidth' => true,
		'cellfitalign' => '',
		'border' => false,
		'hpadding' => 'auto',
		'vpadding' => 'auto',
		'fgcolor' => array(0,0,0),
		'bgcolor' => false, //array(255,255,255),
		'text' => true,
		'font' => 'helvetica',
		'fontsize' => 6,
		'stretchtext' => 4
		);
		$c=0;
		while ($c < $copies) {
			$c++;
			$i=0;
			while ($i < $qty) {
				$i++;
				$pdf->AddPage();
				$pdf->Image("logoblank.jpg",0,0,432,288,'','','',true);
				$font=20;
				$pdf->SetFont("times","B",20,'',false);
				$dt="Due: " . $dateDue;
				$pdf->SetFont("times","",$font,'',false);
				$pdf->SetXY(20,420);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$pdf->Write($font,$customer);
				$pdf->StopTransform();
				$pdf->SetXY(20+$font+4,420);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$pdf->Write($font,$address);
				$pdf->StopTransform();
				$pdf->SetXY(20+($font*2)+6,420);
				$pdf->SetFont("times","",20,'',false);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$csz="$city, $state $zip";
				$pdf->Write($font,$csz);
				$pdf->StopTransform();
				$pdf->SetFont("times","",$font,'',false);
				$pdf->SetXY(20+($font*3)+8,420);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$pdf->SetFont("times","",20,'',false);
				$pdf->Write($font,"PO: " . $po);
				$pdf->StopTransform();
				$pdf->SetXY(20+($font*4)+10,420);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$pdf->Write($font,"SO: $folder");
				$pdf->StopTransform();
				$pdf->SetXY(20+($font*5)+12,420);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$pdf->Write(20,$dt);
				$pdf->StopTransform();
				$pdf->SetXY(240,120);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$pdf->SetFont("times","",15,'',false);
				$pdf->Write(12,"PreferredMachinellc.com");
				$pdf->StopTransform();
				$pdf->SetXY(100,220);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$code=$po . "-" . $i;
				$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
				$pdf->StopTransform();
				$pdf->SetXY(200,120);
				$pdf->StartTransform();
				$pdf->Rotate(90);
				$code=$packslip . "-" . $i;
				$pdf->write1DBarcode($code, 'C128', 150, '', '', 36, 20, $style, 'N');
				$pdf->StopTransform();
			}
		}
	}

$fname="/home/prefwelderp/public_html/documents/".$type.$id.".pdf";	
if (file_exists($fname)) {
	unlink($fname);
}
$pdf->Output($fname, "F");



print "\n<script>try { window.opener.close();} catch (err) {} document.location.href='/documents/$type$id.pdf?rand='+Math.random();</script>\n";
?>
</body></html>