<?php


#error_reporting(E_ERROR);

#ini_set('display_errors','on');

date_default_timezone_set("America/Detroit");

include('dbConnection.php');
## session start is now in dbconnection.php

include('functions.php');

include('security.php');

$start_date=$_GET['start_date'];

if (! $start_date) {

	if ($_SESSION['start_date']) {

		$start_date=$_SESSION['start_date'];

	} else {

		$start_date=Date("m/d/Y");

	}

} else {

	$_SESSION['start_date']=$start_date;

}

$end_date=$_GET['end_date'];

if (! $end_date) {

	if ($_SESSION['end_date']) {

		$end_date=$_SESSION['end_date'];

	} else {

		$end_date=Date("m/d/Y");

	}

} else {

	$_SESSION['end_date']=$end_date;

}

$searchpart=$_GET['part'];

$customer=$_GET['customer'];

$customerName="";

if ($customer) {

	$sql="select name from customers where customer_id=?";

	list($crs,$err)=runIQuery($db,$sql,array("i",$customer));

	$cdata=$crs[0];

	$customerName=$cdata[0];



}



function multiLine($string,$max) {

	$lines=array();

	$words=explode(" ",$string);

	$widx=0;

	$string="";

	while ($widx < count($words)) {

		$retstring="";

		$tooLong=0;

		while ($widx < count($words) and $tooLong==0 ) {

			if ($retstring) {

				$retstring.=" ";

			}

			$oldstring=$retstring;

			$retstring.=$words[$widx];

			if (strlen($words[$widx])>$max) {

				$retstring=substr($words[$widx],0,$max);

				$words[$widx]=substr($words[$widx],$max);

				$tooLong=1;

			} else {

				if ( strlen($retstring)>$max) {

					$retstring=$oldstring;

					$tooLong=1;

				} else {

					$widx++;

				}

			}

		}

		if (trim($retstring)) {

			$lines[]=$retstring;

		}

	}

	$string=implode("\r\n",$lines);

	$numberLines=count($lines);

	return array($numberLines,$string);

}





?>

<!DOCTYPE html>

<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->

<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->

<!--[if !IE]><!--> <html lang="en" > <!--<![endif]-->

<head>

	<meta charset="utf-8">

	<title>Render  QI PDF</title>

</head>

<body>

<?php

include('tcpdf.php');

#include('tcpdi.php');





$pdf = new TCPDF("L","pt","LETTER");

$pdf->SetAutoPageBreak(false, 0);

$pdf->setCellPaddings(0,0,0,0);

#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);

#$pdf->setFontSubsetting(false);

$pdf->SetLeftMargin(.20);

$pdf->SetRightMargin(.20);

$pdf->SetTextColor(0,0,0,100); ## 100% black

$pdf->SetDrawColor(0,0,0,100);

$pdf->SetLineWidth(1);



function printHeader($db,$start,$end,$customerName,$part,$pdf) {

		$pdf->AddPage();

		$pdf->Image("logoblank.jpg",0,0,792,100,'','','',true);

		$pdf->Image("images/logoblack.png",1,1,150, 60,'','','',true);

		$pdf->SetFont("times","I",8,'',false);

		$pdf->SetXY(520,10);

        $pdf->Write("10",'Page '.$pdf->getAliasNumPage().' of '.$pdf->getAliasNbPages());

		$pdf->SetFont("times","",16,'',false);

		$pdf->SetXY(300,10);

		$pdf->Write(16,"Quality Issues");



		$pdf->SetXY(300,26);

		$pdf->Write(16,"Printed " . Date("l, m/d/Y h:i:s"));

		if ($customer) {

			$pdf->SetXY(20,50);

			$pdf->Write(16,$customerName);

		}

		if ($start_date) {

			$pdf->SetXY(100,50);

			if ($end_date) {

				$pdf->Write(16,$start_date) . " - ";



			} else {

				$pdf->Write(16,$start_date);

			}

		}

		if ($end_date) {

			$pdf->SetXY(180,50);

			$pdf->Write(16,$end_date);

		}

		if ($part) {

			$pdf->SetXY(280,50);

			$pdf->Write(16,$part);

		}

		$pdf->SetXY(20,66);

		$pdf->Write(16,"Customer");

		$pdf->SetXY(200,66);

		$pdf->Write(16,"Part");

		$pdf->SetXY(320,66);

		$pdf->Write(16,"Date");

		$pdf->SetXY(400,66);

		$pdf->Write(16,"Reason");

		$pdf->SetXY(590,66);

		$pdf->Write(16,"Quantity");

		$pdf->SetXY(650,66);

		$pdf->Write(16,"Price Per");

		$pdf->SetXY(720,66);

		$pdf->Write(16,"Total");

}



include('qualityIssuesSub.php');

$holdDefect="";

$sqty=0;

$totdollars=0;

$lines=99;

$ypos=80;

while ($data=mysqli_fetch_array($rs)) {

	$part=$data['item_id'];

	$reason=$data['reason_code'];

	$dt=formatDateDBToWeb($data['date_reported']);

	$qty=$data['quantity'];

	$sqty += $qty;

	$by=$data['reporter_name'];

	$ref=$data['customer_reference'];

	$resolution=$data['resolution'];

	$action=$data['action_taken'];

	$issue=$data['issue'];

	$cust=$data['name'];

	$dollars=$data['dollars'] * $qty;

	$perUnit=$data['dollars'];

	$totqty+=$qty;

	$totdollars+=$dollars;

	if ($lines > 45) {

		printHeader($db,$start_date,$end_date,$cust,$searchpart,$pdf,$routing);

		$lines=4;

		$ypos=70;

	}

	$lines++;

	$pdf->SetFont("times","",12,'',false);

	$ypos+=12;

	$pdf->SetXY(20,$ypos);

	$pdf->Write(12,$cust);

	$pdf->SetXY(200,$ypos);

	$pdf->Write(12,$part);

	$pdf->SetXY(320,$ypos);

	$pdf->Write(12,$dt);

	$pdf->SetXY(400,$ypos);

	$pdf->Write(12,$reason);

	$pdf->SetXY(590,$ypos);

	$pdf->Write(12,$qty);

	$pdf->SetXY(650,$ypos);

	$pdf->Write(16,number_format($perUnit,2));

	$pdf->SetXY(720,$ypos);

	$pdf->Write(16,number_format($dollars,2));

}

$ypos+=12;

$pdf->SetXY(20,$ypos);

$pdf->Write(12,"Grand Total");

$pdf->SetXY(650,$ypos);

$pdf->SetXY(12,$sqty);

$pdf->SetXY(720,$ypos);

$pdf->Write(16,number_format($totaldollars,2));


$pdf->Output('QualityIssues.pdf', "I");


?>

</body></html>