<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
include('functions.php');
include('security.php');

$id="";
if (isset($_GET['id'])) {
	$id=$_GET['id'];
}
$type="";
if (isset($_GET['type'])) {
	$type=$_GET['type'];
}

header("Content-type: application/pdf");
$datestamp=Date("m/d/Y");

## Taking the given id from the point_log table and getting the info to fill out the pdf
$sql = "SELECT last_name, first_name, activity_date, reason_date, reason, points_adjusted, points_remaining, point_log.employee_id, point_log.manager_id, employee_signed_date, manager_signed_date FROM point_log INNER JOIN employees ON point_log.employee_id = employees.employee_id WHERE point_id = ?";
list($rs,$err) = runIQuery($db, $sql, array('i', $id));
foreach ($rs as $data) {
    $employeeName = $data['first_name'] . " " . $data['last_name'];
	$forPreviousDate = $data['activity_date'];
    $activityDate = date("m/d/Y", strtotime($data['activity_date']));
    $reasonDate = date("m/d/Y", strtotime($data['reason_date']));
	$employeeSignedDate = is_null($data['employee_signed_date']) ? NULL : date("m/d/Y", strtotime($data['employee_signed_date']));
	$managerSignedDate = is_null($data['manager_signed_date']) ? NULL : date("m/d/Y", strtotime($data['manager_signed_date']));
    $reason = $data['reason'];
    $adjustment = $data['points_adjusted'];
    $currentPoints = $data['points_remaining'];
	$employeeId = $data['employee_id'];
	$managerAdminId = $data['manager_id'];
}

## Get Manager info
$sql = "SELECT full_name FROM site_admins WHERE `user_id` = ?";
list($rs,$err)=runIQuery($db,$sql,array('i',$managerAdminId));
$managerName=$rs[0][0];

// Get Previous points_remaining
$previousPoints = "";
$sql = "SELECT points_remaining, activity_date from point_log where employee_id = ? AND activity_date < ? order by activity_date desc";
list($rs,$err) = runIQuery($db, $sql, array('is', $employeeId, $forPreviousDate));
if (count($rs)) {
    $previousPoints = $rs[0]['points_remaining'];  //first pdf for a given employee won't render unless there's a nonexistent previous history workaround
}

## The pdf is laid out below

include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
include('tcpdf_barcodes_2d.php');
	
$pdf = new TCPDF("P","pt","LETTER");
$pdf->SetAutoPageBreak(false, 0);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
	
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

$pdf->AddPage();
$pdf->Image("logoblank.jpg",0,0,660,100,'','','',true);
$LX = 72;
$pdf->Image("images/logocoatings.jpg",$LX,45,120.5,56,'','','',true);
$pdf->Image("images/logomachine.jpg",$LX += 120, 44, 115, 57,'','','',true);
$pdf->Image("images/logodelivery.jpg",$LX += 116,44,95,57,'','','',true);
$pdf->Image("images/logoweld.jpg",$LX += 96,40,119,64.5,'','','',true);
$pdf->SetFont("helvetica","B",8,'',false);

$pdf->SetXY(50,150);
$pdf->Write(12,"Employee Name:");
$pdf->SetXY(130,150);
$pdf->Write(12,$employeeName);
$pdf->SetXY(50,174);
$pdf->Write(12,"Today's Date:");
$pdf->SetXY(130,174);
$pdf->Write(12,$activityDate);

//Point Reasons
$pdf->SetXY(50,200);
$pdf->Write(12,"This form is to notify you that your points were adjusted on:");
$pdf->SetXY(50,212);
$pdf->Write(12,$reasonDate);
$pdf->SetXY(50,230);
$pdf->Write(12,"For the following reason:");
$pdf->SetXY(50,242);
$pdf->Write(12,$reason);
$pdf->SetXY(50,260);
$pdf->Write(12,"Your points were adjusted by:");
$pdf->SetXY(50,272);
$pdf->Write(12,$adjustment);

//Point Consequences
$pdf->SetXY(50,290);
$pdf->Write(12,"Point Consequences:");
$pdf->SetXY(50,302);
$pdf->Write(12,"* 5.75-6 hours of holiday pay and 1/4 point back.");
$pdf->SetXY(50,314);
$pdf->Write(12,"* 5.50-4 hours of holiday pay and will be given .5 points back.");
$pdf->SetXY(50,326);
$pdf->Write(12,"* 5.25-2 hours of holiday pay and will be given .75 points back.");
$pdf->SetXY(50,338);
$pdf->Write(12,"* 5 points or less you will receive 0 hours of holiday pay and will be given 1 point back.");
$pdf->SetXY(50,350);
$pdf->Write(12,"* 3.75 and below: Probation.");
$pdf->SetXY(55,362);
$pdf->Write(12,"Any employee on probation is ineligible for any profit sharing until they have 4 or more attendance points.");
$pdf->SetXY(50,374);
$pdf->Write(12,"* 2.75 points: One day unpaid suspension.");
$pdf->SetXY(55,386);
$pdf->Write(12,"Placed on a PIP (Personal Improvement Plan) and will be ineligible for any profit sharing");
$pdf->SetXY(55,398);
$pdf->Write(12,"until they have 4 or more attendance points.");
$pdf->SetXY(50,410);
$pdf->Write(12,"* 1.75 points: Three day unpaid suspension.");
$pdf->SetXY(55,422);
$pdf->Write(12,"Extension of PIP and will be ineligible for any profit sharing until they have 4 or more attendance points.");
$pdf->SetXY(50,434);
$pdf->Write(12,"* 0 points: Termination of employment.");

//PIP Message
if (is_numeric($previousPoints)) {

    $pdf->SetTextColor(245,0,0);
    if ($currentPoints <= 2.75 && $previousPoints > 2.75) {
        $pdf->SetXY(50, 500);
        $pdf->Write(12, "A PIP is required at this point.");
    } elseif ($currentPoints <= 2.75) {
        $pdf->SetXY(50, 500);
        $pdf->Write(12, $employeeName . " is currently on a PIP");
    } elseif ($currentPoints <= 3.75) {
        $pdf->SetXY(50, 500);
        $pdf->Write(12, "Ineligible for profit share"); ## bdoss 10/3/22 BW clarified PIP is only at 2.75 points and below, suggested 3.75 and below message could say ineligible for profit share
    }

} elseif ($currentPoints <= 2.75) {
    $pdf->SetTextColor(245,0,0);
    $pdf->SetXY(50, 500);
    $pdf->Write(12, "A PIP is required."); //this is specifically for employees who do not have a point log history, but they're already on a PIP or need one now, can't differentiate
}
$pdf->SetTextColor(0,0,0,100); ## 100% black

//Point Total
$pdf->SetXY(50,520);
$pdf->Write(12,"Your current point total is: ");
$pdf->SetXY(155,520);
$pdf->Write(12,$currentPoints);
$pdf->SetXY(50,540);
$pdf->Write(12,"Please remember that it is important for you as an employee of Preferred Machine to be here on time and show up");
$pdf->SetXY(50,552);
$pdf->Write(12,"to work every day that you are scheduled.");

//Signatures
$pdf->SetXY(50,600);
$pdf->Write(12,"Supervisor's Signature:");
$pdf->SetXY(350,600);
$pdf->Write(12,"Employee's Signature:");
//added code to display names and signature date if signed
if (!is_null($managerSignedDate) ) {
	$pdf->SetXY(50,625);
	$pdf->Write(12, $managerName . " " . $managerSignedDate);
}
if (!is_null($employeeSignedDate) ) {
	$pdf->SetXY(350,625);
	$pdf->Write(12,$employeeName . " " . $employeeSignedDate);
}
$pdf->SetXY(50,630);
$pdf->Write(12,"____________________________");
$pdf->SetXY(350,630);
$pdf->Write(12,"____________________________");

//message about signing it on a hard copy or arguing against point adjustment
if ($currentPoints > 3.75) {
	$pdf->SetXY(50,660);
	$pdf->Write(12,"*If you do not agree with this point adjustment, print the PDF and bring it to your supervisor.");
} else {
	$pdf->SetXY(50,660);
	$pdf->Write(12,"*This form must be manually signed.  The supervisor is responsible for printing a copy.");
}


$fileName=$type . $id . ".pdf";
$pdf->Output($fileName, "I");


?>