<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
## session start is now in dbconnection.php;
include('functions.php');
include('security.php');

error_reporting(E_ALL);
ini_set('display_errors','on');

#header("Content-type: application/pdf");

$id = null;
if (isset($_GET["id"])) $id = $_GET['id'];
$type=$_GET['type'];

//Most of the code is the same, I just removed the excess line-breaks -Josh 01-30-2022
//(most likely caused by using an editor that parses \r\n as separate breaks then saves them all as \n)
function multiLine($string,$max=60) {
	$lines=array();
	$stringlines=explode("\r\n",$string);
	foreach ($stringlines as $string) {
		$words=explode(" ",$string);
		$widx=0;
		$string="";
		while ($widx < count($words)) {
			$retstring="";
			$tooLong=0;
			while ($widx < count($words) and $tooLong==0 ) {
				if ($retstring) {
					$retstring.=" ";
				}
				$oldstring=$retstring;
				$retstring.=$words[$widx];
				if (strlen($words[$widx])>$max) {
					if ($oldstring == "") {
						$retstring=substr($words[$widx],0,$max);
						$words[$widx]=substr($words[$widx],$max);
					} else {
						$retstring=$oldstring;
					}
					$tooLong=1;
				} else {
					if ( strlen($retstring)>$max) {
						$retstring=$oldstring;
						$tooLong=1;
					} else {
						$widx++;
					}
				}
			}
			if (trim($retstring)) {
				$lines[]=$retstring;
			}
		}
	}
	return $lines;
}

// start item operations functions - Josh 02/17/2023
function generateOps($part,&$ops) {
	global $db;
	$sql = "select show_as from routing r, operations op where r.operation_id=op.operation_id and r.parent_part=? and coalesce(show_as,'')<>'' group by coalesce(show_as,'')";
	list($rs,$err)=runIQuery($db,$sql,["s",$part]);

	$theseops = [];
	foreach ($rs as $data) {
		$op = $data["show_as"];
		if (in_array($op,$theseops) || in_array($op,$ops)) {
			continue;
		}
		$theseops[] = $data["show_as"];
	}

	$ops=array_merge($ops,$theseops);
}

function walkBOM($part,&$seen,&$ops) {
	global $db;
	if (in_array($part,$seen)) {
		return;
	}
	$seen[]=$part;
	// item category 19 is components, 24 is sheet stock, restricting to reduce queries
	$sql = "select child_item from billofmaterial bom, items i where child_item=item_name and not item_category in (19,24) and parent_item=? order by runseq";
	list($rs,$err)=runIQuery($db,$sql,["s",$part]);

	foreach ($rs as $data) {
		$item = $data["child_item"];
		generateOps($item,$ops);
		walkBOM($item,$seen,$ops);
	}
}


function generateAllOps($part) { // separate function for isolating $ops and $seen variables by parent
	$ops=[];
	$seen=[];

	generateOps($part,$ops);
	walkBOM($part,$seen,$ops);
	$ops = array_reverse($ops);
	return $ops;
}
// end item operations functions

require_once('tcpdf.php');
require_once('tcpdf_barcodes_1d.php');

$pdf = new TCPDF("P", "pt", "LETTER", true, 'UTF-8', false);
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

function returnPOHeader($db, $pdf, $po, $page, $numPages) {
	$pdf->AddPage();
	$sql="select * from purchase_orders where po_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$po));

	$data=$rs[0];
	$vendorID=$data['vendor_id'];
	$who=$data['who'];

	$sql="select initials from site_admins where user_id=?";
	list($srs,$err)=runIQuery($db,$sql,array("i",$who));

	$initials = false;
	if (isset($srs[0])) {
		$sdata=$srs[0];
		$initials=$sdata[0];
	}

	$ship_name=$data['ship_name'];
	$ship_address=$data['ship_address'];
	$ship_city=$data['ship_city'];
	$ship_state=$data['ship_state'];
	$ship_zip=$data['ship_zip'];
	$notes_to_vendor=strip_tags($data['notes_to_vendor']);
	$terms=$data['terms'];

	if (!$terms) {
		$terms="Net 30";
	}

	$retval="";

	$pdf->SetFont("helvetica", "B", 14, '', false);
	$pdf->SetXY(450,20);
	$pdf->Write(14,"Purchase Order");
	$pdf->SetFont("helvetica", "", 10, "", false);
	$pdf->SetXY(450,40);
	$pdf->Write(10,"Printed " . Date("m/d/Y h:i:s"));
	$sql="select * from company_shiptos ";
	list($rs,$err)=runIQuery($db,$sql);
	$codata=$rs[0];
	$sql="select * from vendors where vendor_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$vendorID));
	$vdata=$rs[0];
	$pdf->SetXY(40,100);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Vendor");
	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(40,110);
	$pdf->Write(10,$vdata['vendor_name']);
	$pdf->SetXY(40,120);
	$pdf->Write(10,$vdata['address']);
	$pdf->SetXY(40,130);
	$pdf->Write(10,$vdata['city'] . ", " . $vdata['state'] . " " . $vdata['zip']);
	$pdf->SetXY(40,140);
	$pdf->Write(10,$vdata['phone']);
	$pdf->SetXY(320,100);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Ship To");
	$pdf->SetFont("helvetica","",10);

	if ($ship_name != $codata['ship_name'] or $ship_address!=$codata['ship_address']) {
		$pdf->SetXY(320,110);
		$pdf->Write(10,$ship_name);
		$pdf->SetXY(320,120);
		$pdf->Write(10,$ship_address);
		$pdf->SetXY(320,130);
		$pdf->Write(10,"$ship_city, $ship_state $ship_zip");
	} else {
		$pdf->SetXY(320,110);
		$pdf->Write(10,$codata['ship_name']);
		$pdf->SetXY(320,120);
		$pdf->Write(10,$codata['ship_address']);
		$pdf->SetXY(320,130);
		$pdf->Write(10,$codata['ship_city'].", " . $codata['ship_state']." " . $codata['ship_zip']);
	}

	$pdf->SetXY(450,52);
	$pdf->Write(10,"PO Number: " . $po);
	$pdf->SetXY(450,64);
	$pdf->Write(10,"Terms: $terms");
	$pdf->SetXY(450,76);

	if (!$initials) {
		$initials=$who;
	}

	if ($initials) {
		$pdf->Write(10,"Purchased By: $initials");
	}

	if ($notes_to_vendor) {
		$pdf->SetFont("helvetica","B",10);
		$lines=multiLine($notes_to_vendor,120);
		$pdf->Rect(20,158,582,count($lines)*10+4);
		$left=306;

		foreach ($lines as $line) {
			$tryleft=306 - $pdf->GetStringWidth($line)/2;
			if ($tryleft < $left) {
				$left=$tryleft;
			}
		}

		$lc=0;

		foreach ($lines as $line) {
			$pdf->SetXY($left, 160 + ($lc*10) );
			$lc++;
			$pdf->Write(10, $line);
		}

		$pdf->SetFont("helvetica","",10);
	}

	if ($numPages > 1) {
		$pdf->SetXY(20,185);
		$pdf->Write(10,"*** This is page $page of $numPages ***");
	}

	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(20, 198);
	$pdf->Write(10,"Quantity");
	$pdf->SetXY(70,198);
	$pdf->Write(10,"SO#");
	$pdf->SetXY(110, 198);
	$pdf->Write(10,"Item");
	$pdf->SetXY(200, 198);
	$pdf->Write(10,"Uom");
	$pdf->SetXY(230, 198);
	$pdf->Write(10,"Description");
	$pdf->SetXY(400, 198);
	$pdf->Write(10,"Rate");
	$pdf->SetXY(490, 198);
	$pdf->Write(10,"Amount");
	$pdf->SetXY(530, 198);
	$pdf->Write(10,"Date Due");
	$pdf->SetFont("helvetica","",8);
	$pdf->Line(20,210,600,210);
	$pdf->Line(20,210,20,750);
	$pdf->Line(68,210,68,750);
	$pdf->Line(108,210,108,750);
	$pdf->Line(198,210,198,750);
	$pdf->Line(228,210,228,750);
	$pdf->Line(398,210,398,750);
	$pdf->Line(448,210,448,750);
	$pdf->Line(528,210,528,750);
	$pdf->Line(600,210,600,750);
	$pdf->Line(20,750,600,750);
	$pdf->Image("images/logo.jpg",12,10,100);

	return $pdf;
}

function returnPSHeader($db, $pdf, $po, $page, $numPages) {
	$pdf->AddPage();
	$pdf->SetLineWidth(1);

	$sql="select * from packing_slip where packing_slip_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$po));
	$data=$rs[0];

	$customerID=$data['customer_id'];
	$attention=$data['attention'];
	$ship_name=$data['ship_name'];
	$ship_address=$data['ship_address'];
	$ship_address2=$data['ship_address2'];
	$ship_city=$data['ship_city'];
	$ship_state=$data['ship_state'];
	$ship_zip=$data['ship_zip'];
	$notes_to_customer=strip_tags($data['notes_to_customer']);

	$phone=$data['ship_phone'];
	$email=$data['ship_email'];

	$tracking_number=$data['tracking_number'];
	$ship_via=$data['ship_via'];
	$date_shipped=$data['date_shipped'];

	$retval="";

	$pdf->Image("images/logo.jpg",12,10,100);
	$pdf->SetFont("helvetica","B",14);

	$pdf->SetXY(270,20);
	$pdf->SetFont("helvetica","B",16);
	$pdf->Write(14,"Packing Slip $po");

	$pdf->SetXY(500,20);
	$pdf->write1DBarcode($po, 'C39', '', '', '', 22, 0.8);


	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(500,48);
	$pdf->Write(10,"Printed " . Date("m/d/Y"));
	$pdf->SetXY(500,58);
	$pdf->Write(10,"Shipped " . formatDateDBToWeb($date_shipped));

	$sql="select * from company_shiptos ";
	list($rs,$err)=runIQuery($db,$sql);
	$codata=$rs[0];

	$pdf->SetXY(110,20);
	$pdf->Write(10,$codata['ship_name']);
	$pdf->SetXY(110,30);
	$pdf->Write(10,$codata['ship_address']);
	$pdf->SetXY(110,40);
	$pdf->Write(10,$codata['ship_city'].", ".$codata['ship_state']." ".$codata['ship_zip']);
	$pdf->SetXY(110,50);
	$pdf->Write(10,$codata['ship_phone']);

	$sql="select * from customers where customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$vdata=$rs[0];

	//I set an X and Y value to move all items under Customer at once -Josh 02-03-2022
	//I haven't done it to all functions yet
	$custX = 40;
	$custY = 90;
	$pdf->SetXY($custX, $custY+=10);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Customer");
	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY($custX, $custY+=10);

	$pdf->Write(10,$vdata['name']);
	$pdf->SetXY($custX, $custY+=10);
	$pdf->Write(10,$vdata['address']);
	$pdf->SetXY($custX, $custY+=10);
	$pdf->Write(10,$vdata['city'] . ", " . $vdata['state'] . " " . $vdata['zip']);
	$pdf->SetXY($custX, $custY+=10);
	$pdf->Write(10,$vdata['phone']);

	//I set an X and Y value to move all items under ship address at once -Josh 02-03-2022
	//I haven't done it to all functions yet
	$shipX = 350;
	$shipY = 90;
	$pdf->SetXY($shipX, $shipY+=10);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Ship To");
	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY($shipX, $shipY+=10);
	$pdf->Write(10,$ship_name);

	$lines = multiline($ship_address, 40);
	foreach($lines as $line) {
		$pdf->SetXY($shipX, $shipY+=10);
		$pdf->Write(10,$line);
	}


	if ($ship_address2) {
		$pdf->SetXY($shipX, $shipY+=10);
		$pdf->Write(10,$ship_address2);
	}

	$pdf->SetXY($shipX, $shipY+=10);
	$pdf->Write(10,"$ship_city, $ship_state $ship_zip");
	$pdf->SetXY($shipX,$shipY+=10);
	$pdf->Write(10,$phone);
	$pdf->SetXY(450,80);
	//$pdf->Write(10,"Packing Slip: " . $po);
	$pdf->SetXY(450,70);
	//$pdf->Write(10,"Ship Via: $ship_via");

	if ($tracking_number) {
		$pdf->SetXY(450,80);
		$pdf->Write(10,"$tracking_number");
	}

	if ($notes_to_customer) {
		$pdf->SetFont("helvetica","B",10);
		$lines=multiLine($notes_to_customer,120);
		$pdf->Rect(20,158,582,count($lines)*10+4);

		$left=306;
		foreach ($lines as $line) {
			$tryleft=306 - $pdf->GetStringWidth($line)/2;
			if ($tryleft < $left) $left=$tryleft;
		}

		$lc=0;
		foreach ($lines as $line) {
			$pdf->SetXY($left, 160 + ($lc*10) );
			$lc++;
			$pdf->Write(10, $line);
		}

		$pdf->SetFont("helvetica","",10);
	}

	//if ($numPages > 1) {
		$pdf->SetFont("helvetica","I",8);
		$pdf->SetXY(20,175);
		$pdf->Write(10,"Page $page of $numPages");

		$pdf->SetFont("helvetica","",10);
	//}


	$lineTop = 200;
	$lineBottom = 690;
	$labelY = $lineTop-12;
	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(20, $labelY);
	//$pdf->Write(10,"Quantity");
	$pdf->Write(10,"Date Due");

	$pdf->SetXY(75, $labelY);
	//$pdf->Write(10,"Item");
	$pdf->Write(10,"Part");

	$pdf->SetXY(220, $labelY);
	//$pdf->Write(10,"Order");
	$pdf->Write(10,"QTY");

	$pdf->SetXY(250, $labelY);
	$pdf->Write(10,"Description");
	$pdf->SetXY(460, $labelY);
	$pdf->Write(10,"PO Line");
	$pdf->SetXY(500, $labelY);
	$pdf->Write(10, "Order ID");
	$pdf->SetXY(542, $labelY);
	$pdf->Write(10, "PO Number");


	$pdf->Line(20,$lineTop,600,$lineTop);
	$pdf->Line(20,$lineTop,20,$lineBottom);
	$pdf->Line(75,$lineTop,75,$lineBottom);
	$pdf->Line(220,$lineTop,220,$lineBottom);
	$pdf->Line(248,$lineTop,248,$lineBottom);
	$pdf->Line(460,$lineTop,460,$lineBottom);
	$pdf->Line(498,$lineTop,498,$lineBottom);
	$pdf->Line(540,$lineTop,540,$lineBottom);
	$pdf->Line(600,$lineTop,600,$lineBottom);
	$pdf->Line(20,$lineBottom,600,$lineBottom);

	$pdf->SetXY(20, $lineBottom + 75);
	$pdf->SetFont("helvetica", "", 10);
	//optionally only put received by on the first page
	/*if ($page == 1)*/ $pdf->Write(12,"RECEIVED BY: ___________________________  DATE: ________________");

	//Print QR Code -Josh 01-31-2022
	$sql = "select * from system_settings where name=?";
	list($rs,$err) = runIQuery($db, $sql, array(
		"s",
		"qr_code_until"
	));
	if (date("Y-m-d", strtotime("-1 day")) < $rs[0]["setting"]) {
		$style = array(
			'border' => 1,
			'vpadding' => 'auto',
			'hpadding' => 'auto',
			'fgcolor' => array(0,0,0),
			'bgcolor' => false, //array(255,255,255)
			'module_width' => 1, // width of a single module in points
			'module_height' => 1 // height of a single module in points
		);

		$pdf->write2DBarcode('http://survey.preferredmachinellc.com/survey.html?c=' . $customerID, 'QRCODE,L', 540, $lineBottom + 25, 60, 60, $style, 'N');
		$pdf->SetXY(513, $lineBottom + 10);
		$pdf->SetFont("helvetica","",10,'',false);
		$pdf->Write(12,"Free Swag Drawing");
	}
	$pdf->SetFont("helvetica","",8);

	return $pdf;
}

function returnMTHeader($db, $pdf, $po, $page, $numPages, $order_id, $customer_id) {
	$pdf->AddPage();

	$sql="select * from transfers where packing_slip=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$po));
	$data=$rs[0];

	$location=$data['location'];
	$ship_name=$data['ship_name'];
	$ship_address=$data['ship_address'];
	$ship_city=$data['ship_city'];
	$ship_state=$data['ship_state'];
	$ship_zip=$data['ship_zip'];
	$date_shipped=$data['transfer_date'];

	$retval="";

	$pdf->Image("images/logo.jpg",12,10,100);
	$pdf->SetFont("helvetica","B",14);

	$pdf->SetXY(230,25);
	$pdf->SetFont("helvetica","B",16);
	$pdf->Write(14,"Material Transfer $po");

	$pdf->SetXY(500,20);
	$pdf->write1DBarcode($po, 'C39', '', '', '', 22, 0.8);

	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(500,48);
	$pdf->Write(10,"Printed:");
	$pdf->SetXY(542,48);
	$pdf->Write(10,date("m/d/Y"));
	$pdf->SetXY(500,58);
	$pdf->Write(10,"Shipped:");
	$pdf->SetXY(542,58);
	$pdf->Write(10,formatDateDBToWeb($date_shipped));
	$pdf->SetXY(500,70);
	$pdf->Write(10,"OUR SO:");
	$pdf->SetXY(542,70);
	$pdf->Write(10,$order_id);

	$sql="select * from company_shiptos ";
	list($rs,$err)=runIQuery($db,$sql);
	$codata=$rs[0];

	$pdf->SetXY(105,15);
	$pdf->Write(10,$codata['ship_name']);
	$pdf->SetXY(105,25);
	$pdf->Write(10,$codata['ship_address']);
	$pdf->SetXY(105,35);
	$pdf->Write(10,$codata['ship_city'].", ".$codata['ship_state']." ".$codata['ship_zip']);
	$pdf->SetXY(105,45);
	$pdf->Write(10,$codata['ship_phone']);

	$shipX = 340;
	$shipY = 70;
	$pdf->SetXY($shipX, $shipY+=10);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Ship To");
	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY($shipX, $shipY+=10);
	$pdf->Write(10,$location);
	$lines = multiline($ship_address, 40);
	foreach($lines as $line) {
		$pdf->SetXY($shipX, $shipY+=10);
		$pdf->Write(10,$line);
	}

	$pdf->SetXY($shipX, $shipY+=10);
	$pdf->Write(10,"$ship_city, $ship_state $ship_zip");


	$lineTop = 162;
	$lineBottom = 690;
	$lineLeft = 20;
	$lineRight = 600;
	$labelX = $lineLeft;
	$labelY = $lineTop-12;

	$pdf->SetFont("helvetica","I",8);
	$pdf->SetXY(20,$labelY-15);
	$pdf->Write(10,"Page $page of $numPages");
	$pdf->SetFont("helvetica","",10);

	// Labels and Separators
	$pdf->SetXY($labelX, $labelY); // labelX=20
	$pdf->Write(10,"Line");
	$pdf->SetXY($labelX+=35, $labelY); // labelX=55

	$pdf->Line($labelX,$lineTop,$labelX,$lineBottom);
	$pdf->Write(10,"Part");
	$pdf->SetXY($labelX+=150, $labelY); // labelX=205

	$pdf->Line($labelX,$lineTop,$labelX,$lineBottom);
	$pdf->Write(10,"Description");
	$pdf->SetXY($labelX+=215,$labelY); // labelX=420

	$pdf->Line($labelX,$lineTop,$labelX,$lineBottom);
	$pdf->Write(10,"Quantity");
	$pdf->SetXY($labelX+=45, $labelY); // labelX=465

	$pdf->Line($labelX,$lineTop,$labelX,$lineBottom);
	$pdf->Write(10,"Customer PO");
	$pdf->SetXY($labelX+=67, $labelY); // labelX=532

	$pdf->Line($labelX,$lineTop,$labelX,$lineBottom);
	$pdf->Write(10,"Due Customer");

	$pdf->SetFont("helvetica","",9);

	// Lines
	$pdf->Line($lineLeft,$lineTop,$lineRight,$lineTop); // box top
	$pdf->Line($lineRight,$lineTop,$lineRight,$lineBottom); // box right
	$pdf->Line($lineLeft,$lineBottom,$lineRight,$lineBottom); // box bottom
	$pdf->Line($lineLeft,$lineTop,$lineLeft,$lineBottom); // box left

	// Ultimate Destination
	if ($order_id || $customer_id) {
		$ship_address = "";
		$ship_city = "";
		$ship_state = "";
		$ship_zip = "";

		if ($order_id) {
			$sql = "select ship_address, ship_city, ship_state, ship_zip from orders where order_id=? and ship_address<>'' and ship_city<>'' and ship_state<>'' and ship_zip<>''";
			list($rs,$err)=runIQuery($db,$sql,["i",$order_id]);
			if (count($rs)) {
				$data=$rs[0];
				$ship_address = $data["ship_address"];
				$ship_city = $data["ship_city"];
				$ship_state = $data["ship_state"];
				$ship_zip = $data["ship_zip"];
			}
		}

		if (!$ship_address && $customer_id) {
			$sql = "select ship_address, ship_city, ship_state, ship_zip from customers where customer_id=? and ship_address<>'' and ship_city<>'' and ship_state<>'' and ship_zip<>''";
			list($rs,$err)=runIQuery($db,$sql,["i",$customer_id]);
			if (count($rs)) {
				$data=$rs[0];
				$ship_address = $data["ship_address"];
				$ship_city = $data["ship_city"];
				$ship_state = $data["ship_state"];
				$ship_zip = $data["ship_zip"];
			}
		}

		if ($ship_address) {
			$pdf->SetXY($lineLeft,$lineBottom);
			$pdf->SetFont("helvetica","B",10,"",false);
			$pdf->Write(10,"Ultimate Destination: $ship_address, $ship_city $ship_state, $ship_zip");
		}
	}

	return $pdf;
}

function returnSOHeader($db, $pdf, $so, $page, $numPages, $grid = 1) {
	$pdf->AddPage();

	$pdf->SetLineWidth(1);

	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$so));
	$data=$rs[0];

	$customerID=$data['customer_id'];
	$who=$data['salesperson_id'];
	$ship_name=$data['ship_name'];
	$attention=$data['attention'];
	$ship_address=$data['ship_address'];
	$ship_address2=$data['ship_address2'];
	$ship_city=$data['ship_city'];
	$ship_state=$data['ship_state'];
	$ship_zip=$data['ship_zip'];
	$status=$data['status'];
	$notes_to_customer=strip_tags(html_entity_decode($data['notes_to_customer']));
	$notes_to_customer=str_replace("<br />"," ",$notes_to_customer);
	$po=$data['po_number'];

	$email=$data['email'];
	$phone=$data['phone'];

	$retval="";

	$pdf->SetFont("helvetica","B",14);
	$pdf->SetXY(450,20);

	$status=$data['status'];
	if ($status == 6) {
		$pdf->Write(14,"Quote");
	} else {
		$confirm = '';
		if (isset($_GET['confirm'])) $confirm = $_GET['confirm'];
		if ($confirm =='yes') {
			$pdf->Write(14,"Order Confimation");
		} else {
			$pdf->Write(14,"Sales Order");
		}
	}

	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(450,40);
	$pdf->Write(10,"Printed " . Date("m/d/Y h:i:s"));

	$sql="select * from customers where customer_id=? ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$cdata=$rs[0];

	$pdf->SetXY(40,100);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Bill To");
	$pdf->SetFont("helvetica","",10);
	$pdf->SetXY(40,110);
	$pdf->Write(10,$cdata['name']);
	$pdf->SetXY(40,120);
	$pdf->Write(10,$cdata['address']);
	$pdf->SetXY(40,130);
	$pdf->Write(10,$cdata['city'] . ", " . $cdata['state'] . " " . $cdata['zip']);
	$pdf->SetXY(40,140);
	$pdf->Write(10,$cdata['phone']);
	$pdf->SetXY(306,100);
	$pdf->SetFont("helvetica","B",10);
	$pdf->Write(10,"Ship To");
	$pdf->SetFont("helvetica","",10);

	$baseShip=110;
	if ($attention) {
		$baseShip=120;
		$pdf->SetXY(306,110);
		$pdf->Write(10,$attention);
	}

	$pdf->SetXY(306,$baseShip);
	$pdf->Write(10,$ship_name);

	$baseShip+=10;
	if ($ship_address) {
		$pdf->SetXY(306,$baseShip);
		$pdf->Write(10,$ship_address);
		$baseShip+=10;
	}

	if ($ship_address2) {
		$pdf->SetXY(306,$baseShip);
		$pdf->Write(10,$ship_address2);
		$baseShip+=10;
	}

	if ($ship_city or $ship_state or $ship_zip) {
		$pdf->SetXY(306,$baseShip);
		$pdf->Write(10,"$ship_city, $ship_state $ship_zip");
		$baseShip+=10;
	}

	## cma removed phone
	#$pdf->SetXY(306,$baseShip);
	#$pdf->Write(10,$phone);

	$baseShip+=10;
	$pdf->SetXY(450,50);
	if ($status == 6) {
		$pdf->Write(10,"Quote: $so");
	} else {
		$pdf->Write(10,"Sales Order: $so");
	}

	$pdf->SetXY(450,60);
	$pdf->Write(10,"PO Number: $po");

	$notes_to_customer=str_replace("\r\n"," ",$notes_to_customer);
	$notes_to_customer=str_replace("\n"," ",$notes_to_customer);
	$pdf->SetXY(20,160);
	$pdf->Write(10,$notes_to_customer);
	$sql="select `setting` from `system_settings` where `name` = 'global_so_notes' ";
	list($ssrs,$err)=runIQuery($db,$sql);
	if (count($ssrs)>0) {
		$notes=$ssrs[0][0];
		$notes=strip_tags($notes);
		$pdf->SetFont("helvetica","",7);
		$pdf->SetXY(20,151);
		$pdf->Write(8,$notes);

	}


	if ($numPages > 1) {
		$pdf->SetXY(20,753);
		$pdf->SetFont("helvetica","I",8);
		$pdf->Write(10,"Page $page of $numPages");
		$pdf->SetFont("helvetica","",10);
	}

	if ($grid) {
		$labelY = 198;
		$pdf->SetFont("helvetica","",9);
		$pdf->SetXY(20, $labelY);
		$pdf->Write(10,"PO Line");
		$pdf->SetXY(57, $labelY);
		$pdf->Write(10,"Item");
		$pdf->SetXY(200, $labelY);
		//$pdf->Write(10,"Uom");
		$pdf->SetXY(196, $labelY);
		$pdf->Write(10,"Description");
		$pdf->SetXY(400, $labelY);
		$pdf->Write(10,"Quantity");
		$pdf->SetXY(450, $labelY);
		$pdf->Write(10,"Rate");
		$pdf->SetXY(480, $labelY);
		$pdf->Write(10,"Amount");
		$pdf->SetXY(530, $labelY);
		$pdf->Write(10,"Due Date");
		$pdf->SetFont("helvetica","",8);
		$width = 600;
		$height = 700;
		$pdf->Line(20,210,$width,210); //Top
		$pdf->Line($x=20,210,$x,$height); //left start, PO left
		$pdf->Line($x=55,210,$x,$height); //PO right, Item left
		//$pdf->Line($x=198,210,$x,$height); //Item right, UOM Left
		$pdf->Line($x=193,210,$x,$height); //Item right, Desc left
		$pdf->Line($x=400,210,$x,$height); //Desc right, Qty left
		$pdf->Line($x=440,210,$x,$height); //Qty right, Rate left
		$pdf->Line($x=478,210,$x,$height); //Rate right, Amount left
		$pdf->Line($x=528,210,$x,$height); //Amount right, Due left
		$pdf->Line($x=600,210,$x,$height); //right end, Due right
		$pdf->Line(20,$height,$width,$height); //Bottom
	}

	//Print QR Code -Josh 01-31-2022
	$sql = "select * from system_settings where name=?";
	list($rs,$err) = runIQuery($db, $sql, array(
		"s",
		"qr_code_until"
	));
	if (date("Y-m-d", strtotime("-1 day")) < $rs[0]["setting"]) {
		$style = array(
			'border' => 1,
			'vpadding' => 'auto',
			'hpadding' => 'auto',
			'fgcolor' => array(0,0,0),
			'bgcolor' => false, //array(255,255,255)
			'module_width' => 1, // width of a single module in points
			'module_height' => 1 // height of a single module in points
		);
		$lineBottom = 780;
		$pdf->write2DBarcode('http://survey.preferredmachinellc.com/survey.html?c=' . $customerID, 'QRCODE,L', 540, $lineBottom - 60, 60, 60, $style, 'N');
		$pdf->SetXY(513, $lineBottom - 75);
		$pdf->SetFont("helvetica","",10,'',false);
		$pdf->Write(12,"Free Swag Drawing");
	}
	$pdf->SetFont("helvetica","",8);

	$pdf->Image("images/logo.jpg",12,10,100);

	return $pdf;
}

//renderTCPDF.php is used for WO, code not needed but keeping just in case -Josh 02-01-2022
if ($type=='WO') {
	$sql="select jobs.*, drawing, revision from jobs, items where job_id=? and jobs.item_id=items.item_name";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];

	$part=$data['item_id'];
	$sequence=$data['sequence'];
	$datedue=formatDateDBToWeb($data['start_date']);
	$description=$data['description'];
	$quantity=$data['quantity_scheduled'];
	$drawing=$data['drawing'];
	$revision=$data['revision'];

	$sql="select name from customers, items where items.customer_id=customers.customer_id and item_name=?";
	list($crs,$err)=runIQuery($db,$sql,array("s",$part));

	$cdata=$crs[0];
	$customer=$cdata[0];

	$sql="select operations.operation_id, operation_name, machine_name, workcenter_name, pph, units, routing.routing_id, routing.display_sequence, notes from jobs, routing left outer join operations on routing.operation_id=operations.operation_id left outer join machines on routing.machine_id=machines.machine_id left outer join workcenters on routing.workcenter_id=workcenters.workcenter_id left outer join routing_text on routing.routing_id=routing_text.routing_id where routing.parent_part=jobs.item_id and jobs.job_id=? order by routing.display_sequence ";
	list($ors,$err)=runIQuery($db,$sql,array("i",$id));
	$numPages=count($ors);

	$page=0;
	foreach ($ors as $routing) {
		$page++;

		// header job info
		$pdf->AddPage();
		$pdf->SetFont("helvetica", "",16);
		$pdf->SetXY(200,20);
		$pdf->Write(16,"Operation Notes");
		$pdf->SetXY(300,20);
		$pdf->Write(16,"Printed " . Date("l, m/d/Y h:i:s"));

		// rectangle
		$pdf->Line(20,60,600,60);
		$pdf->Line(20,60,20,160);
		$pdf->Line(600,60,600,160);
		$pdf->Line(20,160,600,160);
		$pdf->SetXY(30,62);
		$pdf->Write(16,"Production Order");
		$pdf->SetXY(30,78);
		$pdf->Write(16,"Drawing/Rev:");
		$pdf->SetXY(130,78);
		$pdf->Write(16,$drawing . " / ".$revision);
		$pdf->SetXY(30,94);
		$pdf->Write(16,"Description");
		$pdf->SetXY(130,94);
		$pdf->Write(16,$description);
		$pdf->SetXY(30,110);
		$pdf->Write(16,"Customer:");
		$pdf->SetXY(130,110);
		$pdf->SetFont("helvetica", "B",16);
		$pdf->Write(16,$customer);
		$pdf->SetFont("helvetica", "",16);
		$pdf->SetXY(30,126);
		$pdf->Write(16,"Purchase Order(s)");
		$pdf->SetXY(400,62);
		$pdf->Write(16,"Part");
		$pdf->SetXY(400,78);
		$pdf->Write(16,"Due");
		$pdf->SetXY(400,110);
		$pdf->Write(16,"Quantity");
		$pdf->SetFont("helvetica", "B",24);
		$pdf->SetXY(130,62);
		$pdf->Write(24,$id);
		$pdf->SetXY(400,62);
		$pdf->Write(24,$part);
		$pdf->SetXY(400,78);
		$pdf->Write(24,$datedue);
		$pdf->SetXY(400,110);
		$pdf->Write(24,$quantity);

		// operation dependent information
		$operationSequence=$routing['display_sequence'];
		//$pdf->AddFont('FREE3OF9','','FREE3OF9.php');
		$pdf->SetFont('helvetica','',36);
		$pdf->SetXY(300,40);
		$pdf->Write(36,"*".$id."-".$sequence."*");

		$routingID=$routing['routing_id'];
		$opid=$routing['operation_id'];

		$sql="select distinct po_id from po_lines where job_id=? and operation_id=?";
		list($prs,$err)=runIQuery($db,$sql,array("i",$job, $opid));

		$polist="";
		$comma="";
		foreach ($prs as $data) {
			$polist.=$comma;
			$polist.= $data['po_id'];
			$comma=", ";
		}

		$pdf->SetXY(130,126);
		$pdf->Write(16,$polist);

		$pdf->SetFont("helvetica", "",16);
		$pdf->SetXY(30,162);
		$pdf->Write(16,"SEQ");
		$pdf->SetXY(60,162);
		$pdf->Write(16,"Operation");
		$pdf->SetXY(220,162);
		$pdf->Write(16,"Workcenter");
		$pdf->SetXY(320,162);
		$pdf->Write(16,"Machine");
		$pdf->SetXY(420,162);
		$pdf->Write(16,"Parts/Hour");
		$pdf->SetXY(520,162);
		$pdf->Write(16,"# People");

		$mname=$routing['machine_name'];
		$mname=$routing['machine_name'];
		$opname=$routing['operation_name'];
		$wname=$routing['workcenter_name'];
		$pph=$routing['pph'];
		$units=$routing['units'];

		$pdf->SetXY(30,178);
		$pdf->Write(16,$operationSequence);
		$pdf->SetXY(60,162);
		$pdf->SetFont("helvetica", "B",16);
		$pdf->Write(16,$opname);
		$pdf->SetFont("helvetica", "",16);
		$pdf->SetXY(220,162);
		$pdf->Write(16,$wname);
		$pdf->SetXY(320,162);
		$pdf->Write(16,$mname);
		$pdf->SetXY(420,162);
		$pdf->Write(16,$pph);
		$pdf->SetXY(520,162);
		$pdf->Write(16,$units);
		$pdf->SetFont("helvetica", "",16);

		$notes=$routing['notes'];
		$notes=str_replace("<br />","<br>",$notes);
		$retval.=$notes;

		$pdf->SetXY(30,210);
		$pdf->WriteHTML(10,$retval);

		$pdf->SetFont("helvetica", "",16);
		$pdf->SetXY(400,210);
		$pdf->Write(16,"Date/Time       Qty      Who");

		$base=226;
		while ($base < 354) {
			$pdf->SetXY(400,$base);
			$pdf->Write(16,"_______________ ________ _______");
			$base+=16;
		}

		$pdf->SetXY(400,370);
		$pdf->Write(16,"Defect       Qty      Who");
		$pdf->SetXY(400,386);
		$pdf->Write(16,"_______________ ________ _______");
		$pdf->SetXY(400,402);
		$pdf->Write(16,"_______________ ________ _______");
		$pdf->SetXY(400,418);
		$pdf->Write(16,"_______________ ________ _______");

		$sql = "select * from billofmaterial where parent_item=? and routing_id=? ";

		if ($operationSequence==10) $sql = "select * from billofmaterial where parent_item=? and (routing_id=? or routing_id=0)  ";

		$sql .= " order by child_item ";
		list($rs,$err)=runIQuery($db,$sql,array("si",$part,$routingID));

		if (count($rs)>0 ) {
			$pdf->Line(20,600,600,600);
			$base=617;
			$pdf->SetXY(30,601);
			$pdf->Write(16,"Qty Per");
			$pdf->SetXY(90,601);
			$pdf->Write(16,"Qty");
			$pdf->SetXY(120,601);
			$pdf->Write(16,"Component");
			$pdf->SetXY(180,601);
			$pdf->Write(16,"Description");
			$pdf->SetXY(450,601);
			$pdf->Write(16,"Drawing");
			$pdf->SetXY(540,601);
			$pdf->Write(16,"Rev");
		}

		foreach ($rs as $data) {
			$childItem=$data['child_item'];
			$qtyper=$data['quantity_per'];
			$childInfo=getItemData($db,$childItem);
			$cdescription=$childInfo['item_description'];
			$tq=$quantity * $qtyper;
			$dwg=$childInfo['drawing'];
			$rev=$childInfo['revision'];

			$pdf->SetXY(30,$base);
			$pdf->Write(16,$qtyper);
			$pdf->SetXY(90,$base);
			$pdf->Write(16,$tq);
			$pdf->SetXY(120,$base);
			$pdf->Write(16,$childItem);
			$pdf->SetXY(450,$base);
			$pdf->Write(16,$dwg);
			$pdf->SetXY(540,$base);
			$pdf->Write(16,$rev);
			$pdf->SetXY(180,$base);
			$pdf->Write(16,$cdesc);

			$lines=multiLine($cdesc,60);
			$lc=0;
			foreach ($lines as $line) {
				if ($lc > 0) $base+=16;

				$pdf->SetXY(180,$base);
				$pdf->Write(16,$line);

				$lc++;
			}

			$rowh+=$extra;
			$base+=16;
		}

		$pdf->Line(20,$base,600,$base);

		$pdf->Line(20,600,20,$base);
		$pdf->Line(600,600,600,$base);

		$pdf->Image("images/logo.jpg",12,10,100);
	}
}

if ($type=='SO') {
	$sql="select order_lines.*, uom_name, drawing from order_lines left outer join items on item_name=order_lines.item_id left outer join units_of_measure on unit_of_measure=uom_id where order_id=? order by coalesce(po_line,0) * 1, line_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$page=0;
	$numPages=floor(count($rs)/25);
	if ($numPages*25 < count($rs)) $numPages++;
	$numPages++;

	$lc=26;

	$baseTot=0;
	$nowTot=0;
	$potot=0;
	$base=215;
    $sql="select orders.order_type, order_types.factor, order_types.type_name, orders.customer_id, orders.status, customers.show_bom, customers.separate_expedite from orders, customers, order_types where order_id=? and orders.customer_id=customers.customer_id and orders.order_type=order_types.type_id";
	list($ors,$err)=runIQuery($db,$sql,array("i",$id));
    $odata=$ors[0];
    $customerID=$odata["customer_id"];
    $status=$odata["status"];
	$showBOM=$odata["show_bom"];
	$orderType=$odata["order_type"];
	$typeFactor=$odata["factor"];
	$typeName=$odata["type_name"];
	$separateExpedite = $odata["separate_expedite"];

	$totalMOQ=0;
	foreach ($rs as $data) {
		$lc++;
		if ($lc > 25 || ($status == 6 && $base > 600) || ($base > 640)) {
			$page++;
			$pdf=returnSOHeader($db,$pdf,$id,$page,$numPages);
			$lc=1;
			$base=215;
		}
		$pdf->SetFont("helvetica","",8,'',false);
		$pdf->SetXY(22, $base);
		$font=9;
		$pdf->SetFont("helvetica","",$font,'',false);
		$poLine=trim($data['po_line']);

		while ($pdf->GetStringWidth($poLine) > 30) {
			$font-=.5;
			$pdf->SetFont("helvetica","",$font,'',false);
		}

		$pdf->Write(10,$poLine);
		$pdf->SetFont("helvetica","",9,'',false);

		$rowh=8;
		$pdf->SetXY(59,$base);
		$part=$data['item_id'];
		if ($data['item_id'] != 'MISC.') $pdf->Write(10,$data['item_id']);
		else $pdf->Write(10,"See Description");

		// show ops on SO's -Josh 02/18/2023
		$ops = generateAllOps($data["item_id"]);
		if (count($ops)) {
			$ops = implode(",", $ops);
			$opsfont = 8;
			$pdf->SetFont("helvetica","b",$opsfont,"",false);
			while ($pdf->GetStringWidth("OPS: $ops") > 140) {
				$opsfont-=.5;
				$pdf->SetFont("helvetica","b",$opsfont,"",false);
			}

			$base+=9;
			$pdf->SetXY(59,$base);
			$pdf->Write(10,"OPS: ");
			$pdf->SetFont("helvetica","",$opsfont,"",false);
			$pdf->Write(10,$ops);
			$pdf->SetFont("helvetica","",9,'',false);
			$base-=2;
		}

		$description=$data['item_description'];
		$colorID=$data['powder_color'];
		if ($colorID) {
			$sql="select color_code from vendor_colors where vc_id=?";
			list($crs,$err)=runIQuery($db,$sql,array("i",$colorID));
			if (count($crs)>0) {
				$colorCode=$crs[0][0];
				if (! strstr($description,$colorCode)) {
					$description.=" " . $colorCode;
				}
			}
		}

		$lines=multiLine($description,38);
		$extra=0;
		if (count($lines) == 0) $extra = 8;
		foreach ($lines as $line) {
			$pdf->SetXY(195,$base+$extra-5);
			$pdf->Write(10,$line);
			$extra+=8;
		}

		if (trim($data['drawing'])) {
			$dwg=trim($data['drawing']);
			if ($data['revision']) $dwg.=" REV " . $data['revision'];

			$pdf->SetXY(230,$base+$extra);
			$pdf->Write(10,$dwg);

			$extra+=8;
		}

		$trowh=8+$extra;
		if ($trowh > $rowh) $rowh=$trowh;

		$pdf->SetXY(402, $base);
		$pdf->Write(10,$data['quantity']);

		// customer 693 is dematic
		if ($customerID == 693 && $data['quantity'] < 10) {
			$totalMOQ += 75;
		}
		//QTY HERE
		$pdf->SetXY(450, $base);



		$basePrice = 0;
		$nowPrice = 0;
		$baseExt = 0;
		$nowExt = 0;
		$price = '';
		if (isset($_GET['price'])) $price = $_GET['price'];
		if ($price !='no') {
			$basePrice = $data['price'];
			$typeExtra = $basePrice*$typeFactor/100;
			$nowPrice = $basePrice+$typeExtra;
			$baseExt=round($basePrice*$data["quantity"],2);
			$nowExt=round($nowPrice*$data["quantity"],2);
			$ext=round($data['price'] * $data['quantity'],2);

			// pricing changes -Josh 01-13-2023
			$shownPrice = $nowPrice;
			$shownExt = $nowExt;
			if ($separateExpedite) {
				$shownPrice = $basePrice;
				$shownExt = $baseExt;
			}

			$pdf->SetFont("helvetica","",8);
			$offset=475 - $pdf->GetStringWidth(number_format($shownPrice,2));
			$pdf->SetXY($offset, $base);
			$pdf->Write(10,number_format($shownPrice,2));

			$pdf->SetFont("helvetica","",9);
			$pdf->SetXY(480, $base);
			$pdf->Write(10,number_format($shownExt,2));
		}

		//$potot+=$ext;
		$baseTot+=$baseExt;
		$nowTot+=$nowExt;


		$pdf->SetXY(530, $base);
		$pdf->Write(10,formatDateDBToWeb($data['due_date']));
		$base+=$rowh;

		$lineLeft = 20;
		$lineRight = 600;
		if ($showBOM and $status == 6) {
			## not for dematic
			## show bom 4 levels deep
			$pdf->SetXY(20, $base);
			$offset=0;
			$part=$data['item_id'];
			$sql="select child_item, quantity_per, item_description from billofmaterial, items where parent_item=? and child_item=item_name";
			list($brs,$err)=runIQuery($db,$sql,array("s",$part));
			$originalQty=$data['quantity'];
			$pdf->SetFont("helvetica","",9);
			foreach ($brs as $bdata) {
				$qtyper=$bdata['quantity_per'];
                if ($qtyper ==0) {
                    $qtyper=1;
                }
                $originalOffset=$offset+10;
				$originalQty2=$qtyper*$originalQty;
				$pdf->SetXY(23, $base);
				$pdf->Write(10,$originalQty2);
				$pdf->SetXY(92+$originalOffset,$base);
				$child=$bdata['child_item'];
				$pdf->Write(10,$child);
                $pdf->SetXY(230,$base);
                $pdf->Write(10,$bdata['item_description']);
            	$base+=10;
                $sql="select child_item, quantity_per, item_description from billofmaterial, items where parent_item=? and child_item=item_name";
				list($brs2,$err)=runIQuery($db,$sql,array("s",$child));
				foreach ($brs2 as $bdata2) {
					$qtyper=$bdata2['quantity_per'];
                    if ($qtyper ==0) {
                        $qtyper=1;
                    }
                    $originalOffset2=$originalOffset+10;
					$originalQty3=$qtyper*$originalQty2;
					$pdf->SetXY(23, $base);
					$pdf->Write(10,$originalQty3);
					$pdf->SetXY(92+$originalOffset2,$base);
					$child=$bdata2['child_item'];
					$pdf->Write(10,$child);
                    $pdf->SetXY(230,$base);
					$pdf->Write(10,$bdata2['item_description']);
                    $base+=10;
                    $sql="select child_item, quantity_per, item_description from billofmaterial, items where parent_item=? and child_item=item_name";
					list($brs3,$err)=runIQuery($db,$sql,array("s",$child));
					foreach ($brs3 as $bdata3) {
						$qtyper=$bdata3['quantity_per'];
						$originalOffset3=$originalOffset2+10;
                        if ($qtyper ==0) {
                            $qtyper=1;
                        }
                        $originalQty4=$qtyper*$originalQty3;
						$pdf->SetXY(23, $base);
						$pdf->Write(10,$originalQty4);
						$pdf->SetXY(92+$originalOffset3,$base);
						$child=$bdata['child_item'];
						$pdf->Write(10,$child);
                        $pdf->SetXY(230,$base);
                        $pdf->Write(10,$bdata3['item_description']);
                            $base+=10;
                        $sql="select child_item, quantity_per, item_description from billofmaterial, items where parent_item=? and child_item=item_name";
						list($brs4,$err)=runIQuery($db,$sql,array("s",$child));
						foreach ($brs4 as $bdata4) {
							$qtyper=$bdata4['quantity_per'];
                            if ($qtyper ==0) {
                                $qtyper=1;
                            }
							$originalOffset4=$originalOffset3+10;
							$originalQty5=$qtyper*$originalQty4;
							$pdf->SetXY(23, $base);
							$pdf->Write(10,$originalQty5);
							$pdf->SetXY(92+$originalOffset4,$base);
							$child=$bdata['child_item'];
							$pdf->Write(10,$child);
                            $pdf->SetXY(230,$base);
                            $pdf->Write(10,$bdata4['item_description']);
                            $base+=10;
						}
					}

				}

			}
		}
		//Item lines -Josh 02-03-2022
		$pdf->Line($lineLeft,$base,$lineRight,$base, array('width' => 0.1));
	}

	$sql="select * from orders where order_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];

	$status=$data['status'];
	$customerID=$data['customer_id'];
	$ship_name=$data['ship_name'];
	$ship_address=$data['ship_address'];
	$sql="select standard_shipping from customers where customer_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$data=$rs[0];
	$shipping=$data['standard_shipping'];
	$sql="select * from customer_shiptos where customer_id=? and ship_name=? and ship_address=? ";
	list($srs,$err)=runIQuery($db,$sql,array("iss",$customerID,$ship_name,$ship_address));

	if (count($srs)>0) {
		$sdata=$srs[0];
		if ($sdata['shipping_cost'] > 0) {
			$shipping=$sdata['shipping_cost'];
		}
	}

	## cma 9/7/22 shutting this off for now
	#if ($shipping > 0) {
	#	$pdf->SetXY(441, $base);
	#	$pdf->SetFont("helvetica","",6.5);
	#	$pdf->Write(10,"Est Shipping");
	#	$pdf->SetFont("helvetica","",8);
	#	$pdf->SetXY(480, $base);
	#	$pdf->Write(10,number_format($shipping,2));
	#	$base+=$rowh;
	#	$potot+=$shipping;
	#}

	// pricing changes -Josh 01-13-2023
	if ($separateExpedite) {
		if ($nowTot != $baseTot) {
			$feeTot = $nowTot-$baseTot;
			$feeType="$typeName Fee";
			if ($nowTot < $baseTot) {
				$feeType="$typeName";
			}

			$pdf->SetXY(59,$base);
			$pdf->Write(10,$feeType);
			$pdf->SetXY(450, $base);
			$pdf->Write(10,$feeTot);
			$pdf->SetXY(402, $base);
			$pdf->Write(10,1);
			$pdf->SetXY(480, $base);
			$pdf->Write(10,$feeTot);
			$base+=15;
			$pdf->Line($lineLeft,$base,$lineRight,$base, array('width' => 0.1));
		}
	}

	// add dematic MOQ -Josh 01-02-2023
	// 693 is dematic
	if ($customerID == 693 && $totalMOQ != 0) { // MOQ, add $75 line item
		$moqQTY = $totalMOQ/75;
		$pdf->SetXY(59,$base);
		$pdf->Write(10,"Minimum Order Quantity Fee");
		$baseTot+=$totalMOQ;
		$nowTot+=$totalMOQ;
		$pdf->SetXY(450, $base);
		$pdf->Write(10,75);
		$pdf->SetXY(402, $base);
		$pdf->Write(10,$moqQTY);
		$pdf->SetXY(480, $base);
		$pdf->Write(10,$totalMOQ);
		$base+=15;
		$pdf->Line($lineLeft,$base,$lineRight,$base, array('width' => 0.1));
	}

	$pdf->SetFont("helvetica","",8);

	if (isset($status) && $status == 6) {
		$pdf->SetXY(20, 703);
		$pdf->Write(8,"Quote is based on customer supplied electronic CAD data. A programming fee will be charged if we have to draw or re-work parts.");
		$pdf->SetXY(20, 713);
		$pdf->Write(8,"Preferred Machine, LLC does not assume liability for part design of customer. Preferred Machine, LLC's general tolerances will be used if it is NOT specified");
		$pdf->SetXY(20,723);
		$pdf->Write(8, "on customer print/CAD data. Please contact orders@preferredmachinellc.com for current tolerances. Pricing is subject to current material pricing");
		$pdf->SetXY(20,733);
		$pdf->Write(8, "at the time your order is placed. Quote includes material, unless noted otherwise.");
	}

	if ($lc > 25 || ($status == 6 && $base > 600) || ($base > 640)) {
		$page++;
		$pdf=returnSOHeader($db,$pdf,$id,$page,$numPages);
		$lc=1;
		$base=215;
	}

	$pdf->SetFont("helvetica","b",9);
	$base+=5;
	if ($numPages > 0 and $price !='no') {
		$pdf->SetXY(442, $base);
		$pdf->Write(10,"Total");
		$pdf->SetXY(480, $base);

		$pdf->Write(10,number_format($nowTot,2));

		if (isset($status) && $status == 6) {
			$priceBase = $base;
			$pdf->SetFont("helvetica","b",10);
			$sql = "select * from order_types where factor >= 0 order by factor desc ";
			list($otrs,$err)=runIQuery($db,$sql);
			$pdf->SetXY(197	, $priceBase);
			$pdf->Write(10,"Pricing Options");
			$pdf->Line(195,$priceBase+14,395,$priceBase+14,["width"=>0.1]);
			foreach ($otrs as $ot) {
				if ($ot["type_id"] == $orderType) {
					$pdf->SetFont("helvetica","b",10);
				} else {
					$pdf->SetFont("helvetica","",10);
				}
				$pdf->SetXY(197, $priceBase += 14.5);
				$pdf->Write(10,$ot["type_name"] . " ");
				$pdf->SetXY(270, $priceBase);
				if ($ot["type_id"] == $orderType) {
					$pdf->Write(10,"Current Total " . number_format($nowTot+($nowTot*$ot["factor"]/100),2));
				} else {
					$pdf->Write(10,"New Total " . number_format($nowTot+($nowTot*$ot["factor"]/100),2));
				}
				$pdf->Line(195,$priceBase+14,395,$priceBase+14, array('width' => 0.1));
			}
			$pdf->Line(195,$base,195,$priceBase+14, array('width' => 0.1));
			$pdf->Line(395,$base,395,$priceBase+14, array('width' => 0.1));
			$pdf->Line(195,$base,395,$base, array('width' => 0.1));


			$pdf->SetFont("helvetica","",9,'',false);
		}

	}

	$pdf=returnSOHeader($db,$pdf,$id,$page+1,$numPages,0);
	$lc=1;
	$base=200;
	$pdf->SetFont("helvetica","",9,'',false);

	if (isset($status) && $status == 6) {

		$base += 20;		## quote
		$pdf->SetXY(20,$base);
		$pdf->Write(10, "Due to material type and market volatility, price is subject to change. ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(10, "Pricing good for 5 business days contingent on  material  availability.  All amounts are stated in ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "U.S. dollars and must be paid in U.S. dollars.  Quote includes material cost, unless otherwise noted, ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "and is based on customer supplied electronic CAD data.  Changes requested after a quote has been ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "submitted may invalidate quoted pricing.  These changes include, but are not limited to, increase or ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "decrease in part quantity, modifications to prints or CAD data, and deviations of material type or thickness.");
		$base+=11;
		$base+=10;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Unless quoted as such, orders required to be completed within Preferred Machine, LLC's expedite window will incur");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "the normal expediting fees in addition to the quoted pricing.  This will be factored automatically on a ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "per part basis, and will not show as a separate line on an invoice.");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Please contact orders@preferredmachinellc.com for current expedite window.");
		$base+=11;
	}

	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine, LLC does not assume liability for customer part design.  A setup fee will be applied if Preferred");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Machine, LLC is required to draw or re-work customer supplied prints or CAD data.  Preferred Machine, LLC's general ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "tolerances will be used if tolerances are not specified on customer supplied prints or CAD data.");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Please contact orders@preferredmachinellc.com for current tolerances.");
	$base+=11;
	$base+=10;


	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine, LLC applies an expedite fee to all orders that are required to be completed four business");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "days or less from the date a purchase order is received.  Preferred Machine, LLC's cutoff time for receiving");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "purchase orders is 3:00 PM.  All purchase orders received after 3:00 PM will be considered as received");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "on the following business day at 8:00 AM.");
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine, LLC stocks a large number of material types and thicknesses.  Any material type or");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "thickness that is not a stocked material is referred to as Custom Material.  When a Custom Material is");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "requested, Preferred Machine, LLC will charge for the full amount of material ordered.  Any remaining ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "material drops will be scrapped, unless requested to be included with the order when complete.  Please");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "contact orders@preferredmachinellc.com for a current material stock list.");
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "All orders falling below a $50.00 total are subject to Preferred Machine, LLC's minimum order charge, unless ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "otherwise noted.  Shipping costs are not factored into order total, and therefore will not be included when");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "determining if an order falls below the minimum order charge threshold of $50.00.");
	$pdf->SetFont("helvetica","B",10,'',false);
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"SKID RETURN POLICY:");
	$pdf->SetFont("helvetica","",10,'',false);
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"In order to control delivery costs, Preferred Machine, LLC asks that you return skids and pallets.  ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Please work with Preferred Delivery Service drivers, or contact Preferred Delivery Service at ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"corey@preferreddeliveries.com to arrange for pick up.");
	$base+=11;
	$base+=10;
	$pdf->SetFont("helvetica","B",10,'',false);
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"MARKET VOLATILITY");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->SetFont("helvetica","",10,'',false);
	$pdf->Write(12,"Due to material type and market volatility, price is subject to change.");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Pricing is good for 5 business days contingent on material availability.");
}

if ($type=='PO') {
	$sql="select * from purchase_orders where po_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$data=$rs[0];

	$vendorID=$data['vendor_id'];

	$sql="select * from po_lines where po_id=? and quantity > 0 order by line_id";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$page=0;
	$numPages=floor(count($rs)/15);
	if ($numPages*15 < count($rs)) $numPages++;

	$lc=15;
	$potot=0;
	$base=215;

	foreach ($rs as $data) {
		$lc++;

		if ($lc > 15 or $base > 700) {
			$page++;
			$pdf=returnPOHeader($db,$pdf,$id,$page,$numPages);
			$lc=1;
			$base=215;
		}

		$pdf->SetFont("helvetica","",8);
		$offset=55 - $pdf->GetStringWidth($data['quantity']);
		$pdf->SetXY($offset, $base);

		$pdf->Write(10,$data['quantity']);

		$job=$data['job_id'];
		$sql="select l.order_id from jobs j, order_lines l where job_id=? and j.line_id=l.line_id ";
		list($jrs,$err)=runIQuery($db,$sql,array("i",$job));

		$jdata=$jrs[0];
		$so=$jdata['order_id'];
		## seaver wants batch number here
		if ($vendorID == 2225) {
			$sql="select batch_id from jobs_batch_orders where job_id=? ";
			list($jrs,$err)=runIQuery($db,$sql,array("i",$job));

			if (count($jrs)>0) {
				$jdata=$jrs[0];
				$so="B" . $jdata['batch_id'];
			}
		}

		$pdf->SetXY(70,$base);
		$pdf->Write(10,$so);

		$rowh=10;

		$itemInfo=getItemData($db,$data['item_id'],$vendorID);

		$pdf->SetXY(110,$base);

		$part=$itemInfo['item_name'];
		$itemID=$itemInfo['item_id'];
		$suffix=getVendorSuffix($db,$vendorID,$itemID,$data['quantity']);
		$fullpart=$part.$suffix;

		$pdf->SetFont("helvetica","",8);
		$font=8;

		while ($pdf->GetStringWidth($fullpart) > 85) {
			$font-=.5;
			$pdf->SetFont("helvetica","",$font);
		}

		$pdf->Write(10,$part . $suffix);
		$pdf->SetFont("helvetica","",8);
		$pdf->SetXY(200,$base);
		$pdf->Write(10,$itemInfo['uom_name']);

		$lines=multiLine($data['description'],30);

		if ($itemInfo['vendor_part_number'] and $itemInfo['vendor_id']==$vendorID) $lines=multiLine($itemInfo['vendor_part_number'],30);

		$sql="select * from items_vendors where item_id=? and vendor_id=?";
		list($rs,$err)=runIQUery($db,$sql,array("ii",$data['item_id'],$vendorID));

		if (count($rs)>0) {
			$vdata=$rs[0];
			$description=$vdata['vendor_description'];
		}

		$extra=0;
		if (count($lines) == 0) $extra = 8;
		foreach ($lines as $line) {
			$pdf->SetXY(230,$base+$extra);
			$pdf->Write(10,$line);
			$extra+=10;
		}

		$trowh=10+$extra;
		if ($trowh > $rowh) $rowh=$trowh;

		$decimals=4;

		if ($data['price']==round($data['price'],3)) $decimals=3;

		if ($data['price']== round($data['price'],2)) $decimals=2;

		$offset=444 - $pdf->GetStringWidth(number_format($data['price'],$decimals));

		$pdf->SetXY($offset, $base);
		$pdf->Write(10,number_format($data['price'],$decimals));

		$ext=round($data['price'] * $data['quantity'],2);
		$potot+=$ext;
		$offset=520 - $pdf->GetStringWidth(number_format($ext,2));

		$pdf->SetXY($offset, $base);
		$pdf->Write(10,number_format($ext,2));
		$pdf->SetXY(530, $base);
		$pdf->Write(10,formatDateDBToWeb($data['date_expected']));

		$base+=$rowh;

		$lineTop = 200;
		$lineLeft = 20;
		$lineRight = 600;
		$lineBottom = 760;

		//Item lines -Josh 02-03-2022
		$pdf->Line($lineLeft,$base-5,$lineRight,$base-5, array('width' => 0.1));
	}

	if ($numPages > 0) {
		$pdf->SetXY(420, $base);
		$pdf->SetFont("helvetica","B",10);
		$pdf->Write(10,"Total");
		$pdf->SetFont("helvetica","",10);

		$offset=520 - $pdf->GetStringWidth(number_format($potot,2));

		$pdf->SetXY($offset, $base);
		$pdf->Write(10,number_format($potot,2));
		$pdf->SetFont("helvetica","",8);
		if (isset($status) && $status == 6) {
			$pdf->SetXY(20, 703);
			$pdf->Write(8,"    Quote is based on customer supplied electronic CAD data. A programming fee will be charged if we have to draw or re-work parts. Preferred Machine, LLC does not assume liability for part design of customer.  Preferred Machine, LLC's general tolerances will be used if it is NOT specified on customer print/CAD data. Please contact orders@preferredmachinellc.com for current tolerances. Pricing is subject to current material pricing at the time your order is placed. Quote includes material, unless noted otherwise.");
		}
	}
}

if ($type=='PS') {
	$idlist=array();
	$lineTop = 200;
	$lineLeft = 20;
	$lineRight = 600;
	$lineBottom = 760;

	if (isset($_GET['bol'])){
		$bol=$_GET['bol'];
		$sql="select distinct packing_slip from bol_skids where bol_id=? order by packing_slip";
		list($rs,$err)=runIQuery($db,$sql,array("i",$bol));
		foreach ($rs as $data) $idlist[]=$data['packing_slip'];

	} else $idlist[]=$id;

	foreach ($idlist as $id) {
		$sql="select packing_slip_lines.*, drawing, revision from packing_slip_lines left outer join items on items.item_name=packing_slip_lines.part_number where packing_list_id=?  order by po_number, CAST(po_line as SIGNED) ";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$page=0;
		$numPages=floor(count($rs)/15);
		if ($numPages*15 < count($rs)) $numPages++;

		$lc=15;
		$potot=0;
		$base=207;



		foreach ($rs as $data) {
			$part=$data['part_number'];
			$ok=1;
			if (strstr(strtoupper($part),"CHARGE")) {
				if (! strstr(strtoupper($part),"CHARGER")) {
					$ok=0;
				}
			}
			if ($ok) {

				$lc++;

				if ($lc > 15 or $base > 680) {
					$page++;
					$pdf=returnPSHeader($db,$pdf,$id,$page,$numPages);
					$lc=1;
					$base=207;
				}

				$pdf->SetXY(24, $base);

				$sql="select due_date from order_lines where order_lines.line_id=?";
				list($drs,$err)=runIQuery($db,$sql,array("i",$data['order_line']));
				if (count($drs) > 0) {
					$ldata=$drs[0];
					$pdf->Write(10,formatDateDBToWeb($ldata["due_date"]));
				}
				$rowh=10;


				$pdf->SetXY(79,$base);
				if ($data['part_number'] != 'Miscellaneous') $pdf->Write(10,$data['part_number']);
				else $pdf->Write(10,"See Description");

				$pdf->SetXY(225,$base);
				$pdf->Write(10,$data["quantity"]);

				$lines=multiLine($data['description'],42);
				$extra=0;
				if (count($lines) == 0) $extra = 8;
				foreach ($lines as $line) {
					$pdf->SetXY(252,$base+$extra);
					$pdf->Write(10,$line);
					$extra+=10;
				}

				$trowh=10+$extra;
				if ($trowh > $rowh) $rowh=$trowh;

				$pdf->SetXY(464, $base);
				if ($data['po_line']!='0') {
					$line = $data["po_line"];
					if (is_numeric($line)) {
						$num = 4 - strlen($line);
						if ($num > 0) {
							$line = str_repeat("0", $num) . $line;
						}
					}
					$pdf->Write(10,$line);
				}

				$pdf->SetXY(502, $base);
				$pdf->Write(10,$data["order_id"]);

				$pdf->SetXY(544,$base);
				$pdf->Write(10,$data["po_number"]);

				$base+=$rowh;
				//Item lines -Josh 02-03-2022
				$pdf->Line($lineLeft,$base-10,$lineRight,$base-10, array('width' => 0.1));
			}
		}
	}
}

if ($type=='MT') {
	$lineTop = 162;
	$lineBottom = 690;
	$lineLeft = 20;
	$lineRight = 600;
	$sql = "SELECT tl.*, o.date_due, o.po_number as customer_po FROM transfer_lines tl
	LEFT OUTER JOIN orders o ON tl.so_number=o.order_id
	WHERE tl.packing_slip=?
	ORDER BY tl.txid";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	$page=0;
	$numPages=floor(count($rs)/15);
	if ($numPages*15 < count($rs)) $numPages++;

	$lc=15;
	$potot=0;
	$base=166;
	foreach ($rs as $lnum => $data) {
		$order_id = $data["so_number"];
		$customer_id = $data["customer_id"];
		$lc++;
		if ($lc > 15) {
			$page++;
			$pdf=returnMTHeader($db,$pdf,$id,$page,$numPages,$order_id,$customer_id);
			$lc=1;
			$base = 166;
		}
		$pdf->SetFont("helvetica","",10,'',false);

		$pdf->SetXY(25, $base);
		$pdf->Write(10,$lnum+1);
		$description=$data['description'];
		$rowh=10;
		$pdf->SetXY(60,$base);
		if ($data['part_number']!='Miscellaneous') $pdf->Write(10,$data['part_number']);
		else $pdf->Write(10,"See Description");
		$description=str_replace("Metal Finishing Technology","",$description);
		$colorCode=$data['color_name'];
		if (! $colorCode) {
			## get it from the order line
			$sql="select color_code from order_lines l, vendor_colors vc where l.order_id=? and l.item_id=? and l.powder_color=vc.vc_id";
			list($crs,$err)=runIQuery($db,$sql,array("is",$order_id,$data['part_number']));
			if (count($crs)>0) {
				$cdata=$crs[0];
				$colorCode=$cdata['color_code'];
			}
		}
		if ($colorCode) {
			if (! strstr(strtoupper($description),strtoupper($colorCode))) {
				$description=trim($description) . " " . $colorCode;
			}
		}
		$lines=multiLine($description,40);
		$extra=0;
		if (count($lines) == 0) $extra = 8;
		foreach ($lines as $line) {
			$pdf->SetXY(210,$base+$extra);
			$pdf->Write(10,$line);
			$extra+=10;
		}

		$pdf->SetXY(425,$base);
		$pdf->Write(10,$data['quantity']);

		$trowh=10+$extra;
		if ($trowh > $rowh) $rowh=$trowh;
		$pdf->SetXY(470, $base);
		$customer_po="";
		if (isset($data['customer_po'])) {
			$customer_po=$data['customer_po'];
		}
		$pdf->Write(10,$customer_po);

		$date_due="";
		if (!is_null($data['date_due'])) {
			$date_due=formatDateDBToWeb($data['date_due']);
		}
		$pdf->SetXY(537,$base);
		$pdf->Write(10,$date_due);

		$base+=$rowh;

		//Item lines -Josh 02-16-2022
		$pdf->Line($lineLeft,$base-5,$lineRight,$base-5, array('width' => 0.1));
	}

	$sql="select signed_by from transfers where packing_slip=?";
	list($rs,$err)=runIQuery($db,$sql,["i",$id]);
	$signedBy="";
	if(count($rs)) {
		$data=$rs[0];
		$signedBy=$data['signed_by'];
	}

	// Our Info
	$pdf->SetXY($lineLeft,$lineBottom+=13);
	$pdf->WriteHTML("Phone: 616.272.6334  Email: <a>shipping@preferredmachinellc.com</a> Accounts Payable: <a>ap@preferredmachinellc.com</a>");
	$pdf->SetXY($lineLeft,$lineBottom+=11);

	// Signature Stuff
	$pdf->SetFont("helvetica","",7,'',false);
	$pdf->Write(8,"By signing this packing slip, you are agreeing that the listed parts and quantities are accurate and acceptable.");
	$pdf->SetXY($lineLeft,$lineBottom+=10);
	$pdf->Write(8,"You will have 30 calendar days from the date below to claim any discrepancies.");
	$pdf->SetXY($lineLeft+160,$lineBottom+=15);
	$pdf->SetFont("helvetica","",11,'',false);
	if ($signedBy) { //? Note: Currently signed_by is not used in Weld
		try { //Added try/catch in the event that the credentials are incorrect -Josh 01/30/2022
			//include('s3.php');
			$dateSigned=formatDateDBToWeb($data['date_signed']);
			if ($isMT) {
				$dateSigned=formatDateDBToWeb($tdata['date_signed']);
			}
			// TODO: Verify with Chris that we want this/can even do this
			/*$s3client->registerStreamWrapper();
			$file="signature-MT$packSlip.png";
			if (file_exists("s3://$bucket/$file")) {
				$img = file_get_contents("s3://$bucket/$file");
				$pdf->Image("@".$img,410,721,100,40,'','','',true);
			}*/
			$pdf->Write(12,"Received By: $signedBy  Date: $dateSigned");
		} catch (Exception $err) {
			$pdf->Write(12,"Received By: _____________________________  Date: _____________");
		}
	} else {
		$pdf->Write(12,"Received By: _____________________________  Date: _____________");
	}

	// Transfer Note
	$pdf->SetXY($lineLeft,$lineBottom+=30);
	$pdf->SetFont("helvetica","",7,'',false);
	$pdf->Write(8,"In order to control delivery costs, Preferred Machine asks that you return skids and pallets.  Please work with Preferred Delivery Service drivers,");
	$pdf->SetXY($lineLeft,$lineBottom+=10);
	$pdf->SetFont("helvetica","",7,'',false);
	$pdf->WriteHTML("or contact Preferred Delivery Service at <a>corey@preferreddeliveries.com</a> to arrange for pick up.");
}


$sql="select distinct orders.order_id from po_lines, jobs, order_lines, orders where po_lines.job_id=jobs.job_id and jobs.line_id=order_lines.line_id  and order_lines.order_id = orders.order_id and po_lines.po_id=? and orders.status = 1";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));

foreach ($rs as $data) {
	$orderID=$data['order_id'];
	$sql="update orders set status=11, date_on_po=now() where order_id=? and status=1";
	list($updrs,$err)=runIQuery($db,$sql,array("i",$orderID));
	$sqlj="update order_lines sest line_status=11 where order_id=? and line_status=1";
	list($updrs,$err)=runIQuery($db,$sql,array("i",$orderID));
}
$pdf->Output("", "I");