<?php
#error_reporting(E_ALL);
#ini_set('display_errors','1');
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
## session start is now in dbconnection.php
include('functions.php');
include('security.php');

if (0) {
?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->
<!--[if !IE]><!--> <html lang="en" > <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <title>Render PDF</title>
</head>
<body>
<?php
}
include('tcpdf.php');
include('tcpdf_barcodes_1d.php');
$pdf = new TCPDF("L","pt",array(288, 216));
$pdf->SetAutoPageBreak(false, 0);
$pdf->setCellPaddings(0,0,0,0);
#$barcode = $pdf->addTTFfont('FREE3OF9.TTF', '', '', 32);
#$pdf->setFontSubsetting(false);
$pdf->SetLeftMargin(.20);
$pdf->SetRightMargin(.20);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->SetLineWidth(1);

$style = array(
    'position' => '',
    'align' => 'C',
    'stretch' => false,
    'fitwidth' => true,
    'cellfitalign' => '',
    'border' => false,
    'hpadding' => 'auto',
    'vpadding' => 'auto',
    'fgcolor' => array(0,0,0),
    'bgcolor' => false, //array(255,255,255),
    'text' => true,
    'font' => 'helvetica',
    'fontsize' => 6,
    'stretchtext' => 4
);

$orderList=explode(",",$_GET['list']);
foreach ($orderList as $list) {
    list($so,$job,$part,$qty,$due)=explode("|",$list);
    $sql="select notes from routing where parent_part=? and notes like 'PAINT COLOR%'";
    $color="";
    list($rs,$err)=runIQuery($db,$sql,array("s",$part));
    if (count($rs) > 0) {
        $data=$rs[0];
        $color=strtoupper($data[0]);
        list($prefix,$color,$rest)=explode("-",$color);
        $color=trim($color);
        if (trim($rest) <> "") {
            $color.="-" . $rest;
        }
        $color=str_replace("&NBSP;","",$color);
    }
    $pdf->AddPage();
    $pdf->Image("logoblank.jpg",0,0,288,216,'','','',true);
    $pdf->Image("images/logo.png",50,0,117,72,'','','',true);
    // enclosing box
    #$pdf->Rect(2,120,260,70);
    $pdf->SetFont("times","B",12,'',false);
    $pdf->Text(5,132,"WO: $job");
    $pdf->Text(144,132,"Qty: $qty");
    $pdf->Text(5,145,"Due: $due");
    $pdf->Text(144,145,"SO: $so");
    $pdf->Text(5,158,"Part:");
    $pdf->Text(120,158,$color);
    $pdf->Text(5,170, $part);
    // sideways end date
    $pdf->SetFont("timesb","",8,'',false);
    $pdf->Text(5,192,"Date Printed: " . Date("m/d/Y h:i"));
    $pdf->SetFont("timesb","",10,'',false);
    $pdf->Text(95,200,"preferredmachinellc.com");

    $pdf->SetXY(1,80);
    $pdf->write1DBarcode($part, 'C39', '', '', '', 36, 0.8, $style, 'N');
}

$pdf->Output("", "I");
?>