<?php

session_start();

#error_reporting(E_ERROR);

#ini_set('display_errors','on');

date_default_timezone_set("America/Detroit");

$id=$_GET['id'];

include('dbConnection.php');

include('functions.php');

include('security.php');

$id=$_GET['id'];

$type=$_GET['type'];




function multiLine($string,$max=60) {

	$lines=array();

	$stringlines=explode("\r\n",$string);

	foreach ($stringlines as $string) {

		$words=explode(" ",$string);

		$widx=0;

		$string="";

		while ($widx < count($words)) {

			$retstring="";

			$tooLong=0;

			while ($widx < count($words) and $tooLong==0 ) {

				if ($retstring) {

					$retstring.=" ";

				}						

				$oldstring=$retstring;

				$retstring.=$words[$widx];

				if (strlen($words[$widx])>$max) {

					if ($oldstring == "") {

						$retstring=substr($words[$widx],0,$max);

						$words[$widx]=substr($words[$widx],$max);

					} else {

						$retstring=$oldstring;

					}

					$tooLong=1;

				} else {

					if ( strlen($retstring)>$max) {

						$retstring=$oldstring;

						$tooLong=1;

					} else {

						$widx++;

					}

				}

			}

			if (trim($retstring)) {

				$lines[]=$retstring;

			}

		}	

	}

	return $lines;

}





?>

<!DOCTYPE html>

<!--[if IE 8]> <html lang="en" class="ie8"> <![endif]-->

<!--[if IE 9]> <html lang="en" class="ie9"> <![endif]-->

<!--[if !IE]><!--> <html lang="en" > <!--<![endif]-->

<head>

	<meta charset="utf-8">

	<title>Render PDF <?=$type?></title>

</head>

<body>

<?php

require_once('fpdf/fpdf.php');
require_once('fpdf/fpdi.php');

$pdf = new FPDI("P","pt","Letter");



$pdf->SetFont("Arial","",20);

$pdf->SetTextColor(0,0,0);





function returnPOHeader($db,$pdf,$po,$page,$numPages) {

	$pdf->AddPage("P","Letter");	

	$sql="select * from purchase_orders where po_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$po));

	$data=$rs[0];

	$vendorID=$data['vendor_id'];

	$who=$data['who'];

	$sql="select initials from site_admins where user_id=?";

	list($srs,$err)=runIQuery($db,$sql,array("i",$who));

	$sdata=$srs[0];

	$initials=$sdata[0];

	$ship_name=$data['ship_name'];

	$ship_address=$data['ship_address'];

	$ship_city=$data['ship_city'];

	$ship_state=$data['ship_state'];

	$ship_zip=$data['ship_zip'];

	$notes_to_vendor=strip_tags($data['notes_to_vendor']);

	$terms=$data['terms'];

	if (! $terms) {

		$terms="Net 30";

	}

	$retval="";

	$pdf->SetFont("Arial","B",14);

	$pdf->SetXY(450,20);

	$pdf->Write(14,"Purchase Order");

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(450,40);

	$pdf->Write(10,"Printed " . Date("m/d/Y h:i:s"));

	$sql="select * from company_shiptos ";

	list($rs,$err)=runIQuery($db,$sql);

	$codata=$rs[0];

	$sql="select * from vendors where vendor_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$vendorID));

	$vdata=$rs[0];

	$pdf->SetXY(40,100);

	$pdf->SetFont("Arial","B",10);
	$pdf->Write(10,"Vendor");

	$pdf->SetFont("Arial","",10);
	$pdf->SetXY(40,110);

	$pdf->Write(10,$vdata['vendor_name']);

	$pdf->SetXY(40,120);

	$pdf->Write(10,$vdata['address']);

	$pdf->SetXY(40,130);

	$pdf->Write(10,$vdata['city'] . ", " . $vdata['state'] . " " . $vdata['zip']);

	$pdf->SetXY(40,140);

	$pdf->Write(10,$vdata['phone']);

	$pdf->SetXY(320,100);

	$pdf->SetFont("Arial","B",10);
	$pdf->Write(10,"Ship To");
	$pdf->SetFont("Arial","",10);

	if ($ship_name != $codata['ship_name'] or $ship_address!=$codata['ship_address']) {

		$pdf->SetXY(320,110);

		$pdf->Write(10,$ship_name);

		$pdf->SetXY(320,120);

		$pdf->Write(10,$ship_address);

		$pdf->SetXY(320,130);

		$pdf->Write(10,"$ship_city, $ship_state $ship_zip");

	} else {

		$pdf->SetXY(320,110);

		$pdf->Write(10,$codata['ship_name']);

		$pdf->SetXY(320,120);

		$pdf->Write(10,$codata['ship_address']);

		$pdf->SetXY(320,130);

		$pdf->Write(10,$codata['ship_city'].", " . $codata['ship_state']." " . $codata['ship_zip']);

	}

	$pdf->SetXY(450,52);

	$pdf->Write(10,"PO Number: " . $po);

	$pdf->SetXY(450,64);

	$pdf->Write(10,"Terms: $terms");

	$pdf->SetXY(450,76);

	if (! $initials) {
		$initials=$who;
	}
	if ($initials) {		
		$pdf->Write(10,"Purchased By: $initials");
	}

	if ($notes_to_vendor) {

		$pdf->SetFont("Arial","B",10);

		$lines=multiLine($notes_to_vendor,120);

		$pdf->Rect(20,158,582,count($lines)*10+4);		

		$left=306;

		foreach ($lines as $line) {

			$tryleft=306 - $pdf->GetStringWidth($line)/2;		

			if ($tryleft < $left) {

				$left=$tryleft;

			}

		}

		$lc=0;

		foreach ($lines as $line) {

			$pdf->SetXY($left, 160 + ($lc*10) );

			$lc++;

			$pdf->Write(10, $line);

		}

		$pdf->SetFont("Arial","",10);

	}

	if ($numPages > 1) {

		$pdf->SetXY(20,185);

		$pdf->Write(10,"*** This is page $page of $numPages ***");

	}	

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(20, 200);

	$pdf->Write(10,"Quantity");

	$pdf->SetXY(70,200);
	$pdf->Write(10,"SO#");
	
	$pdf->SetXY(110, 200);

	$pdf->Write(10,"Item");

	$pdf->SetXY(200, 200);

	$pdf->Write(10,"Uom");

	$pdf->SetXY(230, 200);

	$pdf->Write(10,"Description");

	$pdf->SetXY(400, 200);

	$pdf->Write(10,"Rate");

	$pdf->SetXY(485, 200);

	$pdf->Write(10,"Amount");

	$pdf->SetXY(530, 200);

	$pdf->Write(10,"Date Due");

	$pdf->SetFont("Arial","",9);

	$pdf->Line(20,210,600,210);

	$pdf->Line(20,210,20,750);

	$pdf->Line(68,210,68,750);
	$pdf->Line(108,210,108,750);

	$pdf->Line(198,210,198,750);

	$pdf->Line(228,210,228,750);

	$pdf->Line(398,210,398,750);

	$pdf->Line(448,210,448,750);

	$pdf->Line(528,210,528,750);

	$pdf->Line(600,210,600,750);

	$pdf->Line(20,750,600,750);

	$pdf->Image("images/logo.png",12,10,100);

	return $pdf;

}

function returnPSHeader($db,$pdf,$po,$page,$numPages) {

	$pdf->AddPage("P","Letter");	

	$sql="select * from packing_slip where packing_slip_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$po));

	$data=$rs[0];

	$customerID=$data['customer_id'];

	$attention=$data['attention'];	

	$ship_name=$data['ship_name'];

	$ship_address=$data['ship_address'];

	$ship_address2=$data['ship_address2'];

	$ship_city=$data['ship_city'];

	$ship_state=$data['ship_state'];

	$ship_zip=$data['ship_zip'];

	$notes_to_customer=strip_tags($data['notes_to_customer']);
	$phone=$data['ship_phone'];

	$email=$data['ship_email'];

	$tracking_number=$data['tracking_number'];

	$ship_via=$data['ship_via'];

	$date_shipped=$data['date_shipped'];

	$retval="";

	$pdf->Image("images/logo.png",12,10,100);

	$pdf->SetFont("Arial","B",14);

	$pdf->SetXY(450,20);

	$pdf->Write(14,"Packing Slip");

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(450,40);

	$pdf->Write(14,"Slip# $po");

	$pdf->SetXY(450,50);

	$pdf->Write(10,"Printed " . Date("m/d/Y h:i:s"));

	$pdf->SetXY(450,60);

	$pdf->Write(10,"Shipped $date_shipped ");

	$sql="select * from company_shiptos ";

	list($rs,$err)=runIQuery($db,$sql);

	$codata=$rs[0];

	$pdf->SetXY(20,50);

	$pdf->Write(10,$codata['ship_name']);

	$pdf->SetXY(20,60);

	$pdf->Write(10,$codata['ship_address']);

	$pdf->SetXY(20,70);

	$pdf->Write(10,$codata['ship_city'].", ".$codata['ship_state']." ".$codata['ship_zip']);

	$pdf->SetXY(20,80);

	$pdf->Write(10,$codata['ship_phone']);

	$sql="select * from customers where customer_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));

	$vdata=$rs[0];

	$pdf->SetXY(40,100);

	$pdf->Write(10,"Customer");

	$pdf->SetXY(40,110);

	$pdf->Write(10,$vdata['name']);

	$pdf->SetXY(40,120);

	$pdf->Write(10,$vdata['address']);

	$pdf->SetXY(40,130);

	$pdf->Write(10,$vdata['city'] . ", " . $vdata['state'] . " " . $vdata['zip']);

	$pdf->SetXY(40,140);

	$pdf->Write(10,$vdata['phone']);

	$pdf->SetXY(420,100);

	$pdf->Write(10,"Ship To");

	$pdf->SetXY(420,110);

	$pdf->Write(10,$ship_name);

	$pdf->SetXY(420,120);

	$pdf->Write(10,$ship_address);

	$y=130;

	if ($ship_address2) {

		$pdf->SetXY(420,130);

		$pdf->Write(10,$ship_address2);

		$y+=10;

	}

	$pdf->SetXY(420,$y);

	$pdf->Write(10,"$ship_city, $ship_state $ship_zip");

	$pdf->SetXY(420,$y+10);

	$pdf->Write(10,$phone);

	$pdf->SetXY(450,50);

	$pdf->Write(10,"Packing Slip: " . $po);

	$pdf->SetXY(450,60);

	$pdf->Write(10,"Ship Via: $ship_via");

	if ($tracking_number) {

		$pdf->SetXY(450,70);

		$pdf->Write(10,"$tracking_number");

	}

	if ($notes_to_customer) {

		$pdf->SetFont("Arial","B",10);

		$lines=multiLine($notes_to_customer,120);

		$pdf->Rect(20,158,582,count($lines)*10+4);		

		$left=306;

		foreach ($lines as $line) {

			$tryleft=306 - $pdf->GetStringWidth($line)/2;		

			if ($tryleft < $left) {

				$left=$tryleft;

			}

		}

		$lc=0;

		foreach ($lines as $line) {

			$pdf->SetXY($left, 160 + ($lc*10) );

			$lc++;

			$pdf->Write(10, $line);

		}

		$pdf->SetFont("Arial","",10);

	}

	if ($numPages > 1) {

		$pdf->SetXY(20,180);

		$pdf->Write(10,"*** This is page $page of $numPages ***");

	}	

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(20, 200);

	$pdf->Write(10,"Quantity");

	$pdf->SetXY(90, 200);

	$pdf->Write(10,"Item");

	$pdf->SetXY(200, 200);

	$pdf->Write(10,"Uom");

	$pdf->SetXY(230, 200);

	$pdf->Write(10,"Description");

	$pdf->SetXY(446, 200);

	$pdf->Write(10,"PO Line");

	$pdf->SetFont("Arial","",9);

	$pdf->Line(20,210,600,210);

	$pdf->Line(20,210,20,750);

	$pdf->Line(88,210,88,750);

	$pdf->Line(198,210,198,750);

	$pdf->Line(228,210,228,750);

	$pdf->Line(448,210,448,750);

	$pdf->Line(478,210,478,750);

	$pdf->Line(528,210,528,750);

	$pdf->Line(600,210,600,750);

	$pdf->Line(20,750,600,750);

	return $pdf;

}



function returnMTHeader($db,$pdf,$po,$page,$numPages) {

	$pdf->AddPage("P","Letter");	

	$sql="select * from transfers where packing_slip=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$po));

	$data=$rs[0];

	$location=$data['location'];	

	$ship_name=$data['ship_name'];

	$ship_address=$data['ship_address'];

	$ship_city=$data['ship_city'];

	$ship_state=$data['ship_state'];

	$ship_zip=$data['ship_zip'];

	$notes_to_vendor=strip_tags($data['notes_to_customer']);

	$date_shipped=$data['transfer_date'];

	$retval="";

	$pdf->Image("images/logo.png",12,10,100);

	$pdf->SetFont("Arial","B",14);

	$pdf->SetXY(450,20);

	$pdf->Write(14,"MT Packing Slip");

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(450,40);

	$pdf->Write(10,"Printed " . Date("m/d/Y h:i:s"));

	$pdf->SetXY(450,50);

	$pdf->Write(10,"Shipped $date_shipped ");

	$pdf->SetXY(450,60);

	$pdf->Write(10,"MT Slip#: " . $po);

	$sql="select * from company_shiptos ";

	list($rs,$err)=runIQuery($db,$sql);

	$codata=$rs[0];

	$pdf->SetXY(20,50);

	$pdf->Write(10,$codata['ship_name']);

	$pdf->SetXY(20,60);

	$pdf->Write(10,$codata['ship_address']);

	$pdf->SetXY(20,70);

	$pdf->Write(10,$codata['ship_city'].", ".$codata['ship_state']." ".$codata['ship_zip']);

	$pdf->SetXY(20,80);

	$pdf->Write(10,$codata['ship_phone']);

	$pdf->SetXY(40,100);

	$pdf->Write(10,"Location");

	$pdf->SetXY(40,110);

	$pdf->Write(10,$location);

	$pdf->SetXY(420,100);

	$pdf->Write(10,"Ship To");

	$pdf->SetXY(420,110);

	$pdf->Write(10,$ship_name);

	$pdf->SetXY(420,120);

	$pdf->Write(10,$ship_address);

	$y=130;

	$pdf->SetXY(420,$y);

	$pdf->Write(10,"$ship_city, $ship_state $ship_zip");

	$pdf->SetXY(420,$y+10);

	$pdf->Write(10,$phone);

	$left=320-(strlen($notes_to_customer)/2*10);

	$pdf->SetXY($left,160);	

	$pdf->Write(10,nl2br($notes_to_customer));

	if ($numPages > 1) {

		$pdf->SetXY(20,180);

		$pdf->Write(10,"*** This is page $page of $numPages ***");

	}	

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(20, 200);

	$pdf->Write(10,"Quantity");

	$pdf->SetXY(90, 200);

	$pdf->Write(10,"Item");

	$pdf->SetXY(200, 200);

	$pdf->Write(10,"Uom");

	$pdf->SetXY(230, 200);

	$pdf->Write(10,"Description");

	$pdf->SetXY(450, 200);

	$pdf->Write(10,"PO Number");

	$pdf->SetFont("Arial","",9);

	$pdf->Line(20,210,600,210);

	$pdf->Line(20,210,20,750);

	$pdf->Line(88,210,88,750);

	$pdf->Line(198,210,198,750);

	$pdf->Line(228,210,228,750);

	$pdf->Line(448,210,448,750);

	$pdf->Line(478,210,478,750);

	$pdf->Line(528,210,528,750);

	$pdf->Line(600,210,600,750);

	$pdf->Line(20,750,600,750);

	return $pdf;

}



function returnSOHeader($db,$pdf,$so,$page,$numPages,$grid=1) {

	$pdf->AddPage("P","Letter");	

	$sql="select * from orders where order_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$so));

	$data=$rs[0];

	$customerID=$data['customer_id'];

	$who=$data['salesperson_id'];

	$ship_name=$data['ship_name'];

	$attention=$data['attention'];

	$ship_address=$data['ship_address'];

	$ship_address2=$data['ship_address2'];

	$ship_city=$data['ship_city'];

	$ship_state=$data['ship_state'];

	$ship_zip=$data['ship_zip'];
	$status=$data['status'];

	$notes_to_customer=strip_tags(html_entity_decode($data['notes_to_customer']));
	$notes_to_customer=str_replace("<br />"," ",$notes_to_customer);
	$po=$data['po_number'];

	$email=$data['email'];

	$phone=$data['phone'];

	$retval="";

	$pdf->SetFont("Arial","B",14);

	$pdf->SetXY(450,20);

	$status=$data['status'];
	if ($status == 6) {
		$pdf->Write(14,"Quote");
	} else {
		if ($_GET['confirm']=='yes') {
			$pdf->Write(14,"Order Confimation");
		} else {
			$pdf->Write(14,"Sales Order");
		}
	}

	$pdf->SetFont("Arial","",10);

	$pdf->SetXY(450,40);

	$pdf->Write(10,"Printed " . Date("m/d/Y h:i:s"));

	$sql="select * from customers where customer_id=? ";

	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));

	$cdata=$rs[0];

	
	$pdf->SetXY(40,100);

	$pdf->Write(10,"Bill To");

	$pdf->SetXY(40,110);

	$pdf->Write(10,$cdata['name']);

	$pdf->SetXY(40,120);

	$pdf->Write(10,$cdata['address']);

	$pdf->SetXY(40,130);

	$pdf->Write(10,$cdata['city'] . ", " . $cdata['state'] . " " . $cdata['zip']);

	$pdf->SetXY(40,140);

	$pdf->Write(10,$cdata['phone']);

	$pdf->SetXY(306,100);

	$pdf->Write(10,"Ship To");

	$baseShip=110;

	if ($attention) {

		$baseShip=120;

		$pdf->SetXY(306,110);

		$pdf->Write(10,$attention);

	}

	$pdf->SetXY(306,$baseShip);

	$pdf->Write(10,$ship_name);

	$baseShip+=10;

	if ($ship_address) {

		$pdf->SetXY(306,$baseShip);

		$pdf->Write(10,$ship_address);

		$baseShip+=10;

	}

	if ($ship_address2) {

		$pdf->SetXY(306,$baseShip);

		$pdf->Write(10,$ship_address2);

		$baseShip+=10;

	}

	if ($ship_city or $ship_state or $ship_zip) {

		$pdf->SetXY(306,$baseShip);	

		$pdf->Write(10,"$ship_city, $ship_state $ship_zip");	

		$baseShip+=10;

	}

	$pdf->SetXY(306,$baseShip);

	$pdf->Write(10,$phone);

	$baseShip+=10;

	$pdf->SetXY(450,50);

	if ($status == 6) {
		$pdf->Write(10,"Quote: $so");
	} else {
		$pdf->Write(10,"Sales Order: $so");
	}

	$pdf->SetXY(450,60);

	$pdf->Write(10,"PO Number: $po");

	$left=320-(strlen($notes_to_customer)/2*10);

	$pdf->SetXY(20,160);	

	$pdf->Write(10,$notes_to_customer);

	if ($numPages > 1) {

		$pdf->SetXY(20,180);

		$pdf->Write(10,"*** This is page $page of $numPages ***");

	}	
	if ($grid) {
		$pdf->SetFont("Arial","",9);

		$pdf->SetXY(20, 200);
	
		$pdf->Write(10,"Quantity");
	
		$pdf->SetXY(90, 200);
	
		$pdf->Write(10,"Item");
	
		$pdf->SetXY(200, 200);
	
		$pdf->Write(10,"Uom");
	
		$pdf->SetXY(230, 200);
	
		$pdf->Write(10,"Description");
	
		$pdf->SetXY(410, 200);
	
		$pdf->Write(10,"PO Line");
	
		$pdf->SetXY(450, 200);
	
		$pdf->Write(10,"Rate");
	
		$pdf->SetXY(480, 200);
	
		$pdf->Write(10,"Amount");
	
		$pdf->SetXY(530, 200);
	
		$pdf->Write(10,"Due Date");
	
		$pdf->SetFont("Arial","",8);
	
		$pdf->Line(20,210,600,210);
	
		$pdf->Line(20,210,20,700);
	
		$pdf->Line(88,210,88,700);
	
		$pdf->Line(198,210,198,700);
	
		$pdf->Line(228,210,228,700);
	
		$pdf->Line(413,210,413,700);
	
		$pdf->Line(440,210,440,700);
	
		$pdf->Line(478,210,478,700);
	
		$pdf->Line(528,210,528,700);
	
		$pdf->Line(600,210,600,700);
	
		$pdf->Line(20,700,600,700);
	}

	$pdf->Image("images/logo.png",12,10,100);

	return $pdf;

}

if ($type=='WO') {	

	$sql="select jobs.*, drawing, revision from jobs, items where job_id=? and jobs.item_id=items.item_name";

	list($rs,$err)=runIQuery($db,$sql,array("i",$job));

	$data=$rs[0];

	$part=$data['item_id'];

	$sequence=$data['sequence'];

	$datedue=formatDateDBToWeb($data['start_date']);

	$description=$data['description'];

	$quantity=$data['quantity_scheduled'];

	$drawing=$data['drawing'];

	$revision=$data['revision'];

	$sql="select name from customers, items where items.customer_id=customers.customer_id and item_name=?";

	list($crs,$err)=runIQuery($db,$sql,array("s",$part));

	$cdata=$crs[0];

	$customer=$cdata[0];

	$sql="select operations.operation_id, operation_name, machine_name, workcenter_name, pph, units, routing.routing_id, routing.display_sequence, notes from jobs, routing left outer join operations on routing.operation_id=operations.operation_id left outer join machines on routing.machine_id=machines.machine_id left outer join workcenters on routing.workcenter_id=workcenters.workcenter_id left outer join routing_text on routing.routing_id=routing_text.routing_id where routing.parent_part=jobs.item_id and jobs.job_id=? order by routing.display_sequence ";

	list($ors,$err)=runIQuery($db,$sql,array("i",$id));

	$numPages=count($ors);

	$page=0;

	foreach ($ors as $routing) {

		$page++;

		// header job info		

		$pdf->AddPage("P","Letter");	

		$pdf->SetFont('Arial','',16);

		$pdf->SetXY(200,20);

		$pdf->Write(16,"Operation Notes");

		$pdf->SetXY(300,20);

		$pdf->Write(16,"Printed " . Date("l, m/d/Y h:i:s"));

		// rectangle

		$pdf->Line(20,60,600,60);

		$pdf->Line(20,60,20,160);

		$pdf->Line(600,60,600,160);		

		$pdf->Line(20,160,600,160);

		$pdf->SetXY(30,62);

		$pdf->Write(16,"Production Order");		

		$pdf->SetXY(30,78);

		$pdf->Write(16,"Drawing/Rev:");		

		$pdf->SetXY(130,78);

		$pdf->Write(16,$drawing . " / ".$revision);		

		$pdf->SetXY(30,94);

		$pdf->Write(16,"Description");		

		$pdf->SetXY(130,94);

		$pdf->Write(16,$description);		

		$pdf->SetXY(30,110);

		$pdf->Write(16,"Customer:");		

		$pdf->SetXY(130,110);

		$pdf->SetFont('Arial','B',16);

		$pdf->Write(16,$customer);		

		$pdf->SetFont('Arial','',16);

		$pdf->SetXY(30,126);

		$pdf->Write(16,"Purchase Order(s)");		

		$pdf->SetXY(400,62);

		$pdf->Write(16,"Part");		

		$pdf->SetXY(400,78);

		$pdf->Write(16,"Due");		

		$pdf->SetXY(400,110);

		$pdf->Write(16,"Quantity");		

		$pdf->SetFont('Arial','B',24);

		$pdf->SetXY(130,62);

		$pdf->Write(24,$id);

		$pdf->SetXY(400,62);

		$pdf->Write(24,$part);

		$pdf->SetXY(400,78);

		$pdf->Write(24,$datedue);

		$pdf->SetXY(400,110);

		$pdf->Write(24,$quantity);



		// operation dependent information		

		

		$operationSequence=$routing['display_sequence'];

		$pdf->AddFont('FREE3OF9','','FREE3OF9.php');

		$pdf->SetFont('FREE3OF9','',36);

		$pdf->SetXY(300,40);

		$pdf->Write(36,"*".$id."-".$sequence."*");



		$routingID=$routing['routing_id'];

		$opid=$routing['operation_id'];

		

		$sql="select distinct po_id from po_lines where job_id=? and operation_id=?";

		list($prs,$err)=runIQuery($db,$sql,array("i",$job, $opid));

		$polist="";

		$comma="";

		foreach ($prs as $data) {

			$polist.=$comma;

			$polist.= $data['po_id'];

			$comma=", ";

		}

		$pdf->SetXY(130,126);

		$pdf->Write(16,$polist);		

		

		$pdf->SetFont('Arial','',16);

		$pdf->SetXY(30,162);

		$pdf->Write(16,"SEQ");

		$pdf->SetXY(60,162);

		$pdf->Write(16,"Operation");

		$pdf->SetXY(220,162);

		$pdf->Write(16,"Workcenter");

		$pdf->SetXY(320,162);

		$pdf->Write(16,"Machine");

		$pdf->SetXY(420,162);

		$pdf->Write(16,"Parts/Hour");

		$pdf->SetXY(520,162);

		$pdf->Write(16,"# People");



		$mname=$routing['machine_name'];

		$mname=$routing['machine_name'];

		$opname=$routing['operation_name'];

		$wname=$routing['workcenter_name'];

		$pph=$routing['pph'];

		$units=$routing['units'];



		$pdf->SetXY(30,178);

		$pdf->Write(16,$operationSequence);

		$pdf->SetXY(60,162);

		$pdf->SetFont('Arial','B',16);

		$pdf->Write(16,$opname);

		$pdf->SetFont('Arial','',16);

		$pdf->SetXY(220,162);

		$pdf->Write(16,$wname);

		$pdf->SetXY(320,162);

		$pdf->Write(16,$mname);

		$pdf->SetXY(420,162);

		$pdf->Write(16,$pph);

		$pdf->SetXY(520,162);

		$pdf->Write(16,$units);



		$pdf->SetFont('Arial','',16);

		

	
		$notes=$routing['notes'];
		$notes=str_replace("<br />","<br>",$notes);
		$retval.=$notes;

		$pdf->SetXY(30,210);

		$pdf->Write(400,WriteHTML($retval));			

		

		$pdf->SetFont('Arial','',16);

		$pdf->SetXY(400,210);

		$pdf->Write(16,"Date/Time       Qty      Who");

		$base=226;

		while ($base < 354) {

			$pdf->SetXY(400,$base);

			$pdf->Write(16,"_______________ ________ _______");

			$base+=16;

		}

		$pdf->SetXY(400,370);

		$pdf->Write("Defect       Qty      Who");

		$pdf->SetXY(400,386);

		$pdf->Write(16,"_______________ ________ _______");

		$pdf->SetXY(400,402);

		$pdf->Write(16,"_______________ ________ _______");

		$pdf->SetXY(400,418);

		$pdf->Write(16,"_______________ ________ _______");

		$sql="select * from billofmaterial where parent_item=? and routing_id=? ";

		if ($operationSequence==10) {

			$sql="select * from billofmaterial where parent_item=? and (routing_id=? or routing_id=0)  ";

		}

		$sql.=" order by child_item ";

		list($rs,$err)=runIQuery($db,$sql,array("si",$part,$routingID));

		if (count($rs)>0 ) {

			$pdf->Line(20,600,600,600);

			$base=617;

			$pdf->SetXY(30,601);

			$pdf->Write(16,"Qty Per");

			$pdf->SetXY(90,601);

			$pdf->Write(16,"Qty");

			$pdf->SetXY(120,601);

			$pdf->Write(16,"Component");

			$pdf->SetXY(180,601);

			$pdf->Write(16,"Description");

			$pdf->SetXY(450,601);

			$pdf->Write(16,"Drawing");

			$pdf->SetXY(540,601);

			$pdf->Write(16,"Rev");

		}

		foreach ($rs as $data) {

			$childItem=$data['child_item'];

			$qtyper=$data['quantity_per'];

			$childInfo=getItemData($db,$childItem);

			$cdescription=$childInfo['item_description'];

			$tq=$quantity * $qtyper;

			$dwg=$childInfo['drawing'];

			$rev=$childInfo['revision'];





			$pdf->SetXY(30,$base);

			$pdf->Write(16,$qtyper);

			$pdf->SetXY(90,$base);

			$pdf->Write(16,$tq);

			$pdf->SetXY(120,$base);

			$pdf->Write(16,$childItem);

			$pdf->SetXY(450,$base);

			$pdf->Write(16,$dwg);

			$pdf->SetXY(540,$base);

			$pdf->Write(16,$rev);

			$pdf->SetXY(180,$base);

			$pdf->Write(16,$cdesc);

			$lines=multiLine($cdesc,60);

			$lc=0;

			foreach ($lines as $line) {

				if ($lc > 0) {

					$base+=16;

				}

				$pdf->SetXY(180,$base);

				$pdf->Write(16,$line);

				$lc++;

			}

			$rowh+=$extra;



			$base+=16;

		}

		$pdf->Line(20,$base,600,$base);

		$pdf->Line(20,600,20,$base);

		$pdf->Line(600,600,600,$base);

		$pdf->Image("images/logo.png",12,10,100);

	}

function returnWOHeader($db,$pdf,$job,$page,$numPages) {

}



}



if ($type=='PO') {

	$sql="select * from purchase_orders where po_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$data=$rs[0];

	$vendorID=$data['vendor_id'];

	$sql="select * from po_lines where po_id=? and quantity > 0 order by line_id";

	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$page=0;

	$numPages=floor(count($rs)/15);

	if ($numPages*15 < count($rs)) {

		$numPages++;

	}

	$lc=15;

	$potot=0;

	$base=215;

	foreach ($rs as $data) {

		$lc++;

		if ($lc > 15 or $base > 700	) {

			$page++;

			$pdf=returnPOHeader($db,$pdf,$id,$page,$numPages);

			$lc=1;	

			$base=215;

		}

		$pdf->SetFont("Arial","",10);
		$offset=55 - $pdf->GetStringWidth($data['quantity']);
		$pdf->SetXY($offset, $base);	

		$pdf->Write(10,$data['quantity']);

		$job=$data['job_id'];
		$sql="select l.order_id from jobs j, order_lines l where job_id=? and j.line_id=l.line_id ";
		list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
		$jdata=$jrs[0];
		$so=$jdata['order_id'];
		## seaver wants batch number here
		if ($vendorID == 2225) {
			$sql="select batch_id from jobs_batch_orders where job_id=? ";
			list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
			if (count($jrs)>0) {
				$jdata=$jrs[0];
				$so="B" . $jdata['batch_id'];
			}
		}
		$pdf->SetXY(70,$base);
		$pdf->Write(10,$so);

		$rowh=10;

		$itemInfo=getItemData($db,$data['item_id'],$vendorID);

		$pdf->SetXY(107,$base);

		$part=$itemInfo['item_name'];
		$itemID=$itemInfo['item_id'];
		$suffix=getVendorSuffix($db,$vendorID,$itemID,$data['quantity']);
		$fullpart=$part.$suffix;
		$pdf->SetFont("Arial","",10);
		$font=10;
		while ($pdf->GetStringWidth($fullpart) > 86) {
			$font-=.5;
			$pdf->SetFont("Arial","",$font);
		}
		$pdf->Write(10,$part . $suffix);

		$pdf->SetFont("Arial","",10);
		$pdf->SetXY(200,$base);


		$pdf->Write(10,$itemInfo['uom_name']);

		$lines=multiLine($data['description'],32);

		if ($itemInfo['vendor_part_number'] and $itemInfo['vendor_id']==$vendorID) {

			$lines=multiLine($itemInfo['vendor_part_number'],32);

		}

		$sql="select * from items_vendors where item_id=? and vendor_id=?";

		list($rs,$err)=runIQUery($db,$sql,array("ii",$data['item_id'],$vendorID));

		if (count($rs)>0) {

			$vdata=$rs[0];

			$description=$vdata['vendor_description'];		

		}

		$extra=0;

		foreach ($lines as $line) {

			$pdf->SetXY(230,$base+$extra);

			$pdf->Write(10,$line);

			$extra+=10;

		}

		$trowh=10+$extra;		

		if ($trowh > $rowh) {

			$rowh=$trowh;

		}

		$decimals=4;

		if ($data['price']==round($data['price'],3)) {

			$decimals=3;

		}

		if ($data['price']== round($data['price'],2)) {

			$decimals=2;

		}

		$offset=444 - $pdf->GetStringWidth(number_format($data['price'],$decimals));		

		$pdf->SetXY($offset, $base);

		$pdf->Write(10,number_format($data['price'],$decimals));

		$ext=round($data['price'] * $data['quantity'],2);

		$potot+=$ext;

		$offset=520 - $pdf->GetStringWidth(number_format($ext,2));

		$pdf->SetXY($offset, $base);		

		$pdf->Write(10,number_format($ext,2));

		$pdf->SetXY(530, $base);
		$pdf->SetFont("Arial","",8);

		$pdf->Write(10,formatDateDBToWeb($data['date_expected']));

		$base+=$rowh;		

	}

	if ($numPages > 0) {

		$pdf->SetXY(420, $base);

	$pdf->SetFont("Arial","B",10);
		$pdf->Write(10,"Total");
	$pdf->SetFont("Arial","",10);

		$offset=520 - $pdf->GetStringWidth(number_format($potot,2));

		$pdf->SetXY($offset, $base);

		$pdf->Write(10,number_format($potot,2));
		$pdf->SetFont("Arial","",8);
		if ($status == 6) {
			$pdf->SetXY(20, 703);
			$pdf->Write(8,"    Quote is based on customer supplied electronic CAD data. A programming fee will be charged if we have to draw or re-work parts. Preferred Machine, LLC does not assume liability for part design of customer.  Preferred Machine, LLC's general tolerances will be used if it is NOT specified on customer print/CAD data. Please contact orders@preferredmachinellc.com for current tolerances. Pricing is subject to current material pricing at the time your order is placed. Quote includes material, unless noted otherwise.");
		}

	}	

}

if ($type=='SO') {

	$sql="select order_lines.*, uom_name, drawing from order_lines left outer join items on item_name=order_lines.item_id left outer join units_of_measure on unit_of_measure=uom_id where order_id=? order by coalesce(po_line,0) * 1, line_id";

	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$page=0;

	$numPages=floor(count($rs)/45);

	if ($numPages*45 < count($rs)) {

		$numPages++;

	}

	$lc=99;

	$potot=0;

	$base=215;

	foreach ($rs as $data) {

		$lc++;
		
		if ($lc > 45) {
			$page++;
			$pdf=returnSOHeader($db,$pdf,$id,$page,$numPages);
			$lc=1;	
			$base=215;
		}

		$pdf->SetXY(20, $base);

		$pdf->Write(10,$data['quantity']);

		$rowh=8;

		$pdf->SetXY(90,$base);

		if ($data['item_id'] != 'MISC.') {

			$pdf->Write(10,$data['item_id']);

		} else {

			$pdf->Write(10,"See Description");			

		}

		

		$pdf->SetXY(200,$base);

		$pdf->Write(10,$data['uom_name']);



		$lines=multiLine($data['item_description'],40);

		$extra=0;		

		foreach ($lines as $line) {

			$pdf->SetXY(230,$base+$extra);

			$pdf->Write(10,$line);

			$extra+=8;

		}

		if (trim($data['drawing'])) {

			$dwg=trim($data['drawing']);

			if ($data['revision']) {

				$dwg.=" REV " . $data['revision'];

			}

			$pdf->SetXY(230,$base+$extra);

			$pdf->Write(10,$dwg);

			$extra+=8;

		}

		$trowh=8+$extra;		

		if ($trowh > $rowh) {

			$rowh=$trowh;

		}

		$pdf->SetXY(415, $base);

		$font=10;
		$pdf->SetFont("Arial","",$font,'',false);
		$poLine=trim($data['po_line']);
		while ($pdf->GetStringWidth($poLine) > 20) {
			$font-=.5;
			$pdf->SetFont("Arial","",$font,'',false);
		}
		$pdf->Write(10,$poLine);		
		$pdf->SetFont("Arial","",10,'',false);
		$pdf->SetXY(450, $base);

		$ext=round($data['price'] * $data['quantity'],2);

		if ($_GET['price']!='no') {
			$pdf->SetFont("Arial","",8);
			$offset=475 - $pdf->GetStringWidth(number_format($data['price'],2));		
			$pdf->SetXY($offset, $base);
			$pdf->Write(10,number_format($data['price'],2));

			$pdf->SetFont("Arial","",9);
			$pdf->SetXY(480, $base);
			$pdf->Write(10,number_format($ext,2));
		}

		$potot+=$ext;

		$pdf->SetXY(530, $base);

		$pdf->Write(10,formatDateDBToWeb($data['due_date']));

		$base+=$rowh;		

	}
	$sql="select * from orders where order_id=?";

	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$data=$rs[0];
	$status=$data['status'];
	$customerID=$data['customer_id'];
	$ship_name=$data['ship_name'];
	$ship_address=$data['ship_address'];
	$sql="select standard_shipping from customers where customer_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$customerID));
	$data=$rs[0];
	$shipping=$data['standard_shipping'];
	$sql="select * from customer_shiptos where customer_id=? and ship_name=? and ship_address=? ";
	list($srs,$err)=runIQuery($db,$sql,array("iss",$customerID,$ship_name,$ship_address));
	if (count($srs)>0) {
		$sdata=$srs[0];
		if ($sdata['shipping_cost'] > 0) {
			$shipping=$sdata['shipping_cost'];
		}
	}
	if ($shipping > 0) {
		$pdf->SetXY(450, $base);
		$pdf->Write(10,"Est. Shipping");
		$pdf->SetXY(480, $base);
		$pdf->Write(10,number_format($shipping,2));
		$base+=$rowh;		
		$potot+=$shipping;
	}
	$pdf->SetFont("Arial","",8);
	if ($status == 6) {
		$pdf->SetXY(20, 703);
		$pdf->Write(8,"    Quote is based on customer supplied electronic CAD data. A programming fee will be charged if we have to draw or re-work parts. Preferred Machine, LLC does not assume liability for part design of customer.  Preferred Machine, LLC's general tolerances will be used if it is NOT specified on customer print/CAD data. Please contact orders@preferredmachinellc.com for current tolerances. Pricing is subject to current material pricing at the time your order is placed. Quote includes material, unless noted otherwise.");
	}
	$pdf->SetFont("Arial","",10);
	$base+=5;
	if ($numPages > 0 and $_GET['price']!='no') {

		$pdf->SetXY(450, $base);

		$pdf->Write(10,"Total");

		$pdf->SetXY(480, $base);

		$pdf->Write(10,number_format($potot,2));

	}	
	$pdf=returnSOHeader($db,$pdf,$id,$page,$numPages,0);
	$lc=1;	
	$base=215;
	$base+=13;
	$pdf->SetFont("Arial","",10,'',false);
	if ($status == 6) {
		## quote
		$pdf->SetXY(20,$base);
		$pdf->Write(10, "Due to material type and market volatility, price is subject to change. ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(10, "Pricing good for 5 business days contingent on  material  availability.  All amounts are stated in ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "U.S. dollars and must be paid in U.S. dollars.  Quote includes material cost, unless otherwise noted, ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "and is based on customer supplied electronic CAD data.  Changes requested after a quote has been ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "submitted may invalidate quoted pricing.  These changes include, but are not limited to, increase or ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "decrease in part quantity, modifications to prints or CAD data, and deviations of material type or thickness.");
		$base+=11;
		$base+=10;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Unless quoted as such, orders required to be completed within Preferred Machine, LLC's expedite window will incur");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "the normal expediting fees in addition to the quoted pricing.  This will be factored automatically on a ");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "per part basis, and will not show as a separate line on an invoice.");
		$base+=11;
		$pdf->SetXY(20,$base);
		$pdf->Write(12, "Please contact orders@preferredmachinellc.com for current expedite window.");		
		$base+=11;
	}	
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine, LLC does not assume liability for customer part design.  A setup fee will be applied if Preferred");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Machine, LLC is required to draw or re-work customer supplied prints or CAD data.  Preferred Machine, LLC's general ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "tolerances will be used if tolerances are not specified on customer supplied prints or CAD data.");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Please contact orders@preferredmachinellc.com for current tolerances.");
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine, LLC applies an expedite fee to all orders that are required to be completed two business");
	$base+=13;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "days or less from the date a purchase order is received.  Preferred Machine, LLC's cutoff time for receiving");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "purchase orders is 3:00 PM.  All purchase orders received after 3:00 PM will be considered as received");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "on the following business day at 8:00 AM.");
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "Preferred Machine, LLC stocks a large number of material types and thicknesses.  Any material type or");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "thickness that is not a stocked material is referred to as Custom Material.  When a Custom Material is");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "requested, Preferred Machine, LLC will charge for the full amount of material ordered.  Any remaining ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "material drops will be scrapped, unless requested to be included with the order when complete.  Please");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "contact orders@preferredmachinellc.com for a current material stock list.");
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "All orders falling below a $50.00 total are subject to Preferred Machine, LLC's minimum order charge, unless ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "otherwise noted.  Shipping costs are not factored into order total, and therefore will not be included when");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12, "determining if an order falls below the minimum order charge threshold of $50.00.");
	$pdf->SetFont("Arial","B",10,'',false);
	$base+=11;
	$base+=10;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"SKID RETURN POLICY:");
	$pdf->SetFont("Arial","",10,'',false);
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"In order to control delivery costs, Preferred Machine, LLC asks that you return skids and pallets.  ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Please work with Preferred Delivery Service drivers, or contact Preferred Delivery Service at ");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"preferreddeliveries@gmail.com to arrange for pick up.");
	$base+=11;
	$base+=10;
	$pdf->SetFont("Arial","B",10,'',false);
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"MARKET VOLATILITY");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->SetFont("Arial","",10,'',false);
	$pdf->Write(12,"Due to material type and market volatility, price is subject to change.");
	$base+=11;
	$pdf->SetXY(20,$base);
	$pdf->Write(12,"Pricing is good for 5 business days contingent on material availability.");
}

if ($type=='PS') {
	$idlist=array();
	if (isset($_GET['bol'])){
		$bol=$_GET['bol'];
		$sql="select distinct packing_slip from bol_skids where bol_id=? order by packing_slip";
		list($rs,$err)=runIQuery($db,$sql,array("i",$bol));
		foreach ($rs as $data) {
			$idlist[]=$data['packing_slip'];
		}
	} else {
		$idlist[]=$id;
	}
	foreach ($idlist as $id) {
		$sql="select * from packing_slip_lines where packing_list_id=? order by line_id";
		list($rs,$err)=runIQuery($db,$sql,array("i",$id));
		$page=0;
		$numPages=floor(count($rs)/10);
		if ($numPages*10 < count($rs)) {
			$numPages++;
		}
		$lc=10;
		$potot=0;
		$base=215;
		foreach ($rs as $data) {
			$lc++;
			if ($lc > 10) {
				$page++;
				$pdf=returnPSHeader($db,$pdf,$id,$page,$numPages);
				$lc=1;	
			}
			$pdf->SetXY(20, $base);
			$pdf->Write(10,$data['quantity']);
			$rowh=10;
			$pdf->SetXY(90,$base);
			if ($data['part_number'] != 'Miscellaneous') {
				$pdf->Write(10,$data['part_number']);			
			} else {
				$pdf->Write(10,"See Description");							}
			$lines=multiLine($data['description'],40);
			$extra=0;
			foreach ($lines as $line) {
				$pdf->SetXY(200,$base+$extra);
				$pdf->Write(10,$line);
				$extra+=10;
			}
			$trowh=10+$extra;		
			if ($trowh > $rowh) {
				$rowh=$trowh;
			}
			$pdf->SetXY(450, $base);
			if ($data['po_line']!='0') {
				$pdf->Write(10,$data['po_line']);			
			}
			$base+=$rowh;		
		}	
	}
}

if ($type=='MT') {

	$sql="select * from transfer_lines where packing_slip=? order by txid";

	list($rs,$err)=runIQuery($db,$sql,array("i",$id));

	$page=0;

	$numPages=floor(count($rs)/10);

	if ($numPages*10 < count($rs)) {

		$numPages++;

	}

	$lc=10;

	$potot=0;

	$base=215;

	foreach ($rs as $data) {

		$lc++;

		if ($lc > 10) {

			$page++;

			$pdf=returnMTHeader($db,$pdf,$id,$page,$numPages);

			$lc=1;	

		}

		$pdf->SetXY(20, $base);

		$pdf->Write(10,$data['quantity']);

		$rowh=10;

		$pdf->SetXY(90,$base);

		if ($data['part_number']!='Miscellaneous') {

			$pdf->Write(10,$data['part_number']);

		} else {

			$pdf->Write(10,"See Description");			

		}

		$lines=multiLine($data['description'],40);

		$extra=0;

		foreach ($lines as $line) {

			$pdf->SetXY(200,$base+$extra);

			$pdf->Write(10,$line);

			$extra+=10;

		}

		$trowh=10+$extra;		

		if ($trowh > $rowh) {

			$rowh=$trowh;

		}

		$pdf->SetXY(450, $base);

		$pdf->Write(10,number_format($data['po_number'],2));

		$base+=$rowh;		

	}

}



$fname="/home/prefwelderp/public_html/documents/".$type.$id.".pdf";	

print "file is $fname<hr>";


if (file_exists($fname)) {

	unlink($fname);

	print "deleted $fname<BR>";

}

$pdf->Output($fname, "F");

if ($type == "PS" and isset($_GET['bol'])) {
	print "<script>window.open('documents/$type$id.pdf','_self')</script>\n";
}
$sql="select distinct orders.order_id from po_lines, jobs, order_lines, orders where po_lines.job_id=jobs.job_id and jobs.line_id=order_lines.line_id  and order_lines.order_id = orders.order_id and po_lines.po_id=? and orders.status = 1";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
foreach ($rs as $data) {
	$orderID=$data['order_id'];
	$sql="update orders set status=11, date_on_po=now() where order_id=? and status=1";
	list($updrs,$err)=runIQuery($db,$sql,array("i",$orderID));	
	$sqlj="update order_lines sest line_status=11 where order_id=? and line_status=1";
	list($updrs,$err)=runIQuery($db,$sql,array("i",$orderID));	
}


?>
</body></html>