<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
## this is called from timeEntry
//print "<html><head></head><body>\n";
header("Content-type: application/pdf");

require_once('tcpdf.php');
require_once('tcpdf_barcodes_1d.php');

$pdf = new TCPDF("l", "mm", [50.8,25.4], true, 'UTF-8', false);
$pdf->SetAutoPageBreak(false, 0);$pdf->setImageScale(1);
$pdf->SetTextColor(0,0,0,100); ## 100% black
$pdf->SetDrawColor(0,0,0,100);
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

function printTag($part) {
    global $pdf;
    $pdf->AddPage();

    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    $pdf->SetFont('helvetica', '', 10);
    $pdf->SetXY(0,0);

    $style = [
        'position' => 'C',
        'align' => 'C',
        'stretch' => true,
        'fitwidth' => true,
        'cellfitalign' => '',
        'border' => false,
        'hpadding' => '-3',
        'vpadding' => '2',
        'fgcolor' => [0,0,0],
        'bgcolor' => false,
        'text' => true,
        'font' => 'helvetica',
        'fontsize' => 35,
        'stretchtext' => 0
    ];
    $pdf->write1DBarcode(strtoupper($part), 'C128A', '', '', '', 28, 5, $style, 'N');
}

list($job,$step)=explode("-",$_GET['scan']);
$qty=$_GET['qty'];
$sql="select po_number, revision, j.item_id from jobs j, order_lines l, orders o where j.job_id=? and j.line_id=l.line_id and l.order_id=o.order_id ";
list($rs,$err)=runIQuery($db,$sql,array("i",$job));

$data=$rs[0];
$part=$data['item_id'];
$revision=$data['revision'];
$poNumber=$data['po_number'];
//print_r($data);
$i=0;
//print "qty is $qty<br>";
while ($i < $qty) {
    printTag($part);
    $i++;
}

$pdf->Output("", "I");
?>