<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');
if (isset($_GET['start'])) {
	$start=$_GET['start'];
	$end=$_GET['end'];
	$start_date=formatDateWebtoDB($_GET['start']);
	$end_date=formatDateWebtoDB($_GET['end']);
} else {
	$start_date=Date("Y-m-d");
	$end_date=$start_date;
	$start=Date("m/d/Y");
	$end=$start;
}
print renderPanel("Quote Report $start_date - $end_date","Quote Performance","primary","span11");
#print "<div style='float: right; margin: 5px;' class='btn btn-primary col-sm-1' onclick='exportReport();'>Export</div>";
print "<form action='quoteReport.php' id='reportform' name='reportform' method=GET>";
print renderDateBox(TRUE,'start',$start,"Start");
print renderDateBox(TRUE,'end',$end,'End');
print "<div  style='float: right; margin: 5px;' class='btn btn-primary col-sm-1' onclick='document.reportform.submit();'>Update</div>";
print "</form>";
print "<div align='center'>By Quote Header</div>";
$sql="select orders.order_id, ship_name, date_changed, status_name, new_status from orders, order_status_update u, order_status  where  orders.order_id = u.order_id and old_status=10  and date_changed >= ? and date_changed <= ? and new_status=status_id  ";
list($rs,$err)=runIQuery($db,$sql,array("ss",$start_date,$end_date));
print "<table class='table table-striped table-hover'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "Order";
print "</th>";
print "<th valign='top'>";
print "Customer";
print "</th>";
print "<th valign='top'>";
print "Date Quoted";
print "</th>";
print "<th valign='top'>";
print "Status";
print "</th>";
print "</tr>\n";
print "</thead>";
print "<tbody>";
$total=0;
$won=0;
$lost=0;
$quote=0;
foreach ( $rs as $data) {
	$order=$data['order_id'];
	$customer=$data['ship_name'];
	$dt=formatDateDBToWeb($data['date_changed']);
	$status=$data['status_name'];
	if ($status == "Cancelled"){
		$lost++;
	} else {
			$won++;			
	}
	$total++;
	print "<tr><td>$order</td><td>$customer</td><td>$dt</td><td>$status</td></tr>\n";
	print "</tr>\n";
}
$sql="select order_id, ship_name, date_uploaded from orders where status=10 and date_uploaded >= ? and date_uploaded <= ?  ";
list($rs,$err)=runIQuery($db,$sql,array("ss",$start_date,$end_date));
foreach ( $rs as $data) {
	$order=$data['order_id'];
	$customer=$data['ship_name'];
	$dt=formatDateDBToWeb($data['date_uploaded']);
	$status="Quote";
	$quote++;
	$total++;
	print "<tr><td>$order</td><td>$customer</td><td>$dt</td><td>$status</td></tr>\n";
	print "</tr>\n";
}
$pct=number_format($won/$total*100,1);
print "<tr><td>Total Won</td><td>$won</td><td>Percentage</td><td>$pct</td></tr>\n";
$pct=number_format($lost/$total*100,1);
print "<tr><td>Total Lost</td><td>$lost</td><td>Percentage</td><td>$pct</td></tr>\n";
$pct=number_format($quote/$total*100,1);
print "<tr><td>Still In Quote</td><td>$quote</td><td>Percentage</td><td>$pct</td></tr>\n";
print "</tbody>";
print "</table>";
print "<hr>";
print "<div align='center'>By Line Item</div>";
print "<p>This list will show all line items uploaded in that date range as a quote, and then see if either the order was flipped Pending Review or if it was flipped to Cancelled.  If the quote was cancelled or still in quote, then the system will also check to see if that customer ordered the quoted parts on any order in the future, counting that as a Win.</p>";
print "<table class='table table-striped table-hover'>";
print "<thead><tr><th>Order</th><th>Customer</th><th>Date Quoted</th><th>Part</th><th>Won/Lost</th></tr></thead><tbody>\n";
$sql="select orders.order_id, customer_id, ship_name, date_uploaded, item_id, status_name from orders, order_status, order_lines where status=status_id and orders.order_id=order_lines.order_id and date_uploaded>=? and date_uploaded <= ? and (status=10 or orders.order_id in (select order_id from order_status_update where old_status=10)) ";
list($rs,$err)=runIQuery($db,$sql,array("ss",$start_date,$end_date));
$total=0;
$won=0;
$lost=0;
$quote=0;
foreach ( $rs as $data) {
	$order=$data['order_id'];
	$customer=$data['ship_name'];
	$customerID=$data['customer_id'];
	$dt=formatDateDBToWeb($data['date_uploaded']);
	$part=$data['item_id'];	
	$status=$data['status_name'];
	if ($status == "Cancelled" or $status == "Quote") {
		## give them a chance to win it by having the part on a future order
		$sql="select * from orders, order_lines where customer_id=? and  status not in (5,10) and date_uploaded > ? and ship_name=? and orders.order_id=order_lines.order_id and item_id=?";
		list($ors,$err)=runIQuery($db,$sql,array("isss",$customerID,$start_date,$customer,$part));
		if (count($ors)>0) {
			$status="Won";
		}
	}
	if ($status == "Cancelled"){
		$status="Lost";
		$lost++;
	} else {
		if ($status == "Quote") {
			$quote++;
		} else {
			$won++;
		}
	}
	$total++;
	print "<tr><td>$order</td><td>$customer</td><td>$dt</td><td>$part</td><td>$status</td></tr>\n";
	print "</tr>\n";
}
$pct=number_format($won/$total*100,1);
print "<tr><td>Total Won</td><td>$won</td><td>Percentage</td><td>$pct</td></tr>\n";
$pct=number_format($lost/$total*100,1);
print "<tr><td>Total Lost</td><td>$lost</td><td>Percentage</td><td>$pct</td></tr>\n";
$pct=number_format($quote/$total*100,1);
print "<tr><td>Still In Quote</td><td>$quote</td><td>Percentage</td><td>$pct</td></tr>\n";
print "</tbody>";
print "</table>";
print renderClosePanel();
?>
<script>
function page_init() {
	jQuery('.datepicker').datepicker();
	
}
</script>
<?php
include('footer.php');
?>