<?php
include("dbConnection.php");
include("security.php");
include("functions.php");
include("header.php");
// including header after sending code causes default favicon to not work, workaround below
print "<link rel='shortcut icon' href='images/favicon.png' type='image/png'>";
print "<style>
    .printarea * {
        text-align: left;
        font-size: 10px !important;
        color: #000 !important;
        padding: 0px;
    }
    .printarea table {
        width: 100% !important;
        border-spacing:0;
        border-collapse: collapse;
    }
    .printarea .separator th,td {
        border-bottom: 1px solid #000;
    }
    .printarea .padded th,td {
        padding: 3px;
    }
    .punchlist * {
        font-size: 14px;
    }
    .weekpickerbox tbody tr:hover {
        background-color: #dbdbdb!important;
    }

    .weekpickerbox tbody tr.selected {
        background-color: #c0c0c0;
    }
</style>

<div style='text-align: left; background-color: #ffffff; display: none; z-index: 99999; font-size: 1px;' class='printarea'></div>";

function renderWeekBox($showLabel,$fieldName,$currentValue,$title,$onchange="") {
	$retval=renderStartItem($showLabel,$fieldName,$title);
	$retval.= "<input style='background-color: white;' type='text' class='form-control datepicker date-picker weekpicker' name='$fieldName' id='$fieldName' value='";
	if (formatDateDBToWeb($currentValue)) {
        $retval.= formatDateDBtoWeb($currentValue);
	} else {
		$retval.=$currentValue;
	}
	$retval.= "' ";
	if ($onchange) {
		$retval.= " onchange=\"$onchange\" ";
	}
	$retval.= ">";
	$retval.=renderEndItem();
	return $retval;
}

$date=date("Y/m/d", strtotime("last week sunday"));
if (isset($_GET["date"])) {
    $date=$_GET["date"];
}

$from = date("Y-m-d", strtotime($date));
$to = date("Y-m-d", strtotime($date . " +7 day"));

$company=1;
if (isset($_GET["company"])) {
    $company=$_GET["company"];
}

$department=0;
$sql = "select department_id from teams t, site_admins sa where t.supervisor=sa.user_id and sa.user_id=?";
list($rs,$err)=runIQuery($db,$sql,["s",$userID]);
if (count($rs)) {
    $isAdmin=1;
    $department=$rs[0]["department_id"];
}
if ($userEmail == "ap@preferredmachinellc.com") { //ap can change anyone's hours
    $isAdmin=1;
}

if (!$isAdmin) {
    die;
}

$exclude = "28,246"; //Shipping, Staging, Etc

$sql = "SELECT card_number, concat(first_name, ' ', last_name) as full_name, out_date, in_date, is_lunch from time_clock_punches tcp, employees emp, teams t where tcp.employee_id=emp.card_number and in_date between '$from' and '$to'" . ($department ? " and department_id=$department" : "") . " and not emp.employee_id in ($exclude) and emp.department_id=t.department_id and company_id=? order by full_name";

$sqle = "select card_number, concat(first_name, ' ', last_name) as full_name, salaried from employees, teams t where inactive=0" . ($department ? " and department_id=$department" : "") . " and not employee_id in ($exclude) and t.department_id=employees.department_id and company_id=?";

list($ers)=runIQuery($db,$sqle, ["s",$company]);

// Get all ACTIVE employees and list them to show if anyone never showed up that week
$punches=[];
foreach ($ers as $emp) {
    $cn = $emp["card_number"];
    if (empty($punches[$cn])) {
        $punches[$cn] = ["punched_in" => false, "full_name" => $emp["full_name"] . ($emp["salaried"] ? " (Salary)": ""), "hours" => 0, "days" => ["lunch_days" => ["total" => 0, "seen" => []], "total" => 0, "seen" => []], "saturday_hours" => 0];
    }
}
list($rs)=runIQuery($db,$sql,["s",$company]);

foreach ($rs as $punch) {
    $cn = $punch["card_number"];
    $info = $punches[$cn];

    $day = date("w", strtotime($punch["in_date"]));
    if ($punch["is_lunch"] == 1 && !in_array($day,$info["days"]["lunch_days"]["seen"]) && $day != 6) {
        $punches[$cn]["days"]["lunch_days"]["seen"][] = $day;
        $punches[$cn]["days"]["lunch_days"]["total"] += $day;
    }

    if (!in_array($day,$info["days"]["seen"])) {
        if ($day != 6) {
            $punches[$cn]["days"]["total"] += $day;
        }
        $punches[$cn]["days"]["seen"][] = $day;
    }

    if (!empty($punch["out_date"])) {
        $hours = round(((strtotime($punch["out_date"]) - strtotime($punch["in_date"]))/60/60)*100)/100;
        $punches[$cn]["hours"] += $hours;
        if ($day == 6) { // saturday
            $punches[$cn]["saturday_hours"] += $hours;
        }
    } else {
        $punches[$cn]["punched_in"] = true;
    }
}

print renderPanel("Week " . date("W", strtotime($to)) . " Overview (" . formatDateDBToWeb($from) . " - " . formatDateDBToWeb($to) . ")","Week Overview","green");
print "<form name='applyForm' class='x' method='GET' action='punchWeekOverview.php'>";

print renderWeekBox(TRUE,"date",date("m/d/Y", strtotime($from)),"Week Start");
print renderStartItem(TRUE,"end","Week End");
    print "<input class='form-control' type='text' id='end' value='" . date("m/d/Y", strtotime($to . " -1 day")) . "' readonly>";
print renderEndItem();

$sql = "select company_id, company_name from quickbooks_companies";
list($crs,$err) = runIQuery($db,$sql);
print renderSelect(TRUE,"company",$company,"Company","",$crs,TRUE);

print "<div style='margin-top: 35px;' class='btn blue hidden-print' onclick='document.forms.applyForm.submit();'>Apply</div>";

print "</form><br>";
print "<div class='punchtables'><table style='width: 50%;' class='employees table table-bordered table-condensed table-striped'>
    <thead>
        <tr>
            <th>Employee</th>
            <th>Week Hours</th>
            <th>Here All Week</th>
            <th>Took Lunch Each Day In</th>
            <th>5 Hours Saturday</th>
            <th>Still Punched In</th>
        </tr>
    </thead>
    <tbody>";

foreach ($punches as $cn => $employee) {
    print "<tr style='cursor: pointer;' onmouseover='this.style.backgroundColor=\"#d0d0d0\"' onmouseout=\"this.style.background='white';\" onclick='window.open(\"listPunches.php?start=" . date("m/d/Y", strtotime($from)) . "&end=" . date("m/d/Y", strtotime($to)) . "&employee=$cn&company=$company\", \"_blank\");'>";
        // Employee name
        print "<td>" . $employee["full_name"] . "</td>";
        // Week Hours
        print "<td style='color: " . (($employee["hours"] < 40 || $employee["hours"] == 0 || $employee["hours"] > 70) ? "red;'>" : "green;'>") . $employee["hours"] . "</td>";
        // Here All Week
        print "<td style='color : " . ($employee["days"]["total"] == 15 ? "green;'>Yes" : "red;'>No") . "</td>";
        // Took Lunch Each Day
        print "<td style='color : " . ($employee["days"]["total"] == $employee["days"]["lunch_days"]["total"] && $employee["days"]["lunch_days"]["total"] != 0 ? "green;'>Yes" : "red;'>No") . "</td>";
        // 5 Hours Saturday
        print "<td style='color : " . (($employee["saturday_hours"] > 4.99) ? "green;'>Yes" : "red;'>No") . "</td>";
        // Still Punched In (SHOULD always be No)
        print "<td style='color: " . ($employee["punched_in"] ? "red;'>Yes" : "green;'>No") . "</td>";
    print "</tr>";
}

print "</tbody></table></div>";
+
print renderClosePanel();
print "</div>";
?>

<script>
    var start_date = new Date("<?=$from?>"), end_date = new Date("<?=$to?>");
    function page_init() {
        var is_weekpicker = false;
        function select_week() {
            setTimeout(function() {
                $(".ui-datepicker a.ui-state-active, .ui-datepicker a.selectedweek").parent().parent().addClass("selected");
            }, 10);
        }
        $(".weekpicker").on("change", function(e) {
            setTimeout(function() {
                var inst = $.datepicker._getInst(e.target);
                date = new Date(e.target.value);
                start_date = new Date(date.getFullYear(), date.getMonth(), date.getDate() - date.getDay());
                end_date = new Date(date.getFullYear(), date.getMonth(), date.getDate() - date.getDay() + 6);
                var dateFormat = $.datepicker._defaults.dateFormat;
                $('#date').val($.datepicker.formatDate( dateFormat, start_date ));
                $('#end').val($.datepicker.formatDate( dateFormat, end_date ));
            }, 50);
        });
        $(".datepicker").datepicker();

        $('.employees').DataTable({
            bPaginate:false,
            searching:true
        });
    }

    function printPage() {
        $(".printarea").empty();
        $(".punchtables").clone().appendTo(".printarea");
        $("iframe, section, .dataTables_filter, .dataTables_info").hide();
        $(".separator, .printarea").show();
        window.print();
        $("iframe, section, .dataTables_filter, .dataTables_info").show();
        $(".separator, .printarea").hide();
    }
</script>

<?php
include("footer.php");
?>