<?php
include("dbConnection.php");
include("security.php");
include("functions.php");
include("header.php");

$autologin=0;
// Auto-login stuff, holding off for now until we are ready for it
if (strstr($userEmail,"@") && strstr($userEmail,".com")) { // is a user
    $sql = "select employee_link from site_admins where email=? and employee_link <> 0";
    list($rs,$err)=runIQuery($db,$sql,["s",$userEmail]);

    if (count($rs)) {
        $sql = "select pin, card_number from employees where employee_id=?";
        list($rs,$err)=runIQuery($db,$sql,["i",$rs[0][0]]);

        if (count($rs)) {
            $_POST["employee"] = $rs[0][1];
            $_POST["pin"] = $rs[0][0];
            $_POST["code"] = 8383;
            $autologin=1;
        }
    }
}

$employee=0;
if (isset($_POST["employee"])) {
    $employee=$_POST["employee"];
}
$pin="";
if (isset($_POST["pin"])) {
    $pin=$_POST["pin"];
}


print renderPanel("Punch Clock", "Punch Clock", "blue");

$showLogin=1;
$triedLogin=0;
if ($employee) {
    $sql = "select pin, points, employee_id from employees where card_number=?";
    list($rs) = runIQuery($db,$sql,["i",$employee]);

    if (!count($rs)) {
        if (strstr($employee, "@")) {
            $sql = "select password, employee_link from site_admins where email=?";
            list($srs,$err)=runIQuery($db,$sql,["s",$employee]);

            if (count($srs)) {
                $link=$srs[0][1];
                $sql = "select pin, points, employee_id, card_number from employees where employee_id=?";
                list($prs,$err)=runIQuery($db,$sql,["i",$link]);
                $row=$prs[0];

                $pass = $srs[0][0];
                $testpin = crypt($pin,"4439448");
                if ($pass==$testpin) {
                    $pin=$prs[0]["pin"];
                    $employee=$prs[0]["card_number"];
                    $rs=$prs;
                }
            }
        }
    }

    if (count($rs)) {
        $employee_id = $rs[0]["employee_id"];
        if  ($pin == $rs[0]["pin"]) { // show clock info, punch in/out button, and logout button
            $showLogin=0;

            include("timeclock/getEmployeeInfo.php");
            //$employee_info["last_punch"] = (array) $employee_info["last_punch"];

            print "<h3>Hello, " . $employee_info["employee"] . "<br>";
            if (empty($employee_info["last_punch"]["type"])) {
                print "You have never punched in";
            } else {
                print "You are currently punched <b><i>" . strtoupper($employee_info["last_punch"]["type"]) . "</i></b></h3>";
            }

            $inorout = "out";
            print "<h4><table class='table'><tr>";
                print "<td>"; //employee info area
                    print "You currently have " . $rs[0]["points"] . " point(s)";
                    if (!empty($employee_info["last_punch"])) {
                        $inorout = $employee_info["last_punch"]["type"];
                        print "<br>You last punched " . strtoupper($employee_info["last_punch"]["type"]) . " on " . date("D, M d, Y \a\\t g:i A", strtotime($employee_info["last_punch"]["punch"]));
                        print "<br>Week Hours: " . $employee_info["week_hours"];
                        print "<br>Day Hours: " . $employee_info["day_hours"];
                        if ($employee_info["last_punch"]["type"] == "out") {
                            print "<br>Last Punch Hours: " . $employee_info["last_punch"]["punch_hours"];
                        }
                    }
                print "</td>";

                print "<td>"; //notes area
                    $sql = "select setting from system_settings where name='punch_notes' and not setting=''";
                    list($rs,$err)=runIQuery($db,$sql);
                    if (count($rs)) {
                        print "<h5>" . $rs[0]["setting"] . "</h5>";
                    }
                    $sql = "select matrix_training_level, department_id from employees where employee_id=?";
                    list($mrs,$err)=runIQuery($db,$sql,["i",$employee_id]);
                    $matrix_level = 0;
                    $department_id = 0;
                    if (count($mrs)) {
                        $matrix_level = $mrs[0][0];
                        $department_id = $mrs[0][1];
                    }
                    print "<h5>Matrix Training Level: $matrix_level</h5>";
                    if ($inorout == "out") {
                        $today = date("m/d/Y");
                        $tomorrow = date("m/d/Y", strtotime("+1 day")); // using tomorrow as selecting a single day seems to always return 0.0% KPI

                        $url = "employeeEfficiency.php?start=$today&end=$tomorrow&team=$department_id&employee=$employee_id";

                        // commented out until we know what we're doing
                        // print renderButton("View My KPI", "blue", "window.open('$url', '_blank'); return false;");
                    }

                    $sql="SELECT employee_signed_date, manager_signed_date from point_log  WHERE (employee_signed_date IS NULL OR manager_signed_date IS NULL) AND coalesce(refused_to_sign,0) = 0 AND coalesce(manually_signed,0) = 0 AND employee_id=?";
                    list($rs,$err)=runIQuery($db,$sql, ["i", $employee_id]);
                    if (count($rs)) {
                        print "<h5>You have an unsigned point form that " . (is_null($rs[0]["employee_signed_date"]) ? (is_null($rs[0]["manager_signed_date"]) ? "you and your manager" : "you") : "your manager") . " need to sign!</h5>";
                    }

                    $hstart = date("Y-m-d", strtotime("+7 day")); // Don't want to go forward too far just in case
                    $sql = "select * from holidays where curdate() < holiday_date and holiday_date < '$hstart' and hours_given=0";
                    list($hrs)=runIQuery($db,$sql);
                    if (count($hrs)) {
                        print "<h5>" . $hrs[0]["holiday_name"] . " coming up! Be sure to work your full shift the work day before and after the holiday to get holiday pay!</h5>";
                    }
                print "</td>";

            print "</tr></table></h4>";

            print "<br><div class='col-sm-3'>
                <div class='input-group'>
                    <label class='control-label' for='notes'>Notes To Accounting</label>
                    <textarea class='form-control wysihtml5' name='notes' id='notes' rows='2'> ";
                    if (!empty($employee_info["last_punch"]["type"])) {
                        print ($employee_info["last_punch"]["type"] == "out" ? "" : $employee_info["last_punch"]["notes"]);
                    }
                    print "</textarea>
                </div>

            </div><br><br>";

            if (!$autologin) {
                print renderButton("Log Out", "yellow", "window.location='punchClock.php';");
            }
            print " " . renderButton("Punch " . (empty($employee_info["last_punch"]["type"]) || $employee_info["last_punch"]["type"] == "out" ? "In" : "Out"), "red", "doPunch(0)");
            if (!empty($employee_info["last_punch"]["type"]) && $employee_info["last_punch"]["type"] == "in") {
                print " " . renderButton("Lunch Punch Out", "green", "doPunch(1)");
            }
        } else {
            $triedLogin=1;
        }
    }
}

if ($showLogin) { // show login screen
    print "<form name='loginForm' method='POST' action='punchClock.php'>";
    print "<input type='hidden' value='8383' name='code'>";
    print renderTextBox(TRUE,"employee","","Employee Number");
    print "<div class='span3'>
        <div class='input-group'>
            <label class='control-label' for='pin'>Pin Number</label>
            <input class='form-control' type='password' name='pin' id='pin' value='' placeholder='Pin Number'>
        </div>
    </div>
    <input type='submit' style='display:none;'><br>";
    print renderButton("Login","green","document.forms.loginForm.submit();");
    print "</form>";
}

print renderClosePanel();
print "</div>";

include("footer.php");
?>
<script>
    var visittime = Date.now();
    <?php if ($employee && !$showLogin) { ?>

    setTimeout(function() {
        window.location="punchClock.php";
    }, <?php print ($autologin ? 360000 : 60000) ?>);

    function doPunch(isLunch) {
        if (Date.now() - visittime > (10*60*1000)) {
            $.gritter.add("Please refresh the page");
            return;
        }
        var url = "timeclock/addClockPunch.php?code=8383&lunch="+isLunch+"&notes="+$("#notes").val()+"&employee=<?=$employee?>&pin=<?=$pin?>&rand=" + Math.random();
        $.ajax({url: url, success: function() {
        	$.gritter.add("Added punch successfully");
            setTimeout(function() {
            	window.location.reload();
            }, 500);
        }});
    }
    <?php }
    if ($showLogin && $triedLogin) { ?>
        $.gritter.add("Incorrect PIN");
    <?php } ?>
</script>