<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
$pageTitle="Production Results";
include('header.php');
date_default_timezone_set('America/Detroit');
$sql="SET time_zone = '" .date('P') . "'";
list($rs,$err)=runIQuery($db,$sql);
$end=Date("Y-m-d");
$start=SubtractBusinessDays($end,5);
$end=formatDateDBToWeb($end);
$start=formatDateDBToWeb($start);
if (isset($_GET['start'])) {
	$start=trim($_GET['start']);
}
if (isset($_GET['end'])) {
	$end=($_GET['end']);
}
$workcenter=0;
if (isset($_GET['wc'])) {
	$workcenter=trim($_GET['wc']);
}
$part="";
if (isset($_GET['part'])) {
	$part=trim($_GET['part']);
}
$employee=0;
if (isset($_GET['employee'])) {
	$employee=trim($_GET['employee']);
}
$id=$employee;
$job="";
if (isset($_GET['job'])) {
	$job=trim($_GET['job']);
}
$order="";
if (isset($_GET['order'])) {
	$order=trim($_GET['order']);
}
$workcenter=0;
if (isset($_GET['workcenter'])) {
	$workcenter=trim($_GET['workcenter']);
}
$team=0;
if (isset($_GET['team'])) {
	$team=$_GET['team'];
}
print renderPanel("Production Results","","blue","span11","cogs");
print "<p>If you specify Job or SO, the start and end dates are ignored.</p>";
print "<form name='findform' action='productionResults.php' method='GET>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print "<div style='clear: both;'></div>";
print renderTextBox(TRUE,"part",$part,"Part Number");
print renderTextBox(TRUE,"job",$job,"Job");
print renderTextBox(TRUE,"order",$order,"Sales Order");
print "<div style='clear: both;'></div>";
$sql="select workcenter_id, workcenter_name from workcenters order by workcenter_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"workcenter",$workcenter,"Work Center","N",$rs,1);
$sql="select card_number, concat(last_name,', ',first_name) from employees where inactive=0 order by last_name ";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"employee",$employee,"Employee","N",$rs,1);
$sql="select department_id, department_name from departments order by department_name";
$rs=mysqli_query($db,$sql);
print renderSelect(TRUE,"team",$team,"Department","N",$rs,1);
print "</form>";
print "<div class='btn green hidden-print' onclick='document.findform.submit();'>Find</div>";
print "<div class='btn blue hidden-print' onclick=\"exportResults();\">Export</div>";
print "<div style='clear: both;'></div>\n";
print "<table class='table table-striped'>";
print "<thead>";
print "<tr>";
print "<th>Workcenter</th>";
print "<th>Start</th>";
print "<th>End</th>";
print "<th>SO</th>";
print "<th>Job-Step</th>";
print "<th>Batch</th>";
print "<th>Assigned To</th>";
print "<th>Part</th>";
print "<th>Who</th>";
print "<th>Duration</th>";
print "<th>Qty Good</th>";
print "<th>Standard PPH</th>";
print "<th>Standard Duration</th>";
print "<th>Job Qty</th>";
print "<th>Cost</th>";
print "<th>Notes</th>";
print "</tr>";
print "</thead>";
print "<tbody>";
$sql="select p.start_time, p.end_time, j.job_id, r.display_sequence, last_name, first_name,  workcenter_name, j.item_id, j.quantity_scheduled, 
	result_date, duration_hours,  duration_minutes, p.quantity_good, p.notes, order_id, r.pph, if(r.pph=0,0,1/r.pph) as HPP, i.cost, jbo.batch_id, 
	m.machine_name, department_name from production_results p 
	 left outer join routing r on p.routing_id=r.routing_id left outer join employees e on p.employee_id=e.employee_id 
	 left outer join departments on e.department_id=departments.department_id 
	 left outer join workcenters w on w.workcenter_id=r.workcenter_id left outer join jobs j on j.job_id=p.job_id 
	left outer join jobs_batch_orders jbo on j.job_id=jbo.job_id 
	left outer join jobs_batch jb on jbo.batch_id=jb.batch_id 
	left outer join machines m on jb.machine_id=m.machine_id 
	left outer join order_lines l on l.line_id=j.line_id left outer join items i on j.item_id=i.item_name where 1 > 0 ";
if ($order) {
	$sql.=" and  l.order_id=$order ";
	$start=formatDateWebtoDB($start);
	$end=formatDateWebtoDB($end);
	if ($employee) {
		$sql.=" and e.card_number=$employee";
	}
	if ($part) {
		$sql.=" and j.item_id like '%" . $part . "%' ";
	}
	if ($workcenter) {
		$sql.=" and r.workcenter_id=$workcenter";
	}
	$sql.=" order by p.start_time ";
} else {
	if ($job) {
		$sql.=" and j.job_id=$job";
		$start=formatDateWebtoDB($start);
		$end=formatDateWebtoDB($end);
		if ($employee) {
			$sql.=" and e.card_number=$employee";
		}
		if ($part) {
			$sql.=" and j.item_id like '%" . $part . "%' ";
		}
		if ($workcenter) {
			$sql.=" and r.workcenter_id=$workcenter";
		}
		$sql.=" order by p.start_time ";
	} else {
		$start=formatDateWebtoDB($start);
		$end=formatDateWebtoDB($end);

		$plusday=date("Y-m-d", strtotime("$end +1 day"));
		$sql.=" and p.start_time > '$start 04:01:00' and p.start_time < '$plusday 04:00:59' ";

		if ($employee) {
			$sql.="  and e.card_number=$employee";
		}
		if ($part) {
			$sql.=" and j.item_id like '%" . $part . "%' ";
		}
		if ($workcenter) {
			$sql.=" and r.workcenter_id=$workcenter";
		}
		if ($team) {
			$sql.=" and e.department_id=$team ";
		}
		if ($employee) {
			$sql.=" order by p.start_time ";
		} else {
			$sql.=" order by  p.start_time ";
		}
	}
}
$exportsql=$sql;
list($result,$err)=runIQuery($db,$sql);
$holdWC="";
$pph=0;
$holdop="";
$opcount=0;
$totals = [];

print "Total Results Count: " . count($result);
foreach ($result as $data) {
	$row++;
	$wc=$data['workcenter_name'];
	$standardpph=$data['pph'];
	if ($wc != $holdWC) {
		if ($holdWC and $order) {
			if ($opcount > 0) {
			$pph = $pph / $opcount;
			}
			if ($totwC > 0) {
				if ($totGood > 0) {
					$realpph=60 / $totWC / $totGood;
				} else {
					$realpph=30;
				}
			} else {
				$realpph=30;
			}
			$realpph=round($realpph);
			$hpp=60*$pph;
			$realhpp=60*$realpph;
			
			#print "<tr><td colspan=9>Total $holdWC: &nbsp;</td><td align='right'>$totWC</td><td align='right'>$totGood</td></tr>\n";
		} else {
			if ($holdWC and $job) {
				if ($opcount > 0) {
				$pph = $pph / $opcount;
				}
				if ($totWC > 0  and $totGood > 0 ) {
					$realpph=60 / $totWC / $totGood;
				} else {
					$realpph=0;
				}
				$realpph=round($realpph);
				$hpp=60*$pph;
				$realhpp=60*$realpph;
				#print "<tr><td colspan=9>Total $holdWC: &nbsp;</td><td align='right'>$totWC</td><td align='right'>$totGood</td></tr>\n";
			}
		}
		if ($holdWC) {
			if (!isset($totals[$holdWC])) {
				$totals[$holdWC] = ["time"=>0,"good"=>0];
			}
			$totals[$holdWC]["time"] += $totWC;
			$totals[$holdWC]["good"] += $totGood;
		}
		$holdWC=$wc;
		$totWC=0;
		$totGood=0;
		$pph=0;
		$opcount=0;
	}
	$opcount++;
	$pph = $pph  + $data['pph'];
	$team=$data['department_name'];
	$job=$data['job_id'];
	$seq=$data['display_sequence'];
	$so=$data['order_id'];
	$item=$data['item_id'];
	$employee=$data['first_name'] . " " . $data['last_name'];
	$duration=abs($data['duration_hours']);
	$duration += abs($data['duration_minutes']) / 60;
	$duration = round($duration,2);
	$qty=$data['quantity_good'];
	$startTime=$data['start_time'];
	$endTime=$data['end_time'];
	$batch=$data['batch_id'];
	$machine=$data['machine_name'];
	if ($wc != "Production Weld") {
		$batch="";
	}
	$scheduled=$data['quantity_scheduled'];
	$sdt=formatDateDBToWeb($startTime);
	$edt=formatDateDBToWeb($endTime);
	$notes=$data['notes'];
	$cost=$data['cost'];
	if (! $standardpph) {
		$standardpph=1;
	}
	if (! $qty) {
		$qty=1;
	}
	$divisor=$standardpph*$qty;
	if ($divisor==0) {
		$standardDuration=0;
	} else {
		if ($standardpph > 0) {
		$standardDuration=60/$standardpph*$qty;
	}
	}
	$standardDuration=round($standardDuration,2);
	print "<tr>";
	print "<td valign='top'>$wc</td>";
	print "<td valign='top'>$sdt</td>";
	print "<td valign='top'>$edt</td>";
	print "<td valign='top'>$so</td>";
	print "<td valign='top'>$job-$seq</td>";
	print "<td valign='top'>$batch</td>";
	print "<td valign='top'>$machine</td>";
	print "<td valign='top'>$item</td>";
	print "<td valign='top'>$employee</td>";
	print "<td valign='top'>$duration</td>";
	print "<td valign='top' align='right'>$qty</td>";
	print "<td valign='top'>$standardpph</td>";
	print "<td valign='top'>$standardDuration</td>";
	print "<td valign='top' align='right'>$scheduled</td>";
	print "<td valign='top'>$cost</td>";
	print "<td valign='top'>$notes</td>";
	print "</tr>\n";
	$totWC += $duration;
	$totGood += $qty;
}
if ($holdWC and $order) {
			$pph=1;
			if ($opcount > 0 ) {
				$pph = $pph / $opcount;
			}
			$realpph=$pph;
			if ($totWC >0  and $totGood > 0) {
				$realpph=60 / $totWC / $totGood;
			}
			$realpph=round($realpph);
			$hpp=60*$pph;
			$realhpp=60*$realpph;
			#print "<tr><td colspan=9>Total $holdWC: &nbsp;</td><td align='right'>$totWC</td><td align='right'>$totGood</td></tr>\n";
} else {
	if ($holdWC and $job) {
				$pph = $pph / $opcount;
				if ($totWC > 0 and $totGood > 0) {
					$realpph=60 / $totWC / $totGood;
					$realpph=round($realpph);
					$hpp=60*$pph;
					$realhpp=60*$realpph;
				} else {
					$realpph=1;
					$hpp=1;
				}
				#print "<tr><td colspan=9>Total $holdWC: &nbsp;</td><td align='right'>$totWC</td><td align='right'>$totGood</td></tr>\n";
	}
}
if ($holdWC) {
	if (!isset($totals[$holdWC])) {
		$totals[$holdWC] = ["time"=>0,"good"=>0];
	}
	$totals[$holdWC]["time"] += $totWC;
	$totals[$holdWC]["good"] += $totGood;
}
#print $totals;
print "</tbody>";
print "</table>\n";

print "<h3>Totals</h3><table class='table table-striped' style='width: 30%'>
<thead>
	<tr>
		<th>Workcenter</th>
		<th>Duration</th>
		<th>Qty Good</th>
	</tr>
</thead>
<tbody>";

foreach ($totals as $wc => $total) {
print "<tr><td>Total $wc</td><td>" . $total["time"] . "</td><td>" . $total["good"] . "</td></tr>";
}

print "</tbody>
</table>";
if ($id) {
	print "<table class='table table-striped'>";
	print "<thead>";
	print "<tr>";
	print "<th>Card Number</th>";
	print "<th>Clock In</th>";
	print "<th>Clock Out</th>";
	print "<th>Hours</th>";
	print "</tr>";
	print "</thead>";
	print "<tbody>";
	$tothours=0;
	$sql="select card_number, clock_in, coalesce(clock_out, now()) as ckout, HOUR(TIMEDIFF(clock_in, coalesce(clock_out,now()))) as hours, MINUTE(TIMEDIFF(clock_in, coalesce(clock_out,now()))) as minutes from employee_time  where card_number=? and clock_in > '$start' and clock_in <= '$end 23:59:59'";
	list($rs,$err)=runIQuery($db,$sql,array("i",$id));
	foreach($rs as $data ) {
		print "<tr><td>";
		print $data['card_number'];
		print "</td>";
		print "<td>";
		print $data['clock_in'];
		print "</td>";
		print "<td>";
		print $data['ckout'];
		print "</td>";
		print "<td>";
		$hours=$data['hours'];
		print $data['hours'];
		$minutes=$data['minutes'];
		$hours = $hours +  round($minutes/60 * 100)/100;
		print $hours;
		$tothours+=$hours;
		print "</td>";
		print "</tr>";

	}
	print "<tr><td colspan='3'></td><td>$tothours</td></tr>\n";
	print "</tbody>";
	print "</table>\n";
}

print renderClosePanel("");
?>

<script>
function page_init() {
  $('.datepicker').datepicker();
}
function exportResults() {
	document.findform.action='exportProductionResults.php';
	document.findform.target='_blank';
	document.findform.submit();
	document.findform.action='productionResults.php';
	document.findform.target='_self';
}
</script>
<?php
include('footer.php');
?>