<?php
include('dbConnection.php');
include('functions.php');
include('security.php');
$pageTitle="Production OTD Report";

include('header.php');
print renderPanel("Production OTD Report");

$start_date=Date("m/d/Y");
if (isset($_GET['start_date'])) {
	$start_date=$_GET['start_date'];
}

$end_date=$start_date;
if (isset($_GET['end_date'])) {
	$end_date=$_GET['end_date'];
}

$order="";
if (isset($_GET['order'])) {
	$order=$_GET['order'];
}

$customer="";
if (isset($_GET['customer'])) {
	$customer=$_GET['customer'];
}


print "<form name='searchform' method='GET' class='form-horizontal form-bordered' action='productionOTDReport.php' style='width: 100%; display: flex; flex-direction: row; justify-content: space-around'>\n";
//print "<div class='form-group'>\n";
//print "<div class='col-sm-3'>\n";
print "<div>";
print "<label for='start_date'>Start Date:</label>";
//print "<div class='input-group'>";
print "<input type='text' class='form-control datepicker' size=10 name='start_date' id='start_date' value='$start_date'>";
print "</div>";
//print "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
//print "</div>";
//print "</div>";
//print "<div class='col-sm-3'>\n";
print "<div>";
print "<label for='end_date'>End Date:</label>";
//print "<div class='input-group'>";
print "<input size=10 type='text' name='end_date' id='end_date' class='form-control datepicker' value='$end_date'>";
print "</div>";
//print "<span class='input-group-addon'><i class='glyphicon glyphicon-calendar'></i></span>";
//print "</div>";
//print "</div>";
print renderTextBox(TRUE,"order",$order,"Order Number");
$sql="select customer_id, name from customers order by name";
list($rs,$err)=runIQuery($db,$sql);
//print "<div style='clear: both;'></div>\n";
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print "<input type='submit' class='btn btn-success' value='Find' style='height: 40px; width: 80px'>";
print "</form>\n";

## bdoss table below for displaying results: sales orders that have an inner due date during the time frame and when they reached shipping 
print "<br><br><br><h3>Orders Due by Inner Due Date</h3>";
print "<br><p>Production contributes to orders being on time if the order reaches Shipping by 8 AM of the internal due date.</p><br>";
print "<table class='table table-bordered table-striped'>";
print "<thead>";
print "<tr>";
print "<th valign='top'>";
print "Customer";
print "</th>";
print "<th valign='top'>";
print "Sales Order Number";
print "</th>";
print "<th valign='top'>";
print "Inner Due Date";
print "</th>";
print "<th valign='top'>";
print "Date It Reached Shipping";
print "</th>";
print "<th valign='top'>";
print "Current Order Status";
print "</th>";
// print "<th>";
// print "New Time";
// print "</th>";
print "<th>";
print "On Time Status";
print "</th>";
print "</tr>";
print "</thead>\n";
print "<tbody>";
if (isset($_GET['start_date'])) {
	$sd=formatDateWebtoDB($start_date);
	$ed=formatDateWebtoDB($end_date);

	$sql="SELECT DISTINCT orders.order_id, date_due, `status`, status_name, `name`
	FROM orders 
	INNER JOIN order_status ON order_status.status_id=orders.status
	LEFT JOIN customers on customers.customer_id=orders.customer_id
	WHERE (date_due > ? AND date_due < ?) 
	AND 
	status <> 5 ";  ## bdoss I don't want canceled orders
	if (strlen($order) > 1 && strlen($customer) > 1) {
		$sql.="AND order_id=? AND orders.customer_id=? ORDER BY order_id";
		list($rs,$err)=runIQuery($db,$sql,array("ssii",$sd,$ed,$order,$customer));
	} elseif (strlen($order) > 1) {
		$sql.="AND order_id=? ORDER BY order_id";
		list($rs,$err)=runIQuery($db,$sql,array("ssi",$sd,$ed,$order));
	} elseif (strlen($customer) > 1) {
		$sql.="AND orders.customer_id=? ORDER BY order_id";
		list($rs,$err)=runIQuery($db,$sql,array("ssi",$sd,$ed,$customer));
	} else {
		$sql.="ORDER BY order_id";
		list($rs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
	}
	
	$totalOrders = count($rs);
	$totalOnTime=0;
	$totalLate=0;

	foreach($rs as $data) {
		
		$orderID=$data['order_id'];
		$innerDueDate=$data['date_due'];
		$currentStatus=$data['status_name'];
		$customer=$data['name'];
	
		$inShippingDate="Hasn't reached shipping";
		$sql="SELECT MAX(date_changed) FROM order_status_update WHERE order_id=? AND new_status=8";
		list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
		if (!is_null($rs[0][0])) {
			if (strlen($rs[0][0])>0) {
				$inShippingDate=$rs[0][0];
			
				## compare inner due date to date it was updated to "In Shipping" minus 8 hours (they're given until 8AM of the Inner Due Date to get the order to shipping)
				$date=date_create($inShippingDate);
				$newTime = date_sub($date, date_interval_create_from_date_string('8 hours'));
				$newTime = date_format($newTime, 'y-m-d H:i:s');
				if (strtotime($newTime) <= strtotime($innerDueDate)) {
					$onTimeStatus = "On Time";
					$color ="green";
					$totalOnTime+=1;
				} else {
					$onTimeStatus = "Late";
					$color ="red";
					$totalLate+=1;
				}
			}
		}

		if ($inShippingDate == "Hasn't reached shipping" && $innerDueDate < Date("Y-m-d")) {
			$onTimeStatus = "Late";
			$color = "red";
			$totalLate+=1;
		}

		print "<tr>";
		print "<td>";
		print $customer;
		print "</td>";
		print "<td><a href='editOrders.php?id=$orderID' target='_blank' rel='opener'>";
		print $orderID;
		print "</a></td>";
		print "<td>";
		print formatDateDBtoWeb($innerDueDate);
		print "</td>";
		print "<td>";
		print $inShippingDate == "Hasn't reached shipping" ? $inShippingDate : formatDateDBtoWeb($inShippingDate);
		print "</td>";
		print "<td>";
		print $currentStatus;
		print "</td>";
		// print "<td>";
		// print $newTime;
		// print "</td>";
		print "<td style='color: $color'>";
		//print var_dump($newTime);
		//print var_dump($innerDueDate);
		print $onTimeStatus;
		print "</td";
		print "</tr>";

	}
}
if ($totalOrders !=0) {
	$percentageOnTime = ($totalOnTime / $totalOrders) * 100;
}
print "<tr><td></td><td></td><td></td><td></td><td></td><td><b>Percentage On Time : " . round($percentageOnTime) . " %</b></td>";
print "</tbody>";
print "</table>";




print renderClosePanel();
?>
<script>
	function page_init() {
		jQuery('.datepicker').datepicker();
		$(".control-label").css("padding-top", "0px");
	}
</script>
<?php
include('footer.php');
?>