<?php
error_reporting(E_ALL);
ini_set('display_errors','on');

ob_end_flush();


## this function returns the next display sequence in a parts routing

function getNextSequence($db,$part) {
	$max=0;
	$sql="select max(display_sequence) as max from routing where parent_part=?";
	list($rrs,$err)=runIQuery($db,$sql,array("s",$part));
	if (count($rrs)>0) {
		$max=$rrs[0]['max'];
	}
	return $max+10;
}
## this function specifally makes a production fabrication routing if necessary and adds the child part to that step
function makeRoutingBOM($db,$parent,$child,$qtyper) {
	$retval="";
	## cannot be sheet stock
	$sql="select * from items where item_name=? and item_category <> 24 ";
	list($rs,$err)=runIQuery($db,$sql,array("s",$parent));
	if (count($rs)) {
		$sql="select * from billofmaterial where parent_item=? and child_item=? ";
		list($rs,$err)=runIQuery($db,$sql,array("ss",$parent,$child));
		if (count($rs)==0) {
			## 3134 is Prouduction Fabrication
			$sql="select display_sequence, routing_id from routing where parent_part=? and operation_id=3134";
			list($rs,$err)=runIQuery($db,$sql,array("s",$parent));
			if (count($rs)==0) {
				$seq=30;
				$weldSeconds=1000;
				$url="https://preferrederp1.com/getOperationTimes.php?operation=WELD&part=$parent&code=8383";
				$test=file_get_contents($url);
				if ($test) {
					$weldSeconds=$test;
				}
				$seq=30;
				// fix to prevent divide by 0 error - Josh 01-13-2023
				if (!$weldSeconds) {
					$hpp=0;
					$pph=0;
				} else {
					$hpp=$weldSeconds/3600;
					$pph=1/$hpp;
				}

				if ($pph > 1000) {
					$pph=1000;
				}
				$sql="select * from routing where parent_part=? and operation_id=3134";
				list($ckrs,$err)=runIQuery($db,$sql,array("s",$parent));
				if (count($ckrs)==0) {
					$sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
					$sql.=" values ('Weld', ?, 3134, 0, 183, ?, 1, 1, 'Weld To Print', $seq) ";
					list($rrs,$err)=runIQuery($db,$sql,array("sd",$parent,$pph));
					$routing=$rrs[0]['id'];
				} else {
					$routing=$ckrs[0]['routing_id'];
				}
				$retval.="<tr><td>Added Production Fab to $parent</td></tr>";
			} else {
				$data=$rs[0];
				$routing=$data['routing_id'];
				$seq=$data['display_sequence'];
			}
			$sql="insert into billofmaterial (parent_item, child_item, quantity_per, routing_id, runseq) ";
			$sql.=" values (?, ?, ?, ?, ?) ";
			list($rs,$err)=runIQuery($db,$sql,array("ssdii",$parent,$child,$qtyper,$routing,$seq));
			$retval.= "<tr><td>Set $child as child of $parent</td></tr>\n";
		} else {
			$retval.= "<tr><td> $child already child of $parent</td></tr>\n";
		}
	}
	return $retval;
}

$ip="";
if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	$ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
}
if (! $ip)  {
	$ip=$_SERVER['REMOTE_ADDR'];
}

include('dbConnection.php');
include('functions.php');
include('security.php');
include('machineDB.php');
include('header.php');

print "<table>";

$so=$_GET['so'];

#$sql="select * from orders where order_id in (select order_id from orders_moved) order by order_id  ";
$sql="select * from orders where order_id =$so order by order_id  ";

list($rs,$err)=runIQuery($machineDB,$sql);
foreach ($rs as $data) {
    $id=$data['order_id'];
    $orderID=$id;
        ## order created let's process the order lines
        $sql="select l.*, material_name from order_lines l left outer join materials m on l.material=m.material_id where order_id=? order by line_id ";
        list($lrs,$err)=runIQuery($machineDB,$sql,array("i",$id));
        foreach ($lrs as $ldata) {
            $oldLine=$ldata['line_id'];
            $item_id=$ldata['item_id'];
            $item_description=$ldata['item_description'];
            $possibleParent=explode(" ",$item_description)[0];
            $quantity=$ldata['quantity'];
            $price=$ldata['price'];
            $cost=$ldata['cost'];
            $document_id=$ldata['document_id'];
            $po_line=$ldata['po_line'];
            $due_date=$ldata['due_date'];
            $revision=$ldata['revision'];
            $material=$ldata['material'];
            $thickness=$ldata['thickness'];
            $xdimension=$ldata['xdimension'];
            $ydimension=$ldata['ydimension'];
            $operator_notes=$ldata['operator_notes'];
            $calculated_price=$ldata['calculated_price'];
            $plugs=$ldata['plugs'];
            $masking=$ldata['masking'];
            $shipped_quantity=0;
            $weight=$ldata['weight'];
            $materialName=$ldata['material_name'];
    
            ## create item if necessary        
            $sql="select * from items where item_name=?";
            list($updrs,$err)=runIQuery($db,$sql,array("s",$item_id));
            print "\n\n$sql\n\n";
            if (count($updrs)) {
                $data=$updrs[0];
                $id=$data['item_id'];
                $category=$data['item_category'];
                $sql="select customer_id, salesperson_id  from orders where order_id=? ";
                list($ors,$err)=runIQuery($db,$sql,array("i",$orderID));
                $odata=$ors[0];
                $customer=$odata[0];
                $salesperson=$odata[1];
                $sql="update items set  width=?, length=?, customer_id=?, salesperson_id=?, price=?, cost=? where item_id=?";
            
                list($rs,$err)=runIQuery($db,$sql,array("ddiiddi",$xdimension,$ydimension,$customer,$salesperson,$price,$cost,$id));
                $inItems=1;
                $itemList[]=$item_id;
            } else {
                $category=20;
                ## finished goods
                $sql="select * from items where item_name=?";
                list($rs,$err)=runIQuery($db,$sql,array("s",$item_description));
                if (count($rs)) {
                    $category=19; ## component
                }
                if (!isset($plugs)) {
                    $plugs=0;
                }
                if (!isset($masking)) {
                    $masking=0;
                }
                $customer=706;
                $sql="select customer_id, salesperson_id  from orders where order_id=? ";
                list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
                print "trying to get to $orderID\n\n\n";
                $data=$rs[0];
                $customer=$data[0];
                $salesperson=$data[1];
                $sql="insert into items (item_name, item_category, item_description, unit_of_measure, price, cost, status, quantity_on_hand, vendor_id, customer_id, width, length, plugs, masking, notes, markup, salesperson_id) ";
                $sql.=" values (?, ?, ?, 7, ?, ?, 4, 0, 0,?,?,?,?,?,'CREATED BY bulkLoadOrders.php',20,?) ";
                list($rs,$err)=runIQuery($db,$sql,array("sisddiddiii",$item_id,$category,$item_description,$price,$cost,$customer,$xdimension,$ydimension,$plugs,$masking,$salesperson));
                $data=$rs[0];
                $id=$data['id'];
            }
            ## add to order line table
            print "category is $category\n\n\n";
            if ($category == 20 or $category == 17) {
                $color=0;
                $sql="select date_due, status from orders where order_id=? ";
                list($rs,$err)=runIQuery($db,$sql,array("i",$orderID));
                $due=$rs[0][0];
                $newStatus=$rs[0][1];
                $sql="select * from order_lines where order_id=? and item_id=? ";
                list($ckrs,$err)=runIQuery($db,$sql,array("is",$orderID,$item_id));
                if (count($ckrs)==0) {
                    $sql="insert into order_lines (order_id, item_id, item_description, quantity, price, po_line, cost, due_date,revision, powder_color, 
                    xdimension, ydimension,plugs,masking, line_status) ";
                    $sql.=" values (?, ?, ?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?) ";
                    if (!isset($po_line)) { // fixed potential undefined errors - Josh 01-13-2023
                        $po_line=0;
                    }
                    list($updrs,$err)=runIQuery($db,$sql,array("issddsdssiddiii",$orderID,$item_id,$item_description,$quantity,$price,$po_line,$cost,$due_date,$revision,$color,$xdimension,$ydimension,$plugs,
                        $masking,$newStatus));
                    print "inserted line $err\n\n";
                }
            }
            ## check if description matches a line on the order and if so create weldment step(s) for the description part
            $sql="select quantity from order_lines where item_id=? order by line_id desc";
            print "checking $item_description for weldbom\n\n";
            // description = parent item, item_id = child item
            list($rrs,$err)=runIQuery($db,$sql,array("s",$possibleParent));
            if (count($rrs)>0) {
                $parentQuantity=$rrs[0][0];
                print "making $quantity and $parentQuantity\n\n";
                print makeRoutingBOM($db,$item_description,$item_id,$quantity/$parentQuantity);
            }
            ## check for operations, add them in correct order operations.customer_sequence is the clue
            $sql="select op.operation_name from  order_line_operations olo
            inner join operations op on olo.operation_id=op.operation_id
             where line_id=?  order by op.customer_sequence";
            list($oprs,$err)=runIQuery($machineDB,$sql,array("i",$oldLine));
            foreach ($oprs as $opdata) {
                $opname=strtoupper($opdata[0]);
                $opAdded=0;
                ## if laser checked, get material name and add it to the BOM with Laser routing
                if ($opname=="LASER") {
                    ## create routing for Laser - operation 3123
                    ## for now make it 1000
                    $sql="select * from routing r where parent_part=? and operation_id=3123";
                    list($rrs,$err)=runIQuery($db,$sql,array("s",$item_id));
                    if (count($rrs)==0) {
                        $laserSeconds=10;
                        $url="https://preferrederp1.com/getOperationTimes.php?operation=LASER&part=$item_id&code=8383";
                        $test=file_get_contents($url);
                        if ($test) {
                            $laserSeconds=$test;
                        }
                        // fix to prevent divide by 0 error - Josh 01-13-2023
                        if (!$laserSeconds) {
                            $hpp=0;
                            $pph=0;
                        } else {
                            $hpp=$laserSeconds/3600;
                            $pph=1/$hpp;
                        }
                        if ($pph > 1000) {
                            $pph=1000;
                        }
                        $seq=getNextSequence($db,$item_id);
                        $sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
                        $sql.=" values ('Laser', ?, 3123, 181, 181, ?, 1, 1, 'Laser Cut', $seq) ";
                        list($rrs,$err)=runIQuery($db,$sql,array("sd",$item_id,$pph));
                        print "<tr><td>";
                        print "Added Laser to $item_id";
                        print "</td></tr>";
                        $routing=$rrs[0]['id'];
                        // item category 17 is laser cut
                        // But be careful if it is going to go into a routing do not change from component
                        $sql="select quantity from order_lines where item_id=? order by line_id desc";
                        list($rrs,$err)=runIQuery($db,$sql,array("s",$item_description));
                        if (count($rrs)==0) {
                            $sql = "update items set item_category=17 where item_name=?";
                            list($lcrs,$err)=runIQuery($db,$sql,["s",$item_id]);
                        }
                        print "checking for material $materialName\n\n";
                        $sql="select * from items where item_name=?";
                        list($mrs,$err)=runIQuery($db,$sql,array("s",$materialName));
                        if (count($mrs)> 0) {
                            $mdata=$mrs[0];
                            $materialArea=$mdata['length'] * $mdata['width'];
                            if (! $materialArea) {
                                $materialArea=120*60;
                            }
                            $qtyper=1;
                            if ($materialArea > 0) {
                                $qtyper=($xdimension*$ydimension)/$materialArea;
                            }
                            $sql="insert into billofmaterial (parent_item, child_item, quantity_per, routing_id, runseq) ";
                            $sql.=" values (?, ?, ?, ?, 10) ";
                            list($brs,$err)=runIQuery($db,$sql,array("ssdi",$item_id,$materialName,$qtyper,$routing));
                            print "<tr><td>";
                            print "Added $materialName as BOM for $item_id";
                            print "</td></tr>";
                        } else {
                            print "missing material is $materialName\n\n";
                        }
                    } else {
                        print "<tr><TD>LASER already on $item_id</td></tr>";
                    }
                    $opAdded=1;
                }
                if ($opname == "BEND") {
                    $sql="select * from routing r where parent_part=? and operation_id=3122";
                    list($rrs,$err)=runIQuery($db,$sql,array("s",$item_id));
                    if (count($rrs)==0) {
                        $bendSeconds=1000;
                        ## add routing for bend - operation 3122
                        ## get from machines system via api
                        $url="https://preferrederp1.com/getOperationTimes.php?operation=BEND&part=$item_id&code=8383";
                        $test=file_get_contents($url);
                        if ($test) {
                            $bendSeconds=$test;
                        }
                        $seq=getNextSequence($db,$item_id);
                        // fix to prevent divide by 0 error - Josh 01-13-2023
                        if (!$bendSeconds) {
                            $hpp=0;
                            $pph=0;
                        } else {
                            $hpp=$bendSeconds/3600;
                            $pph=1/$hpp;
                        }
                        if ($pph > 1000) {
                            $pph=1000;
                        }
                        $sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
                        $sql.=" values ('Bend', ?, 3122, 180, 180, ?, 1, 1, 'Bend To Print', $seq) ";
                        list($rrs,$err)=runIQuery($db,$sql,array("sd",$item_id,$pph));
                        print "<tr><td>";
                        print "Added BEND to $item_id";
                        print "</td></tr>";
    
                    } else {
                        print "<tr><TD>BEND already on $item_id</td></tr>";
                    }
                    $opAdded=1;
                }
                if ($opname == "WELDMENT") {
                    ## doing this elsewhere
                    $opAdded=1;
                }
                if ($opname == "WELD") {
                    $sql="select * from routing r where parent_part=? and operation_id=3099";
                    list($rrs,$err)=runIQuery($db,$sql,array("s",$item_id));
                    if (count($rrs)==0) {
                        $weldSeconds=1000;
                        ## add routing for bend - operation 3122
                        ## get from machines system via api
                        $url="https://preferrederp1.com/getOperationTimes.php?operation=WELD&part=$item_id&code=8383";
                        $test=file_get_contents($url);
                        if ($test) {
                            $weldSeconds=$test;
                        }
                        $seq=getNextSequence($db,$item_id);
                        // fix to prevent divide by 0 error - Josh 01-13-2023
                        if (!$weldSeconds) {
                            $hpp=0;
                            $pph=0;
                        } else {
                            $hpp=$weldSeconds/3600;
                            $pph=1/$hpp;
                        }
                        if ($pph > 1000) {
                            $pph=1000;
                        }
                        $sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
                        $sql.=" values ('Weld', ?, 3099, 317, 168, ?, 1, 1, 'Weld To Print', $seq) ";
                        list($rrs,$err)=runIQuery($db,$sql,array("sd",$item_id,$pph));
                        print "<tr><td>";
                        print "Added WELD to $item_id";
                        print "</td></tr>";
    
                    } else {
                        print "<tr><TD>WELD already on $item_id</td></tr>";
                    }
                    $opAdded=1;
                }
    
    
                if (! $opAdded) {
                    $sql="select * from operations where operation_name=? ";
                    list($ors,$err)=runIQuery($db,$sql,array("s",$opname));
                    if (count($ors)>0) {
                        $odata=$ors[0];
                        $workcenter=$odata['default_workcenter'];
                        $machine=$odata['default_machine'];
                        $opid=$odata['operation_id'];
                        if (! $machine) {
                            $sql="select machine_id from machines where machine_name=?";
                            list($ors,$err)=runIQuery($db,$sql,array("s",$opname));
                            if (count($ors)) {
                                $machine=$ors[0][0];
                            } else {
                                $machine=313;
                            }
                        }	
                        if (! $workcenter) {
                            $sql="select workcenter_id from workcenters where workcenter_name=?";
                            list($ors,$err)=runIQuery($db,$sql,array("s",$opname));
                            if (count($ors)) {
                                $workcenter=$ors[0][0];
                            } else {
                                $workcenter=182; ## training
                            }
                        }
                        $seconds=10;
                        $url="https://preferrederp1.com/getOperationTimes.php?operation=$opname&part=$item_id&code=8383";
                        $test=file_get_contents($url);
                        if ($test) {
                            $seconds=$test;
                        }
                        // fix to prevent divide by 0 error - Josh 01-13-2023
                        if (!$seconds) {
                            $hpp=0;
                            $pph=0;
                        } else {
                            $hpp=$seconds/3600;
                            $pph=1/$hpp;
                        }
                        $seq=getNextSequence($db,$item_id);
                        $sql="select * from routing where parent_part=? and operation_id=?";
                        list($rrs,$err)=runIQuery($db,$sql,array("si",$item_id,$opid));
                        if (count($rrs)==0) {
                            $sql="insert into routing (description, parent_part, operation_id, machine_id, workcenter_id, pph, people, units, notes, display_sequence) ";
                            $sql.=" values ('$opname', ?, $opid, $machine, $workcenter, ?, 1, 1, '$opname', $seq) ";
                            list($rrs,$err)=runIQuery($db,$sql,array("sd",$item_id,$pph));
                            print "<tr><td>";
                            print "Added $opname to $item_id";
                            print "</td></tr>";
                        }
    
                    }
    
                }
            }
        }

}
print "</table>";

$sql="select order_id from orders_moved";
list($rs,$err)=runIQuery($machineDB,$sql);
foreach ($rs as $data) {
    $orderID=$data['order_id'];
    createJobsForOrder($db,$orderID);
}

createJobsForOrder($db,134476);
createJobsForOrder($db,139613);


    include('footer.php');





