<?php
date_default_timezone_set("America/Detroit");
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
$id=$_GET['id'];

print renderPanel("Invoice","Invoice","red","col-md-12");
$sql="select * from orders where order_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$id));
$data=$rs[0];
$po=$data['po_number'];
$customer_id=$data['customer_id'];
if (! $customer_id) {
	$customer_id=0;
}
$sql="select * from customers where customer_id=?";
list($rs,$err)=runIQuery($db,$sql,array("i",$customer_id));
$cdata=$rs[0];
$customer_name=$cdata['name'];
$customer=str_replace(" ","",$cdata['name']);
$customer_address=$cdata['address'];
$customer_city=$cdata['city'];
$customer_state=$cdata['state'];
$customer_zip=$cdata['zip'];
$customer_phone=$cdata['phone'];
$customer_email=$cdata['email'];
$ship_name=$data['ship_name'];
$ship_address=$data['ship_address'];
$ship_city=$data['ship_city'];
$ship_state=$data['ship_state'];
$ship_zip=$data['ship_zip'];
$date_order=formatDateDBToWeb($data['date_order']);
$order=$data['order_id'];
$date_due=$data['date_due'];
if (! $date_due) {
	$date_due=Date("Y-m-d");
}
$status=$data['status'];
$po_number=$data['po_number'];
$orderType=$data['order_type'];

$salesperson_id=$data['salesperson_id'];
$notes_to_customer=$data['notes_to_customer'];
$notes_to_self=$data['notes_to_self'];
$email=$data['email'];
$phone=$data['phone'];
$surcharge=0;
if ($orderType) {
	// is `factor` in weld, unsure why -Josh 03/16/2023
	$sql="select factor, type_name from order_types where type_id=?";
	list($rs,$err)=runIQuery($db,$sql,array("i",$orderType));
	$data=$rs[0];
	$surcharge=$data[0];
	$typeName=$data[1];
}

$grandTotal=0;


print renderStartItem(FALSE,"Customer","Customer");
print "Customer<BR>" . $customer_name;
print renderEndItem();
print renderStartItem(FALSE,"ship_name","Ship Name");
print "Ship To<BR>" . $ship_name;
print renderEndItem();
print renderStartItem(FALSE,"date_due","Date Due");
print "Date Due<BR>" . formatDateDBToWeb($date_due);
print renderEndItem();
print renderStartItem(FALSE,"ponumber","PO Number");
print "PO Number<BR>" . $po;
$sql="select * from orders where po_number=? and order_id != ? and customer_id = ?";
list($prs,$perr)=runIQuery($db,$sql,array("ssi",$po,$order,$customer_id));
foreach($prs as $pdata) {
	$order=$pdata['order_id'];
	print "<br>Related Order <a href='printInvoice.php?id=$order' target='_blank'>$order</a>";
}
print renderEndItem();
print renderTextBox(TRUE,"Order",$order,"SO #");
$sql="select status_id, status_name from order_status order by status_name='Open' Desc, status_name";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"order_status",$status,"Status","N",$rs,0);
print "<div style='clear: both;'></div>\n";
$grandTotal=0;
$grandCost=0;
$grandActual=0;
print "<table class='table table-striped'>";
print "<thead>";
print "<tr><th>Part</th><th>Description</th><th>Cost</th><th>Price</th><th>Actual Cost</th><th>Quantity</th><th>Extended Cost</th><th>Extended Price</th><th>Extended Actual</th></tr>\n";
print "</thead>";
print "<tbody>";
$sql="select * from order_lines where order_id=? order by line_id ";
list($rs,$err)=runIQuery($db,$sql,array("s",$order));
foreach ($rs as $data) {
	$part=$data['item_id'];
	$price=$data['price'];
	$cost=calculateCost($db,$part);
	$powderCost=calculatePowderCost($db,$part,1);
	$cost+=$powderCost;
	$qty=$data['quantity'];
	$description=$data['item_description'];
	$extCost=$cost * $qty;
	$extPrice=$price * $qty;
	$line=$data['line_id'];
	// calculateActualCost uses number_format, which has a ',' as a separator for thousands separator
	// we could change that but I don't know if that would effect anything else so just replacing it here -Josh 03/16/2023
	$actualCost=str_replace(",", "", calculateActualCost($db,$part,$line));
	$actualCost+=$powderCost;
	$extActual=$actualCost*$qty;
	print "<tr><td><a href='showCostPrice.php?prefix=$part' target='_blank'>$part</a></td>";
	print "<td>$description</td>";
	print "<td align='right'>$cost</td>";
	print "<td align='right'>$price</td>";
	print "<td align='right'>$actualCost</td>";
	print "<td align='right'>$qty</td>";
	print "<td align='right'>";
	print number_format($extCost,2);
	print "</td>";
	print "<td align='right'>";
	print number_format($extPrice,2);
	print "</td>";
	print "<td align='right'>";
	print number_format($extActual,2);
	print "</td>";
	print "</tr>\n";
	$grandCost+=$extCost;
	$grandTotal+=$extPrice;
	$grandActual+=$extActual;
}
print "<tr><td colspan='6' align='right'>Total Order</td>";
print "<td align='right'>";
print number_format($grandCost,2);
print "</td>";
print "<td align='right'>";
print number_format($grandTotal,2);
print "</td>";
print "<td align='right'>";
print number_format($grandActual,2);
print "</td>";
print "</tr>\n";
print "<tr><td colspan='6' ></td><td align='right'>";
// was using $extXXXX which is for individual parts, changed to totals -Josh 03-16-2023
$diff=$grandTotal - $grandCost;
$pct=0;
if ($grandCost) {
	$pct = $diff / $grandCost * 100;
}
print "Profit: ";
print number_format($diff,2);
print "&nbsp;&nbsp;%";
print number_format($pct,1);
print "</td><td align='right'>";
$diff=$grandTotal - $grandActual;
$pct=0;
if ($grandActual) {
	$pct = $diff / $grandActual * 100;
}
print "Actual Profit: ";
print number_format($diff,2);
print "&nbsp;&nbsp;%";
print number_format($pct,1);
print "</td></tr>\n";
print "</tbody></table>\n";

print renderClosePanel();

include('footer.php');

