<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (! $_POST) {
	$_POST=$_GET;
}

function createResults($db,$card,$job,$routing,$hours,$minutes,$qtygood,$start,$end) {
    global $businessUnit;
    date_default_timezone_set('America/Detroit');
    $sql = "SET time_zone = ?";
    list($rs,$err)=runIQuery($db,$sql,["s",date('P')]);

	$sql="select employee_id from employees where card_number=? and coalesce(inactive,0) = 0 ";
	list($rs,$err)=runIQuery($db,$sql,array("i",$card));
	$data=$rs[0];
	if ($data[0]) {
		$employee=$data[0];
	}
	if (! $employee)  {
		$employee=$card;
	}
	if (! $employee) {
		$employee=0;
	}
		if ($minutes < 1 and $hours == 0) {
			$minutes=1;
		}

    $sql = "insert into production_results (job_id,routing_id,employee_id,result_date,duration_hours,duration_minutes,quantity_good,shift_id,notes,start_time,end_time,complete,business_unit) values (?,?,?,now(),?,?,?,1,'',?,?,1,?)";
    list ($rs,$err)=runIQuery($db,$sql,["iiiiiissi", $job,$routing,$employee,$hours,$minutes,$qtygood,$start,$end,$businessUnit]);
}

$lorul=0;
$title="Line Loading or Unloading";
$color="green";
if (isset($_POST["lorul"])) {
    $lorul=$_POST["lorul"];
    if ($lorul == 1) {
        $title = "Line Loading";
        $color="blue";
    }
    if ($lorul == 2) {
        $title = "Line Unloading";
        $color="red";
    }
}
$bottomScript="";

$employees = "$userID-"; // Used by load_scans to keep track of the userID-emp1,emp2,emp3 etc
$employeeParams = "";
$employeeCount = 5;
for ($i = 1; $employeeCount+1 > $i; $i++) {
    if (isset($_POST["employee$i"])) {
        ${"employee$i"} = $_POST["employee$i"]; // Will automatically set variables
    } else {
        ${"employee$i"} = 0; // Will be 0 if not in $_POST
    }

    $cardnum = ${"employee$i"};
    if ($cardnum == 0) {
        continue;
    }
    if ($employees != "$userID-") {
        $employees .= ",";
    }
    $employees .= $cardnum;

    if ($employeeParams != "") {
        $employeeParams .= "&";
    }
    $employeeParams .= "employee$i=" . ${"employee$i"};
}
$hasEmployees = $employee1 > 0;

print renderPanel($title,"",$color);

if ($hasEmployees) {
    $sql = "select card_number, concat(first_name, ' ', last_name) as full_name from employees where card_number in (";
    $vars = [];
    for ($i = 1; $employeeCount+1 > $i; $i++) {
        $emp = ${"employee".$i};
        if ($emp > 0) {
            if (count($vars) == 0) {
                $sql .= "?";
                $vars[] = "i";
            } else {
                $sql .= ", ?";
                $vars[0] .= "i";
            }
            $vars[] = $emp;
        }
    }
    $sql .= ") and inactive=0 order by first_name";

    print "<table class='table table-bordered'>
        <tr><th>Employees</th><th></th><th></th><th></th><th><button class='btn red' id='signoutbtn' onclick='signOut(); return false;'>Sign Out</button></th><tr>";

    list($rs,$err) = runIQuery($db,$sql,$vars);
    $count = 1;
    foreach ($rs as $employee) {
        print "<td style='width: " . (100/$employeeCount) . "%;'>" . $employee["full_name"] . "</td>";
        $count++;
    }

    for ($i = $count; $employeeCount+1 > $i; $i++) {
        print "<td style='width: " . (100/$employeeCount) . "%;'></td>";
    }

    print "</tr></table>";
}

print "<form name='selform' id='selform' action='powderTimeEntry.php' method='POST'>";
if (!$lorul) {
    if ($hasEmployees) {
        for ($i = 1; $employeeCount+1 > $i; $i++) {
            $cardnum = 0;
            if (isset($_POST["employee$i"])) {
                $cardnum = $_POST["employee$i"];
            }
            print "<input type='hidden' name='employee$i' id='employee$i' value='$cardnum'>";
        }
    }

    print "<h3>Please select if you are loading or unloading</h3>";

    print "<div class='span3'>
        <div class='control-group span11'>
            <div class='controls'>
                <select name='lorul' id='lorul'>
                    <option value='0'>Not Selected</option>
                    <option value='1'>Loading</option>
                    <option value='2'>Unloading</option>
                </select>
            </div>
        </div>
    </div>";

    print renderButton("Select","blue");
} else {
    print "<input type='hidden' name='lorul' id='lorul' value='$lorul'>";

    if (!$hasEmployees) { // No employees provided/employee1 not set (required)

        for ($i = 1; $employeeCount+1 > $i; $i++) {
            print renderStartItem(TRUE,"employee$i","Employee #$i");
            print "<input class='employee-input' type='number' name='employee$i' id='employee$i' class='form-control' value=''>";
            print renderEndItem();
        }
        print renderStartItem(TRUE,"","‎");
        print renderButton("Next","blue","submitEmployees(); return false;","empsub"); //return false to stop default behavior of the button
        print renderEndItem();
    } else {
        for ($i = 1; $employeeCount+1 > $i; $i++) {
            print "<input type='hidden' name='employee$i' id='employee$i' value='" . ${"employee".$i} . "'>";
        }
        print "<input type='hidden' name='start' id='start' value='" . date("Y-m-d H:i:s") . "'>";

        if ($lorul == 1) {
            include("powderNewLoad.php");
        }
        if ($lorul == 2) {
            include("powderNewUnload.php");
        }
    }
}
print "</form>";
print "</td>";
print "</tr>";
print "</table>";
print renderClosePanel();

include("footer.php");
?>
<style>
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        appearance: none;
    }

    input[type=number] {
        -moz-appearance: textfield;
    }

    .invalid {
        background: #ff9a9a !important;
    }

    .valid {
        background: #88f188 !important;
    }
</style>
<script>
    function page_init() {
        $('.employee-input').on("change",function(e) {
            var elm = $(this);
            var emp = elm.val();
            elm.removeClass("valid").removeClass("invalid");

            if (emp > 0) {
                $.ajax({
                    url: "validateEmployee.php?code=8383&id="+emp+"&rand="+Math.random(),
                    success: function(resp) {
                        if (resp != "OK-Employee Found") {
                            $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> Invalid Employee Number</span>");
                            elm.removeClass("valid").addClass("invalid").effect("shake").focus();
                        } else {
                            elm.removeClass("invalid").addClass("valid");
                        }
                    }
                });
            }
        }).keypress(function(e) {
            if (e.keyCode == 13) {
                var nextid = (+$(e.target).attr("id").substr(-1))+1;
                var nextelm = $("#employee"+nextid).focus();;
                if (!nextelm.length) {
                    $("#empsub").focus();
                }
                return false;
            }
        });

        $("#empsub").keypress(function(e) {
            submitEmployees();
            return e.keyCode != 13;
        });

        $("#employee1").focus();


        var highlighted = 0;
        var lastClicks = [];
        $(".qtyinput").on("click", function(e) {
            var elm = $(e.target || e.srcElement);
            var lastClick = lastClicks[elm.attr("id")] || 0;
            var diff = Date.now() - lastClick;
            if (diff < 300) {
                elm.val(0);
            }

            lastClicks[elm.attr("id")] = Date.now();

            if (highlighted < 2) {
                highlighted++;
                $(".highlight").effect("highlight");
            }
        });

    }

    function submitEmployees() {
        setTimeout(function() { //500ms delay to account for clicking submit before the verification ajax finished
            if ($(".invalid").length) { // has one or more invalids
                $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> One or more invalid employees!</span>");
                $(".invalid").effect("shake").first().focus();
                return;
            }

            if (!$(".valid").length) { //has no valids
                $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> No employees provided!</span>");
                $("#employee1").effect("shake").focus();
                return;
            }
            if (!$("#employee1").val()) {
                $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> Please fill out employees in order</span>");
                $("#employee1").effect("shake").focus();
                return;
            }

            document.selform.submit();
        }, 500);
    }

    function signOut() {
        document.location.href='powderTimeEntry.php?rand='+Math.random();
    }

    function checkOnLine() {
        var elm = $("#group").find(":selected");
        if (elm.hasClass("on-line")) {
            $.gritter.add("<span class='label label-warning'>This Group is already on the line!</span>");
        }
    }
</script>