<?php
include("dbConnection.php");
include("functions.php");
include("security.php");
include("header.php");

print renderPanel("Line Colors");

print "<table class='colorlist table table-bordered' style='font-size: 25px; width: 900px;'>
    <thead>
        <tr>
            <th>Group</th>
            <th>Color Code</th>
            <th>Color Name</th>
            <th>Example</th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>";

print renderClosePanel();
include("footer.php");
?>
<script>
    var demcols = {"00":"#064A25","04":"#F9D210","93":"#555B60","98":"#C6C8C5","A1":"#27292b","E9":"#c5c7c4","02":"#080808","08":"#005e83","15":"#007cb0","20":"#005b8c","N1":"#B3B3B3","T3":"#eae7e1","EY":"#F9D210","NL":"#064A25","1C":"#182D7E","69":"#4E83B8","28":"#004792","1K":"#ECEBE0","12":"#004f7c","HB":"#e6e6e6"};
    var rals = {"RAL 1001":"rgb(194, 176, 120)","RAL 1002":"rgb(198, 166, 100)","RAL 1003":"rgb(229, 190, 1)","RAL 1004":"rgb(205, 164, 52)","RAL 1005":"rgb(169, 131, 7)","RAL 1006":"rgb(228, 160, 16)","RAL 1007":"rgb(220, 157, 0)","RAL 1011":"rgb(138, 102, 66)","RAL 1012":"rgb(199, 180, 70)","RAL 1013":"rgb(238, 234, 205)","RAL 1014":"rgb(225, 204, 79)","RAL 1015":"rgb(230, 214, 144)","RAL 1016":"rgb(237, 255, 33)","RAL 1017":"rgb(245, 208, 51)","RAL 1018":"rgb(248, 243, 43)","RAL 1019":"rgb(158, 151, 100)","RAL 1020":"rgb(153, 153, 80)","RAL 1021":"rgb(243, 218, 11)","RAL 1023":"rgb(250, 210, 1)","RAL 1024":"rgb(174, 160, 75)","RAL 1026":"rgb(255, 255, 0)","RAL 1027":"rgb(157, 145, 1)","RAL 1028":"rgb(244, 169, 0)","RAL 1032":"rgb(214, 174, 1)","RAL 1033":"rgb(243, 165, 5)","RAL 1034":"rgb(239, 169, 74)","RAL 1035":"rgb(106, 93, 77)","RAL 1036":"rgb(112, 83, 53)","RAL 1037":"rgb(243, 159, 24)","RAL 2001":"rgb(201, 60, 32)","RAL 2002":"rgb(203, 40, 33)","RAL 2003":"rgb(255, 117, 20)","RAL 2004":"rgb(244, 70, 17)","RAL 2005":"rgb(255, 35, 1)","RAL 2007":"rgb(255, 164, 32)","RAL 2008":"rgb(247, 94, 37)","RAL 2009":"rgb(245, 64, 33)","RAL 2010":"rgb(216, 75, 32)","RAL 2011":"rgb(236, 124, 38)","RAL 2012":"rgb(229, 81, 55)","RAL 2013":"rgb(195, 88, 49)","RAL 3001":"rgb(165, 32, 25)","RAL 3002":"rgb(162, 35, 29)","RAL 3003":"rgb(155, 17, 30)","RAL 3004":"rgb(117, 21, 30)","RAL 3005":"rgb(94, 33, 41)","RAL 3007":"rgb(53, 31, 33)","RAL 3009":"rgb(100, 36, 36)","RAL 3011":"rgb(120, 31, 25)","RAL 3012":"rgb(193, 135, 107)","RAL 3013":"rgb(161, 35, 18)","RAL 3014":"rgb(211, 110, 112)","RAL 3015":"rgb(234, 137, 154)","RAL 3016":"rgb(179, 40, 33)","RAL 3017":"rgb(230, 50, 68)","RAL 3018":"rgb(213, 48, 50)","RAL 3020":"rgb(204, 6, 5)","RAL 3022":"rgb(217, 80, 48)","RAL 3024":"rgb(248, 0, 0)","RAL 3026":"rgb(254, 0, 0)","RAL 3027":"rgb(197, 29, 52)","RAL 3028":"rgb(203, 50, 52)","RAL 3031":"rgb(179, 36, 40)","RAL 3032":"rgb(114, 20, 34)","RAL 3033":"rgb(180, 76, 67)","RAL 4002":"rgb(146, 43, 62)","RAL 4003":"rgb(222, 76, 138)","RAL 4004":"rgb(110, 28, 52)","RAL 4005":"rgb(108, 70, 117)","RAL 4006":"rgb(160, 52, 114)","RAL 4007":"rgb(74, 25, 44)","RAL 4008":"rgb(146, 78, 125)","RAL 4009":"rgb(164, 125, 144)","RAL 4010":"rgb(215, 45, 109)","RAL 4011":"rgb(134, 115, 161)","RAL 4012":"rgb(108, 104, 129)","RAL 5001":"rgb(31, 52, 56)","RAL 5002":"rgb(32, 33, 79)","RAL 5003":"rgb(29, 30, 51)","RAL 5004":"rgb(24, 23, 28)","RAL 5005":"rgb(30, 45, 110)","RAL 5007":"rgb(62, 95, 138)","RAL 5008":"rgb(38, 37, 45)","RAL 5009":"rgb(2, 86, 105)","RAL 5010":"rgb(14, 41, 75)","RAL 5011":"rgb(35, 26, 36)","RAL 5012":"rgb(59, 131, 189)","RAL 5013":"rgb(30, 33, 61)","RAL 5014":"rgb(96, 110, 140)","RAL 5015":"rgb(34, 113, 179)","RAL 5017":"rgb(6, 57, 113)","RAL 5018":"rgb(63, 136, 143)","RAL 5019":"rgb(27, 85, 131)","RAL 5020":"rgb(29, 51, 74)","RAL 5021":"rgb(37, 109, 123)","RAL 5022":"rgb(37, 40, 80)","RAL 5023":"rgb(73, 103, 141)","RAL 5024":"rgb(93, 155, 155)","RAL 5025":"rgb(42, 100, 120)","RAL 5026":"rgb(16, 44, 84)","RAL 6001":"rgb(40, 114, 51)","RAL 6002":"rgb(45, 87, 44)","RAL 6003":"rgb(66, 70, 50)","RAL 6004":"rgb(31, 58, 61)","RAL 6005":"rgb(47, 69, 56)","RAL 6006":"rgb(62, 59, 50)","RAL 6007":"rgb(52, 59, 41)","RAL 6008":"rgb(57, 53, 42)","RAL 6009":"rgb(49, 55, 43)","RAL 6010":"rgb(53, 104, 45)","RAL 6011":"rgb(88, 114, 70)","RAL 6012":"rgb(52, 62, 64)","RAL 6013":"rgb(108, 113, 86)","RAL 6014":"rgb(71, 64, 46)","RAL 6015":"rgb(59, 60, 54)","RAL 6016":"rgb(30, 89, 69)","RAL 6017":"rgb(76, 145, 65)","RAL 6018":"rgb(87, 166, 57)","RAL 6019":"rgb(189, 236, 182)","RAL 6020":"rgb(46, 58, 35)","RAL 6021":"rgb(137, 172, 118)","RAL 6022":"rgb(37, 34, 27)","RAL 6024":"rgb(48, 132, 70)","RAL 6025":"rgb(61, 100, 45)","RAL 6026":"rgb(1, 93, 82)","RAL 6027":"rgb(132, 195, 190)","RAL 6028":"rgb(44, 85, 69)","RAL 6029":"rgb(32, 96, 61)","RAL 6032":"rgb(49, 127, 67)","RAL 6033":"rgb(73, 126, 118)","RAL 6034":"rgb(127, 181, 181)","RAL 6035":"rgb(28, 84, 45)","RAL 6036":"rgb(25, 55, 55)","RAL 6037":"rgb(0, 143, 57)","RAL 6038":"rgb(0, 187, 45)","RAL 7001":"rgb(138, 149, 151)","RAL 7002":"rgb(126, 123, 82)","RAL 7003":"rgb(108, 112, 89)","RAL 7004":"rgb(150, 153, 146)","RAL 7005":"rgb(100, 107, 99)","RAL 7006":"rgb(109, 101, 82)","RAL 7008":"rgb(106, 95, 49)","RAL 7009":"rgb(77, 86, 69)","RAL 7010":"rgb(76, 81, 74)","RAL 7011":"rgb(67, 75, 77)","RAL 7012":"rgb(78, 87, 84)","RAL 7013":"rgb(70, 69, 49)","RAL 7015":"rgb(67, 71, 80)","RAL 7016":"rgb(41, 49, 51)","RAL 7021":"rgb(35, 40, 43)","RAL 7022":"rgb(51, 47, 44)","RAL 7023":"rgb(104, 108, 94)","RAL 7024":"rgb(71, 74, 81)","RAL 7026":"rgb(47, 53, 59)","RAL 7030":"rgb(139, 140, 122)","RAL 7031":"rgb(71, 75, 78)","RAL 7032":"rgb(184, 183, 153)","RAL 7033":"rgb(125, 132, 113)","RAL 7034":"rgb(143, 139, 102)","RAL 7035":"rgb(215, 215, 215)","RAL 7036":"rgb(127, 118, 121)","RAL 7037":"rgb(125, 127, 125)","RAL 7038":"rgb(195, 195, 195)","RAL 7039":"rgb(108, 105, 96)","RAL 7040":"rgb(157, 161, 170)","RAL 7042":"rgb(141, 148, 141)","RAL 7043":"rgb(78, 84, 82)","RAL 7044":"rgb(202, 196, 176)","RAL 7045":"rgb(144, 144, 144)","RAL 7046":"rgb(130, 137, 143)","RAL 7047":"rgb(208, 208, 208)","RAL 7048":"rgb(137, 129, 118)","RAL 8001":"rgb(149, 95, 32)","RAL 8002":"rgb(108, 59, 42)","RAL 8003":"rgb(115, 66, 34)","RAL 8004":"rgb(142, 64, 42)","RAL 8007":"rgb(89, 53, 31)","RAL 8008":"rgb(111, 79, 40)","RAL 8011":"rgb(91, 58, 41)","RAL 8012":"rgb(89, 35, 33)","RAL 8014":"rgb(56, 44, 30)","RAL 8015":"rgb(99, 58, 52)","RAL 8016":"rgb(76, 47, 39)","RAL 8017":"rgb(69, 50, 46)","RAL 8019":"rgb(64, 58, 58)","RAL 8022":"rgb(33, 33, 33)","RAL 8023":"rgb(166, 94, 46)","RAL 8024":"rgb(121, 85, 61)","RAL 8025":"rgb(117, 92, 72)","RAL 8028":"rgb(78, 59, 49)","RAL 8029":"rgb(118, 60, 40)","RAL 9002":"rgb(231, 235, 218)","RAL 9003":"rgb(244, 244, 244)","RAL 9004":"rgb(40, 40, 40)","RAL 9005":"rgb(10, 10, 10)","RAL 9006":"rgb(165, 165, 165)","RAL 9007":"rgb(143, 143, 143)","RAL 9010":"rgb(255, 255, 255)","RAL 9011":"rgb(28, 28, 28)","RAL 9016":"rgb(246, 246, 246)","RAL 9017":"rgb(30, 30, 29)","RAL 9018":"rgb(215, 215, 215)","RAL 9022":"rgb(156, 156, 156)","RAL 9023":"rgb(130, 130, 130)"};
    function refreshColors() {
        var url = "getNextLoadColor.php";
        $.ajax({
            url: url,
            success: function(resp) {
                $(".colorlist tbody").html("");

                var colors = resp.split("\n");
                for (var i = 0; colors.length > i; i++) {
                    if (colors[i] == "") {
                        continue;
                    }
                    var data = colors[i].split("|");
                    var code = data[0];
                    var name = data[1];
                    var group = data[2];
                    var color = rals[code];
                    if (!color) {
                        var ralcode = code.match(/RAL [0-9]{4}/i, code);

                        if (ralcode) {
                            color = rals[ralcode];
                        } else {
                            color=demcols[code.split(" ")[0]];
                        }
                    }

                    $(".colorlist tbody").append(`<tr>
                        <td>${group}</td>
                        <td>${code}</td>
                        <td>${name}</td>
                        <td style='background-color: ${color};'></td>
                    </tr>`);
                }
            }
        });
    }
    setInterval(refreshColors, 7500);
    refreshColors();
</script>