<?php
/**
 * TODO: Sign out not working when on unload page and no loads available
 * TODO: Allows to unload short without defect reason.
 * TODO: Add shipping>Batch Contents to line load ribbon
*/

$jobExists = 0;
function updateOrderStatusToAtPaint($db,$order) {
	$sql="select * from order_lines  where order_id=? and line_status <> 8";
	list($rs,$err)=runIQuery($db,$sql,array("i",$order));
	if (count($rs)==0) {
		$sql="select line_id from order_lines  where order_id=? and line_status = 8";
		list($rs,$err)=runIQuery($db,$sql,array("i",$order));
		if (count($rs)>0) {
			updateOrderStatus($db,$order,8);
		}
	}
}
function walkBillOfMaterial($parent, $vendorID, $part, $qtycompare,$goodcompare) {
	global $db,$qtys,$parts,$goodlist,$descriptions,$alreadyProcessed;
	$sql="select * from billofmaterial b, routing r where parent_item=? and b.child_item=r.parent_part and vendor_id=? and b.child_item <> ?";
	list($brs,$err)=runIQuery($db,$sql,array("sis",$parent,$vendorID,$part));
	if ($vendorID == 2299) {
		$sql="select * from billofmaterial b, routing r where parent_item=? and b.child_item=r.parent_part and vendor_id>0 and b.child_item <> ?";
		list($brs,$err)=runIQuery($db,$sql,array("ss",$parent,$part));
	}
	foreach ($brs as $bdata) {
		$qtyper=$bdata['quantity_per'];
		$child=$bdata['child_item'];
		$newqty=$qtyper*$qtycompare;
		$newgood=$qtyper*$goodcompare;
		if (! in_array($child,$alreadyProcessed)) {
			if (in_array($child,$parts)) {
				$qtys[$child]+=$newqty;
				$goodlist[$child]+=$newgood;
			} else {
				$sql="select item_description, item_category from items where item_name=?";
				list($irs,$err)=runIQuery($db,$sql,array("s",$child));
				$data=$irs[0];
				$description=$data['item_description'];
				$category=$data['item_category'];
				$parts[]=$child;
				$qtys[$child]=$newqty;
				$goodlist[$child]=$newgood;
				$descriptions[$child]=$description;
				walkBillOfMaterial($child,$vendorID,"",$newqty,$newgood);
			}
		}
	}

}
$i=0;
$id=0;
$qtygood=0;
$group=0;
$loadcomplete=0;
if (isset($_POST["loadcomplete"])) {
	$loadcomplete=$_POST["loadcomplete"];
}
if (isset($_GET['id'])) {
	$id=$_GET['id'];
}
if (isset($_POST['id'])) {
	$id=$_POST['id'];
}
if (isset($_POST['scan'])) {
	$scan=strtoupper(trim($_POST['scan']));
}
if (isset($_POST["group"])) {
	$group=$_POST["group"];
}

// changed variable name to make more sense
$linecount=0;
$totalpartqty=0;
if (isset($_POST["finishgroup"])) {
	## add the lines with a quantity
	$totalRows = $_POST['totalrows'];
	$i=0;
	while ($totalRows > $i) {
		$i++;
		if (isset($_POST['job'.$i])) {
			$job=$_POST['job'.$i];
			$step=$_POST['step'.$i];
		} else {
			continue;
		}

		$qty = $_POST['qty'.$i];
		if (! $qty) {
			$qty=0;
		}

		if ($qty > 0) {
			$linecount++;
			$totalpartqty+=$qty;
		}
	}

    $inserted=0;
	if ($linecount) {
		if (! $id  ) {
			## get vendor information
			$td=Date("Y-m-d");
			$sql="insert into powdercoat_load (load_group, load_date, loaded_by) values (?, now(), ? ) ";
			list($rs,$err)=runIQuery($db,$sql,array("ss",$group,$employees));
			$id=$rs[0][0];
			$inserted=1;
		}

		$i=0;
		## they scan 1 job and it shows all the components for that part
		$scan=strtoupper(trim($_POST['scan']));
		$labelqty=-1;
		$salesOrder=0;
		$sql="insert into powdercoat_load_scans (load_id, scanned_value, date_scanned, scanned_by) values (?, ?, now(), ?) ";
		list($updrs,$err)=runIQuery($db,$sql,array("iss",$id,$scan,$employees));
		if (substr($scan,0,1)=="S") {
			$salesOrder=str_replace("S","",$scan);
		}

		$start=$_POST["start"];
		$end=date("Y-m-d H:i:s");

		//Switch over to new time calculation -Josh 04-25-2022
		$diff = strtotime($end) - strtotime($start); //total seconds taken
		//!!
		$timeperqty = $diff/$totalpartqty; // time allotted for each individual part

		$minutes = round($diff/60)%60;
		$hours = floor($diff/60/60);

		$factor=0;
		for ($i = 1; $employeeCount+1 > $i; $i++) {
			$emp = ${"employee$i"};
			if ($emp > 0) {
				$factor++;
			}
		}

		$i=0;
		while ($i < $totalRows) {
			$i++;
			if (isset($_POST['job'.$i])) {
				$job=$_POST['job'.$i];
				$step=$_POST['step'.$i];
			} else {
				continue;
			}
			$part=$_POST['part'.$i];
			$qty = $_POST['qty'.$i];
			if (! $qty) {
				$qty=0;
			}
			$needed=$_POST['need'.$i];
			$colorCode = $_POST['color'.$i];
			$colorName = $_POST['cname'.$i];
			if (!$colorCode) {
				$colorCode="";
			}
			if (!$colorName) {
				$colorName = "";
			}
			if ($qty > 0) {
				$jobdiff = $timeperqty*$qty; //!!
				$minutes = round($jobdiff/60)%60;
                $hours = floor($jobdiff/60/60);

				$rid=0; // should be set always, we shall see
				## check for load , if not there, have to run the function to switch
				$sql="select * from routing where parent_part=? and operation_id=3138";
				list($rrs,$err)=runIQuery($db,$sql,array("s",$part));
				if (count($rrs)==0) {
					switchFromBatchToLine($db,$part);
					$sql = "select * from routing where parent_part=? and operation_id=3138";
					list($rrs,$err)=runIQuery($db,$sql,["s",$part]);
				}
				$rid = $rrs[0][0];


				$pph = 0; //for now
				$people=$factor;

				$qtyinsert = floor($qty/$factor);
				$leftover = $qty - ($qtyinsert * $factor);
				$firstemp = 0;
				for ($x = 1; $employeeCount+1 > $x; $x++) {
					$emp = ${"employee$x"};
					if ($emp > 0) {
						$given = $qtyinsert;
						if ($firstemp == 0) {
							$given+=$leftover;
							$firstemp=1;
						}

						createResults($db,$emp,$job,$rid,$hours,$minutes,$given,$start,$end);
					}
				}

				$sql="insert into powdercoat_load_contents (load_id, part_number, quantity, color_name, job_id) ";
				$sql.=" values (?, ?, ?, ?, ?) ";
				$pkg="";
				list($rs,$err)=runIQuery($db,$sql,array("isisi",$id,$part,$qty,$colorName,$job));
			}
		}
	}
}


if ($loadcomplete) {
	if ($id && $linecount) {
		$sql = "update powdercoat_load set load_status=2 where load_id=? and load_status=1";
		list($rs,$err)=runIQuery($db,$sql,["i",$id]);
	}

	print "<script>window.location.href='powderTimeEntry.php?$employeeParams&lorul=1&updated=1';</script>";
	die;
}

$title="New Powder Coat Load";
if ($group) {
	$title="Add to Group $group";
}

print renderPanel($title,"","green");
print "<table><tr>";
print "<td valign='top'>";
if (isset($_POST["scan"])) {
    print "<h4>Select which parts to load to group</h4>"	;
	print "<p>Enter the quantities of each part that are on this load</p>";
	print "<p>Quantites of 0 will be marked as not loaded. <span class='highlight'>(Double click the quantity to automatically set it to 0)</span></p>";
	print "<form name='updform' action='powderTimeEntry.php' method='post' onsubmit='SaveTheForm();'>";
	print "<input type='hidden' name='start' value='" . date("Y-m-d H:i:s") . "'>";
	print "<input type='hidden' name='finishgroup' value='1' id='finishgroup'>";
	print "<input type='hidden' name='loadcomplete' value='1' id='loadcomplete'>";
	print "<input type='hidden' name='scan' value='$scan'>";
    print "<input type='hidden' name='group' id='group' value='$group'>";

    $parts=array();
	$qtys=array();
	$goodlist=array();
	$descriptions=array();
	$i=1;
	$salesOrder=0;
	print "<select id='colorsel'></select>";
	print "<input type='text' class='itemScan' id='itemscan' placeholder='Scan Here' onkeydown='if (event.keyCode==13) { itemScannedCMA(this.value);event.preventDefault();return false; }' onchange='itemScannedCMA(this.value);'>";
	print "<span id='badscan'>No Match: </span>";
	print "<table id='partlist' class='table table-striped table-condensed'><thead><tr><th>Part</th><th>Description</th><th>Quantity</th><th></th><th>Scheduled / Done</th><th>&nbsp;&nbsp;&nbsp;Color</th><th>Color Code</th><th style='width: 100px;'></th><th>Scan Match</th></tr></thead><tbody>\n";
	$j=0;
	$alreadyProcessed=array();
	$vendorID=0;
		$scan=strtoupper($_POST['scan']);
		$colors = [];
		if ($scan)  {
			$salesOrder=0;
			if (!$id) {
				$sql="insert into powdercoat_load_scans (load_id, scanned_value, date_scanned, scanned_by) values (?, ?, now(), ?) ";
				list($updrs,$err)=runIQuery($db,$sql,array("iss",$id,$scan,$employees));
				if (count($updrs)) {
					print "<h4><b>Scanned Value: $scan</b></h4> ";
				}
			}

			$salesOrder = $scan;
			if (substr($scan,0,1)=="S") { // str_starts_with is part of php 8+, switched to this during testing on .info
				$salesOrder = substr($scan,1);
				$sql = "SELECT po_number from orders where order_id=? and customer_id=706";
				list($glrs,$err)=runIQuery($db,$sql,["i",$salesOrder]);
				if (count($glrs)) {
					$url = "https://preferrederp1.com/getSalesGroupLead.php?code=8383&so=".$glrs[0]["po_number"];
					$contact = file_get_contents($url);

					$cparts = explode("|",$contact);
					if (count($cparts) == 3) { // found

						print "<h4><b>SO Contact</b>: " . implode(", ", $cparts) . "</h4>";
					}
				}
			}

			//powder applicaton is 3116, line load is 3138, outside process is 3106
			$sql = "SELECT j.*, routing_id, display_sequence from order_lines ol, jobs j, routing r
			left outer join vendors v on r.vendor_id=v.vendor_id
				where ol.line_id=j.line_id
				and j.item_id=r.parent_part
				and (operation_id in (3116,3138) or (operation_id=3106 and coalesce(v.paint_vendor,0)=1))
					and ol.order_id=?";
			list($rs,$err)=runIQuery($db,$sql,["i",$salesOrder]);

			if (!count($rs)) {
				print "<script>alert('No jobs found with paint operations for this SO OR SO not in system!');window.history.back();</script>";
				die;
			}

            foreach ($rs as $data) {
				$job=$data['job_id'];
				$jobExists = $job;

				//powder applicaton is 3116, line load is 3138, outside process is 3106
				$sql = "SELECT display_sequence, workcenter_id, r.routing_id from jobs j, routing r
				left outer join vendors v  on r.vendor_id=v.vendor_id
					where (operation_id in (3116,3138) or (operation_id=3106 and coalesce(v.paint_vendor,0)=1))
					and j.job_id=?
					and j.item_id=r.parent_part
				order by v.vendor_id desc";
				list($jrs,$err)=runIQuery($db,$sql,array("i",$job));
				if (count($jrs)>0) {
					$jdata=$jrs[0];
					$step=$jdata[0];
					$wc=$jdata[1];
					if ($wc == 176) {
						## force racking to outside process
						$wc=170;
					}
				}

				if (isset($step)) {
					$part=$data['item_id'];
					$description=$data['description'];
					$customer=$data['customer_id'];
					$lineID=$data['line_id'];
					$routingID = $data["routing_id"];
					$qty=$data['quantity_scheduled'];
					$sql="select order_id from order_lines where line_id=?";
					list($updrs,$err)=runIQuery($db,$sql,array("i",$lineID));
					$odata=$updrs[0];
					$so=$odata[0];
					$vendorID=0;
					$sql="select vendor_id, operation_id from routing where parent_part=? and display_sequence >=? and vendor_id > 0 order by display_sequence  LIMIT 1 ";
					list($vrs,$err)=runIQuery($db,$sql,array("si",$part,$step));
					if (count($vrs)==0) {
						$sql="select vendor_id, operation_id from routing r where parent_part=? and operation_id in (3106, 3113) ";
						$sql.=" order by vendor_id desc  LIMIT 1 ";
						list($vrs,$err)=runIQuery($db,$sql,array("s",$part));
					}
					foreach ($vrs as $vdata) {
						if ($vendorID == 0) {
							$vendorID=$vdata['vendor_id'];
							if ($vendorID==0) {
								if ($vdata['operation_id']==3113) {
									$vendorID=2299;
								}
							}
						}
					}
					if (! $vendorID) {
						#print "<script>alert('Error Job $job Step $step does not have a vendor assigned');</script>"; // Note: This spams alerts no matter what you do, even if only one alert is sent (on Chrome only, not Firefox. likely a browser bug)
					}
				}

                if ($step) {
					$sql = "SELECT sum(quantity_good) from production_results pr, routing r where pr.job_id=? and pr.routing_id=r.routing_id and r.operation_id=3139";
					list($prs,$err)=runIQuery($db,$sql,["i",$job]);
					$qtygood=0;
					if (count($prs)) {
						$qtygood=$prs[0][0];
					}

                    $sql = "SELECT sum(quantity) from powdercoat_load_contents plc, powdercoat_load pl where plc.load_id=pl.load_id and plc.job_id=? and pl.load_status in (1,2,3)";
					list($pclrs,$err)=runIQuery($db,$sql,["i",$job]);
					$hung=0;
					if (count($pclrs)) {
						$hung=$pclrs[0][0];
					}

					$qtydone = $hung+$qtygood;

					$needed=$qty-$qtydone;
					$sql="select item_category from items where item_name=?";
					list($irs,$err)=runIQuery($db,$sql,array("s",$part));
					$category=$irs[0][0];
                    ### cma todo maybe include these now?
					if ($category != 19 && strtoupper(substr($part,0,9)) != "C20470001") {
						if ($needed < 0) {
							$needed=0;
						}

						if (!$needed) {
							continue;
						}
						$j++;
						print "<tr class='unverified error listitem' id='tr$j'>";
						print "<td>";
						print $part;
						$alreadyProcessed[]=$part;
						print "</td>";

						print "<td>";
						print $description;
						print "</td>";

						print "<td>";
						print "<input type='hidden' name='job$j' id='job$j' class='jobval' value='$job'>";
						print "<input type='hidden' name='step$j' id='step$j' value='$step'>";
						print "<input type='hidden' name='part$j' id='part$j' value='$part'>";
						if ($needed==0) {
							print "<input type='text' name='qty$j' id='qty$j' style='width: 100px;' value='$needed' readonly>";
						} else {
							print "<input type='number' min='1' max='$needed' name='qty$j' id='qty$j' class='qtyinput' style='width: 100px;' value='0' onchange=\"checkQuantity('$j',this);\" readonly>";
						}
						print "<input type='hidden' name='description$j' id='description$j' value='$description'>";
						print "<input type='hidden' name='need$j' id='need$j' class='itemval' value='$needed'>";
						print "</td>";

						print "<td></td>";

						print "<td>";
						print $qty . "/" . $qtydone;
						print "</td>";

						list($code,$name)=getDematicColor($db,$part);
						if (!$code) {
							$sql = "select color_code, color_description from vendor_colors vc, items i where i.powder_color=vc.vc_id and i.item_name=?";
							list($crs,$err)=runIQuery($db,$sql,["s",$part]);
							if (count($crs)) {
								$code = $crs[0][0];
								$name = $crs[0][1];
							}
						}
						if (!in_array($code,$colors)) {
							if (trim($code)) {
								$colors[] = $code;
							}
						}
						print "<td>";
						print "<input type='text' style='width: 200px;' name='cname$j' value='$name' readonly>";
						print "</td>";

						print "<td>";
						print "<input type='text' style='width: 100px;' name='color$j' value='$code' readonly>\n";
						print "</td>";

						print "<td></td><td id='itemscan$j'></td>";
						print "</tr>\n";
					}
					walkBillOfMaterial($parent,$vendorID,$part,$qty,$hung,0);
                }
            }
            $bottomScript .= "if ($('.qtyinput').length == 0) {
                setTimeout(function() { //small delay so they can screenshot the page if they need to submit a ticket on this
                    if (" . ($jobExists ? $jobExists : "0") . " == 0) {
                        alert('SO does not exist!');
                    } else {
                        alert('No more parts need to be hung for this SO!');
                    }
                    window.history.back();
                }, 500);
            }";
		}

	if (count($parts) > 0) {
		$i=$j;
		foreach ($parts as $part) {
			if (! in_array($part,$alreadyProcessed) and strtoupper(substr($part,0,9)) != "C20470001") {
				$sql="select item_category from items where item_name=?";
				list($irs,$err)=runIQuery($db,$sql,array("s",$part));
				$category=$irs[0][0];
				if ($category != 19) {
					## now check if Plugging/Masking is needed and if so there need to be production results for it.
					## we might actually get to the quantity in the results, but for now if there is a result we are good
					$okPR=1;
					$sql="select routing_id from routing where parent_part=? and operation_id=3119";
					list($irs,$err)=runIQuery($db,$sql,array("s",$part));
					if (count($irs)>0) {
						$idata=$irs[0];
						$checkRouting=$idata['routing_id'];
						$sql="select * from order_lines l, jobs j, production_results r where l.order_id=? and l.line_id=j.line_id and j.job_id=r.job_id and routing_id=?";
						list($irs,$err)=runIQuery($db,$sql,array("ii",$salesOrder,$checkRouting));
						if (count($irs)==0) {
							$okPR=0;
						}
					}
					$okPR=1;

					if ($okPR > 0) {
						print "<tr>";
						print "<td>";
						print $part;
						print "</td>";
						print "<td>";
						$description=$descriptions[$part];
						print $description;
						print "</td>";
						print "<td>";
						$i++;
						$qty=$qtys[$part];
						$hung=$goodlist[$part];
						print "</td>";
						print "<td></td>";
						print "<td align='right'>";
						print "$qty";
						print "</td>";
						list($code,$name)=getDematicColor($db,$part);
						if (!$code) {
							$sql = "select color_code, color_description from vendor_colors vc, items i where i.powder_color=vc.vc_id and i.item_name=?";
							list($crs,$err)=runIQuery($db,$sql,["s",$part]);
							if (count($crs)) {
								$code = $crs[0][0];
								$name = $crs[0][1];
							}
						}
						print "<td>";
						print "<input type='text' style='width: 200px;' name='cname$i' value='$name' readonly>";
						print "</td>";
						print "<td><input type='text' style='width: 100px;' name='color$i' value='$code' readonly>\n";
						print "</td>";
						print "</tr>\n";
					} else {
						print "<tr>";
						print "<td style='color: red;'>";
						print $part;
						print " NEEDS PLUGS/MASKING";
						print "</td>";
						print "<td>";
						$description=$descriptions[$part];
						print $description;
						print "</td>";
						print "<td>";
						$i++;
						$qty=$qtys[$part];
						$hung=$goodlist[$part];
						print "</td>";
						print "<td></td>";
						print "<td align='right'>";
						print "$qty";
						print "</td>";
						print "<td>";
						print "<input type='text' style='width: 200px;' name='cname$i' value='NEEDSPM' readonly>";
						print "</td>";
						print "<td><input type='text' style='width: 100px;' name='color$i' value='NEEDSPM' readonly>\n";
						print "</td>";
						print "</tr>\n";

					}
				}
			}
		}
	}
	print "</tbody></table>";

	print "<input type='hidden' id='totalrows' name='totalrows' value='$j'>\n";
	print "<input type='hidden' id='id' name='id' value='$id' id='id'>\n";
	print "<div style='clear: both;'></div>";
	print renderButton("Finish Loading $group","green","SaveTheForm()","SaveFormButton");
	print "</form>";

	$bottomScript .= "\nvar colorsel = $('#colorsel'); var colorlist = " . json_encode($colors) . ";
	colorsel.on('change', function(e) {
		e.target.value;

		$('#partlist').children()[1].children.forEach(function(x) {
			try {
				var color = x.children[6].children[0].value;
				if (color != e.target.value) {
					x.style.display = 'none';
					$(x).removeClass('no-apply').addClass('no-apply');
				} else {
					x.style.display = 'table-row';
					$(x).removeClass('no-apply');
				}
				if (e.target.value == 0) {
					x.style.display = 'table-row';
				}
			} catch(e) {

			}
		});

		$('#SaveFormButton').removeAttr('disabled');

		if (e.target.value == 0) {
			$('#SaveFormButton').attr('disabled', 1);
		}
	});";
	$bottomScript .= " if (colorlist.length > 1) {
		colorsel.append('<option value=\"0\">Not Selected</option>');
		$('#SaveFormButton').attr('disabled', 1);
	}";
	$bottomScript .= "colorlist.forEach(function(x,i) { colorsel.append('<option value=\"' + x + '\">' + x + '</option>'); });\n";
} else {
    if (isset($_POST["updated"])) {
        print "<h3>Records updated</h3>";
    }

    print "<h4>Scan Sales Order to add to Powdercoat Load</h4>";
	print "<p>All coated parts associated with that job will be presented for selection.</p>";
	print  "<form name='updform' action='powderTimeEntry.php' method='post'>";
	print "<input type='hidden' name='id' value='$id' id='id'>";
	print "<div style='clear: both;'></div>";

    $sql = "select distinct load_group from powdercoat_load where not load_status=4";
    list($grs,$err)=runIQuery($db,$sql);
    $loaded = [];
    foreach ($grs as $group) {
        $loaded[] = $group["load_group"];
    }

    $groups = str_split("ABCDEFGHIJKLMNOPQRSTUVWXYZ",1);

    print renderStartItem(TRUE,"","Current Group");
    print "<select id='group' name='group'>";

    $loadcount = count($loaded);
    $lastgroup = $loaded[count($loaded)-1];
    $selectNext = $loadcount == 0;
    $selected = false;

    foreach ($groups as $gr) {
        $modifier = "";
        $inload = in_array($gr,$loaded);

        if ($selectNext && !$selected) {
            $modifier .= "selected";
            $selected = true;
        } else if ($inload) {
            $modifier .= "style='background-color: lightgray;' disabled";

            if ($gr == $lastgroup) {
                $selectNext = true;
            }
        }
        print "<option value='$gr' $modifier>$gr</option>";
    }
    print "</select>";

	print renderTextBox(TRUE,"scan","","Scan SO#","left","SaveTheForm()");
	$bottomScript .= "$('#scan').focus();";
	print "<div style='clear: both;'></div>";
	print renderButton("Continue","green","SaveTheForm()","SaveFormButton");
	print "</form>";
}
print renderClosePanel();

?>
<script>


    function SaveTheForm() {
        if ($("#scan").length > 0) {
            if ($("#scan").val().trim() == '') {
                $.gritter.add("Please enter a SO number!");
                $("#scan").effect("highlight");
                return;
            }
        }

		var goodToGo = 0;
		$(".listitem").each(function(i,x) {
			var elm = $(x);

			if (elm.hasClass("no-apply")) {
				return;
			}

			var qty = elm.children()[2].children[3].value;
			if (!elm.hasClass("unverified") && qty > 0) {
				goodToGo++;
			}
		});

		if (!goodToGo && $(".listitem").length > 0) {
			$.gritter.add("Any verified parts must have a quantity greater than 0!");
			return;
		}

		$(".unverified .qtyinput").val(0).remove();
		$(".no-apply .qtyinput").val(0).remove();

        document.selform.submit();
    }

	function itemScanned(elm) {
		var jobs = [];
		var items = [];
		$(".itemScan").each(function(i,x) {
			jobs.push(x.value.split("-")[0]);
		});

		$(".listitem").each(function(i,x) {
			var job = x.children[2].children[0].value;
			var item = x.children[2].children[2].value;
			if (jobs.includes(job)) {
				$(x).removeClass("error").removeClass("success").removeClass("unverified").addClass("success");
				$(x.children[2].children[3]).removeAttr("readonly");
				$(x.children[2].children[3]).value=$(x.children[2].children[5].value);
			} else {
				$(x).removeClass("error").removeClass("success").addClass("unverified").addClass("error");
				$(x.children[2].children[3]).val(0).attr("readonly",1);
			}
		});
	}

	function itemScannedCMA(valtocheck) {
		console.log(valtocheck);
		jobtocheck=valtocheck.split('-')[0];
		console.log($('#totalrows').val());
		var matchfound=0;
		for (idx=1; idx <= $('#totalrows').val(); idx++ ) {
			if ($('#qty'+idx).val() == '0') {
				if (($('#job'+idx).val() == jobtocheck) || (valtocheck == $('#part'+idx).val()) || (valtocheck.trim() == $('#part'+idx).val())) {
					matchfound=idx;
				}
			}
		}
		console.log(matchfound);
		if (matchfound > 0) {
			console.log($('#need'+matchfound).val());
			$('#tr'+matchfound).removeClass("error").removeClass("success").removeClass("unverified").addClass("success");
			$('#qty'+matchfound).val($('#need'+matchfound).val()).prop("readonly", false);
			$('#itemscan'+matchfound).html(valtocheck);
		} else {
			var bsinfo=$('#badscan').html();
			bsinfo=bsinfo+' '+'<font color=red>' + valtocheck + '</font>';
			$('#badscan').html(bsinfo);
		}
		// because something else is going to the next element
		document.getElementById('itemscan').focus();
		document.getElementById('itemscan').select();
	}

    function checkQuantity(idx,obj) {
        var newvalue=parseInt(obj.value);
        var whatisneeded=parseInt(document.getElementById('need'+idx).value);
        if (newvalue > whatisneeded) {
            alert('You cannot load more than '+whatisneeded);
            obj.value=whatisneeded;
			(function(currentObject) {
				setTimeout(function() { currentObject.focus() },100);
			})(obj);
        } else {
            if (newvalue < whatisneeded) {
                alert('You are loading less than full quantity');
            }
        }
    }
</script>