<?php
include("dbConnection.php");
include("functions.php");
include("security.php");

$employeeParams = "";
$employeeCount = 3;
for ($i = 1; $employeeCount+1 > $i; $i++) {
    if (isset($_POST["employee$i"])) {
        ${"employee$i"} = $_POST["employee$i"]; // Will automatically set variables
    } else {
        ${"employee$i"} = 0; // Will be 0 if not in $_POST
    }

    if ($employeeParams != "") {
        $employeeParams .= "&";
    }
    $employeeParams .= "employee$i=" . ${"employee$i"};
}
$hasEmployees = $employee1 > 0;

if (isset($_POST["code"])) {
    $code = $_POST["code"];
    $dispsq = $_POST["dispsq"];
    $routing = $_POST["routing"];
    $remove = $_POST["remove"]; // extra verification

    if ($code != 8383 || $remove != 1) {
        die;
    }

    $sql = "select parent_part from routing where routing_id=? and display_sequence=?";
    list($rs,$err)=runIQuery($db,$sql,["ii", $routing, $dispsq]);

    if (count($rs)) {
        $part = $rs[0]["parent_part"];

        $sql = "delete from routing where routing_id=? and display_sequence=?";
        list($drs,$err)=runIQuery($db,$sql,["ii", $routing, $dispsq]);

        $sql = "insert into transaction_log (`who`, `when`, `script_name`, `table_name`, `sql_statement`) values (?, now(), 'plugMaskTimeEntry.php', 'none', 'removed plug/mask steps from $part')";
        list($rs,$err)=runIQuery($db,$sql, ["s", "$employee1,$employee2,$employee3"]);
        print $err;
    }

    die;
}

include("header.php");

print "<div id='confModal' class='modal fade' role='dialog'>
	<div class='modal-dialog'>
		<div class='modal-content'>
			<div class='modal-header'><h4 class='modal-title confTitle'></h4></div>
			<div class='modal-body'>
				<span class='confBody'></span>
			</div>
			<div class='modal-footer'>
				<button class='btn green' data-dismiss='modal' onclick='confInput(true)'>Yes</button>
				<button class='btn red' data-dismiss='modal' onclick='confInput(false)'>No</button>
			</div>
		</div>
	</div>
</div>";

print renderPanel("Plug/Mask Time Entry", "Plug/Mask Time Entry", "yellow");
print "<form name='selform' id='selform' action='plugMaskTimeEntry.php' method='POST'><input type='hidden'>"; // having an input here fixes the formatting on the screen for some reason

if ($hasEmployees) {
    $sql = "select card_number, concat(first_name, ' ', last_name) as full_name from employees where card_number in (";
    $vars = [];
    for ($i = 1; $employeeCount+1 > $i; $i++) {
        $emp = ${"employee".$i};
        if ($emp > 0) {
            if (count($vars) == 0) {
                $sql .= "?";
                $vars[] = "i";
            } else {
                $sql .= ", ?";
                $vars[0] .= "i";
            }
            $vars[] = $emp;
        }
    }
    $sql .= ") and inactive=0 order by first_name";

    $repeats = $employeeCount-2;
    if ($repeats < 0) {
        $repeats = 0;
    }
    print "<table class='table table-bordered'>
        <tr><th>Employees</th>" . str_repeat("<th></th>", $repeats) . "<th><button class='btn red' id='signoutbtn' onclick='signOut(); return false;'>Sign Out</button></th><tr>";

    list($rs,$err) = runIQuery($db,$sql,$vars);
    $count = 1;
    foreach ($rs as $employee) {
        print "<td style='width: " . (100/$employeeCount) . "%;'>" . $employee["full_name"] . "</td>";
        $count++;
    }

    for ($i = $count; $employeeCount+1 > $i; $i++) {
        print "<td style='width: " . (100/$employeeCount) . "%;'></td>";
    }

    print "</tr></table>";
}


if ($hasEmployees) {
    for ($i = 1; $employeeCount+1 > $i; $i++) {
        print "<input type='hidden' name='employee$i' id='employee$i' value='" . ${"employee".$i} . "'>";
    }

    print renderPanel("Plug/Mask Scan", "Plug/Mask Scan", "green");

        $scan=0;
        if (isset($_POST["scan"])) {
            $scan=$_POST["scan"];
        }

        if ($scan) {
            if (substr($scan, 0, 1) == "S") {
                $scan = substr($scan,1);
            }

            $sql = "SELECT order_id from orders where order_id=?";
            list($ors,$err)=runIQuery($db,$sql,["i",$scan]);

            if (count($ors)) {

                // operation_id 3119 is PLUG/MASK
                $sql = "SELECT j.*, routing_id, display_sequence from order_lines ol, jobs j, routing r
                    where ol.line_id=j.line_id
                    and j.item_id=r.parent_part
                    and r.operation_id=3119
                        and ol.order_id=?";
                list($jrs,$err)=runIQuery($db,$sql,["i",$scan]);

                if (count($jrs)) { // plug/mask found
                    print "<h4>Select which parts to start plugging/masking</h4>";
                    print "<p>If any parts do not need plugging/masking please click \"Remove Plug/Mask\"</p>";

                    print "<table class='table'>
                        <thead>
                            <tr><th>Part</th><th>Description</th><th>Actions</th></tr>
                        </thead>
                        <tbody>";
                    foreach ($jrs as $i => $data) { // TODO: Show items
                        $part = $data["item_id"];
                        $desc = $data["description"];
                        $routing = $data["routing_id"];
                        $job = $data["job_id"];
                        $dispsq = $data["display_sequence"];

                        print "<tr id='$i'" . ($i%2 ? "style='background-color: #ececec;'" : "") . ">";
                            print "<td>$part</td>";
                            print "<td>$desc</td>";
                            print "<td>";
                                print renderButton("Start Job", "green", "startJob('$job-$dispsq', $i); return false;");
                                print renderButton("Remove Plug/Mask", "red", "removeSteps($routing, $dispsq, $i); return false;");
                            print "</td>";
                        print "</tr>";
                    }
                    print "</tbody></table>";

                } else { // no plug/mask operation
                    $bottomScript .= "alert('No plugging and masking found on this SO!'); window.history.back();";
                }

            } else { // SO not in system
                $bottomScript .= "alert('SO not found!'); window.history.back();";
            }

        } else {
            print "<h4>Scan Sales Order to check for Plug/Mask</h4>";
            print "<div style='padding: 0px -35px;'>";
            print renderTextBox(TRUE,"scan","","Scan");
            print "<div style='clear: both;'></div>";
            print renderButton("Continue","green","SaveTheForm(2)","SaveTheFormButton");
            print "</div>";
        }

    print renderClosePanel();
} else {
    for ($i = 1; $employeeCount+1 > $i; $i++) {
        print renderStartItem(TRUE,"employee$i","Employee #$i");
        print "<input class='employee-input' type='number' name='employee$i' id='employee$i' class='form-control' value=''>";
        print renderEndItem();
    }
    print renderStartItem(TRUE,"","‎");
    print renderButton("Next","blue","SaveTheForm(1); return false;","empsub"); //return false to stop default behavior of the button
    print renderEndItem();
}
print "</form>";

print renderClosePanel();

include("footer.php");
?>
<style>
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        appearance: none;
    }

    input[type=number] {
        -moz-appearance: textfield;
    }

    .invalid {
        background: #ff9a9a !important;
    }

    .valid {
        background: #88f188 !important;
    }
</style>

<script>
    // TODO: remove steps function and endpoint

    function confirmModal(title,body,cb=function(){}) {
        $("#confModal .confTitle").text(title);
        $("#confModal .confBody").html(body);
        window.confInput = cb;
        $("#confModal").modal("show");
    }

    function SaveTheForm(step) {
        if (step == 1) { // step 1 is entering employees
            submitEmployees();
        }

        if (step == 2) { // step 2 is scanning the SO
            checkScan();
        }

        return false;
    }

    function startJob(job, i) {
        $("#"+i).addClass("success");
        window.open("timeEntry.php?scan=" + job + "&<?=$employeeParams?>");
    }

    function removeSteps(routing, dispsq, i) {
        confirmModal("Remove Steps?", "Are you sure you want to remove Plug/Mask steps from this part? <h4>Warning: This cannot be undone</h4>", function(yes) {
            if (yes) {
                $("#"+i).addClass("error");
                $("#"+i+" button").attr("disabled","true");

                var url = "plugMaskTimeEntry.php?code=8383&routing=" + routing + "&dispsq=" + dispsq + "&remove=1";
                $.ajax({
                    url: url,
                    type: "POST",
                    data: "code=8383&routing=" + routing + "&dispsq=" + dispsq + "&remove=1&<?=$employeeParams?>",
                    success: function() {

                    }
                });
            }
        });
    }

    function submitEmployees() { // step 1
        setTimeout(function() { //500ms delay to account for clicking submit before the verification ajax finished
            if ($(".invalid").length) { // has one or more invalids
                $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> One or more invalid employees!</span>");
                $(".invalid").effect("shake").first().focus();
                return;
            }

            if (!$(".valid").length) { //has no valids
                $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> No employees provided!</span>");
                $("#employee1").effect("shake").focus();
                return;
            }
            if (!$("#employee1").val()) {
                $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> Please fill out employees in order</span>");
                $("#employee1").effect("shake").focus();
                return;
            }

            document.selform.submit();
        }, 500);
    }

    function checkScan() { // step 2
        if ($("#scan").length > 0) {
            if ($("#scan").val().trim() == '') {
                $.gritter.add("Please enter a SO number!");
                $("#scan").effect("highlight");
            } else {
                document.selform.submit();
            }
        }
    }

    function page_init() {
        $('.employee-input').on("change",function(e) {
            var elm = $(this);
            var emp = elm.val();
            elm.removeClass("valid").removeClass("invalid");

            if (emp > 0) {
                $.ajax({
                    url: "validateEmployee.php?code=8383&id="+emp+"&rand="+Math.random(),
                    success: function(resp) {
                        if (resp != "OK-Employee Found") {
                            $.gritter.add("<span class='label label-warning'><img src='images/icn_alert_warning.png'> Invalid Employee Number</span>");
                            elm.removeClass("valid").addClass("invalid").effect("shake").focus();
                        } else {
                            elm.removeClass("invalid").addClass("valid");
                        }
                    }
                });
            }
        }).keypress(function(e) {
            if (e.keyCode == 13) {
                var nextid = (+$(e.target).attr("id").substr(-1))+1;
                var nextelm = $("#employee"+nextid).focus();;
                if (!nextelm.length) {
                    $("#empsub").focus();
                }
                return false;
            }
        });

        $("#empsub").keypress(function(e) {
            submitEmployees();
            return e.keyCode != 13;
        });

        $("#scan").focus();
        $("#employee1").focus();

        $("#scan")[0].onkeypress = function(event) {
            if (event.keyCode == 13) {
                event.preventDefault();
                return false;
            }
        }
    }

    function signOut() {
        confirmModal("Sign Out?", "Are you sure you want to sign out? Anything unsubmitted will not be recorded!", function(yes) {
            if (yes) {
                document.location.href='plugMaskTimeEntry.php?rand='+Math.random();
            }
        });
    }
</script>