<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (isset($_SESSION['start_date'])) {
	$start=$_SESSION['start_date'];
} else {
	$start=Date("m/d/Y");	
}
if (isset($_GET['start'])) {
	$start=$_GET['start'];
	$_SESSION['start_date']=$start;
}
if (isset($_SESSION['end_date'])) {
	$end=$_SESSION['end_date'];
} else {
	$end=$start;
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
	$_SESSION['end_date']=$end;
}
$sd=formatDateWebToDB($start);
$ed=formatDateWebToDB($end);

print renderPanel("Plan vs Actual By Part","","blue","span11","cogs");

print "<form name='findform' action='planToActualPart.php' method='GET>";
print "<div style: 'display: flex; flex-direction: row; width: 100%'>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print renderButton("Find","success","document.findform.submit();");
print "</div>";
print "</form>";

print "<table class='table table-striped'><thead><tr><th>Order</th><th>Date Due</th><th>Per Part</th></tr></thead><tbody>";

$sql="SELECT orders.order_id, orders.folder_number, orders.date_due FROM orders WHERE orders.date_due >= ? AND orders.date_due <= ?";
list($rs,$err)=runIQuery($db,$sql,array("ss",$sd,$ed));
foreach($rs as $data) {
    $order=$data['order_id'];
    $job=$data['folder_number'];
    $dueDate=formatDateDBToWeb($data['date_due']);

    print "<tr><td><a href='editOrders.php?id=$order' target='_blank'>$order</a></td><td>$dueDate</td><td><table class='table table-striped'><thead><tr><th>Item</th><th>Quantity</th></tr></thead><tbody>";

    $sql="SELECT item_id, quantity FROM order_lines WHERE order_lines.order_id=?";
    list($rs,$err)=runIQuery($db,$sql,array("i",$order));
    foreach($rs as $data) {
        $part=$data['item_id'];
        $quantityPlanned=$data['quantity'];

        print "<tr><td>$part</td><td>$quantityPlanned</td><td><table class='table table-striped'><thead><tr><th>Operations</th><th>Planned Time</th><th>Actual Time</th><th>Quantity Good</th></tr></thead><tbody>";

        $sql="SELECT production_results.operation_id, operations.operation_name FROM production_results INNER JOIN operations ON production_results.operation_id=operations.operation_id
          WHERE production_results.job_id=? AND production_results.item_name=?";
        list($rs,$err)=runIQuery($db,$sql,array("ss",$job,$part));
        $operations=[];
        foreach($rs as $data) {
          $operationName=$data['operation_name'];
          $operationID=$data['operation_id'];
          $operations[$operationID]=$operationName;
        }
        foreach($operations as $opID => $opName) {
          $sql="SELECT setup, per_part FROM operation_times WHERE part_number=? AND LOWER(operation)=?";
          list($rs,$err)=runIQuery($db,$sql,array("ss",$part,strtolower($opName)));
          foreach($rs as $data) {
            $setup=$data['setup'];
            $perpart=$data['per_part'];
          }
          $timePlanned = ($quantityPlanned * $perpart) + $setup;

          $showMath = "setup: $setup + (per part: $perpart * quantity: $quantityPlanned)"; #bdoss tooltip showing how the math is done so they know per part time

          $sql="SELECT SUM(quantity_good) AS quantity, SUM(`minutes`) AS actual FROM production_results WHERE job_id=? AND item_name=? AND operation_id=?";
          list($rs,$err)=runIQuery($db,$sql,array("ssi",$job,$part,$opID));
          foreach($rs as $data) {
            $quantityActual=$data['quantity'];
            $timeActual=($data['actual'] * 60);
            // if ($quantityActual !=0 && $timeActual > $setup) {
            //   $showAverage = (($timeActual - $setup) / $quantityActual); ## could be used to show average time per part, but not sure how setup time is factored into that total
            // }
          }
          ## bdoss making font red for actual time if it is greater than planned time
          $font="black";
          if ($timeActual > $timePlanned) {
            $font="red";
          }

          print "<tr><td><strong>$opName</strong></td><td title='$showMath'>$timePlanned</td><td style='color: $font'>$timeActual</td><td>$quantityActual</td></tr>";
        }

        print "</tbody></table></td>";
    }

    print "</tbody></table></td>";
}

print "</tbody></table>";

print renderClosePanel();

?>
<script>
function page_init() {
  $('#start').datepicker();
  $('#end').datepicker();
}

</script>

<?php
include('footer.php');
?>