<?php
include('dbConnection.php');
include('functions.php');
include('security.php');

$start=formatDateWebtoDB($_GET['start']);
$end=formatDateWebtoDB($_GET['end']);

$searchEmployee=0;
if (isset($_GET['employee'])) {
	$searchEmployee=$_GET['employee'];
}

header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=planToActualEngineering.xls");
header("Pragma: no-cache");
header("Expires: 0");

print "Date";
print "\t";
print "Who";
print "\t";
print "Notes";
print "\t";
print "Step";
print "\t";
print "Planned Seconds";
print "\t";
print "Actual Seconds\t";
print "PVA Percent";
print "\r\n";
$sql="select date_posted, full_name, activity, notes, allocated_seconds, elapsed_seconds from engineering_activity a inner join site_admins s on a.user_id=s.user_id ";
if ($searchEmployee) {
    $sql.=" inner join employees on employee_link=employee_id and card_number='$searchEmployee' ";
}
$sql.=" and allocated_seconds <> 0 and coalesce(first_entry,0) = 0 and activity <> 'RESUME' "; 
$sql.=" and DATE(date_posted) >= ? and DATE(date_posted) <= ? ";
$sql.="order by a.activity ";
list($result,$err)=runIQuery($db,$sql,array("ss",$start,$end));

$holdJob=0;
$total=0;
$lc=0;
$so="";
$totalPlanned=0;
$totalActual=0;
foreach ($result as $data) {
    $dt=formatDateDBToWeb($data['date_posted']);
    $name=$data['full_name'];
    $activity=$data['activity'];
    $step=1;
    if ($activity == 'Saved Quoted Part') {
        $step=2;
    }
    $notes=$data['notes'];
    $planned=$data['allocated_seconds'];
    $totalPlanned+=$planned;
    $actual=$data['elapsed_seconds'];
    $totalActual+=$actual;
    $lc++;
	$percentage=($actual != 0 ? round($planned/$actual * 100,1) : "Not available");
    print "$dt\t$name\t$notes\t$step\t$planned\t$actual\t$percentage";
    print "\r\n";
}
## totals section
$pct=0;
if ($totalActual > 0) {
	$pct=round($totalPlanned/$totalActual*100,1);
}
print "\r\n";
print "\t\tTotals\t$lc\t$totalPlanned\t$totalActual\t$pct %";
print "\r\n\r\n";

##other production activity section
if ($searchEmployee) {
	$sql="select o.operation_name, result_date, quantity_good,  minutes, item_name, notes from production_results r inner join operations o on r.operation_id=o.operation_id   ";
	$sql.=" where r.item_name not in (select item_name from items where item_category = 16) ";
	$sql.=" and operation_name in ('BREAK','Maintenance','Cleaning','Training','Troubleshooting','Clean Up','Preventative Maintenance','Internal Work','Engineering','Shipping', 'Drafting', 'Meeting', 'Phone Call', 'Break Time') ";
	$sql.=" and DATE(result_date) >= ? and DATE(result_date) <= ? ";
	$sql.=" and r.employee_id=? ";
	$sql.=" and r.job_id = 0 ";	
	list($result,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$searchEmployee));
	if (count($result)>0) {
		print "Operation";
		print "Minutes\t";
		print "Date\t";
		print "Notes\t";
        print "\r\n";
		foreach ($result as $data) {
			$operation=$data['operation_name'];
			$minutes=$data['minutes'];
			$notes=$data['notes'];
			$dt=formatDateDBToWeb($data['result_date']);
	
			print "$operation\t$minutes\t$dt\t$notes";
            print "\r\n";
		}
        print "\r\n\r\n";
	}

    ##irma section
	$sql="select orders.folder_number, operation_name, item_id,   irma.quantity, irma.irma_date, irma.reason ";
	$sql.=" from irma  left outer join order_lines on irma.line_id = order_lines.line_id left outer join orders on order_lines.order_id = orders.order_id ";
	$sql.=" left outer join operations op on irma.operation_id=op.operation_id ";
	$sql.=" where irma.irma_date  >= ?  and irma.irma_date  <= ? and irma.employee_id=? and irma.quantity <> 0 ";  ## bdoss 12/14/22 ignore irma's with quantity of 0
	list($results,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$searchEmployee));
	if (count($results)>0) {
		print "Folder\tOperation\tPart\tIRMA Qty\tDate\tReason";
		print "\r\n";
		foreach ($results as $data) {
			$folder=$data['folder_number'];
			$op=$data['operation_name'];
			$part=$data['item_id'];
			$qty=$data['quantity'];
			$dt=formatDateDBToWeb($data['irma_date']);
			$reason=$data['reason'];
			print "$folder\t$op\t$part\t$qty\t$dt\t$reason";
            print "\r\n";
		}
	}
}

?>