<?php
include('dbConnection.php');
header("Content-type: application/octet-stream");
header("Content-Disposition: attachment; filename=PlanToActual.xls");
header("Pragma: no-cache");
header("Expires: 0");
include('security.php');
include('functions.php');
$pageTitle="Plan Versus Actual";
list($rs,$err)=runIQuery($db,$sql);
if (isset($_SESSION['start_date'])) {
	$start=$_SESSION['start_date'];
} else {
	$start=Date("m/d/Y");	
}
if (isset($_GET['start'])) {
	$start=$_GET['start'];
	$_SESSION['start_date']=$start;
}
if (isset($_SESSION['end_date'])) {
	$end=$_SESSION['end_date'];
} else {
	$end=$start;
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
	$_SESSION['end_date']=$end;
}
$searchwc=0;
if (isset($_GET['wc'])) {
	$searchwc=$_GET['wc'];
}
$searchEmployee=0;
if (isset($_GET['employee'])) {
	$searchEmployee=$_GET['employee'];
}
$part="";
if (isset($_GET['part'])) {
	$part=trim($_GET['part']);
}
$order="";
if (isset($_GET['order'])) {
	$order=$_GET['order'];
}
$percent=0;
if (isset($_GET['percent'])) {
	$percent=$_GET['percent'];
}
$start=formatDateWebtoDB($start);
$end=formatDateWebtoDB($end);
list($operationSetup,$operationPerPart)=getOperationTimes($db,$start,$end,"","");

print "Operation\tJob\tPart\tQuantity\tPlanned Minutes per Part\tActual Minutes Per Part\tPlanned Cost (Total)\tActual Cost (total)\tDfference\n";
$sql="select operation_name,  hourly_rate, r.item_name, r.job_id, o.order_id sum(minutes) as minutes, sum(r.quantity_good) as good ";
$sql.=" from production_results r inner join operations op on r.operation_id=op.operation_id ";
$sql.=" inner join orders o on r.job_id=o.folder_number ";
#$sql.=" left outer join operation_times t on if(o.operation_name='Hand-Deburr','DEBURR',if(o.operation_name='Vibe Unload','DEBURR',if(o.operation_name='Vibe Load','DEBURR',o.operation_name)))=t.operation and r.item_name=t.part_number   ";
#$sql.=" and t.order_id=o.order_id ";
#$sql.=" left outer join operation_times ot on if(o.operation_name='Hand-Deburr','DEBURR',if(o.operation_name='Vibe Unload','DEBURR',if(o.operation_name='Vibe Load','DEBURR',o.operation_name)))=ot.operation 
#and r.item_name=ot.part_number  and ot.order_id is null  ";
if (in_array($searchwc,array(41,85,88))) {
	$sql="select operation_name,  hourly_rate, r.item_name, r.job_id,  o.order_id, sum(minutes) as minutes, sum(r.quantity_good) as good from production_results r ";
	$sql.=" inner join operations op on r.operation_id=op.operation_id ";
	$sql.=" inner join orders o on r.job_id=o.folder_number ";
	##$sql.=" left outer join operation_times t on t.operation='BEND' and r.item_name=t.part_number  and t.order_id=o.order_id ";
	##$sql.=" left outer join operation_times ot on ot.operation='BEND' and r.item_name=ot.part_number  ot.order_id is null ";
}
if (in_array($searchwc,array(2,62))) {
	$sql="select  operation_name, hourly_rate, r.item_name, r.job_id, o.order_id sum(minutes) as minutes, sum(r.quantity_good) as good from production_results r ";
	$sql.=" inner join operations op on r.operation_id=op.operation_id ";
	$sql.=" inner join orders o on r.job_id=o.folder_number ";
	#$sql.=" left outer join operation_times t on t.operation='WELD' and r.item_name=t.part_number and t.order_id=o.order_id  ";
	#$sql.=" left outer join operation_times ot on ot.operation='WELD' and r.item_name=ot.part_number  and ot.order_id is null   ";
}
$sql.=" where r.item_name not in (select item_name from items where item_category = 16) ";
$sql.=" and operation_name not in ('BREAK','Maintenance','Cleaning','Training','Troubleshooting','Clean Up','Preventative Maintenance','Internal Work','Engineering','Shipping') ";
if ($order) {
	$sql.=" and r.job_id=$order ";
} else {
	$sql.=" and DATE(result_date) >= '$start' and DATE(result_date) <= '$end' ";
	if ($searchwc) {
		if (in_array($searchwc,array(41,85,88))) {
			## 41 is bend
			## 85 is bend2
			## 88 is Tool Change
			$sql.=" and o.operation_id in (41,85,88) ";

		} else {
			if (in_array($searchwc,array("2,62"))) {
				$sql.=" and o.operation_id in (2,62) ";
			} else {
				$sql.=" and o.operation_id=$searchwc";
			}
		}
	}
}
if ($searchEmployee) {
	$sql.=" and r.employee_id=$searchEmployee ";
}
if ($part) {
	$sql.=" and r.item_name like '%$part%'";
}
$sql.=" and r.job_id > 0 ";
if ($searchwc) {
	$sql.=" group by r.item_name, r.job_id, setup, per_part ";
	$sql.=" order by r.job_id,  o.customer_sequence,  r.item_name ";
} else {
	$sql.=" group by o.operation_name, r.item_name, r.job_id, t.setup, t.per_part ";
	$sql.=" order by r.job_id,  o.customer_sequence, o.operation_name, r.item_name ";
}
list($result,$err)=runIQuery($db,$sql);

$holdJob=0;
$total=0;
$lc=0;
$so="";
$grandTotal=0;
foreach ($result as $data) {
	$so=$data['job_id'];
	$lc++;
	$wc=$data['operation_name'];
	if (in_array($searchwc,array(41,85,88))) {
		$wc="Bend (included Tool Change)";
	}
	if (in_array($searchwc,array(31,98,99))) {
		$wc="Deburr (include Vibe Bowl)";
	}

	$part=strtoupper($data['item_name']);
	$minutes=$data['minutes'];
	$qty=$data['good'];
	$rate=$data['hourly_rate']/60;
	## setup and per part are in seconds
	$onum=$data['order_id'];
	reset($operationSetup);
	$setup=0;
	if (isset($operationSetup[$part][$onum][$op])) {
		$setup=$operationSetup[$part][$onum][$op];
	} else {
		if (isset($operationSetup[$part]["0"][$op])) {
			$setup=$operationSetup[$part]["0"][$op];
		}
	}
	reset($operationPerPart);
	if (isset($operationPerPart[$part][$onum][$op])) {
		$perPart=$operationPerPart[$part][$onum][$op];
	} else {
		if (isset($operationPerPart[$part]["0"][$op])) {
			$perPart=$operationPerPart[$part]["0"][$op];
		}
	}
	if (! $setup) {
		$setup=0;
	}
	if (! $perPart) {
		$perPart=0;
	}
	if ($qty > 0) {
		$actualMinutesPerPart=$minutes / $qty;	 
		$planMinutesPerPart=($setup + ($qty*$perPart))/$qty/60;
	} else {
		$actualMinutesPerPart=$minutes;
		$planMinutesPerPart=($setup + $perPart)/60;
	}
	$actualMinutesPerPart=round($actualMinutesPerPart*10)/10;
	$planMinutesPerPart=round($planMinutesPerPart*10)/10;
	$pct=$percent / 100;
	if ($actualMinutesPerPart > $planMinutesPerPart or $actualMinutesPerPart <= ($planMinutesPerPart-($planMinutesPerPart*$pct))) {
		print "$wc\t$so\t";
		$sql="select name from orders, customers where folder_number=? and orders.customer_id=customers.customer_id";
		list($crs,$err)=runIQuery($db,$sql,array("s",$so));
		$cdata=$crs[0];
		$customer=$cdata['name'];
		print $part;
		print "\t";
		print "$qty\t$planMinutesPerPart\t$actualMinutesPerPart\t";
		$planCost=$planMinutesPerPart*$qty*$rate;
		$actualCost=$actualMinutesPerPart*$qty*$rate;
		$difference=$planCost - $actualCost;
		print $planCost;
		print "\t";
		print $actualCost;
		print "\t";
		print $difference;
		print "\n";
	}
}
