<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Engineering Line Entry Detail";
include('header.php');
date_default_timezone_set('America/Detroit');
$sql="SET time_zone = '" .date('P') . "'";
list($rs,$err)=runIQuery($db,$sql);
if (isset($_SESSION['start_date'])) {
	$start=$_SESSION['start_date'];
} else {
	$start=Date("m/d/Y");	
}
if (isset($_GET['start'])) {
	$start=$_GET['start'];
	$_SESSION['start_date']=$start;
}
if (isset($_SESSION['end_date'])) {
	$end=$_SESSION['end_date'];
} else {
	$end=$start;
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
	$_SESSION['end_date']=$end;
}
$searchwc=0;
if (isset($_GET['wc'])) {
	$searchwc=$_GET['wc'];
}
$searchEmployee=0;
if (isset($_GET['employee'])) {
	$searchEmployee=$_GET['employee'];
}
?>
<style>
.tableFixHead          { overflow-y: auto; height: 100px; }
.tableFixHead thead th { position: sticky; top: 0; }
</style>
<?php
print renderPanel("Plan vs Actual","","blue","span11","cogs");
print "<p>This report shows all lines entered for an engineer in the given date range.</p>";
print "<form name='findform' action='planToActualEngineering.php' method='GET>";
print "<div class='row'>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
print "</div>";
print "<div style='clear: both;'></div>\n";
$sql="select card_number, concat(last_name,', ', first_name) as full_name from employees where coalesce(inactive,0)=0 order by last_name, first_name";
list($rs,$err)=runIQuery($db,$sql);
print renderSelect(TRUE,"employee",$searchEmployee,"Employee","N",$rs,1);
print renderButton("Find","success","document.findform.submit();");
## bdoss 10/3/22 added export file
print renderButton("Export","primary","exportPTA()"); // bdoss function below is exportPTA(), removing "Engineering" at the end
print "<div style='clear: both;'></div>\n";
print "</form>";
print "<table class='table table-striped tableFixHead'>";
print "<thead>";
print "<tr>";
print "<th>Date</th>";
print "<th>Who</th>";
print "<th>Notes</th>";
print "<th>Step</th>";
print "<th>Planned Seconds</th>";
print "<th>Actual Seconds</th>";
//addition here 4/20/22 BD - adding column for actual/planned seconds (1/3 additions)
print "<th>PVA Percent</th>";
//end addition
print "</tr>";
print "</thead>";
print "<tbody>";
$start=formatDateWebtoDB($start);
$end=formatDateWebtoDB($end);
$sql="select date_posted, full_name, activity, notes, allocated_seconds, elapsed_seconds from engineering_activity a inner join site_admins s on a.user_id=s.user_id ";
if ($searchEmployee) {
    $sql.=" inner join employees on employee_link=employee_id and card_number='$searchEmployee' ";
}
//$sql.=" and a.activity in ('Saved Quoted Part','Add DXF') "; //commenting this out Brittany 7/27/22 
//adding this next to line to filter out lines with pressing a pause button that have 0 seconds planned, but add a lot of time to actual seconds
$sql.=" and allocated_seconds <> 0 and coalesce(first_entry,0) = 0 and activity <> 'RESUME' "; 
$sql.=" and DATE(date_posted) >= ? and DATE(date_posted) <= ? ";
$sql.="order by a.activity ";
list($result,$err)=runIQuery($db,$sql,array("ss",$start,$end));

$holdJob=0;
$total=0;
$lc=0;
$so="";
$totalPlanned=0;
$totalActual=0;
foreach ($result as $data) {
    $dt=formatDateDBToWeb($data['date_posted']);
    $name=$data['full_name'];
    $activity=$data['activity'];
    $step=1;
    if ($activity == 'Saved Quoted Part') {
        $step=2;
    }
    $notes=$data['notes'];
    $planned=$data['allocated_seconds'];
    $totalPlanned+=$planned;
    $actual=$data['elapsed_seconds'];
    $totalActual+=$actual;
    $lc++;
	//adding variable for percentage here (2/3 additions)
	##Brittany reversing this from actual/planned to planned/actual	
	$percentage=($actual != 0 ? round($planned/$actual * 100,1) : "Not available");
    print "<tr><td>$dt</td><td>$name</td><td>$notes</td><td>$step</td><td>$planned</td><td>$actual</td><td>$percentage</td></tr>\n";
	//end additions - actual divided by planned insert above make sure it's not dividing by zero
}
//total percentage below of all actual/planned for the employee - was already there, but in the wrong spot (3/3 additions)
$pct=0;
if ($totalActual > 0) {
	$pct=round($totalPlanned/$totalActual*100,1);
}
print "<td colspan=2'>Totals</td><td>$lc</td><td></td><td>$totalPlanned</td><td>$totalActual</td><td>$pct %</td>";
print "</tbody>";
print "</table>\n";
## bdoss 9/19/22 added 4 new operations per Matt: Drafting, Meeting, Phone Call, and Break Time; should help keep track off things done outside of engineering programs

## cma 1/17/23 moved the settings into an include that is used here and in  employeeEfficiency.php
include('indirectOperations.php');
if ($searchEmployee) {
	$sql="select o.operation_name, result_date, quantity_good,  minutes, item_name, notes from production_results r inner join operations o on r.operation_id=o.operation_id   ";
	$sql.=" where r.item_name not in (select item_name from items where item_category = 16) ";
	$sql.=" and operation_name in $indirect ";
	$sql.=" and DATE(result_date) >= ? and DATE(result_date) <= ? ";
	$sql.=" and r.employee_id=? ";
	$sql.=" and r.job_id = 0 ";	
	list($result,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$searchEmployee));
	if (count($result)>0) {
		print "<center><h4>Below are any production results for the employee not tied to a job, so you cannot compare against plan</h4></center>";
		print "<table class='table table-striped'><thead>";
		print "<tr>";
		print "<th>Operation</th>";
		print "<th>Minutes</th>";
		print "<th>Date</th>";
		print "<th>Notes</th>";
		print "</tr>";
		print "</thead>";
		print "<tbody>";
		foreach ($result as $data) {
			$operation=$data['operation_name'];
			$minutes=$data['minutes'];
			$notes=$data['notes'];
			$dt=formatDateDBToWeb($data['result_date']);
			print "<tr>";
			print "<td valign='top'>";
			print $operation;
			print "</td>";
			print "<td valign='top'>";
			print $minutes;
			print "</td>";
			print "<td valign='top'>";
			print $dt;
			print "</td>";
			print "<td valign='top'>";
			print $notes;
			print "</td>";
			print "</tr>\n";
		}
		print "</tbody>";
		print "</table>\n";
	}
	$sql="select orders.folder_number, operation_name, item_id,   irma.quantity, irma.irma_date, irma.reason ";
	$sql.=" from irma  left outer join order_lines on irma.line_id = order_lines.line_id left outer join orders on order_lines.order_id = orders.order_id ";
	$sql.=" left outer join operations op on irma.operation_id=op.operation_id ";
	$sql.=" where irma.irma_date  >= ?  and irma.irma_date  <= ? and irma.employee_id=? and irma.quantity <> 0 ";  ## bdoss 12/14/22 don't display irma's with 0 quantity
	list($results,$err)=runIQuery($db,$sql,array("ssi",$start,$end,$searchEmployee));
	if (count($results)>0) {
		print "<center><h4>Below are IRMA's for the employee for the date range specified</h4></center>";
		print "<table class='table table-striped'><thead>";
		print "<tr><th>Folder</th><th>Operation</th><th>Part</th><th>IRMA Qty</th><th>Date</th><th>Reason</th></tr>\n";
		print "<tbody>";
		foreach ($results as $data) {
			$folder=$data['folder_number'];
			$op=$data['operation_name'];
			$part=$data['item_id'];
			$qty=$data['quantity'];
			$dt=formatDateDBToWeb($data['irma_date']);
			$reason=$data['reason'];
			print "<tr><td>$folder</td><td>$op</td><td>$part</td><td>$qty</td><td>$dt</td><td>$reason</td></tr>\n";
		}
		print "</tbody>";
		print "</table>\n";

	}
}
print renderClosePanel("");
?>
<script>
function page_init() {
  $('#start').datepicker();
  $('#end').datepicker();
}
function exportPTA() {
	document.findform.action='planToActualExportEngineering.php';
	document.findform.target='_blank';
	document.findform.submit();
	document.findform.action='planToActualEngineering.php';
	document.findform.target='_self';
}
</script>
<?php
include('footer.php');
