<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
include('security.php');
include('functions.php');
$pageTitle="Plan Versus Actual";
include('header.php');
date_default_timezone_set('America/Detroit');
$sql="SET time_zone = '" .date('P') . "'";
list($rs,$err)=runIQuery($db,$sql);
if (isset($_SESSION['start_date'])) {
	$start=$_SESSION['start_date'];
} else {
	$start=Date("m/d/Y");
}
if (isset($_GET['start'])) {
	$start=$_GET['start'];
	$_SESSION['start_date']=$start;
}
if (isset($_SESSION['end_date'])) {
	$end=$_SESSION['end_date'];
} else {
	$end=$start;
}
if (isset($_GET['end'])) {
	$end=$_GET['end'];
	$_SESSION['end_date']=$end;
}
$searchwc=0;
if (isset($_GET['wc'])) {
	$searchwc=$_GET['wc'];
}
$searchEmployee=0;
if (isset($_GET['employee'])) {
	$searchEmployee=$_GET['employee'];
}
$part="";
if (isset($_GET['part'])) {
	$part=trim($_GET['part']);
}
$order="";
if (isset($_GET['order'])) {
	$order=$_GET['order'];
}
$percent=0;
if (isset($_GET['percent'])) {
	$percent=$_GET['percent'];
}
?>
<style>
.tableFixHead          { overflow-y: auto; height: 100px; }
.tableFixHead thead th { position: sticky; top: 0; }
</style>
<?php

print renderPanel("Plan vs Actual by Operation","","blue","span11","cogs");
print "<p>This report shows, for a given operation, for each employee that performed that operation in the time frame selected, their actual performance against plan.</p>";
print "<p>Select start and end date and  operation</p>";
print "<p>To see detail, click on an employee name</p>";
print "<form name='findform' action='planToActualByDepartment.php' method='GET>";
print "<div class='row'>";
print renderDateBox(TRUE,"start",$start,"Start Date");
print renderDateBox(TRUE,"end",$end,"End Date");
$sql="select operation_id, operation_name from operations order by operation_name";
list($rs,$err)=runIQuery($db,$sql);
print "</div>";
print "<div class='row'>";
print renderSelect(TRUE,"wc",$searchwc,"Operation","N",$rs,1);
print renderButton("Find","success","document.findform.submit();");
print "<a href='#' id='downloader'>" . renderButton("Export","primary","tableToTab('exportTable','PTAByDept.xls')") . "</a>";
print "</div>";
print "<div style='clear: both;'></div>\n";
print "</form>";
print "<table id='exportTable' class='table table-striped tableFixHead'>";
print "<thead>";
print "<tr>";
print "<th>Operation</th>";
print "<th>Employee</th>";
print "<th># Parts</th>";
print "<th>Pieces</th>";
print "<th>Planned Minutes</th>";
print "<th>Actual Minutes</th>";
print "<th>Difference</th>";
print "</tr>";
print "</thead>";
print "<tbody>";
$st=formatDateWebtoDB($start);
$en=formatDateWebtoDB($end);
list($operationSetup,$operationPerPart)=getOperationTimes($db,$st,$en,"","");

$sql="select operation_name,  hourly_rate, r.item_name , o.order_id, sum(r.quantity_good) as good, count(*) as numparts, concat(last_name,', ', first_name) as full_name, r.employee_id 
from production_results r inner join operations op on r.operation_id=op.operation_id 
 inner join orders o on r.job_id=o.folder_number ";
if (in_array($searchwc,array(41,85,88))) {
	$sql="select  operation_name, hourly_rate, r.item_name, r.job_id, o.order_id, sum(minutes) as minutes, sum(r.quantity_good) as good, count(*) as numparts, concat(last_name,', ', first_name) as full_name, r.employee_id 
	from production_results r inner join operations op on r.operation_id=op.operation_id 
	inner join orders o on r.job_id=o.folder_number ";
}
if (in_array($searchwc,array(2,62))) {
	$sql="select  operation_name, hourly_rate, r.item_name, r.job_id,  o.order_id, sum(minutes) as minutes, sum(r.quantity_good) as good, 
	count(*) as numparts, concat(last_name,', ', first_name) as full_name, r.employee_id 
	from production_results r inner join operations op on r.operation_id=op.operation_id 
	inner join orders o on r.job_id=o.folder_number  ";
}
$sql.=" left outer join employees e on r.employee_id=e.card_number ";
$sql.=" where r.item_name not in (select item_name from items where item_category = 16) ";
$sql.=" and operation_name not in ('BREAK','Maintenance','Cleaning','Training','Troubleshooting','Clean Up','Preventative Maintenance','Internal Work','Engineering','Shipping') ";
if ($order) {
	$sql.=" and r.job_id=$order ";
} else {
	$sql.=" and DATE(result_date) >= '$st' and DATE(result_date) <= '$en' ";
	if ($searchwc) {
		if (in_array($searchwc,array(41,85,88))) {
			## 41 is bend
			## 85 is bend2
			## 88 is Tool Change
			$sql.=" and o.operation_id in (41,85,88) ";

		} else {
			if (in_array($searchwc,array("2,62"))) {
				$sql.=" and o.operation_id in (2,62) ";
			} else {
				$sql.=" and o.operation_id=$searchwc";
			}
		}
	}
}
$sql.=" and r.job_id > 0 ";
if ($searchwc) {
	$sql.=" group by r.employee_id, r.item_name, r.job_id, t.setup, t.per_part ";
	$sql.=" order by  last_name, first_name, r.item_name, o.operation_name ";
} else {
	if ($order) {
		$sql.=" group by r.employee_id, o.operation_name, r.item_name, r.job_id, setup, per_part ";
		$sql.=" order by last_name, first_name, r.item_name,   o.operation_name ";
	} else {
		$sql="select * from order_status where 1 < 0 LIMIT 1";
	}
}
list($result,$err)=runIQuery($db,$sql);

$total=0;
$lc=0;
$so="";
$grandTotal=0;
$parts=0;
$holdQty=0;
$minutes=0;
$planned=0;
$holdEmployee="";

foreach ($result as $data) {
	$name=$data['full_name'];
    if ($name != $holdEmployee) {
        if ($holdEmployee) {
			$diff=$planned  - $minutes;
			$planned=number_format($planned,1);
			$minutes=number_format($minutes,1);
			$diff=number_format($diff,1);
			print "<tr><td>$wc</td><td>";
			print "<a href='planToActual.php?employee=$employee&wc=$searchwc&start=$start&end=$end&percent=0&order=' target='_blank'>";
			print $holdEmployee;
			print "</a></td><td>$parts</td><td>$holdQty</td><td>$planned</td><td>$minutes</td><td>$diff</td></tr>\n";
        }
        $parts=0;
        $qty=0;
        $planned=0;
        $minutes=0;
        $holdEmployee=$name;
    }
	$parts++;
	$wc=$data['operation_name'];
	$employee=$data['employee_id'];
	if (in_array($searchwc,array(41,85,88))) {
		$wc="Bend (included Tool Change)";
	}
	$minutes+=$data['minutes'];
    $qty=$data['good'];
    $holdQty+=$qty;
	$rate=$data['hourly_rate']/60;
	## setup and per part are in seconds
	## setup and per part are in seconds
	$onum=$data['order_id'];
	reset($operationSetup);
	$setup=0;
	if (isset($operationSetup[$part][$onum][$op])) {
		$setup=$operationSetup[$part][$onum][$op];
	} else {
		if (isset($operationSetup[$part]["0"][$op])) {
			$setup=$operationSetup[$part]["0"][$op];
		}
	}
	reset($operationPerPart);
	if (isset($operationPerPart[$part][$onum][$op])) {
		$perPart=$operationPerPart[$part][$onum][$op];
	} else {
		if (isset($operationPerPart[$part]["0"][$op])) {
			$perPart=$operationPerPart[$part]["0"][$op];
		}
	}
	if (! $setup) {
		$setup=0;
	}
	if (! $perPart) {
		$perPart=0;
	}
    $planned += ($setup + ($qty*$perPart))/60;
}
if ($holdEmployee) {
    $diff=$planned  - $minutes;
	$planned=number_format($planned,1);
	$minutes=number_format($minutes,1);
	$diff=number_format($diff,1);
	print "<tr><td>$wc</td><td>";
	print "<a href='planToActual.php?employee=$employee&wc=$searchwc&start=$start&end=$end&percent=0&order=' target='_blank'>";
	print $holdEmployee;
	print "</a></td><td>$parts</td><td>$holdQty</td><td>$planned</td><td>$minutes</td><td>$diff</td></tr>\n";
}
print renderClosePanel("");
?>
<script>
function page_init() {
  $('#start').datepicker();
  $('#end').datepicker();
}
function exportPTA() {
	document.findform.action='planToActualExportByDepartment.php';
	document.findform.target='_blank';
	document.findform.submit();
	document.findform.action='planToActualByDepartment.php';
	document.findform.target='_self';
}
function tableToTab(tableid, filename="download.xls") {
	var csv = "";
	var rows = $("#"+tableid+" tr");

	for(var i = 0; rows.length > i; i++) {
		var row = rows[i].innerText.replace(/\n/g," ");
		csv += row + "\n";
	}

	var a = document.getElementById("downloader");
	var file = new Blob([csv], {type: 'text/plain'});
	a.href = URL.createObjectURL(file);
	a.download = filename;
}
</script>
<?php
include('footer.php');
?>