<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (empty($_POST)) $_POST = $_GET;
$employee = $_POST["employee"];
$color = $_POST["color"];
$batch = $_POST["batch"]; //!check if batch exists, if so it's a batch job
$noGo = 0;
$qty = []; //{jobid: good, jobid: good}

if (!$employee || (!$batch && !$color)) {
    $noGo = 1;
}

foreach ($_POST as $k => $v) {
    if ($v > 0 && substr($k, 0, 5) == "good-") {
        $j = (int) substr($k, 5);
        $qty[$j] = $v;
    }
}

print renderPanel("Piece Work Results");
if ($noGo || !count($qty)) {
    print "<h3>You must enter your valid employee number, the job or batch number, and the quantity good</h3>";
} else {
    $start = strtotime($_POST['start']);
    $notes = $_POST['notes'];
    $now = strtotime(date("Y-m-d H:i:s"));

    $diff = $now - $start; //total seconds taken

    $minutes = ($diff/60)%60;
    $hours = floor($diff/60/60);

    print "<h3><b>Employee</b>: $name <b>Hours</b>: $hours <b>Minutes</b>: $minutes<br>";

    foreach ($qty as $job => $qtygood) {
        $needed = $_POST["needed-" . $job];
        if ($needed == 0) continue;

        if ($qtygood > $needed) {
            print "<h3>You made $qtygood, but Job #$job only needs $needed. Your time will be recorded but the quantity good will be $needed.</h3><br>";
            $qtygood = $needed;
        }

        print "Job #: $job Good: $qtygood<br>";

        $complete = 0;
        if ($qtygood > $needed) {
            $complete = 1;
        } else {
            if ($qtygood == $needed) $complete = 1;
            $needed = $qtygood;
        }

        $vars = [];
        if ($batch) {
            $vars[] = "iiisiiisssi";
            $sql = "insert into piece_work_results (batch_id, job_id, operation_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete) values (?, ?, 3131, ?, ?, ?, ?, ?, 1, ?, ?, ?, ?)";
            $vars[] = $batch;
        } else {
            $vars[] = "iisiiisssi";
            $sql = "insert into piece_work_results (job_id, operation_id, employee_id, result_date, duration_hours, duration_minutes, quantity_good, shift_id, notes, start_time, end_time, complete) values (?, 3131, ?, ?, ?, ?, ?, 1, ?, ?, ?, ?)";
        }


        $vars = array_merge($vars, [
            $job,
            $employee,
            date("Y-m-d"),
            $hours,
            $minutes,
            $needed,
            $notes,
            date("Y-m-d H:i:s", $start),
            date("Y-m-d H:i:s", $now),
            $complete
        ]);

        runIQuery($db, $sql, $vars);
    }

    if ($complete) {
        $sql = "update piece_work_results set complete=1 where job_id=?";
        runIQuery($db, $sql, ["i", $job]);
    }

    print "Piece Work Results have been updated. <br>";
    print renderButton("Return", "red", "window.location = 'pieceWorkSelect.php';");
}

print renderClosePanel();
include('footer.php');
?>
<script>
    if (window.history.replaceState) { //prevent refresh from resubmitting POST requets with formdata
        window.history.replaceState(null, null, window.location.href);
    }
</script>