<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

print renderPanel("Part Select");
$sql = "select job_id from piece_work_results where complete=1 and job_id in (";
$jobs = [];
$batch_counts = [];

$bosql = "
select j.job_id, jbo.batch_id from jobs_batch_orders jbo
    inner join jobs j
        on jbo.job_id=j.job_id
    inner join piece_work_parts pwp
        on j.item_id=pwp.part_number
    inner join order_lines ol
        on j.line_id=ol.line_id
    where j.status=1
    and pwp.part_type='BOOT'
    and ol.item_id in (select item_id from piece_work_parents)
";
list($bors,$err) = runIQuery($db, $bosql);
foreach ($bors as $boot) {
    $jobs[] = $boot["job_id"];
    if (!isset($batch_counts[$boot["batch_id"]])) $batch_counts[$boot["batch_id"]] = 0;
    $batch_counts[$boot["batch_id"]]++;
}

$brsql = "
select j.job_id from jobs j
    inner join piece_work_parts pwp
        on pwp.part_number=j.item_id
    inner join order_lines ol
        on j.line_id=ol.line_id
    where j.status=1
    and pwp.part_type='BRACKET'
    and ol.item_id in (select item_id from piece_work_parents)
    and j.start_date < DATE_ADD(NOW(), INTERVAL 60 DAY)
";
list($brrs,$err) = runIQuery($db, $brsql);
foreach ($brrs as $bracket) {
    $jobs[] = $bracket["job_id"];
}

if (count($bors) || count($brrs)) {
    $sql .= implode(", ", $jobs) . ")";
    list($crs,$err) = runIQuery($db, $sql);

    $complete = [];
    foreach($crs as $completed) {
        $complete[] = $completed["job_id"];
    }

    $boots = [];
    foreach ($bors as $boot) {
        if (in_array($boot["job_id"], $complete)) continue;
        $sql = "select count(batch_id) from jobs_batch_orders where batch_id=?";
        list($rs,$err) = runIQuery($db, $sql, ["i", $boot["batch_id"]]);

        if (count($rs) != $batch_counts[$boot["batch_id"]]) continue;
        $boots[] = $boot;
    }

    $brackets = [];
    foreach ($brrs as $bracket) {
        if (in_array($bracket["job_id"], $complete)) continue;
        $brackets[] = $bracket;
    }

    print "<h3>Please select which type of part you would like to pre-assemble</h3>";
    if (count($boots)) print renderButton("Boots", "blue", "window.location = 'pieceWorkBoots.php';") . " ";
    if (count($brackets)) print renderButton("Brackets", "blue", "window.location = 'pieceWorkBrackets.php';");
} else {
    print "<h3>No Boots or Brackets need to be made</h3>";
}
print renderClosePanel();
?>
<?php
include('footer.php');
?>