<?php
include('dbConnection.php');
include('security.php');
include('functions.php');
include('header.php');

if (empty($_POST)) $_POST = $_GET;
$start = "01/01/" . Date("Y");
$end = "12/31/" . Date("Y");

if (isset($_POST["start"])) $start = $_POST["start"];
if (isset($_POST["end"])) $end = $_POST["end"];
$st = formatDateWebtoDB($start);
$et = formatDateWebtoDB($end);

print renderPanel("Piece Work Results", "", "green", "span11", "star");
print "<form name='findform' action='pieceWorkResults.php' method='GET'>";
print "<input type='hidden' name='search' value='1'>";
print renderDateBox(TRUE, "start", $start, "Start Search");
print renderDateBox(TRUE, "end", $end, "End Search");
print "<div class='span3'><div class='control-group span11'><label class='control-label'>‎</label><div class='controls'>" . renderButton("Find", "green", "document.findform.submit();") . renderButton("Export", "blue", "exportResults();") . "</div></div></div>";
print "</form>";
if ($_POST["search"] == "1") {
    $sql = "select pwr.end_time, concat(emp.first_name, ' ', emp.last_name) as full_name, pwr.notes, j.item_id, ol.item_id as parent_part, j.quantity_scheduled, pwr.duration_hours, pwr.duration_minutes, sum(pwr.quantity_good) as quantity_good, pwr.complete, pwr.batch_id, pwr.job_id, ol.order_id from order_lines ol, piece_work_results pwr, employees emp, jobs j where pwr.employee_id=emp.card_number and j.job_id=pwr.job_id and ol.line_id=j.line_id and pwr.start_time between ? and ? group by concat(pwr.start_time,pwr.end_time,pwr.job_id) order by pwr.start_time";
    list($rs,$err) = runIQuery($db, $sql, ["ss", $st, $et]);

    print "<style>th { min-width: 3vw; } </style>";
    print "<table class='table table-bordered'>";
    print "<thead>
        <tr>
            <th>Employee Name</th>
            <th>Time</th>
            <th>Hours</th>
            <th>Minutes</th>
            <th>Complete</th>
            <th>Notes</th>
            <th>Batch</th>
            <th>WO</th>
            <th>Order</th>
            <th>Item</th>
            <th>Parent Item</th>
            <th>Quantity Good</th>
            <th>Total Scheduled</th>
        </tr>
    </thead>
    <tbody>";

    $style = "cursor: pointer; color: #0d638f; font-weight: bold;";
    foreach ($rs as $result) {
        print "<tr>";
            print "<td>" . $result["full_name"] . "</td>";
            print "<td>" . date("m/d/Y h:i A", strtotime($result["end_time"])) . "</td>";
            print "<td>" . $result["duration_hours"] . "</td>";
            print "<td>" . $result["duration_minutes"] . "</td>";
            print "<td>" . ($result["complete"] ? "<span style='color: #35aa47;'>Yes</span>" : "<span style='color: #e02222;'>No</span>") . "</td>";
            print "<td>" . $result["notes"] . "</td>";
            print "<td " . (empty($result["batch_id"]) ? "" : "onclick=\"viewBatch('" . $result["batch_id"] . "')\" style='$style'") . ">" . $result["batch_id"] . "</td>";
            print "<td onclick=\"editJobs('" . $result["job_id"] . "');\" style='$style'>" . $result["job_id"] . "</td>";
            print "<td onclick=\"editOrders('" . $result["order_id"] . "');\" style='$style'>" . $result["order_id"] . "</td>";
            print "<td>" . $result["item_id"] . "</td>";
            print "<td>" . $result["parent_part"] . "</td>";
            print "<td>" . number_format($result["quantity_good"], 0) . "</td>";
            print "<td>" . $result["quantity_scheduled"] . "</td>";
        print "</tr>";
    }

    print "</tbody></table>";
}

print renderClosePanel();
include('footer.php');
?>
<script>
    function exportResults() {
        window.open("pieceWorkExport.php?start=<?=$start?>&end=<?=$end?>", "exporter");
    }
    function editJobs(leadid) {
		url='editJob.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editj');
	}
    function editOrders(leadid) {
		url='editOrders.php?id='+leadid+'&rand='+Math.random();
		window.open(url,'editr');
	}
    function viewBatch(leadid) {
		url='batchView.php?batch='+leadid+'&rand='+Math.random();
		window.open(url,'batchv');
	}
</script>